/* i386-win32.pe.h
   created from i386-win32.pe.bin, 27890 (0x6cf2) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2023 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2023 Laszlo Molnar
   Copyright (C) 2000-2023 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_I386_WIN32_PE_SIZE    27890
#define STUB_I386_WIN32_PE_ADLER32 0xc149ed7a
#define STUB_I386_WIN32_PE_CRC32   0x0a7a4370

unsigned char stub_i386_win32_pe[27890] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */ 208, 32,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */   0,  0,  0,  0,128,124, 36,  8,  1, 15,133,252,255,255,255, 96,
/* 0x0040 */ 190,  0,  0,  0,  0,232,  0,  0,  0,  0, 88,141,176,  3,  0,  0,
/* 0x0050 */   0,141,190,  0,  0,  0,  0,102,255,135,  0,  0,  0,  0,102,129,
/* 0x0060 */ 135,  0,  0,  0,  0,  0,  0,141,135,  0,  0,  0,  0,255, 48,199,
/* 0x0070 */   0,  0,  0,  0,  0, 80, 87,131,205,255,235,  3,164,235,  3,138,
/* 0x0080 */   6, 70,136,  7, 71,  1,219,117,  7,139, 30,131,238,252, 17,219,
/* 0x0090 */ 114,  1, 49,192, 64,114,255,184,  1,  0,  0,  0,  1,219,117,  7,
/* 0x00a0 */ 139, 30,131,238,252, 17,219, 17,192,  1,219,117,  7,139, 30,131,
/* 0x00b0 */ 238,252, 17,219,115,255,  1,219,115,255,117,  9,139, 30,131,238,
/* 0x00c0 */ 252, 17,219,115,255, 49,201,131,232,  3,114, 13,193,224,  8,138,
/* 0x00d0 */   6, 70,131,240,255,116,255,137,197,  1,219,117,  7,139, 30,131,
/* 0x00e0 */ 238,252, 17,219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,
/* 0x00f0 */ 219, 17,201,117,255, 65,  1,219,117,  7,139, 30,131,238,252, 17,
/* 0x0100 */ 219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219,115, 48,
/* 0x0110 */   1,219,115, 48,117,  9,139, 30,131,238,252, 17,219,115, 48, 65,
/* 0x0120 */  65,131,193,  2,129,253,  0,243,255,255,131,209,  1,137,242,141,
/* 0x0130 */  52, 47,243,164,137,214,233,252,255,255,255,141, 20, 47,131,253,
/* 0x0140 */ 252,118,255,138,  2, 66,136,  7, 71, 73,117,247,233,252,255,255,
/* 0x0150 */ 255,139,  2,131,194,  4,137,  7,131,199,  4,131,233,  4,119,241,
/* 0x0160 */   1,207,233,252,255,255,255,235,  3,164,235,  3,138,  6, 70,136,
/* 0x0170 */   7, 71,  1,219,117,  7,139, 30,131,238,252, 17,219,114,  1, 49,
/* 0x0180 */ 192, 64,114,255,184,  1,  0,  0,  0,  1,219,117,  7,139, 30,131,
/* 0x0190 */ 238,252, 17,219, 17,192,  1,219,117,  7,139, 30,131,238,252, 17,
/* 0x01a0 */ 219,114, 15,  1,219,115, 11,117, 15,139, 30,131,238,252, 17,219,
/* 0x01b0 */ 114, 15, 72,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,192,
/* 0x01c0 */ 235,255, 49,201,131,232,  3,114, 17,193,224,  8,138,  6, 70,131,
/* 0x01d0 */ 240,255,116,255,209,248,137,197,235, 11,  1,219,117,  7,139, 30,
/* 0x01e0 */ 131,238,252, 17,219, 17,201,  1,219,117,  7,139, 30,131,238,252,
/* 0x01f0 */  17,219, 17,201,117,255, 65,  1,219,117,  7,139, 30,131,238,252,
/* 0x0200 */  17,219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219,115,
/* 0x0210 */  68,  1,219,115, 68,117,  9,139, 30,131,238,252, 17,219,115, 68,
/* 0x0220 */  65, 65,131,193,  2,129,253,  0,251,255,255,131,209,  1,137,242,
/* 0x0230 */ 141, 52, 47,243,164,137,214,233,252,255,255,255,141, 20, 47,131,
/* 0x0240 */ 253,252,118,255,138,  2, 66,136,  7, 71, 73,117,247,233,252,255,
/* 0x0250 */ 255,255,139,  2,131,194,  4,137,  7,131,199,  4,131,233,  4,119,
/* 0x0260 */ 241,  1,207,233,252,255,255,255,235,  3,164,235,  3,138,  6, 70,
/* 0x0270 */ 136,  7, 71,  1,219,117,  7,139, 30,131,238,252, 17,219,114,  1,
/* 0x0280 */  49,192, 64,114,255,184,  1,  0,  0,  0,  1,219,117,  7,139, 30,
/* 0x0290 */ 131,238,252, 17,219, 17,192,  1,219,117,  7,139, 30,131,238,252,
/* 0x02a0 */  17,219,114, 30,  1,219,115, 11,117, 30,139, 30,131,238,252, 17,
/* 0x02b0 */ 219,114, 30, 72,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,
/* 0x02c0 */ 192,235,255,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,
/* 0x02d0 */ 235,255, 49,201,131,232,  3,114, 17,193,224,  8,138,  6, 70,131,
/* 0x02e0 */ 240,255,116,255,209,248,137,197,235, 11,  1,219,117,  7,139, 30,
/* 0x02f0 */ 131,238,252, 17,219,114,204, 65,  1,219,117,  7,139, 30,131,238,
/* 0x0300 */ 252, 17,219,114,190,  1,219,117,  7,139, 30,131,238,252, 17,219,
/* 0x0310 */  17,201,  1,219,117,  7,139, 30,131,238,252, 17,219,115, 81,  1,
/* 0x0320 */ 219,115, 81,117,  9,139, 30,131,238,252, 17,219,115, 81, 65, 65,
/* 0x0330 */ 131,193,  2,129,253,  0,251,255,255,131,209,  2,137,242,141, 52,
/* 0x0340 */  47,243,164,137,214,233,252,255,255,255,141, 20, 47,131,253,252,
/* 0x0350 */ 118,255,138,  2, 66,136,  7, 71, 73,117,247,233,252,255,255,255,
/* 0x0360 */ 139,  2,131,194,  4,137,  7,131,199,  4,131,233,  4,119,241,  1,
/* 0x0370 */ 207,233,252,255,255,255,137,229,141,156, 36,  0,  0,  0,  0, 49,
/* 0x0380 */ 192, 80, 57,220,117,251, 70, 70, 83,104,  0,  0,  0,  0, 87,131,
/* 0x0390 */ 195,  4, 83,104,  0,  0,  0,  0, 86,131,195,  4, 83, 80,199,  3,
/* 0x03a0 */   0,  0,  0,  0,137,229,139, 85,  0,172, 74,136,193, 36,  7,192,
/* 0x03b0 */ 233,  3,187,  0,253,255,255,211,227,141,164, 92,144,241,255,255,
/* 0x03c0 */ 131,228,224,106,  0,106,  0,137,227, 83,131,195,  4,139, 77,  0,
/* 0x03d0 */ 255, 49, 87, 83,131,195,  4,136, 67,  2,172, 74,136,193, 36, 15,
/* 0x03e0 */ 136,  3,192,233,  4,136, 75,  1, 82, 86, 83, 80, 85, 87, 86, 83,
/* 0x03f0 */ 131,236,124,139,148, 36,144,  0,  0,  0,199, 68, 36,116,  0,  0,
/* 0x0400 */   0,  0,198, 68, 36,115,  0,139,172, 36,156,  0,  0,  0,141, 66,
/* 0x0410 */   4,137, 68, 36,120,184,  1,  0,  0,  0, 15,182, 74,  2,137,195,
/* 0x0420 */ 211,227,137,217, 73,137, 76, 36,108, 15,182, 74,  1,211,224, 72,
/* 0x0430 */ 137, 68, 36,104,139,132, 36,168,  0,  0,  0, 15,182, 50,199, 69,
/* 0x0440 */   0,  0,  0,  0,  0,199, 68, 36, 96,  0,  0,  0,  0,199,  0,  0,
/* 0x0450 */   0,  0,  0,184,  0,  3,  0,  0,137,116, 36,100,199, 68, 36, 92,
/* 0x0460 */   1,  0,  0,  0,199, 68, 36, 88,  1,  0,  0,  0,199, 68, 36, 84,
/* 0x0470 */   1,  0,  0,  0,199, 68, 36, 80,  1,  0,  0,  0, 15,182, 74,  1,
/* 0x0480 */   1,241,211,224,141,136, 54,  7,  0,  0, 57, 76, 36,116,115, 14,
/* 0x0490 */ 139, 68, 36,120,102,199,  0,  0,  4,131,192,  2,226,246,139,156,
/* 0x04a0 */  36,148,  0,  0,  0, 49,255,199, 68, 36, 72,255,255,255,255,137,
/* 0x04b0 */ 218,  3,148, 36,152,  0,  0,  0,137, 84, 36, 76, 49,210, 59, 92,
/* 0x04c0 */  36, 76, 15,132,124,  9,  0,  0, 15,182,  3,193,231,  8, 66, 67,
/* 0x04d0 */   9,199,131,250,  4,126,231,139,140, 36,164,  0,  0,  0, 57, 76,
/* 0x04e0 */  36,116, 15,131,100,  9,  0,  0,139,116, 36,116, 35,116, 36,108,
/* 0x04f0 */ 139, 68, 36, 96,139, 84, 36,120,193,224,  4,137,116, 36, 68,  1,
/* 0x0500 */ 240,129,124, 36, 72,255,255,255,  0,141, 44, 66,119, 24, 59, 92,
/* 0x0510 */  36, 76, 15,132, 44,  9,  0,  0,193,100, 36, 72,  8, 15,182,  3,
/* 0x0520 */ 193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 85,  0,193,232,
/* 0x0530 */  11, 15,183,202, 15,175,193, 57,199, 15,131,221,  1,  0,  0,137,
/* 0x0540 */  68, 36, 72,184,  0,  8,  0,  0, 41,200,138, 76, 36,100,193,248,
/* 0x0550 */   5,190,  1,  0,  0,  0,141,  4,  2, 15,182, 84, 36,115,102,137,
/* 0x0560 */  69,  0,139, 68, 36,116, 35, 68, 36,104,139,108, 36,120,211,224,
/* 0x0570 */ 185,  8,  0,  0,  0, 43, 76, 36,100,211,250,  1,208,105,192,  0,
/* 0x0580 */   6,  0,  0,131,124, 36, 96,  6,141,132,  5,108, 14,  0,  0,137,
/* 0x0590 */  68, 36, 20, 15,142,202,  0,  0,  0,139, 68, 36,116, 43, 68, 36,
/* 0x05a0 */  92,139,148, 36,160,  0,  0,  0, 15,182,  4,  2,137, 68, 36, 64,
/* 0x05b0 */ 209,100, 36, 64,139, 76, 36, 64,141, 20, 54,139,108, 36, 20,129,
/* 0x05c0 */ 225,  0,  1,  0,  0,129,124, 36, 72,255,255,255,  0,141, 68, 77,
/* 0x05d0 */   0,137, 76, 36, 60,141, 44, 16,119, 24, 59, 92, 36, 76, 15,132,
/* 0x05e0 */  96,  8,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,
/* 0x05f0 */   9,199,139, 68, 36, 72,102,139,141,  0,  2,  0,  0,193,232, 11,
/* 0x0600 */  15,183,241, 15,175,198, 57,199,115, 35,137, 68, 36, 72,184,  0,
/* 0x0610 */   8,  0,  0, 41,240,137,214,193,248,  5,131,124, 36, 60,  0,141,
/* 0x0620 */   4,  1,102,137,133,  0,  2,  0,  0,116, 34,235, 46, 41, 68, 36,
/* 0x0630 */  72, 41,199,137,200,141,114,  1,102,193,232,  5,102, 41,193,131,
/* 0x0640 */ 124, 36, 60,  0,102,137,141,  0,  2,  0,  0,116, 14,129,254,255,
/* 0x0650 */   0,  0,  0, 15,142, 87,255,255,255,235,121,129,254,255,  0,  0,
/* 0x0660 */   0,127,113,141, 20, 54,139,108, 36, 20,  1,213,129,124, 36, 72,
/* 0x0670 */ 255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132,196,  7,  0,  0,
/* 0x0680 */ 193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68,
/* 0x0690 */  36, 72,102,139, 77,  0,193,232, 11, 15,183,241, 15,175,198, 57,
/* 0x06a0 */ 199,115, 25,137, 68, 36, 72,184,  0,  8,  0,  0, 41,240,137,214,
/* 0x06b0 */ 193,248,  5,141,  4,  1,102,137, 69,  0,235,159, 41, 68, 36, 72,
/* 0x06c0 */  41,199,137,200,141,114,  1,102,193,232,  5,102, 41,193,102,137,
/* 0x06d0 */  77,  0,235,135,139, 84, 36,116,137,240,139,140, 36,160,  0,  0,
/* 0x06e0 */   0,136, 68, 36,115,136,  4, 10, 66,131,124, 36, 96,  3,137, 84,
/* 0x06f0 */  36,116,127, 13,199, 68, 36, 96,  0,  0,  0,  0,233, 27,  7,  0,
/* 0x0700 */   0,131,124, 36, 96,  9,127, 10,131,108, 36, 96,  3,233, 10,  7,
/* 0x0710 */   0,  0,131,108, 36, 96,  6,233,  0,  7,  0,  0,139, 76, 36, 72,
/* 0x0720 */  41,199,139,116, 36, 96, 41,193,137,208,102,193,232,  5,102, 41,
/* 0x0730 */ 194,129,249,255,255,255,  0,102,137, 85,  0,139,108, 36,120,141,
/* 0x0740 */ 116,117,  0,137,116, 36, 56,119, 22, 59, 92, 36, 76, 15,132,241,
/* 0x0750 */   6,  0,  0, 15,182,  3,193,231,  8,193,225,  8, 67,  9,199,139,
/* 0x0760 */ 108, 36, 56,137,200,193,232, 11,102,139,149,128,  1,  0,  0, 15,
/* 0x0770 */ 183,234, 15,175,197, 57,199,115, 82,137,198,184,  0,  8,  0,  0,
/* 0x0780 */  41,232,139,108, 36, 88,193,248,  5,139, 76, 36, 84,141,  4,  2,
/* 0x0790 */ 139, 84, 36, 56,137, 76, 36, 80,139, 76, 36,120,102,137,130,128,
/* 0x07a0 */   1,  0,  0,139, 68, 36, 92,137,108, 36, 84,137, 68, 36, 88, 49,
/* 0x07b0 */ 192,131,124, 36, 96,  6, 15,159,192,129,193,100,  6,  0,  0,141,
/* 0x07c0 */   4, 64,137, 68, 36, 96,233,116,  2,  0,  0,137,206, 41,199, 41,
/* 0x07d0 */ 198,137,208,102,193,232,  5,139, 76, 36, 56,102, 41,194,129,254,
/* 0x07e0 */ 255,255,255,  0,102,137,145,128,  1,  0,  0,119, 22, 59, 92, 36,
/* 0x07f0 */  76, 15,132, 77,  6,  0,  0, 15,182,  3,193,231,  8,193,230,  8,
/* 0x0800 */  67,  9,199,139,108, 36, 56,137,242,193,234, 11,102,139,141,152,
/* 0x0810 */   1,  0,  0, 15,183,193, 15,175,208, 57,215, 15,131,227,  0,  0,
/* 0x0820 */   0,189,  0,  8,  0,  0,137,214, 41,197,199, 68, 36, 52,  0,  8,
/* 0x0830 */   0,  0,137,232,193,248,  5,141,  4,  1,139, 76, 36, 56,102,137,
/* 0x0840 */ 129,152,  1,  0,  0,139, 68, 36, 96,139, 76, 36, 68,193,224,  5,
/* 0x0850 */   3, 68, 36,120,129,250,255,255,255,  0,141, 44, 72,119, 22, 59,
/* 0x0860 */  92, 36, 76, 15,132,219,  5,  0,  0, 15,182,  3,193,231,  8,193,
/* 0x0870 */ 230,  8, 67,  9,199,102,139,149,224,  1,  0,  0,137,240,193,232,
/* 0x0880 */  11, 15,183,202, 15,175,193, 57,199,115, 96, 41, 76, 36, 52,193,
/* 0x0890 */ 124, 36, 52,  5,139,116, 36, 52,137, 68, 36, 72,131,124, 36,116,
/* 0x08a0 */   0,141,  4, 50,102,137,133,224,  1,  0,  0, 15,132,147,  5,  0,
/* 0x08b0 */   0, 49,192,131,124, 36, 96,  6,139,172, 36,160,  0,  0,  0,139,
/* 0x08c0 */  84, 36,116, 15,159,192,141, 68,  0,  9,137, 68, 36, 96,139, 68,
/* 0x08d0 */  36,116, 43, 68, 36, 92,138, 68,  5,  0,136, 68, 36,115,136,  4,
/* 0x08e0 */  42, 66,137, 84, 36,116,233, 49,  5,  0,  0, 41,198, 41,199,137,
/* 0x08f0 */ 208,102,193,232,  5,102, 41,194,102,137,149,224,  1,  0,  0,233,
/* 0x0900 */  31,  1,  0,  0,137,200, 41,214,102,193,232,  5,139,108, 36, 56,
/* 0x0910 */ 102, 41,193, 41,215,129,254,255,255,255,  0,102,137,141,152,  1,
/* 0x0920 */   0,  0,119, 22, 59, 92, 36, 76, 15,132, 22,  5,  0,  0, 15,182,
/* 0x0930 */   3,193,231,  8,193,230,  8, 67,  9,199,139, 76, 36, 56,137,240,
/* 0x0940 */ 193,232, 11,102,139,145,176,  1,  0,  0, 15,183,202, 15,175,193,
/* 0x0950 */  57,199,115, 35,137,198,184,  0,  8,  0,  0, 41,200,139,108, 36,
/* 0x0960 */  56,193,248,  5,141,  4,  2,102,137,133,176,  1,  0,  0,139, 68,
/* 0x0970 */  36, 88,233,160,  0,  0,  0,137,241, 41,199, 41,193,137,208,102,
/* 0x0980 */ 193,232,  5,102, 41,194,139, 68, 36, 56,129,249,255,255,255,  0,
/* 0x0990 */ 102,137,144,176,  1,  0,  0,119, 22, 59, 92, 36, 76, 15,132,161,
/* 0x09a0 */   4,  0,  0, 15,182,  3,193,231,  8,193,225,  8, 67,  9,199,139,
/* 0x09b0 */ 116, 36, 56,137,200,193,232, 11,102,139,150,200,  1,  0,  0, 15,
/* 0x09c0 */ 183,234, 15,175,197, 57,199,115, 32,137,198,184,  0,  8,  0,  0,
/* 0x09d0 */  41,232,139,108, 36, 56,193,248,  5,141,  4,  2,102,137,133,200,
/* 0x09e0 */   1,  0,  0,139, 68, 36, 84,235, 38,137,206, 41,199, 41,198,137,
/* 0x09f0 */ 208,102,193,232,  5,102, 41,194,139, 68, 36, 56,102,137,144,200,
/* 0x0a00 */   1,  0,  0,139, 84, 36, 84,139, 68, 36, 80,137, 84, 36, 80,139,
/* 0x0a10 */  76, 36, 88,137, 76, 36, 84,139,108, 36, 92,137, 68, 36, 92,137,
/* 0x0a20 */ 108, 36, 88, 49,192,131,124, 36, 96,  6,139, 76, 36,120, 15,159,
/* 0x0a30 */ 192,129,193,104, 10,  0,  0,141, 68, 64,  8,137, 68, 36, 96,129,
/* 0x0a40 */ 254,255,255,255,  0,119, 22, 59, 92, 36, 76, 15,132,243,  3,  0,
/* 0x0a50 */   0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,102,139, 17,
/* 0x0a60 */ 137,240,193,232, 11, 15,183,234, 15,175,197, 57,199,115, 47,137,
/* 0x0a70 */  68, 36, 72,184,  0,  8,  0,  0, 41,232,193,100, 36, 68,  4,193,
/* 0x0a80 */ 248,  5,199, 68, 36, 44,  0,  0,  0,  0,141,  4,  2,102,137,  1,
/* 0x0a90 */ 139, 68, 36, 68,141, 76,  1,  4,137, 76, 36, 16,235,114, 41,198,
/* 0x0aa0 */  41,199,137,208,102,193,232,  5,102, 41,194,129,254,255,255,255,
/* 0x0ab0 */   0,102,137, 17,119, 22, 59, 92, 36, 76, 15,132,132,  3,  0,  0,
/* 0x0ac0 */  15,182,  3,193,231,  8,193,230,  8, 67,  9,199,102,139, 81,  2,
/* 0x0ad0 */ 137,240,193,232, 11, 15,183,234, 15,175,197, 57,199,115, 59,137,
/* 0x0ae0 */  68, 36, 72,184,  0,  8,  0,  0, 41,232,193,100, 36, 68,  4,193,
/* 0x0af0 */ 248,  5,199, 68, 36, 44,  8,  0,  0,  0,141,  4,  2,139, 84, 36,
/* 0x0b00 */  68,102,137, 65,  2,141,140, 17,  4,  1,  0,  0,137, 76, 36, 16,
/* 0x0b10 */ 199, 68, 36, 48,  3,  0,  0,  0,235, 47, 41,198, 41,199,137,208,
/* 0x0b20 */ 137,116, 36, 72,102,193,232,  5,199, 68, 36, 44, 16,  0,  0,  0,
/* 0x0b30 */ 102, 41,194,199, 68, 36, 48,  8,  0,  0,  0,102,137, 81,  2,129,
/* 0x0b40 */ 193,  4,  2,  0,  0,137, 76, 36, 16,139, 76, 36, 48,186,  1,  0,
/* 0x0b50 */   0,  0,137, 76, 36, 40,141, 44, 18,139,116, 36, 16,  1,238,129,
/* 0x0b60 */ 124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132,209,
/* 0x0b70 */   2,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,
/* 0x0b80 */ 199,139, 68, 36, 72,102,139, 22,193,232, 11, 15,183,202, 15,175,
/* 0x0b90 */ 193, 57,199,115, 24,137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,
/* 0x0ba0 */ 193,248,  5,141,  4,  2,137,234,102,137,  6,235, 21, 41, 68, 36,
/* 0x0bb0 */  72, 41,199,137,208,102,193,232,  5,102, 41,194,102,137, 22,141,
/* 0x0bc0 */  85,  1,139,116, 36, 40, 78,137,116, 36, 40,117,137,138, 76, 36,
/* 0x0bd0 */  48,184,  1,  0,  0,  0,211,224, 41,194,  3, 84, 36, 44,131,124,
/* 0x0be0 */  36, 96,  3,137, 84, 36, 12, 15,143,231,  1,  0,  0,131, 68, 36,
/* 0x0bf0 */  96,  7,131,250,  3,137,208,126,  5,184,  3,  0,  0,  0,139,116,
/* 0x0c00 */  36,120,193,224,  7,199, 68, 36, 36,  6,  0,  0,  0,141,132,  6,
/* 0x0c10 */  96,  3,  0,  0,137, 68, 36,  8,184,  1,  0,  0,  0,141, 44,  0,
/* 0x0c20 */ 139,116, 36,  8,  1,238,129,124, 36, 72,255,255,255,  0,119, 24,
/* 0x0c30 */  59, 92, 36, 76, 15,132, 10,  2,  0,  0,193,100, 36, 72,  8, 15,
/* 0x0c40 */ 182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 22,193,
/* 0x0c50 */ 232, 11, 15,183,202, 15,175,193, 57,199,115, 24,137, 68, 36, 72,
/* 0x0c60 */ 184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,  6,
/* 0x0c70 */ 137,232,235, 21, 41, 68, 36, 72, 41,199,137,208,102,193,232,  5,
/* 0x0c80 */ 102, 41,194,141, 69,  1,102,137, 22,139,108, 36, 36, 77,137,108,
/* 0x0c90 */  36, 36,117,137,141, 80,192,131,250,  3,137, 20, 36, 15,142, 39,
/* 0x0ca0 */   1,  0,  0,137,208,137,214,209,248,131,230,  1,141, 72,255,131,
/* 0x0cb0 */ 206,  2,131,250, 13,137, 76, 36, 32,127, 28,139,108, 36,120,211,
/* 0x0cc0 */ 230,  1,210,137, 52, 36,141, 68,117,  0, 41,208,  5, 94,  5,  0,
/* 0x0cd0 */   0,137, 68, 36,  4,235, 86,141, 80,251,129,124, 36, 72,255,255,
/* 0x0ce0 */ 255,  0,119, 24, 59, 92, 36, 76, 15,132, 86,  1,  0,  0,193,100,
/* 0x0cf0 */  36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,209,108, 36, 72,
/* 0x0d00 */   1,246, 59,124, 36, 72,114,  7, 43,124, 36, 72,131,206,  1, 74,
/* 0x0d10 */ 117,200,139, 68, 36,120,193,230,  4,137, 52, 36,  5, 68,  6,  0,
/* 0x0d20 */   0,199, 68, 36, 32,  4,  0,  0,  0,137, 68, 36,  4,199, 68, 36,
/* 0x0d30 */  28,  1,  0,  0,  0,184,  1,  0,  0,  0,139,108, 36,  4,  1,192,
/* 0x0d40 */ 137, 68, 36, 24,  1,197,129,124, 36, 72,255,255,255,  0,119, 24,
/* 0x0d50 */  59, 92, 36, 76, 15,132,234,  0,  0,  0,193,100, 36, 72,  8, 15,
/* 0x0d60 */ 182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 85,  0,
/* 0x0d70 */ 193,232, 11, 15,183,242, 15,175,198, 57,199,115, 27,137, 68, 36,
/* 0x0d80 */  72,184,  0,  8,  0,  0, 41,240,193,248,  5,141,  4,  2,102,137,
/* 0x0d90 */  69,  0,139, 68, 36, 24,235, 31, 41, 68, 36, 72, 41,199,137,208,
/* 0x0da0 */ 102,193,232,  5,102, 41,194,139, 68, 36, 24,102,137, 85,  0,139,
/* 0x0db0 */  84, 36, 28, 64,  9, 20, 36,139, 76, 36, 32,209,100, 36, 28, 73,
/* 0x0dc0 */ 137, 76, 36, 32, 15,133,112,255,255,255,139, 52, 36, 70,137,116,
/* 0x0dd0 */  36, 92,116, 89,139, 76, 36, 12,139,108, 36,116,131,193,  2, 57,
/* 0x0de0 */ 108, 36, 92,119, 95,139,132, 36,160,  0,  0,  0,137,234, 43, 68,
/* 0x0df0 */  36, 92,  3,148, 36,160,  0,  0,  0,141, 52, 40,138,  6, 70,136,
/* 0x0e00 */  68, 36,115,136,  2, 66,255, 68, 36,116, 73,116, 15,139,172, 36,
/* 0x0e10 */ 164,  0,  0,  0, 57,108, 36,116,114,226,235, 17,139,132, 36,164,
/* 0x0e20 */   0,  0,  0, 57, 68, 36,116, 15,130,187,246,255,255,129,124, 36,
/* 0x0e30 */  72,255,255,255,  0,119, 21, 59, 92, 36, 76,184,  1,  0,  0,  0,
/* 0x0e40 */ 116, 41,235,  7,184,  1,  0,  0,  0,235, 32, 67, 43,156, 36,148,
/* 0x0e50 */   0,  0,  0, 49,192,139,148, 36,156,  0,  0,  0,139, 76, 36,116,
/* 0x0e60 */ 137, 26,139,156, 36,168,  0,  0,  0,137, 11,131,196,124, 91, 94,
/* 0x0e70 */  95, 93, 85, 87, 86, 83,131,236,124,139,148, 36,144,  0,  0,  0,
/* 0x0e80 */ 199, 68, 36,116,  0,  0,  0,  0,198, 68, 36,115,  0,139,172, 36,
/* 0x0e90 */ 156,  0,  0,  0,141, 66,  4,137, 68, 36,120,184,  1,  0,  0,  0,
/* 0x0ea0 */  15,182, 74,  2,137,195,211,227,137,217, 73,137, 76, 36,108, 15,
/* 0x0eb0 */ 182, 74,  1,211,224, 72,137, 68, 36,104,139,132, 36,168,  0,  0,
/* 0x0ec0 */   0, 15,182, 50,199, 69,  0,  0,  0,  0,  0,199, 68, 36, 96,  0,
/* 0x0ed0 */   0,  0,  0,199,  0,  0,  0,  0,  0,184,  0,  3,  0,  0,137,116,
/* 0x0ee0 */  36,100,199, 68, 36, 92,  1,  0,  0,  0,199, 68, 36, 88,  1,  0,
/* 0x0ef0 */   0,  0,199, 68, 36, 84,  1,  0,  0,  0,199, 68, 36, 80,  1,  0,
/* 0x0f00 */   0,  0, 15,182, 74,  1,  1,241,211,224,141,136, 54,  7,  0,  0,
/* 0x0f10 */  57, 76, 36,116,115, 14,139, 68, 36,120,102,199,  0,  0,  4,131,
/* 0x0f20 */ 192,  2,226,246,139,156, 36,148,  0,  0,  0, 49,255,199, 68, 36,
/* 0x0f30 */  72,255,255,255,255,137,218,  3,148, 36,152,  0,  0,  0,137, 84,
/* 0x0f40 */  36, 76, 49,210, 59, 92, 36, 76, 15,132,124,  9,  0,  0, 15,182,
/* 0x0f50 */   3,193,231,  8, 66, 67,  9,199,131,250,  4,126,231,139,140, 36,
/* 0x0f60 */ 164,  0,  0,  0, 57, 76, 36,116, 15,131,100,  9,  0,  0,139,116,
/* 0x0f70 */  36,116, 35,116, 36,108,139, 68, 36, 96,139, 84, 36,120,193,224,
/* 0x0f80 */   4,137,116, 36, 68,  1,240,129,124, 36, 72,255,255,255,  0,141,
/* 0x0f90 */  44, 66,119, 24, 59, 92, 36, 76, 15,132, 44,  9,  0,  0,193,100,
/* 0x0fa0 */  36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,
/* 0x0fb0 */ 102,139, 85,  0,193,232, 11, 15,183,202, 15,175,193, 57,199, 15,
/* 0x0fc0 */ 131,221,  1,  0,  0,137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,
/* 0x0fd0 */ 138, 76, 36,100,193,248,  5,190,  1,  0,  0,  0,141,  4,  2, 15,
/* 0x0fe0 */ 182, 84, 36,115,102,137, 69,  0,139, 68, 36,116, 35, 68, 36,104,
/* 0x0ff0 */ 139,108, 36,120,211,224,185,  8,  0,  0,  0, 43, 76, 36,100,211,
/* 0x1000 */ 250,  1,208,105,192,  0,  6,  0,  0,131,124, 36, 96,  6,141,132,
/* 0x1010 */   5,108, 14,  0,  0,137, 68, 36, 20, 15,142,202,  0,  0,  0,139,
/* 0x1020 */  68, 36,116, 43, 68, 36, 92,139,148, 36,160,  0,  0,  0, 15,182,
/* 0x1030 */   4,  2,137, 68, 36, 64,209,100, 36, 64,139, 76, 36, 64,141, 20,
/* 0x1040 */  54,139,108, 36, 20,129,225,  0,  1,  0,  0,129,124, 36, 72,255,
/* 0x1050 */ 255,255,  0,141, 68, 77,  0,137, 76, 36, 60,141, 44, 16,119, 24,
/* 0x1060 */  59, 92, 36, 76, 15,132, 96,  8,  0,  0,193,100, 36, 72,  8, 15,
/* 0x1070 */ 182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139,141,  0,
/* 0x1080 */   2,  0,  0,193,232, 11, 15,183,241, 15,175,198, 57,199,115, 35,
/* 0x1090 */ 137, 68, 36, 72,184,  0,  8,  0,  0, 41,240,137,214,193,248,  5,
/* 0x10a0 */ 131,124, 36, 60,  0,141,  4,  1,102,137,133,  0,  2,  0,  0,116,
/* 0x10b0 */  34,235, 46, 41, 68, 36, 72, 41,199,137,200,141,114,  1,102,193,
/* 0x10c0 */ 232,  5,102, 41,193,131,124, 36, 60,  0,102,137,141,  0,  2,  0,
/* 0x10d0 */   0,116, 14,129,254,255,  0,  0,  0, 15,142, 87,255,255,255,235,
/* 0x10e0 */ 121,129,254,255,  0,  0,  0,127,113,141, 20, 54,139,108, 36, 20,
/* 0x10f0 */   1,213,129,124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76,
/* 0x1100 */  15,132,196,  7,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,
/* 0x1110 */   8, 67,  9,199,139, 68, 36, 72,102,139, 77,  0,193,232, 11, 15,
/* 0x1120 */ 183,241, 15,175,198, 57,199,115, 25,137, 68, 36, 72,184,  0,  8,
/* 0x1130 */   0,  0, 41,240,137,214,193,248,  5,141,  4,  1,102,137, 69,  0,
/* 0x1140 */ 235,159, 41, 68, 36, 72, 41,199,137,200,141,114,  1,102,193,232,
/* 0x1150 */   5,102, 41,193,102,137, 77,  0,235,135,139, 84, 36,116,137,240,
/* 0x1160 */ 139,140, 36,160,  0,  0,  0,136, 68, 36,115,136,  4, 10, 66,131,
/* 0x1170 */ 124, 36, 96,  3,137, 84, 36,116,127, 13,199, 68, 36, 96,  0,  0,
/* 0x1180 */   0,  0,233, 27,  7,  0,  0,131,124, 36, 96,  9,127, 10,131,108,
/* 0x1190 */  36, 96,  3,233, 10,  7,  0,  0,131,108, 36, 96,  6,233,  0,  7,
/* 0x11a0 */   0,  0,139, 76, 36, 72, 41,199,139,116, 36, 96, 41,193,137,208,
/* 0x11b0 */ 102,193,232,  5,102, 41,194,129,249,255,255,255,  0,102,137, 85,
/* 0x11c0 */   0,139,108, 36,120,141,116,117,  0,137,116, 36, 56,119, 22, 59,
/* 0x11d0 */  92, 36, 76, 15,132,241,  6,  0,  0, 15,182,  3,193,231,  8,193,
/* 0x11e0 */ 225,  8, 67,  9,199,139,108, 36, 56,137,200,193,232, 11,102,139,
/* 0x11f0 */ 149,128,  1,  0,  0, 15,183,234, 15,175,197, 57,199,115, 82,137,
/* 0x1200 */ 198,184,  0,  8,  0,  0, 41,232,139,108, 36, 88,193,248,  5,139,
/* 0x1210 */  76, 36, 84,141,  4,  2,139, 84, 36, 56,137, 76, 36, 80,139, 76,
/* 0x1220 */  36,120,102,137,130,128,  1,  0,  0,139, 68, 36, 92,137,108, 36,
/* 0x1230 */  84,137, 68, 36, 88, 49,192,131,124, 36, 96,  6, 15,159,192,129,
/* 0x1240 */ 193,100,  6,  0,  0,141,  4, 64,137, 68, 36, 96,233,116,  2,  0,
/* 0x1250 */   0,137,206, 41,199, 41,198,137,208,102,193,232,  5,139, 76, 36,
/* 0x1260 */  56,102, 41,194,129,254,255,255,255,  0,102,137,145,128,  1,  0,
/* 0x1270 */   0,119, 22, 59, 92, 36, 76, 15,132, 77,  6,  0,  0, 15,182,  3,
/* 0x1280 */ 193,231,  8,193,230,  8, 67,  9,199,139,108, 36, 56,137,242,193,
/* 0x1290 */ 234, 11,102,139,141,152,  1,  0,  0, 15,183,193, 15,175,208, 57,
/* 0x12a0 */ 215, 15,131,227,  0,  0,  0,189,  0,  8,  0,  0,137,214, 41,197,
/* 0x12b0 */ 199, 68, 36, 52,  0,  8,  0,  0,137,232,193,248,  5,141,  4,  1,
/* 0x12c0 */ 139, 76, 36, 56,102,137,129,152,  1,  0,  0,139, 68, 36, 96,139,
/* 0x12d0 */  76, 36, 68,193,224,  5,  3, 68, 36,120,129,250,255,255,255,  0,
/* 0x12e0 */ 141, 44, 72,119, 22, 59, 92, 36, 76, 15,132,219,  5,  0,  0, 15,
/* 0x12f0 */ 182,  3,193,231,  8,193,230,  8, 67,  9,199,102,139,149,224,  1,
/* 0x1300 */   0,  0,137,240,193,232, 11, 15,183,202, 15,175,193, 57,199,115,
/* 0x1310 */  96, 41, 76, 36, 52,193,124, 36, 52,  5,139,116, 36, 52,137, 68,
/* 0x1320 */  36, 72,131,124, 36,116,  0,141,  4, 50,102,137,133,224,  1,  0,
/* 0x1330 */   0, 15,132,147,  5,  0,  0, 49,192,131,124, 36, 96,  6,139,172,
/* 0x1340 */  36,160,  0,  0,  0,139, 84, 36,116, 15,159,192,141, 68,  0,  9,
/* 0x1350 */ 137, 68, 36, 96,139, 68, 36,116, 43, 68, 36, 92,138, 68,  5,  0,
/* 0x1360 */ 136, 68, 36,115,136,  4, 42, 66,137, 84, 36,116,233, 49,  5,  0,
/* 0x1370 */   0, 41,198, 41,199,137,208,102,193,232,  5,102, 41,194,102,137,
/* 0x1380 */ 149,224,  1,  0,  0,233, 31,  1,  0,  0,137,200, 41,214,102,193,
/* 0x1390 */ 232,  5,139,108, 36, 56,102, 41,193, 41,215,129,254,255,255,255,
/* 0x13a0 */   0,102,137,141,152,  1,  0,  0,119, 22, 59, 92, 36, 76, 15,132,
/* 0x13b0 */  22,  5,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,
/* 0x13c0 */ 139, 76, 36, 56,137,240,193,232, 11,102,139,145,176,  1,  0,  0,
/* 0x13d0 */  15,183,202, 15,175,193, 57,199,115, 35,137,198,184,  0,  8,  0,
/* 0x13e0 */   0, 41,200,139,108, 36, 56,193,248,  5,141,  4,  2,102,137,133,
/* 0x13f0 */ 176,  1,  0,  0,139, 68, 36, 88,233,160,  0,  0,  0,137,241, 41,
/* 0x1400 */ 199, 41,193,137,208,102,193,232,  5,102, 41,194,139, 68, 36, 56,
/* 0x1410 */ 129,249,255,255,255,  0,102,137,144,176,  1,  0,  0,119, 22, 59,
/* 0x1420 */  92, 36, 76, 15,132,161,  4,  0,  0, 15,182,  3,193,231,  8,193,
/* 0x1430 */ 225,  8, 67,  9,199,139,116, 36, 56,137,200,193,232, 11,102,139,
/* 0x1440 */ 150,200,  1,  0,  0, 15,183,234, 15,175,197, 57,199,115, 32,137,
/* 0x1450 */ 198,184,  0,  8,  0,  0, 41,232,139,108, 36, 56,193,248,  5,141,
/* 0x1460 */   4,  2,102,137,133,200,  1,  0,  0,139, 68, 36, 84,235, 38,137,
/* 0x1470 */ 206, 41,199, 41,198,137,208,102,193,232,  5,102, 41,194,139, 68,
/* 0x1480 */  36, 56,102,137,144,200,  1,  0,  0,139, 84, 36, 84,139, 68, 36,
/* 0x1490 */  80,137, 84, 36, 80,139, 76, 36, 88,137, 76, 36, 84,139,108, 36,
/* 0x14a0 */  92,137, 68, 36, 92,137,108, 36, 88, 49,192,131,124, 36, 96,  6,
/* 0x14b0 */ 139, 76, 36,120, 15,159,192,129,193,104, 10,  0,  0,141, 68, 64,
/* 0x14c0 */   8,137, 68, 36, 96,129,254,255,255,255,  0,119, 22, 59, 92, 36,
/* 0x14d0 */  76, 15,132,243,  3,  0,  0, 15,182,  3,193,231,  8,193,230,  8,
/* 0x14e0 */  67,  9,199,102,139, 17,137,240,193,232, 11, 15,183,234, 15,175,
/* 0x14f0 */ 197, 57,199,115, 47,137, 68, 36, 72,184,  0,  8,  0,  0, 41,232,
/* 0x1500 */ 193,100, 36, 68,  4,193,248,  5,199, 68, 36, 44,  0,  0,  0,  0,
/* 0x1510 */ 141,  4,  2,102,137,  1,139, 68, 36, 68,141, 76,  1,  4,137, 76,
/* 0x1520 */  36, 16,235,114, 41,198, 41,199,137,208,102,193,232,  5,102, 41,
/* 0x1530 */ 194,129,254,255,255,255,  0,102,137, 17,119, 22, 59, 92, 36, 76,
/* 0x1540 */  15,132,132,  3,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,
/* 0x1550 */   9,199,102,139, 81,  2,137,240,193,232, 11, 15,183,234, 15,175,
/* 0x1560 */ 197, 57,199,115, 59,137, 68, 36, 72,184,  0,  8,  0,  0, 41,232,
/* 0x1570 */ 193,100, 36, 68,  4,193,248,  5,199, 68, 36, 44,  8,  0,  0,  0,
/* 0x1580 */ 141,  4,  2,139, 84, 36, 68,102,137, 65,  2,141,140, 17,  4,  1,
/* 0x1590 */   0,  0,137, 76, 36, 16,199, 68, 36, 48,  3,  0,  0,  0,235, 47,
/* 0x15a0 */  41,198, 41,199,137,208,137,116, 36, 72,102,193,232,  5,199, 68,
/* 0x15b0 */  36, 44, 16,  0,  0,  0,102, 41,194,199, 68, 36, 48,  8,  0,  0,
/* 0x15c0 */   0,102,137, 81,  2,129,193,  4,  2,  0,  0,137, 76, 36, 16,139,
/* 0x15d0 */  76, 36, 48,186,  1,  0,  0,  0,137, 76, 36, 40,141, 44, 18,139,
/* 0x15e0 */ 116, 36, 16,  1,238,129,124, 36, 72,255,255,255,  0,119, 24, 59,
/* 0x15f0 */  92, 36, 76, 15,132,209,  2,  0,  0,193,100, 36, 72,  8, 15,182,
/* 0x1600 */   3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 22,193,232,
/* 0x1610 */  11, 15,183,202, 15,175,193, 57,199,115, 24,137, 68, 36, 72,184,
/* 0x1620 */   0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,137,234,102,137,
/* 0x1630 */   6,235, 21, 41, 68, 36, 72, 41,199,137,208,102,193,232,  5,102,
/* 0x1640 */  41,194,102,137, 22,141, 85,  1,139,116, 36, 40, 78,137,116, 36,
/* 0x1650 */  40,117,137,138, 76, 36, 48,184,  1,  0,  0,  0,211,224, 41,194,
/* 0x1660 */   3, 84, 36, 44,131,124, 36, 96,  3,137, 84, 36, 12, 15,143,231,
/* 0x1670 */   1,  0,  0,131, 68, 36, 96,  7,131,250,  3,137,208,126,  5,184,
/* 0x1680 */   3,  0,  0,  0,139,116, 36,120,193,224,  7,199, 68, 36, 36,  6,
/* 0x1690 */   0,  0,  0,141,132,  6, 96,  3,  0,  0,137, 68, 36,  8,184,  1,
/* 0x16a0 */   0,  0,  0,141, 44,  0,139,116, 36,  8,  1,238,129,124, 36, 72,
/* 0x16b0 */ 255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132, 10,  2,  0,  0,
/* 0x16c0 */ 193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68,
/* 0x16d0 */  36, 72,102,139, 22,193,232, 11, 15,183,202, 15,175,193, 57,199,
/* 0x16e0 */ 115, 24,137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,193,248,  5,
/* 0x16f0 */ 141,  4,  2,102,137,  6,137,232,235, 21, 41, 68, 36, 72, 41,199,
/* 0x1700 */ 137,208,102,193,232,  5,102, 41,194,141, 69,  1,102,137, 22,139,
/* 0x1710 */ 108, 36, 36, 77,137,108, 36, 36,117,137,141, 80,192,131,250,  3,
/* 0x1720 */ 137, 20, 36, 15,142, 39,  1,  0,  0,137,208,137,214,209,248,131,
/* 0x1730 */ 230,  1,141, 72,255,131,206,  2,131,250, 13,137, 76, 36, 32,127,
/* 0x1740 */  28,139,108, 36,120,211,230,  1,210,137, 52, 36,141, 68,117,  0,
/* 0x1750 */  41,208,  5, 94,  5,  0,  0,137, 68, 36,  4,235, 86,141, 80,251,
/* 0x1760 */ 129,124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132,
/* 0x1770 */  86,  1,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,
/* 0x1780 */   9,199,209,108, 36, 72,  1,246, 59,124, 36, 72,114,  7, 43,124,
/* 0x1790 */  36, 72,131,206,  1, 74,117,200,139, 68, 36,120,193,230,  4,137,
/* 0x17a0 */  52, 36,  5, 68,  6,  0,  0,199, 68, 36, 32,  4,  0,  0,  0,137,
/* 0x17b0 */  68, 36,  4,199, 68, 36, 28,  1,  0,  0,  0,184,  1,  0,  0,  0,
/* 0x17c0 */ 139,108, 36,  4,  1,192,137, 68, 36, 24,  1,197,129,124, 36, 72,
/* 0x17d0 */ 255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132,234,  0,  0,  0,
/* 0x17e0 */ 193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68,
/* 0x17f0 */  36, 72,102,139, 85,  0,193,232, 11, 15,183,242, 15,175,198, 57,
/* 0x1800 */ 199,115, 27,137, 68, 36, 72,184,  0,  8,  0,  0, 41,240,193,248,
/* 0x1810 */   5,141,  4,  2,102,137, 69,  0,139, 68, 36, 24,235, 31, 41, 68,
/* 0x1820 */  36, 72, 41,199,137,208,102,193,232,  5,102, 41,194,139, 68, 36,
/* 0x1830 */  24,102,137, 85,  0,139, 84, 36, 28, 64,  9, 20, 36,139, 76, 36,
/* 0x1840 */  32,209,100, 36, 28, 73,137, 76, 36, 32, 15,133,112,255,255,255,
/* 0x1850 */ 139, 52, 36, 70,137,116, 36, 92,116, 89,139, 76, 36, 12,139,108,
/* 0x1860 */  36,116,131,193,  2, 57,108, 36, 92,119, 95,139,132, 36,160,  0,
/* 0x1870 */   0,  0,137,234, 43, 68, 36, 92,  3,148, 36,160,  0,  0,  0,141,
/* 0x1880 */  52, 40,138,  6, 70,136, 68, 36,115,136,  2, 66,255, 68, 36,116,
/* 0x1890 */  73,116, 15,139,172, 36,164,  0,  0,  0, 57,108, 36,116,114,226,
/* 0x18a0 */ 235, 17,139,132, 36,164,  0,  0,  0, 57, 68, 36,116, 15,130,187,
/* 0x18b0 */ 246,255,255,129,124, 36, 72,255,255,255,  0,119, 21, 59, 92, 36,
/* 0x18c0 */  76,184,  1,  0,  0,  0,116, 41,235,  7,184,  1,  0,  0,  0,235,
/* 0x18d0 */  32, 67, 43,156, 36,148,  0,  0,  0, 49,192,139,148, 36,156,  0,
/* 0x18e0 */   0,  0,139, 76, 36,116,137, 26,139,156, 36,168,  0,  0,  0,137,
/* 0x18f0 */  11,131,196,124, 91, 94, 95, 93,  3,115,252,  3,123,248, 49,192,
/* 0x1900 */ 141,140, 36,  0,255,255,255,137,236, 80, 57,204,117,251,137,236,
/* 0x1910 */  49,201, 94, 95, 88,137,  7,141,190,  0,  0,  0,  0,137,247,185,
/* 0x1920 */   0,  0,  0,  0,138,  7, 71, 44,232, 60,  1,119,247,128, 63,  0,
/* 0x1930 */ 117,  4,139,  7,138, 95,  4,102,193,232,  8,134,196,193,192, 16,
/* 0x1940 */ 134,196, 41,248,128,235,232,  1,240,137,  7,131,199,  5,136,216,
/* 0x1950 */ 226,  9,185,  0,  0,  0,  0,176,232,176,233,242,174,117,  6,128,
/* 0x1960 */  63,  0,117,255,139,  7,102,193,232,  8,134,196,193,192, 16,134,
/* 0x1970 */ 196, 41,248,  1,240,171,235,  4,185,  0,  0,  0,  0,235, 31,138,
/* 0x1980 */   7, 71, 60,128,114, 10, 60,143,119,  6,128,127,254, 15,116,  5,
/* 0x1990 */  44,232, 60,  1,119,255,131,249,  4,114,  4,139,  7, 44,  0,117,
/* 0x19a0 */ 255,134,196,193,192, 16,134,196, 41,248,  1,240,131,233,  4,171,
/* 0x19b0 */ 131,233,  1,114,  4,138,  7, 71,235, 13,131,233,  1,115,  6,141,
/* 0x19c0 */ 190,  0,  0,  0,  0,139,  7,  9,192,116,255,139, 95,  4,141,132,
/* 0x19d0 */  48,  0,  0,  0,  0,  1,243, 80,131,199,  8,255,150,  0,  0,  0,
/* 0x19e0 */   0,149,138,  7, 71,  8,192,116,220,137,249,121,  6,122, 14,139,
/* 0x19f0 */   7,131,199,  4,139,132, 48,  0,  0,  0,  0,235, 14, 15,183,  7,
/* 0x1a00 */  71, 80, 71,185, 87, 72,242,174, 85,255,150,  0,  0,  0,  0,  9,
/* 0x1a10 */ 192,116,  7,137,  3,131,195,  4,235, 34, 97, 49,192,194, 12,  0,
/* 0x1a20 */ 255,150,  0,  0,  0,  0,141,190,  0,  0,  0,  0,131,199,  4,141,
/* 0x1a30 */  94,252, 49,192,138,  7, 71,  9,192,116,  1, 60,239,119, 17,  1,
/* 0x1a40 */ 195,139,  3,134,196,193,192, 16,134,196,  1,240,137,  3,235,226,
/* 0x1a50 */  36, 15,193,224, 16,102,139,  7,131,199,  2,  9,192,117, 12,139,
/* 0x1a60 */   7,131,199,  4,235, 12,135,247,141,143,  0,  0,  0,  0,169,102,
/* 0x1a70 */   1, 12,  7,173,  9,192,117,247,193,233, 16,169,102,  1, 12,  7,
/* 0x1a80 */ 173,  9,192,117,247,139,174,  0,  0,  0,  0,141,190,  0,  0,  0,
/* 0x1a90 */   0,187,  0,  0,  0,  0, 80, 84,106,  4, 83, 87,255,213,141,135,
/* 0x1aa0 */   0,  0,  0,  0,128, 32,127,128, 96, 40,127, 88, 80, 84, 80, 83,
/* 0x1ab0 */  87,255,213, 88,141,158,  0,  0,  0,  0,141,187,  1,  0,  0,  0,
/* 0x1ac0 */  87, 49,192,170, 89, 73, 80,106,  1, 83,255,209, 97,141, 68, 36,
/* 0x1ad0 */ 128,106,  0, 57,196,117,250,131,236,128, 49,192, 64,194, 12,  0,
/* 0x1ae0 */ 233,252,255,255,255,235, 26, 86,190,  0,  0,  0,  0,252,173,133,
/* 0x1af0 */ 192,116, 13,106,  3, 89,255,116, 36, 16,226,250,255,208,235,238,
/* 0x1b00 */  94,194, 12,  0, 85, 80, 88, 33,161,216,208,213,  0,  0,  0,  0,
/* 0x1b10 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1b20 */   0,  0,  0, 45,102,105,108,101, 32,102,111,114,109, 97,116, 32,
/* 0x1b30 */ 101,108,102, 51, 50, 45,105, 51, 56, 54, 10, 10, 83,101, 99,116,
/* 0x1b40 */ 105,111,110,115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32,
/* 0x1b50 */  32, 32, 32, 32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32,
/* 0x1b60 */  32, 32, 86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65, 32,
/* 0x1b70 */  32, 32, 32, 32, 32, 32, 70,105,108,101, 32,111,102,102, 32, 32,
/* 0x1b80 */  65,108,103,110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32,
/* 0x1b90 */  80, 69, 73, 83, 68, 76, 76, 49, 32, 32, 32, 32, 32, 32, 48, 98,
/* 0x1ba0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 52, 32, 32, 50, 42, 42,
/* 0x1bb0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 49, 32,
/* 0x1bc0 */  80, 69, 77, 65, 73, 78, 48, 49, 32, 32, 32, 32, 32, 32, 48, 49,
/* 0x1bd0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 51,102, 32, 32, 50, 42, 42,
/* 0x1be0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 50, 32,
/* 0x1bf0 */  80, 69, 83, 79, 67, 82, 69, 76, 32, 32, 32, 32, 32, 32, 48, 53,
/* 0x1c00 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 52, 48, 32, 32, 50, 42, 42,
/* 0x1c10 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 51, 32,
/* 0x1c20 */  80, 69, 83, 79, 67, 80, 73, 67, 32, 32, 32, 32, 32, 32, 48, 99,
/* 0x1c30 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 52, 53, 32, 32, 50, 42, 42,
/* 0x1c40 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 52, 32,
/* 0x1c50 */  80, 69, 83, 79, 85, 78, 67, 48, 32, 32, 32, 32, 32, 32, 48, 54,
/* 0x1c60 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 53, 49, 32, 32, 50, 42, 42,
/* 0x1c70 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 53, 32,
/* 0x1c80 */  80, 69, 73, 67, 79, 78, 83, 49, 32, 32, 32, 32, 32, 32, 48, 55,
/* 0x1c90 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 53, 55, 32, 32, 50, 42, 42,
/* 0x1ca0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 54, 32,
/* 0x1cb0 */  80, 69, 73, 67, 79, 78, 83, 50, 32, 32, 32, 32, 32, 32, 48, 57,
/* 0x1cc0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 53,101, 32, 32, 50, 42, 42,
/* 0x1cd0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 55, 32,
/* 0x1ce0 */  80, 69, 84, 76, 83, 72, 65, 75, 32, 32, 32, 32, 32, 32, 48,102,
/* 0x1cf0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 54, 55, 32, 32, 50, 42, 42,
/* 0x1d00 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 56, 32,
/* 0x1d10 */  80, 69, 77, 65, 73, 78, 48, 50, 32, 32, 32, 32, 32, 32, 48, 49,
/* 0x1d20 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 55, 54, 32, 32, 50, 42, 42,
/* 0x1d30 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 57, 32,
/* 0x1d40 */  80, 69, 77, 65, 73, 78, 48, 51, 32, 32, 32, 32, 32, 32, 48, 51,
/* 0x1d50 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 55, 55, 32, 32, 50, 42, 42,
/* 0x1d60 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 48, 32,
/* 0x1d70 */  78, 50, 66, 83, 77, 65, 49, 48, 32, 32, 32, 32, 32, 32, 48, 51,
/* 0x1d80 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 55, 97, 32, 32, 50, 42, 42,
/* 0x1d90 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 49, 32,
/* 0x1da0 */  78, 50, 66, 70, 65, 83, 49, 48, 32, 32, 32, 32, 32, 32, 48, 50,
/* 0x1db0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 55,100, 32, 32, 50, 42, 42,
/* 0x1dc0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 50, 32,
/* 0x1dd0 */  78, 50, 66, 70, 65, 83, 49, 49, 32, 32, 32, 32, 32, 32, 48, 54,
/* 0x1de0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 55,102, 32, 32, 50, 42, 42,
/* 0x1df0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 51, 32,
/* 0x1e00 */  78, 50, 66, 68, 69, 67, 49, 48, 32, 32, 32, 32, 32, 32, 48, 98,
/* 0x1e10 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 56, 53, 32, 32, 50, 42, 42,
/* 0x1e20 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 52, 32,
/* 0x1e30 */  78, 50, 66, 83, 77, 65, 50, 48, 32, 32, 32, 32, 32, 32, 48, 53,
/* 0x1e40 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 57, 48, 32, 32, 50, 42, 42,
/* 0x1e50 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 53, 32,
/* 0x1e60 */  78, 50, 66, 70, 65, 83, 50, 48, 32, 32, 32, 32, 32, 32, 48, 55,
/* 0x1e70 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 57, 53, 32, 32, 50, 42, 42,
/* 0x1e80 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 54, 32,
/* 0x1e90 */  78, 50, 66, 68, 69, 67, 50, 48, 32, 32, 32, 32, 32, 32, 48,100,
/* 0x1ea0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 57, 99, 32, 32, 50, 42, 42,
/* 0x1eb0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 55, 32,
/* 0x1ec0 */  78, 50, 66, 83, 77, 65, 51, 48, 32, 32, 32, 32, 32, 32, 48,100,
/* 0x1ed0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 97, 57, 32, 32, 50, 42, 42,
/* 0x1ee0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 56, 32,
/* 0x1ef0 */  78, 50, 66, 70, 65, 83, 51, 48, 32, 32, 32, 32, 32, 32, 48,102,
/* 0x1f00 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 98, 54, 32, 32, 50, 42, 42,
/* 0x1f10 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 57, 32,
/* 0x1f20 */  78, 50, 66, 68, 69, 67, 51, 48, 32, 32, 32, 32, 32, 32, 48, 51,
/* 0x1f30 */ 101, 32, 32, 48, 32, 32, 48, 32, 32, 48, 99, 53, 32, 32, 50, 42,
/* 0x1f40 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 48,
/* 0x1f50 */  32, 78, 50, 66, 83, 77, 65, 52, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x1f60 */ 100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 48, 51, 32, 32, 50,
/* 0x1f70 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50,
/* 0x1f80 */  49, 32, 78, 50, 66, 70, 65, 83, 52, 48, 32, 32, 32, 32, 32, 32,
/* 0x1f90 */  48,102, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 49, 48, 32, 32,
/* 0x1fa0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x1fb0 */  50, 50, 32, 78, 50, 66, 83, 77, 65, 53, 48, 32, 32, 32, 32, 32,
/* 0x1fc0 */  32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 49,102, 32,
/* 0x1fd0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x1fe0 */  32, 50, 51, 32, 78, 50, 66, 70, 65, 83, 53, 48, 32, 32, 32, 32,
/* 0x1ff0 */  32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 50, 49,
/* 0x2000 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2010 */  10, 32, 50, 52, 32, 78, 50, 66, 68, 69, 67, 53, 48, 32, 32, 32,
/* 0x2020 */  32, 32, 32, 48, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 50,
/* 0x2030 */  52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2040 */  83, 10, 32, 50, 53, 32, 78, 50, 66, 83, 77, 65, 54, 48, 32, 32,
/* 0x2050 */  32, 32, 32, 32, 48,101, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x2060 */  50,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2070 */  84, 83, 10, 32, 50, 54, 32, 78, 50, 66, 70, 65, 83, 54, 48, 32,
/* 0x2080 */  32, 32, 32, 32, 32, 48, 49, 54, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2090 */  48, 49, 51, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x20a0 */  69, 78, 84, 83, 10, 32, 50, 55, 32, 78, 50, 66, 70, 65, 83, 54,
/* 0x20b0 */  49, 32, 32, 32, 32, 32, 32, 48, 49, 54, 32, 32, 48, 32, 32, 48,
/* 0x20c0 */  32, 32, 48, 49, 53, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x20d0 */  78, 84, 69, 78, 84, 83, 10, 32, 50, 56, 32, 78, 50, 66, 68, 69,
/* 0x20e0 */  67, 54, 48, 32, 32, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x20f0 */  32, 32, 48, 49, 54, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2100 */  78, 84, 69, 78, 84, 83, 10, 32, 50, 57, 32, 78, 50, 68, 83, 77,
/* 0x2110 */  65, 49, 48, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32,
/* 0x2120 */  48, 32, 32, 48, 49, 54, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2130 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 48, 32, 78, 50, 68, 70,
/* 0x2140 */  65, 83, 49, 48, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32,
/* 0x2150 */  32, 48, 32, 32, 48, 49, 54, 97, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2160 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 49, 32, 78, 50, 68,
/* 0x2170 */  70, 65, 83, 49, 49, 32, 32, 32, 32, 32, 32, 48, 54, 32, 32, 48,
/* 0x2180 */  32, 32, 48, 32, 32, 48, 49, 54, 99, 32, 32, 50, 42, 42, 48, 32,
/* 0x2190 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 50, 32, 78, 50,
/* 0x21a0 */  68, 68, 69, 67, 49, 48, 32, 32, 32, 32, 32, 32, 48, 98, 32, 32,
/* 0x21b0 */  48, 32, 32, 48, 32, 32, 48, 49, 55, 50, 32, 32, 50, 42, 42, 48,
/* 0x21c0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 51, 32, 78,
/* 0x21d0 */  50, 68, 83, 77, 65, 50, 48, 32, 32, 32, 32, 32, 32, 48, 53, 32,
/* 0x21e0 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 55,100, 32, 32, 50, 42, 42,
/* 0x21f0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 52, 32,
/* 0x2200 */  78, 50, 68, 70, 65, 83, 50, 48, 32, 32, 32, 32, 32, 32, 48, 55,
/* 0x2210 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 56, 50, 32, 32, 50, 42,
/* 0x2220 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 53,
/* 0x2230 */  32, 78, 50, 68, 68, 69, 67, 50, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x2240 */ 100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 56, 57, 32, 32, 50,
/* 0x2250 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51,
/* 0x2260 */  54, 32, 78, 50, 68, 83, 77, 65, 51, 48, 32, 32, 32, 32, 32, 32,
/* 0x2270 */  48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 54, 32, 32,
/* 0x2280 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x2290 */  51, 55, 32, 78, 50, 68, 70, 65, 83, 51, 48, 32, 32, 32, 32, 32,
/* 0x22a0 */  32, 48,102, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 51, 32,
/* 0x22b0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x22c0 */  32, 51, 56, 32, 78, 50, 68, 68, 69, 67, 51, 48, 32, 32, 32, 32,
/* 0x22d0 */  32, 32, 48, 53, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98,
/* 0x22e0 */  50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x22f0 */  83, 10, 32, 51, 57, 32, 78, 50, 68, 83, 77, 65, 52, 48, 32, 32,
/* 0x2300 */  32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50,
/* 0x2310 */  48, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2320 */  84, 83, 10, 32, 52, 48, 32, 78, 50, 68, 70, 65, 83, 52, 48, 32,
/* 0x2330 */  32, 32, 32, 32, 32, 48,102, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2340 */  50, 49, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2350 */  78, 84, 83, 10, 32, 52, 49, 32, 78, 50, 68, 83, 77, 65, 53, 48,
/* 0x2360 */  32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2370 */  48, 50, 50, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2380 */  69, 78, 84, 83, 10, 32, 52, 50, 32, 78, 50, 68, 70, 65, 83, 53,
/* 0x2390 */  48, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32,
/* 0x23a0 */  32, 48, 50, 50, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x23b0 */  84, 69, 78, 84, 83, 10, 32, 52, 51, 32, 78, 50, 68, 68, 69, 67,
/* 0x23c0 */  53, 48, 32, 32, 32, 32, 32, 32, 48, 57, 32, 32, 48, 32, 32, 48,
/* 0x23d0 */  32, 32, 48, 50, 50, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x23e0 */  78, 84, 69, 78, 84, 83, 10, 32, 52, 52, 32, 78, 50, 68, 83, 77,
/* 0x23f0 */  65, 54, 48, 32, 32, 32, 32, 32, 32, 48,101, 32, 32, 48, 32, 32,
/* 0x2400 */  48, 32, 32, 48, 50, 50,101, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2410 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 53, 32, 78, 50, 68, 70,
/* 0x2420 */  65, 83, 54, 48, 32, 32, 32, 32, 32, 32, 48, 49, 54, 32, 32, 48,
/* 0x2430 */  32, 32, 48, 32, 32, 48, 50, 51, 99, 32, 32, 50, 42, 42, 48, 32,
/* 0x2440 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 54, 32, 78, 50,
/* 0x2450 */  68, 70, 65, 83, 54, 49, 32, 32, 32, 32, 32, 32, 48, 49, 54, 32,
/* 0x2460 */  32, 48, 32, 32, 48, 32, 32, 48, 50, 53, 50, 32, 32, 50, 42, 42,
/* 0x2470 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 55, 32,
/* 0x2480 */  78, 50, 68, 68, 69, 67, 54, 48, 32, 32, 32, 32, 32, 32, 48, 32,
/* 0x2490 */  32, 48, 32, 32, 48, 32, 32, 48, 50, 54, 56, 32, 32, 50, 42, 42,
/* 0x24a0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 56, 32,
/* 0x24b0 */  78, 50, 69, 83, 77, 65, 49, 48, 32, 32, 32, 32, 32, 32, 48, 51,
/* 0x24c0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 54, 56, 32, 32, 50, 42,
/* 0x24d0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 57,
/* 0x24e0 */  32, 78, 50, 69, 70, 65, 83, 49, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x24f0 */  50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 54, 98, 32, 32, 50,
/* 0x2500 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 53,
/* 0x2510 */  48, 32, 78, 50, 69, 70, 65, 83, 49, 49, 32, 32, 32, 32, 32, 32,
/* 0x2520 */  48, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 54,100, 32, 32,
/* 0x2530 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x2540 */  53, 49, 32, 78, 50, 69, 68, 69, 67, 49, 48, 32, 32, 32, 32, 32,
/* 0x2550 */  32, 48, 98, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 55, 51, 32,
/* 0x2560 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2570 */  32, 53, 50, 32, 78, 50, 69, 83, 77, 65, 50, 48, 32, 32, 32, 32,
/* 0x2580 */  32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 55,101,
/* 0x2590 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x25a0 */  10, 32, 53, 51, 32, 78, 50, 69, 70, 65, 83, 50, 48, 32, 32, 32,
/* 0x25b0 */  32, 32, 32, 48, 55, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 56,
/* 0x25c0 */  51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x25d0 */  83, 10, 32, 53, 52, 32, 78, 50, 69, 68, 69, 67, 50, 48, 32, 32,
/* 0x25e0 */  32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50,
/* 0x25f0 */  56, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2600 */  84, 83, 10, 32, 53, 53, 32, 78, 50, 69, 83, 77, 65, 51, 48, 32,
/* 0x2610 */  32, 32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2620 */  50, 57, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2630 */  78, 84, 83, 10, 32, 53, 54, 32, 78, 50, 69, 70, 65, 83, 51, 48,
/* 0x2640 */  32, 32, 32, 32, 32, 32, 48,102, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2650 */  48, 50, 97, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2660 */  69, 78, 84, 83, 10, 32, 53, 55, 32, 78, 50, 69, 68, 69, 67, 51,
/* 0x2670 */  48, 32, 32, 32, 32, 32, 32, 48, 53,102, 32, 32, 48, 32, 32, 48,
/* 0x2680 */  32, 32, 48, 50, 98, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2690 */  78, 84, 69, 78, 84, 83, 10, 32, 53, 56, 32, 78, 50, 69, 83, 77,
/* 0x26a0 */  65, 52, 48, 32, 32, 32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32,
/* 0x26b0 */  48, 32, 32, 48, 51, 49, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x26c0 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 53, 57, 32, 78, 50, 69, 70,
/* 0x26d0 */  65, 83, 52, 48, 32, 32, 32, 32, 32, 32, 48,102, 32, 32, 48, 32,
/* 0x26e0 */  32, 48, 32, 32, 48, 51, 49,102, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x26f0 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 48, 32, 78, 50, 69,
/* 0x2700 */  83, 77, 65, 53, 48, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48,
/* 0x2710 */  32, 32, 48, 32, 32, 48, 51, 50,101, 32, 32, 50, 42, 42, 48, 32,
/* 0x2720 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 49, 32, 78, 50,
/* 0x2730 */  69, 70, 65, 83, 53, 48, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32,
/* 0x2740 */  48, 32, 32, 48, 32, 32, 48, 51, 51, 48, 32, 32, 50, 42, 42, 48,
/* 0x2750 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 50, 32, 78,
/* 0x2760 */  50, 69, 68, 69, 67, 53, 48, 32, 32, 32, 32, 32, 32, 48, 57, 32,
/* 0x2770 */  32, 48, 32, 32, 48, 32, 32, 48, 51, 51, 51, 32, 32, 50, 42, 42,
/* 0x2780 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 51, 32,
/* 0x2790 */  78, 50, 69, 83, 77, 65, 54, 48, 32, 32, 32, 32, 32, 32, 48,101,
/* 0x27a0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 51, 99, 32, 32, 50, 42,
/* 0x27b0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 52,
/* 0x27c0 */  32, 78, 50, 69, 70, 65, 83, 54, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x27d0 */  49, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 52, 97, 32, 32,
/* 0x27e0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x27f0 */  54, 53, 32, 78, 50, 69, 70, 65, 83, 54, 49, 32, 32, 32, 32, 32,
/* 0x2800 */  32, 48, 49, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 54, 48,
/* 0x2810 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2820 */  10, 32, 54, 54, 32, 78, 50, 69, 68, 69, 67, 54, 48, 32, 32, 32,
/* 0x2830 */  32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 55, 54,
/* 0x2840 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2850 */  10, 32, 54, 55, 32, 76, 90, 77, 65, 95, 68, 69, 67, 48, 48, 32,
/* 0x2860 */  32, 32, 32, 48, 50,101, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51,
/* 0x2870 */  55, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2880 */  84, 83, 10, 32, 54, 56, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48,
/* 0x2890 */  48, 32, 32, 32, 32, 48, 52, 56, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x28a0 */  48, 51, 97, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x28b0 */  69, 78, 84, 83, 10, 32, 54, 57, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x28c0 */  67, 49, 48, 32, 32, 32, 32, 48, 97, 56, 54, 32, 32, 48, 32, 32,
/* 0x28d0 */  48, 32, 32, 48, 51,101, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x28e0 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 55, 48, 32, 76, 90, 77, 65,
/* 0x28f0 */  95, 68, 69, 67, 50, 48, 32, 32, 32, 32, 48, 97, 56, 54, 32, 32,
/* 0x2900 */  48, 32, 32, 48, 32, 32, 48,101, 55, 50, 32, 32, 50, 42, 42, 48,
/* 0x2910 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 55, 49, 32, 76,
/* 0x2920 */  90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 49, 97,
/* 0x2930 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 56,102, 56, 32, 32, 50,
/* 0x2940 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 55,
/* 0x2950 */  50, 32, 80, 69, 77, 65, 73, 78, 49, 48, 32, 32, 32, 32, 32, 32,
/* 0x2960 */  48, 49, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 49, 50, 32,
/* 0x2970 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2980 */  32, 55, 51, 32, 80, 69, 84, 76, 83, 72, 65, 75, 50, 32, 32, 32,
/* 0x2990 */  32, 32, 48, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 49,
/* 0x29a0 */  51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x29b0 */  83, 10, 32, 55, 52, 32, 80, 69, 67, 84, 84, 80, 79, 83, 32, 32,
/* 0x29c0 */  32, 32, 32, 32, 48, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x29d0 */  57, 49, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x29e0 */  78, 84, 83, 10, 32, 55, 53, 32, 80, 69, 67, 84, 84, 78, 85, 76,
/* 0x29f0 */  32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2a00 */  48, 49, 57, 49,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2a10 */  84, 69, 78, 84, 83, 10, 32, 55, 54, 32, 67, 65, 76, 76, 84, 82,
/* 0x2a20 */  48, 48, 32, 32, 32, 32, 32, 32, 48,101, 32, 32, 48, 32, 32, 48,
/* 0x2a30 */  32, 32, 48, 49, 57, 49,102, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2a40 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 55, 55, 32, 67, 84, 67, 76,
/* 0x2a50 */  69, 86, 69, 49, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32,
/* 0x2a60 */  32, 48, 32, 32, 48, 49, 57, 50,100, 32, 32, 50, 42, 42, 48, 32,
/* 0x2a70 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 55, 56, 32, 67, 65,
/* 0x2a80 */  76, 76, 84, 82, 48, 49, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32,
/* 0x2a90 */  48, 32, 32, 48, 32, 32, 48, 49, 57, 51, 50, 32, 32, 50, 42, 42,
/* 0x2aa0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 55, 57, 32,
/* 0x2ab0 */  67, 84, 66, 83, 72, 82, 48, 49, 32, 32, 32, 32, 32, 32, 48, 52,
/* 0x2ac0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 51, 55, 32, 32, 50,
/* 0x2ad0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 56,
/* 0x2ae0 */  48, 32, 67, 84, 66, 82, 79, 82, 48, 49, 32, 32, 32, 32, 32, 32,
/* 0x2af0 */  48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 51, 98, 32,
/* 0x2b00 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2b10 */  32, 56, 49, 32, 67, 84, 66, 83, 87, 65, 48, 49, 32, 32, 32, 32,
/* 0x2b20 */  32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 51,
/* 0x2b30 */ 100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2b40 */  83, 10, 32, 56, 50, 32, 67, 65, 76, 76, 84, 82, 48, 50, 32, 32,
/* 0x2b50 */  32, 32, 32, 32, 48, 49, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2b60 */  49, 57, 52, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2b70 */  69, 78, 84, 83, 10, 32, 56, 51, 32, 67, 65, 76, 76, 84, 82, 49,
/* 0x2b80 */  48, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32,
/* 0x2b90 */  32, 48, 49, 57, 53, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2ba0 */  78, 84, 69, 78, 84, 83, 10, 32, 56, 52, 32, 67, 65, 76, 76, 84,
/* 0x2bb0 */  82, 69, 56, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32,
/* 0x2bc0 */  48, 32, 32, 48, 49, 57, 53, 55, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2bd0 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 56, 53, 32, 67, 65, 76,
/* 0x2be0 */  76, 84, 82, 69, 57, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48,
/* 0x2bf0 */  32, 32, 48, 32, 32, 48, 49, 57, 53, 57, 32, 32, 50, 42, 42, 48,
/* 0x2c00 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 56, 54, 32, 67,
/* 0x2c10 */  65, 76, 76, 84, 82, 49, 49, 32, 32, 32, 32, 32, 32, 48, 52, 32,
/* 0x2c20 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 53, 98, 32, 32, 50, 42,
/* 0x2c30 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 56, 55,
/* 0x2c40 */  32, 67, 84, 67, 76, 69, 86, 69, 50, 32, 32, 32, 32, 32, 32, 48,
/* 0x2c50 */  53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 53,102, 32, 32,
/* 0x2c60 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x2c70 */  56, 56, 32, 67, 65, 76, 76, 84, 82, 49, 50, 32, 32, 32, 32, 32,
/* 0x2c80 */  32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 54, 52,
/* 0x2c90 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2ca0 */  10, 32, 56, 57, 32, 67, 84, 66, 83, 72, 82, 49, 49, 32, 32, 32,
/* 0x2cb0 */  32, 32, 32, 48, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57,
/* 0x2cc0 */  54, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2cd0 */  84, 83, 10, 32, 57, 48, 32, 67, 84, 66, 82, 79, 82, 49, 49, 32,
/* 0x2ce0 */  32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2cf0 */  49, 57, 54, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2d00 */  69, 78, 84, 83, 10, 32, 57, 49, 32, 67, 84, 66, 83, 87, 65, 49,
/* 0x2d10 */  49, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32,
/* 0x2d20 */  32, 48, 49, 57, 54, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2d30 */  78, 84, 69, 78, 84, 83, 10, 32, 57, 50, 32, 67, 65, 76, 76, 84,
/* 0x2d40 */  82, 49, 51, 32, 32, 32, 32, 32, 32, 48, 55, 32, 32, 48, 32, 32,
/* 0x2d50 */  48, 32, 32, 48, 49, 57, 55, 49, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2d60 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 57, 51, 32, 99,116,111,
/* 0x2d70 */ 107, 51, 50, 46, 48, 48, 32, 32, 32, 32, 32, 48, 97, 32, 32, 48,
/* 0x2d80 */  32, 32, 48, 32, 32, 48, 49, 57, 55, 56, 32, 32, 50, 42, 42, 48,
/* 0x2d90 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 57, 52, 32, 99,
/* 0x2da0 */ 116,111,107, 51, 50, 46, 49, 48, 32, 32, 32, 32, 32, 48,101, 32,
/* 0x2db0 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 56, 50, 32, 32, 50, 42,
/* 0x2dc0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 57, 53,
/* 0x2dd0 */  32, 99,116,111,107, 51, 50, 46, 50, 48, 32, 32, 32, 32, 32, 48,
/* 0x2de0 */  50, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 57, 48, 32,
/* 0x2df0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2e00 */  32, 57, 54, 32, 99,116,111,107, 51, 50, 46, 51, 48, 32, 32, 32,
/* 0x2e10 */  32, 32, 48, 97, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 98,
/* 0x2e20 */  48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2e30 */  83, 10, 32, 57, 55, 32, 99,116,111,107, 51, 50, 46, 52, 48, 32,
/* 0x2e40 */  32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x2e50 */  57, 98, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2e60 */  78, 84, 83, 10, 32, 57, 56, 32, 80, 69, 73, 77, 80, 79, 82, 84,
/* 0x2e70 */  32, 32, 32, 32, 32, 32, 48, 50, 99, 32, 32, 48, 32, 32, 48, 32,
/* 0x2e80 */  32, 48, 49, 57, 98,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2e90 */  78, 84, 69, 78, 84, 83, 10, 32, 57, 57, 32, 80, 69, 73, 66, 89,
/* 0x2ea0 */  79, 82, 68, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32,
/* 0x2eb0 */  48, 32, 32, 48, 49, 57,101, 98, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2ec0 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 48, 48, 32, 80, 69, 75,
/* 0x2ed0 */  51, 50, 79, 82, 68, 32, 32, 32, 32, 32, 32, 48, 49, 48, 32, 32,
/* 0x2ee0 */  48, 32, 32, 48, 32, 32, 48, 49, 57,101,100, 32, 32, 50, 42, 42,
/* 0x2ef0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 48, 49, 32,
/* 0x2f00 */  80, 69, 73, 77, 79, 82, 68, 49, 32, 32, 32, 32, 32, 32, 48, 55,
/* 0x2f10 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57,102,100, 32, 32, 50,
/* 0x2f20 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 48,
/* 0x2f30 */  50, 32, 80, 69, 73, 77, 80, 79, 82, 50, 32, 32, 32, 32, 32, 32,
/* 0x2f40 */  48, 49, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 48, 52,
/* 0x2f50 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2f60 */  10, 49, 48, 51, 32, 80, 69, 73, 69, 82, 68, 76, 76, 32, 32, 32,
/* 0x2f70 */  32, 32, 32, 48, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97,
/* 0x2f80 */  49, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2f90 */  84, 83, 10, 49, 48, 52, 32, 80, 69, 73, 69, 82, 69, 88, 69, 32,
/* 0x2fa0 */  32, 32, 32, 32, 32, 48, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2fb0 */  49, 97, 50, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2fc0 */  69, 78, 84, 83, 10, 49, 48, 53, 32, 80, 69, 73, 77, 68, 79, 78,
/* 0x2fd0 */  69, 32, 32, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2fe0 */  48, 49, 97, 50, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2ff0 */  84, 69, 78, 84, 83, 10, 49, 48, 54, 32, 80, 69, 82, 69, 76, 79,
/* 0x3000 */  67, 49, 32, 32, 32, 32, 32, 32, 48, 54, 32, 32, 48, 32, 32, 48,
/* 0x3010 */  32, 32, 48, 49, 97, 50, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x3020 */  79, 78, 84, 69, 78, 84, 83, 10, 49, 48, 55, 32, 80, 69, 82, 69,
/* 0x3030 */  76, 79, 67, 50, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32,
/* 0x3040 */  32, 48, 32, 32, 48, 49, 97, 50, 99, 32, 32, 50, 42, 42, 48, 32,
/* 0x3050 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 48, 56, 32, 80, 69,
/* 0x3060 */  82, 69, 76, 79, 67, 51, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32,
/* 0x3070 */  48, 32, 32, 48, 32, 32, 48, 49, 97, 50,102, 32, 32, 50, 42, 42,
/* 0x3080 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 48, 57, 32,
/* 0x3090 */  82, 69, 76, 79, 67, 51, 50, 48, 32, 32, 32, 32, 32, 32, 48, 50,
/* 0x30a0 */  57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 51, 50, 32, 32,
/* 0x30b0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49,
/* 0x30c0 */  49, 48, 32, 82, 69, 76, 51, 50, 66, 73, 71, 32, 32, 32, 32, 32,
/* 0x30d0 */  32, 48, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 53, 98,
/* 0x30e0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x30f0 */  10, 49, 49, 49, 32, 82, 69, 76, 79, 67, 51, 50, 74, 32, 32, 32,
/* 0x3100 */  32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97,
/* 0x3110 */  54, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x3120 */  84, 83, 10, 49, 49, 50, 32, 82, 69, 76, 51, 50, 69, 78, 68, 32,
/* 0x3130 */  32, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x3140 */  97, 54, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x3150 */  78, 84, 83, 10, 49, 49, 51, 32, 80, 69, 82, 76, 79, 72, 73, 48,
/* 0x3160 */  32, 32, 32, 32, 32, 32, 48, 56, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x3170 */  48, 49, 97, 54, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x3180 */  84, 69, 78, 84, 83, 10, 49, 49, 52, 32, 80, 69, 82, 69, 76, 76,
/* 0x3190 */  79, 48, 32, 32, 32, 32, 32, 32, 48, 97, 32, 32, 48, 32, 32, 48,
/* 0x31a0 */  32, 32, 48, 49, 97, 54,101, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x31b0 */  79, 78, 84, 69, 78, 84, 83, 10, 49, 49, 53, 32, 80, 69, 82, 69,
/* 0x31c0 */  76, 72, 73, 48, 32, 32, 32, 32, 32, 32, 48,100, 32, 32, 48, 32,
/* 0x31d0 */  32, 48, 32, 32, 48, 49, 97, 55, 56, 32, 32, 50, 42, 42, 48, 32,
/* 0x31e0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 49, 54, 32, 80, 69,
/* 0x31f0 */  68, 69, 80, 72, 65, 75, 32, 32, 32, 32, 32, 32, 48, 50,102, 32,
/* 0x3200 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 56, 53, 32, 32, 50, 42,
/* 0x3210 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 49, 55,
/* 0x3220 */  32, 80, 69, 84, 76, 83, 67, 32, 32, 32, 32, 32, 32, 32, 32, 48,
/* 0x3230 */  49, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 98, 52, 32,
/* 0x3240 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x3250 */  49, 49, 56, 32, 80, 69, 77, 65, 73, 78, 50, 48, 32, 32, 32, 32,
/* 0x3260 */  32, 32, 48, 49, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 99,
/* 0x3270 */  99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x3280 */  83, 10, 49, 49, 57, 32, 67, 76, 69, 65, 82, 83, 84, 65, 67, 75,
/* 0x3290 */  32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x32a0 */  97, 99,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x32b0 */  78, 84, 83, 10, 49, 50, 48, 32, 80, 69, 77, 65, 73, 78, 50, 49,
/* 0x32c0 */  32, 32, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x32d0 */  49, 97,100, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x32e0 */  69, 78, 84, 83, 10, 49, 50, 49, 32, 80, 69, 82, 69, 84, 85, 82,
/* 0x32f0 */  78, 32, 32, 32, 32, 32, 32, 48, 54, 32, 32, 48, 32, 32, 48, 32,
/* 0x3300 */  32, 48, 49, 97,100, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x3310 */  78, 84, 69, 78, 84, 83, 10, 49, 50, 50, 32, 80, 69, 68, 79, 74,
/* 0x3320 */  85, 77, 80, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32,
/* 0x3330 */  48, 32, 32, 48, 49, 97,101, 48, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x3340 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 50, 51, 32, 80, 69, 84,
/* 0x3350 */  76, 83, 67, 50, 32, 32, 32, 32, 32, 32, 32, 48, 49,102, 32, 32,
/* 0x3360 */  48, 32, 32, 48, 32, 32, 48, 49, 97,101, 53, 32, 32, 50, 42, 42,
/* 0x3370 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 50, 52, 32,
/* 0x3380 */  85, 80, 88, 49, 72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 48, 50,
/* 0x3390 */  48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 48, 52, 32, 32,
/* 0x33a0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 83,
/* 0x33b0 */  89, 77, 66, 79, 76, 32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48,
/* 0x33c0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x33d0 */  66, 83, 77, 65, 49, 48, 32, 48, 32, 78, 50, 66, 83, 77, 65, 49,
/* 0x33e0 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x33f0 */ 100, 32, 32, 78, 50, 66, 70, 65, 83, 49, 49, 32, 48, 32, 78, 50,
/* 0x3400 */  66, 70, 65, 83, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3410 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48,
/* 0x3420 */  32, 48, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x3430 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66,
/* 0x3440 */  68, 69, 67, 50, 48, 32, 48, 32, 78, 50, 66, 68, 69, 67, 50, 48,
/* 0x3450 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3460 */  32, 32, 78, 50, 66, 68, 69, 67, 51, 48, 32, 48, 32, 78, 50, 66,
/* 0x3470 */  68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3480 */  32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69, 67, 53, 48, 32,
/* 0x3490 */  48, 32, 78, 50, 66, 68, 69, 67, 53, 48, 10, 48, 48, 48, 48, 48,
/* 0x34a0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70,
/* 0x34b0 */  65, 83, 54, 49, 32, 48, 32, 78, 50, 66, 70, 65, 83, 54, 49, 10,
/* 0x34c0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x34d0 */  32, 78, 50, 66, 68, 69, 67, 54, 48, 32, 48, 32, 78, 50, 66, 68,
/* 0x34e0 */  69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x34f0 */  32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 49, 48, 32, 48,
/* 0x3500 */  32, 78, 50, 68, 83, 77, 65, 49, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x3510 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65,
/* 0x3520 */  83, 49, 49, 32, 48, 32, 78, 50, 68, 70, 65, 83, 49, 49, 10, 48,
/* 0x3530 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3540 */  78, 50, 68, 68, 69, 67, 49, 48, 32, 48, 32, 78, 50, 68, 68, 69,
/* 0x3550 */  67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3560 */  32, 32,100, 32, 32, 78, 50, 68, 68, 69, 67, 50, 48, 32, 48, 32,
/* 0x3570 */  78, 50, 68, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3580 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69, 67,
/* 0x3590 */  51, 48, 32, 48, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 48, 48,
/* 0x35a0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x35b0 */  50, 68, 68, 69, 67, 53, 48, 32, 48, 32, 78, 50, 68, 68, 69, 67,
/* 0x35c0 */  53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x35d0 */  32,100, 32, 32, 78, 50, 68, 70, 65, 83, 54, 49, 32, 48, 32, 78,
/* 0x35e0 */  50, 68, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x35f0 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69, 67, 54,
/* 0x3600 */  48, 32, 48, 32, 78, 50, 68, 68, 69, 67, 54, 48, 10, 48, 48, 48,
/* 0x3610 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x3620 */  69, 83, 77, 65, 49, 48, 32, 48, 32, 78, 50, 69, 83, 77, 65, 49,
/* 0x3630 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3640 */ 100, 32, 32, 78, 50, 69, 70, 65, 83, 49, 49, 32, 48, 32, 78, 50,
/* 0x3650 */  69, 70, 65, 83, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3660 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48,
/* 0x3670 */  32, 48, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x3680 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69,
/* 0x3690 */  68, 69, 67, 50, 48, 32, 48, 32, 78, 50, 69, 68, 69, 67, 50, 48,
/* 0x36a0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x36b0 */  32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 32, 48, 32, 78, 50, 69,
/* 0x36c0 */  68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x36d0 */  32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69, 67, 53, 48, 32,
/* 0x36e0 */  48, 32, 78, 50, 69, 68, 69, 67, 53, 48, 10, 48, 48, 48, 48, 48,
/* 0x36f0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70,
/* 0x3700 */  65, 83, 54, 49, 32, 48, 32, 78, 50, 69, 70, 65, 83, 54, 49, 10,
/* 0x3710 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3720 */  32, 78, 50, 69, 68, 69, 67, 54, 48, 32, 48, 32, 78, 50, 69, 68,
/* 0x3730 */  69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3740 */  32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 48, 48, 32, 48,
/* 0x3750 */  32, 67, 65, 76, 76, 84, 82, 48, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x3760 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84,
/* 0x3770 */  82, 49, 48, 32, 48, 32, 67, 65, 76, 76, 84, 82, 49, 48, 10, 48,
/* 0x3780 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3790 */  67, 65, 76, 76, 84, 82, 49, 49, 32, 48, 32, 67, 65, 76, 76, 84,
/* 0x37a0 */  82, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x37b0 */  32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 49, 51, 32, 48, 32,
/* 0x37c0 */  67, 65, 76, 76, 84, 82, 49, 51, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x37d0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,116,111,107, 51, 50,
/* 0x37e0 */  46, 48, 48, 32, 48, 32, 99,116,111,107, 51, 50, 46, 48, 48, 10,
/* 0x37f0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3800 */  32, 99,116,111,107, 51, 50, 46, 49, 48, 32, 48, 32, 99,116,111,
/* 0x3810 */ 107, 51, 50, 46, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3820 */ 108, 32, 32, 32, 32,100, 32, 32, 99,116,111,107, 51, 50, 46, 50,
/* 0x3830 */  48, 32, 48, 32, 99,116,111,107, 51, 50, 46, 50, 48, 10, 48, 48,
/* 0x3840 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,
/* 0x3850 */ 116,111,107, 51, 50, 46, 52, 48, 32, 48, 32, 99,116,111,107, 51,
/* 0x3860 */  50, 46, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3870 */  32, 32, 32,100, 32, 32, 80, 69, 73, 77, 80, 79, 82, 84, 32, 48,
/* 0x3880 */  32, 80, 69, 73, 77, 80, 79, 82, 84, 10, 48, 48, 48, 48, 48, 48,
/* 0x3890 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 73, 77, 79,
/* 0x38a0 */  82, 68, 49, 32, 48, 32, 80, 69, 73, 77, 79, 82, 68, 49, 10, 48,
/* 0x38b0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x38c0 */  80, 69, 73, 77, 80, 79, 82, 50, 32, 48, 32, 80, 69, 73, 77, 80,
/* 0x38d0 */  79, 82, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x38e0 */  32, 32,100, 32, 32, 80, 69, 73, 77, 68, 79, 78, 69, 32, 48, 32,
/* 0x38f0 */  80, 69, 73, 77, 68, 79, 78, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3900 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 82, 69, 76, 79, 67, 51,
/* 0x3910 */  50, 48, 32, 48, 32, 82, 69, 76, 79, 67, 51, 50, 48, 10, 48, 48,
/* 0x3920 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 82,
/* 0x3930 */  69, 76, 79, 67, 51, 50, 74, 32, 48, 32, 82, 69, 76, 79, 67, 51,
/* 0x3940 */  50, 74, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3950 */  32,100, 32, 32, 80, 69, 77, 65, 73, 78, 50, 49, 32, 48, 32, 80,
/* 0x3960 */  69, 77, 65, 73, 78, 50, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3970 */  32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 84, 76, 83, 67, 50,
/* 0x3980 */  32, 48, 32, 80, 69, 84, 76, 83, 67, 50, 10, 48, 48, 48, 48, 48,
/* 0x3990 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 73, 83,
/* 0x39a0 */  68, 76, 76, 49, 32, 48, 32, 80, 69, 73, 83, 68, 76, 76, 49, 10,
/* 0x39b0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x39c0 */  32, 80, 69, 77, 65, 73, 78, 48, 49, 32, 48, 32, 80, 69, 77, 65,
/* 0x39d0 */  73, 78, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x39e0 */  32, 32, 32,100, 32, 32, 80, 69, 83, 79, 67, 82, 69, 76, 32, 48,
/* 0x39f0 */  32, 80, 69, 83, 79, 67, 82, 69, 76, 10, 48, 48, 48, 48, 48, 48,
/* 0x3a00 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 83, 79, 67,
/* 0x3a10 */  80, 73, 67, 32, 48, 32, 80, 69, 83, 79, 67, 80, 73, 67, 10, 48,
/* 0x3a20 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3a30 */  80, 69, 83, 79, 85, 78, 67, 48, 32, 48, 32, 80, 69, 83, 79, 85,
/* 0x3a40 */  78, 67, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3a50 */  32, 32,100, 32, 32, 80, 69, 73, 67, 79, 78, 83, 49, 32, 48, 32,
/* 0x3a60 */  80, 69, 73, 67, 79, 78, 83, 49, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3a70 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 73, 67, 79, 78,
/* 0x3a80 */  83, 50, 32, 48, 32, 80, 69, 73, 67, 79, 78, 83, 50, 10, 48, 48,
/* 0x3a90 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80,
/* 0x3aa0 */  69, 84, 76, 83, 72, 65, 75, 32, 48, 32, 80, 69, 84, 76, 83, 72,
/* 0x3ab0 */  65, 75, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3ac0 */  32,100, 32, 32, 80, 69, 77, 65, 73, 78, 48, 50, 32, 48, 32, 80,
/* 0x3ad0 */  69, 77, 65, 73, 78, 48, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3ae0 */  32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 77, 65, 73, 78, 48,
/* 0x3af0 */  51, 32, 48, 32, 80, 69, 77, 65, 73, 78, 48, 51, 10, 48, 48, 48,
/* 0x3b00 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x3b10 */  66, 70, 65, 83, 49, 48, 32, 48, 32, 78, 50, 66, 70, 65, 83, 49,
/* 0x3b20 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3b30 */ 100, 32, 32, 78, 50, 66, 83, 77, 65, 50, 48, 32, 48, 32, 78, 50,
/* 0x3b40 */  66, 83, 77, 65, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3b50 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 50, 48,
/* 0x3b60 */  32, 48, 32, 78, 50, 66, 70, 65, 83, 50, 48, 10, 48, 48, 48, 48,
/* 0x3b70 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66,
/* 0x3b80 */  83, 77, 65, 51, 48, 32, 48, 32, 78, 50, 66, 83, 77, 65, 51, 48,
/* 0x3b90 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3ba0 */  32, 32, 78, 50, 66, 70, 65, 83, 51, 48, 32, 48, 32, 78, 50, 66,
/* 0x3bb0 */  70, 65, 83, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3bc0 */  32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 52, 48, 32,
/* 0x3bd0 */  48, 32, 78, 50, 66, 83, 77, 65, 52, 48, 10, 48, 48, 48, 48, 48,
/* 0x3be0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70,
/* 0x3bf0 */  65, 83, 52, 48, 32, 48, 32, 78, 50, 66, 70, 65, 83, 52, 48, 10,
/* 0x3c00 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3c10 */  32, 78, 50, 66, 83, 77, 65, 53, 48, 32, 48, 32, 78, 50, 66, 83,
/* 0x3c20 */  77, 65, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3c30 */  32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 53, 48, 32, 48,
/* 0x3c40 */  32, 78, 50, 66, 70, 65, 83, 53, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x3c50 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77,
/* 0x3c60 */  65, 54, 48, 32, 48, 32, 78, 50, 66, 83, 77, 65, 54, 48, 10, 48,
/* 0x3c70 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3c80 */  78, 50, 66, 70, 65, 83, 54, 48, 32, 48, 32, 78, 50, 66, 70, 65,
/* 0x3c90 */  83, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3ca0 */  32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 49, 48, 32, 48, 32,
/* 0x3cb0 */  78, 50, 68, 70, 65, 83, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3cc0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65,
/* 0x3cd0 */  50, 48, 32, 48, 32, 78, 50, 68, 83, 77, 65, 50, 48, 10, 48, 48,
/* 0x3ce0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x3cf0 */  50, 68, 70, 65, 83, 50, 48, 32, 48, 32, 78, 50, 68, 70, 65, 83,
/* 0x3d00 */  50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3d10 */  32,100, 32, 32, 78, 50, 68, 83, 77, 65, 51, 48, 32, 48, 32, 78,
/* 0x3d20 */  50, 68, 83, 77, 65, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3d30 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 51,
/* 0x3d40 */  48, 32, 48, 32, 78, 50, 68, 70, 65, 83, 51, 48, 10, 48, 48, 48,
/* 0x3d50 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x3d60 */  68, 83, 77, 65, 52, 48, 32, 48, 32, 78, 50, 68, 83, 77, 65, 52,
/* 0x3d70 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3d80 */ 100, 32, 32, 78, 50, 68, 70, 65, 83, 52, 48, 32, 48, 32, 78, 50,
/* 0x3d90 */  68, 70, 65, 83, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3da0 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 53, 48,
/* 0x3db0 */  32, 48, 32, 78, 50, 68, 83, 77, 65, 53, 48, 10, 48, 48, 48, 48,
/* 0x3dc0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68,
/* 0x3dd0 */  70, 65, 83, 53, 48, 32, 48, 32, 78, 50, 68, 70, 65, 83, 53, 48,
/* 0x3de0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3df0 */  32, 32, 78, 50, 68, 83, 77, 65, 54, 48, 32, 48, 32, 78, 50, 68,
/* 0x3e00 */  83, 77, 65, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3e10 */  32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 54, 48, 32,
/* 0x3e20 */  48, 32, 78, 50, 68, 70, 65, 83, 54, 48, 10, 48, 48, 48, 48, 48,
/* 0x3e30 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70,
/* 0x3e40 */  65, 83, 49, 48, 32, 48, 32, 78, 50, 69, 70, 65, 83, 49, 48, 10,
/* 0x3e50 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3e60 */  32, 78, 50, 69, 83, 77, 65, 50, 48, 32, 48, 32, 78, 50, 69, 83,
/* 0x3e70 */  77, 65, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3e80 */  32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 50, 48, 32, 48,
/* 0x3e90 */  32, 78, 50, 69, 70, 65, 83, 50, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x3ea0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77,
/* 0x3eb0 */  65, 51, 48, 32, 48, 32, 78, 50, 69, 83, 77, 65, 51, 48, 10, 48,
/* 0x3ec0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3ed0 */  78, 50, 69, 70, 65, 83, 51, 48, 32, 48, 32, 78, 50, 69, 70, 65,
/* 0x3ee0 */  83, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3ef0 */  32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 52, 48, 32, 48, 32,
/* 0x3f00 */  78, 50, 69, 83, 77, 65, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3f10 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83,
/* 0x3f20 */  52, 48, 32, 48, 32, 78, 50, 69, 70, 65, 83, 52, 48, 10, 48, 48,
/* 0x3f30 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x3f40 */  50, 69, 83, 77, 65, 53, 48, 32, 48, 32, 78, 50, 69, 83, 77, 65,
/* 0x3f50 */  53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3f60 */  32,100, 32, 32, 78, 50, 69, 70, 65, 83, 53, 48, 32, 48, 32, 78,
/* 0x3f70 */  50, 69, 70, 65, 83, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3f80 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 54,
/* 0x3f90 */  48, 32, 48, 32, 78, 50, 69, 83, 77, 65, 54, 48, 10, 48, 48, 48,
/* 0x3fa0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x3fb0 */  69, 70, 65, 83, 54, 48, 32, 48, 32, 78, 50, 69, 70, 65, 83, 54,
/* 0x3fc0 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3fd0 */ 100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 48, 48, 32, 48, 32,
/* 0x3fe0 */  76, 90, 77, 65, 95, 68, 69, 67, 48, 48, 10, 48, 48, 48, 48, 48,
/* 0x3ff0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65,
/* 0x4000 */  95, 69, 76, 70, 48, 48, 32, 48, 32, 76, 90, 77, 65, 95, 69, 76,
/* 0x4010 */  70, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x4020 */  32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32,
/* 0x4030 */  48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x4040 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90,
/* 0x4050 */  77, 65, 95, 68, 69, 67, 50, 48, 32, 48, 32, 76, 90, 77, 65, 95,
/* 0x4060 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4070 */  32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51,
/* 0x4080 */  48, 32, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 10, 48,
/* 0x4090 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x40a0 */  80, 69, 77, 65, 73, 78, 49, 48, 32, 48, 32, 80, 69, 77, 65, 73,
/* 0x40b0 */  78, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x40c0 */  32, 32,100, 32, 32, 80, 69, 84, 76, 83, 72, 65, 75, 50, 32, 48,
/* 0x40d0 */  32, 80, 69, 84, 76, 83, 72, 65, 75, 50, 10, 48, 48, 48, 48, 48,
/* 0x40e0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 67, 84,
/* 0x40f0 */  84, 80, 79, 83, 32, 48, 32, 80, 69, 67, 84, 84, 80, 79, 83, 10,
/* 0x4100 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x4110 */  32, 80, 69, 67, 84, 84, 78, 85, 76, 32, 48, 32, 80, 69, 67, 84,
/* 0x4120 */  84, 78, 85, 76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4130 */  32, 32, 32,100, 32, 32, 67, 84, 67, 76, 69, 86, 69, 49, 32, 48,
/* 0x4140 */  32, 67, 84, 67, 76, 69, 86, 69, 49, 10, 48, 48, 48, 48, 48, 48,
/* 0x4150 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84,
/* 0x4160 */  82, 48, 49, 32, 48, 32, 67, 65, 76, 76, 84, 82, 48, 49, 10, 48,
/* 0x4170 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x4180 */  67, 84, 66, 83, 72, 82, 48, 49, 32, 48, 32, 67, 84, 66, 83, 72,
/* 0x4190 */  82, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x41a0 */  32, 32,100, 32, 32, 67, 84, 66, 82, 79, 82, 48, 49, 32, 48, 32,
/* 0x41b0 */  67, 84, 66, 82, 79, 82, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x41c0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66, 83, 87, 65,
/* 0x41d0 */  48, 49, 32, 48, 32, 67, 84, 66, 83, 87, 65, 48, 49, 10, 48, 48,
/* 0x41e0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,
/* 0x41f0 */  65, 76, 76, 84, 82, 48, 50, 32, 48, 32, 67, 65, 76, 76, 84, 82,
/* 0x4200 */  48, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x4210 */  32,100, 32, 32, 67, 65, 76, 76, 84, 82, 69, 56, 32, 48, 32, 67,
/* 0x4220 */  65, 76, 76, 84, 82, 69, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4230 */  32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 69,
/* 0x4240 */  57, 32, 48, 32, 67, 65, 76, 76, 84, 82, 69, 57, 10, 48, 48, 48,
/* 0x4250 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84,
/* 0x4260 */  67, 76, 69, 86, 69, 50, 32, 48, 32, 67, 84, 67, 76, 69, 86, 69,
/* 0x4270 */  50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4280 */ 100, 32, 32, 67, 65, 76, 76, 84, 82, 49, 50, 32, 48, 32, 67, 65,
/* 0x4290 */  76, 76, 84, 82, 49, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x42a0 */ 108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66, 83, 72, 82, 49, 49,
/* 0x42b0 */  32, 48, 32, 67, 84, 66, 83, 72, 82, 49, 49, 10, 48, 48, 48, 48,
/* 0x42c0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66,
/* 0x42d0 */  82, 79, 82, 49, 49, 32, 48, 32, 67, 84, 66, 82, 79, 82, 49, 49,
/* 0x42e0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x42f0 */  32, 32, 67, 84, 66, 83, 87, 65, 49, 49, 32, 48, 32, 67, 84, 66,
/* 0x4300 */  83, 87, 65, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4310 */  32, 32, 32, 32,100, 32, 32, 99,116,111,107, 51, 50, 46, 51, 48,
/* 0x4320 */  32, 48, 32, 99,116,111,107, 51, 50, 46, 51, 48, 10, 48, 48, 48,
/* 0x4330 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69,
/* 0x4340 */  73, 66, 89, 79, 82, 68, 32, 48, 32, 80, 69, 73, 66, 89, 79, 82,
/* 0x4350 */  68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4360 */ 100, 32, 32, 80, 69, 75, 51, 50, 79, 82, 68, 32, 48, 32, 80, 69,
/* 0x4370 */  75, 51, 50, 79, 82, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4380 */ 108, 32, 32, 32, 32,100, 32, 32, 80, 69, 73, 69, 82, 68, 76, 76,
/* 0x4390 */  32, 48, 32, 80, 69, 73, 69, 82, 68, 76, 76, 10, 48, 48, 48, 48,
/* 0x43a0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 73,
/* 0x43b0 */  69, 82, 69, 88, 69, 32, 48, 32, 80, 69, 73, 69, 82, 69, 88, 69,
/* 0x43c0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x43d0 */  32, 32, 80, 69, 82, 69, 76, 79, 67, 49, 32, 48, 32, 80, 69, 82,
/* 0x43e0 */  69, 76, 79, 67, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x43f0 */  32, 32, 32, 32,100, 32, 32, 80, 69, 82, 69, 76, 79, 67, 50, 32,
/* 0x4400 */  48, 32, 80, 69, 82, 69, 76, 79, 67, 50, 10, 48, 48, 48, 48, 48,
/* 0x4410 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 82, 69,
/* 0x4420 */  76, 79, 67, 51, 32, 48, 32, 80, 69, 82, 69, 76, 79, 67, 51, 10,
/* 0x4430 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x4440 */  32, 82, 69, 76, 51, 50, 66, 73, 71, 32, 48, 32, 82, 69, 76, 51,
/* 0x4450 */  50, 66, 73, 71, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4460 */  32, 32, 32,100, 32, 32, 82, 69, 76, 51, 50, 69, 78, 68, 32, 48,
/* 0x4470 */  32, 82, 69, 76, 51, 50, 69, 78, 68, 10, 48, 48, 48, 48, 48, 48,
/* 0x4480 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 82, 76, 79,
/* 0x4490 */  72, 73, 48, 32, 48, 32, 80, 69, 82, 76, 79, 72, 73, 48, 10, 48,
/* 0x44a0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x44b0 */  80, 69, 82, 69, 76, 76, 79, 48, 32, 48, 32, 80, 69, 82, 69, 76,
/* 0x44c0 */  76, 79, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x44d0 */  32, 32,100, 32, 32, 80, 69, 82, 69, 76, 72, 73, 48, 32, 48, 32,
/* 0x44e0 */  80, 69, 82, 69, 76, 72, 73, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x44f0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 68, 69, 80, 72,
/* 0x4500 */  65, 75, 32, 48, 32, 80, 69, 68, 69, 80, 72, 65, 75, 10, 48, 48,
/* 0x4510 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80,
/* 0x4520 */  69, 84, 76, 83, 67, 32, 48, 32, 80, 69, 84, 76, 83, 67, 10, 48,
/* 0x4530 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x4540 */  80, 69, 77, 65, 73, 78, 50, 48, 32, 48, 32, 80, 69, 77, 65, 73,
/* 0x4550 */  78, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x4560 */  32, 32,100, 32, 32, 67, 76, 69, 65, 82, 83, 84, 65, 67, 75, 32,
/* 0x4570 */  48, 32, 67, 76, 69, 65, 82, 83, 84, 65, 67, 75, 10, 48, 48, 48,
/* 0x4580 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69,
/* 0x4590 */  82, 69, 84, 85, 82, 78, 32, 48, 32, 80, 69, 82, 69, 84, 85, 82,
/* 0x45a0 */  78, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x45b0 */ 100, 32, 32, 80, 69, 68, 79, 74, 85, 77, 80, 32, 48, 32, 80, 69,
/* 0x45c0 */  68, 79, 74, 85, 77, 80, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x45d0 */ 108, 32, 32, 32, 32,100, 32, 32, 85, 80, 88, 49, 72, 69, 65, 68,
/* 0x45e0 */  32, 48, 32, 85, 80, 88, 49, 72, 69, 65, 68, 10, 48, 48, 48, 48,
/* 0x45f0 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x4600 */  68, 42, 32, 48, 32,115,116, 97,114,116, 95,111,102, 95, 99,111,
/* 0x4610 */ 109,112,114,101,115,115,101,100, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4620 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32,
/* 0x4630 */  48, 32,115,116, 97,114,116, 95,111,102, 95,117,110, 99,111,109,
/* 0x4640 */ 112,114,101,115,115,101,100, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4650 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48,
/* 0x4660 */  32,105, 99,111,110, 95,111,102,102,115,101,116, 10, 48, 48, 48,
/* 0x4670 */  48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,
/* 0x4680 */  78, 68, 42, 32, 48, 32,105, 99,111,110, 95,100,101,108,116, 97,
/* 0x4690 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,
/* 0x46a0 */  32, 32, 42, 85, 78, 68, 42, 32, 48, 32,116,108,115, 95, 97,100,
/* 0x46b0 */ 100,114,101,115,115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x46c0 */  32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,116,
/* 0x46d0 */ 108,115, 95,118, 97,108,117,101, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x46e0 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32,
/* 0x46f0 */  48, 32,108,122,109, 97, 95,115,116, 97, 99,107, 95, 97,100,106,
/* 0x4700 */ 117,115,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32,
/* 0x4710 */  32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,108,122,109,
/* 0x4720 */  97, 95,117, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4730 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48,
/* 0x4740 */  32,108,122,109, 97, 95, 99, 95,108,101,110, 10, 48, 48, 48, 48,
/* 0x4750 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x4760 */  68, 42, 32, 48, 32,108,122,109, 97, 95,112,114,111,112,101,114,
/* 0x4770 */ 116,105,101,115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32,
/* 0x4780 */  32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,102,105,
/* 0x4790 */ 108,116,101,114, 95, 98,117,102,102,101,114, 95,115,116, 97,114,
/* 0x47a0 */ 116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32,
/* 0x47b0 */  32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,102,105,108,116,101,
/* 0x47c0 */ 114, 95,108,101,110,103,116,104, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x47d0 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32,
/* 0x47e0 */  48, 32,102,105,108,116,101,114, 95, 99,116,111, 10, 48, 48, 48,
/* 0x47f0 */  48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,
/* 0x4800 */  78, 68, 42, 32, 48, 32, 99,111,109,112,114,101,115,115,101,100,
/* 0x4810 */  95,105,109,112,111,114,116,115, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4820 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32,
/* 0x4830 */  48, 32,115,116, 97,114,116, 95,111,102, 95,105,109,112,111,114,
/* 0x4840 */ 116,115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32,
/* 0x4850 */  32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32, 76,111, 97,100,
/* 0x4860 */  76,105, 98,114, 97,114,121, 65, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4870 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32,
/* 0x4880 */  48, 32,107,101,114,110,101,108, 51, 50, 95,111,114,100,105,110,
/* 0x4890 */  97,108,115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32,
/* 0x48a0 */  32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32, 71,101,116,
/* 0x48b0 */  80,114,111, 99, 65,100,100,114,101,115,115, 10, 48, 48, 48, 48,
/* 0x48c0 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x48d0 */  68, 42, 32, 48, 32, 69,120,105,116, 80,114,111, 99,101,115,115,
/* 0x48e0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,
/* 0x48f0 */  32, 32, 42, 85, 78, 68, 42, 32, 48, 32,115,116, 97,114,116, 95,
/* 0x4900 */ 111,102, 95,114,101,108,111, 99,115, 10, 48, 48, 48, 48, 48, 48,
/* 0x4910 */  48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,
/* 0x4920 */  32, 48, 32,114,101,108,111, 99, 95,100,101,108,116, 10, 48, 48,
/* 0x4930 */  48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42,
/* 0x4940 */  85, 78, 68, 42, 32, 48, 32, 86,105,114,116,117, 97,108, 80,114,
/* 0x4950 */ 111,116,101, 99,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x4960 */  32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,118,
/* 0x4970 */ 112, 95, 98, 97,115,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4980 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,
/* 0x4990 */ 118,112, 95,115,105,122,101, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x49a0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48,
/* 0x49b0 */  32,115,119,114,105, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x49c0 */  32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,116,
/* 0x49d0 */ 108,115, 95,109,111,100,117,108,101, 95, 98, 97,115,101, 10, 48,
/* 0x49e0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x49f0 */  42, 85, 78, 68, 42, 32, 48, 32,111,114,105,103,105,110, 97,108,
/* 0x4a00 */  95,101,110,116,114,121, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4a10 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,
/* 0x4a20 */ 116,108,115, 95, 99, 97,108,108, 98, 97, 99,107,115, 95,112,116,
/* 0x4a30 */ 114, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x4a40 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 73, 83, 68,
/* 0x4a50 */  76, 76, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x4a60 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4a70 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 55, 32,
/* 0x4a80 */  82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x4a90 */  32, 32, 80, 69, 77, 65, 73, 78, 50, 49, 10, 10, 82, 69, 76, 79,
/* 0x4aa0 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x4ab0 */  79, 82, 32, 91, 80, 69, 83, 79, 67, 82, 69, 76, 93, 58, 10, 79,
/* 0x4ac0 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x4ad0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x4ae0 */  48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 51,
/* 0x4af0 */  50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,115,116, 97,114,116,
/* 0x4b00 */  95,111,102, 95, 99,111,109,112,114,101,115,115,101,100, 10, 10,
/* 0x4b10 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x4b20 */  68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 83, 79, 67, 80, 73, 67,
/* 0x4b30 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x4b40 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x4b50 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 51,
/* 0x4b60 */  56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,115,
/* 0x4b70 */ 116, 97,114,116, 95,111,102, 95, 99,111,109,112,114,101,115,115,
/* 0x4b80 */ 101,100, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x4b90 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 83, 79,
/* 0x4ba0 */  85, 78, 67, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x4bb0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4bc0 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50,
/* 0x4bd0 */  32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x4be0 */  32, 32, 32,115,116, 97,114,116, 95,111,102, 95,117,110, 99,111,
/* 0x4bf0 */ 109,112,114,101,115,115,101,100, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x4c00 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x4c10 */  32, 91, 80, 69, 73, 67, 79, 78, 83, 49, 93, 58, 10, 79, 70, 70,
/* 0x4c20 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x4c30 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x4c40 */  48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32,
/* 0x4c50 */  32, 32, 32, 32, 32, 32, 32, 32, 32,105, 99,111,110, 95,111,102,
/* 0x4c60 */ 102,115,101,116, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x4c70 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69,
/* 0x4c80 */  73, 67, 79, 78, 83, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x4c90 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4ca0 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x4cb0 */  48, 51, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32,
/* 0x4cc0 */  32, 32, 32, 32, 32,105, 99,111,110, 95,111,102,102,115,101,116,
/* 0x4cd0 */  10, 48, 48, 48, 48, 48, 48, 48, 55, 32, 82, 95, 51, 56, 54, 95,
/* 0x4ce0 */  49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,105, 99,111,110,
/* 0x4cf0 */  95,100,101,108,116, 97, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x4d00 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x4d10 */  80, 69, 84, 76, 83, 72, 65, 75, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x4d20 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4d30 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x4d40 */  48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32,
/* 0x4d50 */  32, 32, 32, 32, 32, 32, 32,116,108,115, 95, 97,100,100,114,101,
/* 0x4d60 */ 115,115, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82, 95, 51, 56,
/* 0x4d70 */  54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,116,108,
/* 0x4d80 */ 115, 95,118, 97,108,117,101, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x4d90 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x4da0 */  91, 78, 50, 66, 83, 77, 65, 49, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x4db0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x4dc0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x4dd0 */  48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x4de0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48,
/* 0x4df0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x4e00 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83,
/* 0x4e10 */  49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x4e20 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4e30 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82,
/* 0x4e40 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4e50 */  32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67,
/* 0x4e60 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x4e70 */  82, 32, 91, 78, 50, 66, 83, 77, 65, 50, 48, 93, 58, 10, 79, 70,
/* 0x4e80 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x4e90 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x4ea0 */  48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x4eb0 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 83, 77, 65,
/* 0x4ec0 */  49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x4ed0 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70,
/* 0x4ee0 */  65, 83, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x4ef0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4f00 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49,
/* 0x4f10 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x4f20 */  32, 32, 32, 78, 50, 66, 70, 65, 83, 49, 49, 10, 10, 82, 69, 76,
/* 0x4f30 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x4f40 */  70, 79, 82, 32, 91, 78, 50, 66, 83, 77, 65, 51, 48, 93, 58, 10,
/* 0x4f50 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x4f60 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x4f70 */  10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95,
/* 0x4f80 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68,
/* 0x4f90 */  69, 67, 50, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x4fa0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,
/* 0x4fb0 */  66, 70, 65, 83, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x4fc0 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4fd0 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x4fe0 */  48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x4ff0 */  32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x5000 */  48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x5010 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 50,
/* 0x5020 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x5030 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 68, 69,
/* 0x5040 */  67, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x5050 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5060 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 49, 32,
/* 0x5070 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x5080 */  32, 32, 78, 50, 66, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48,
/* 0x5090 */  48, 50,102, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x50a0 */  32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 53, 48, 10, 10,
/* 0x50b0 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x50c0 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 83, 77, 65, 52, 48,
/* 0x50d0 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x50e0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x50f0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51,
/* 0x5100 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x5110 */  50, 66, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x5120 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x5130 */  91, 78, 50, 66, 70, 65, 83, 52, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x5140 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x5150 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x5160 */  48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x5170 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 51, 48,
/* 0x5180 */  10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95,
/* 0x5190 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68,
/* 0x51a0 */  69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x51b0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,
/* 0x51c0 */  66, 83, 77, 65, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x51d0 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x51e0 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x51f0 */  48, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x5200 */  32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82,
/* 0x5210 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x5220 */  83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 54, 48, 93,
/* 0x5230 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x5240 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x5250 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 55, 32, 82, 95, 51, 56,
/* 0x5260 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x5270 */  66, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 49, 50, 32,
/* 0x5280 */  82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x5290 */  32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79,
/* 0x52a0 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x52b0 */  79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 54, 49, 93, 58, 10, 79,
/* 0x52c0 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x52d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x52e0 */  48, 48, 48, 48, 48, 48, 49, 50, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x52f0 */  67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69,
/* 0x5300 */  67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x5310 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68,
/* 0x5320 */  83, 77, 65, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x5330 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5340 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5350 */  49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x5360 */  32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69,
/* 0x5370 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x5380 */  32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 49, 48, 93, 58,
/* 0x5390 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x53a0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x53b0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,
/* 0x53c0 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68,
/* 0x53d0 */  68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x53e0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x53f0 */  50, 68, 83, 77, 65, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x5400 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5410 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x5420 */  48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x5430 */  32, 32, 32, 32, 32, 32, 78, 50, 68, 83, 77, 65, 49, 48, 10, 10,
/* 0x5440 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x5450 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 50, 48,
/* 0x5460 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x5470 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x5480 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51,
/* 0x5490 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x54a0 */  50, 68, 70, 65, 83, 49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x54b0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x54c0 */  91, 78, 50, 68, 83, 77, 65, 51, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x54d0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x54e0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x54f0 */  48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x5500 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48,
/* 0x5510 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x5520 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83,
/* 0x5530 */  51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x5540 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5550 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 53, 32, 82,
/* 0x5560 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5570 */  32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x5580 */  48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x5590 */  32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 10, 82,
/* 0x55a0 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x55b0 */  83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 68, 69, 67, 51, 48, 93,
/* 0x55c0 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x55d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x55e0 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48,102, 32, 82, 95, 51, 56,
/* 0x55f0 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x5600 */  68, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 50, 49, 32,
/* 0x5610 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x5620 */  32, 32, 78, 50, 68, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48,
/* 0x5630 */  48, 52, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x5640 */  32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 53, 48, 10, 10,
/* 0x5650 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x5660 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 52, 48,
/* 0x5670 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x5680 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x5690 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51,
/* 0x56a0 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x56b0 */  50, 68, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x56c0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x56d0 */  91, 78, 50, 68, 70, 65, 83, 52, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x56e0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x56f0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x5700 */  48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x5710 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48,
/* 0x5720 */  10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95,
/* 0x5730 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68,
/* 0x5740 */  69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x5750 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,
/* 0x5760 */  68, 83, 77, 65, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x5770 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5780 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x5790 */  48, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x57a0 */  32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82,
/* 0x57b0 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x57c0 */  83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 54, 48, 93,
/* 0x57d0 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x57e0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x57f0 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 55, 32, 82, 95, 51, 56,
/* 0x5800 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x5810 */  68, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 49, 50, 32,
/* 0x5820 */  82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x5830 */  32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79,
/* 0x5840 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x5850 */  79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 54, 49, 93, 58, 10, 79,
/* 0x5860 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x5870 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x5880 */  48, 48, 48, 48, 48, 48, 49, 50, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x5890 */  67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69,
/* 0x58a0 */  67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x58b0 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69,
/* 0x58c0 */  83, 77, 65, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x58d0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x58e0 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x58f0 */  49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x5900 */  32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69,
/* 0x5910 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x5920 */  32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 49, 48, 93, 58,
/* 0x5930 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x5940 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x5950 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,
/* 0x5960 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69,
/* 0x5970 */  68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x5980 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x5990 */  50, 69, 83, 77, 65, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x59a0 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x59b0 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x59c0 */  48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x59d0 */  32, 32, 32, 32, 32, 32, 78, 50, 69, 83, 77, 65, 49, 48, 10, 10,
/* 0x59e0 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x59f0 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 50, 48,
/* 0x5a00 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x5a10 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x5a20 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51,
/* 0x5a30 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x5a40 */  50, 69, 70, 65, 83, 49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x5a50 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x5a60 */  91, 78, 50, 69, 83, 77, 65, 51, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x5a70 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x5a80 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x5a90 */  48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x5aa0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48,
/* 0x5ab0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x5ac0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83,
/* 0x5ad0 */  51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x5ae0 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5af0 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 53, 32, 82,
/* 0x5b00 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5b10 */  32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x5b20 */  48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x5b30 */  32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 10, 82,
/* 0x5b40 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x5b50 */  83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 68, 69, 67, 51, 48, 93,
/* 0x5b60 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x5b70 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x5b80 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48,102, 32, 82, 95, 51, 56,
/* 0x5b90 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x5ba0 */  69, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 49,101, 32,
/* 0x5bb0 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x5bc0 */  32, 32, 78, 50, 69, 68, 69, 67, 53, 48, 10, 48, 48, 48, 48, 48,
/* 0x5bd0 */  48, 51, 48, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x5be0 */  32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 54, 48, 10, 10,
/* 0x5bf0 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x5c00 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 52, 48,
/* 0x5c10 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x5c20 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x5c30 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51,
/* 0x5c40 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x5c50 */  50, 69, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x5c60 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x5c70 */  91, 78, 50, 69, 70, 65, 83, 52, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x5c80 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x5c90 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x5ca0 */  48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x5cb0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48,
/* 0x5cc0 */  10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95,
/* 0x5cd0 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68,
/* 0x5ce0 */  69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x5cf0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,
/* 0x5d00 */  69, 83, 77, 65, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x5d10 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5d20 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x5d30 */  48, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x5d40 */  32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82,
/* 0x5d50 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x5d60 */  83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 54, 48, 93,
/* 0x5d70 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x5d80 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x5d90 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 55, 32, 82, 95, 51, 56,
/* 0x5da0 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x5db0 */  69, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 49, 50, 32,
/* 0x5dc0 */  82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x5dd0 */  32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79,
/* 0x5de0 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x5df0 */  79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 54, 49, 93, 58, 10, 79,
/* 0x5e00 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x5e10 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x5e20 */  48, 48, 48, 48, 48, 48, 49, 50, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x5e30 */  67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69,
/* 0x5e40 */  67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x5e50 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77,
/* 0x5e60 */  65, 95, 68, 69, 67, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x5e70 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5e80 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x5e90 */  48, 48, 53, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32,
/* 0x5ea0 */  32, 32, 32, 32, 32, 32,108,122,109, 97, 95,115,116, 97, 99,107,
/* 0x5eb0 */  95, 97,100,106,117,115,116, 10, 48, 48, 48, 48, 48, 48, 49, 52,
/* 0x5ec0 */  32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x5ed0 */  32, 32, 32,108,122,109, 97, 95,117, 95,108,101,110, 10, 48, 48,
/* 0x5ee0 */  48, 48, 48, 48, 49,101, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32,
/* 0x5ef0 */  32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95, 99, 95,
/* 0x5f00 */ 108,101,110, 10, 48, 48, 48, 48, 48, 48, 50, 97, 32, 82, 95, 51,
/* 0x5f10 */  56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,
/* 0x5f20 */ 122,109, 97, 95,112,114,111,112,101,114,116,105,101,115, 10, 10,
/* 0x5f30 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x5f40 */  68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 67, 84, 84, 80, 79, 83,
/* 0x5f50 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x5f60 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x5f70 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51,
/* 0x5f80 */  56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,
/* 0x5f90 */ 105,108,116,101,114, 95, 98,117,102,102,101,114, 95,115,116, 97,
/* 0x5fa0 */ 114,116, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x5fb0 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76,
/* 0x5fc0 */  84, 82, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x5fd0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5fe0 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49,
/* 0x5ff0 */  32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x6000 */  32, 32, 32,102,105,108,116,101,114, 95,108,101,110,103,116,104,
/* 0x6010 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x6020 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 84, 67, 76, 69, 86,
/* 0x6030 */  69, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x6040 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6050 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82,
/* 0x6060 */  95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6070 */  32,102,105,108,116,101,114, 95, 99,116,111, 10, 48, 48, 48, 48,
/* 0x6080 */  48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x6090 */  32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 48, 48, 10,
/* 0x60a0 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x60b0 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 48,
/* 0x60c0 */  50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x60d0 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x60e0 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,102, 32, 82, 95,
/* 0x60f0 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6100 */  67, 65, 76, 76, 84, 82, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x6110 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x6120 */  32, 91, 67, 65, 76, 76, 84, 82, 49, 48, 93, 58, 10, 79, 70, 70,
/* 0x6130 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x6140 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x6150 */  48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32,
/* 0x6160 */  32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114, 95,
/* 0x6170 */ 108,101,110,103,116,104, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x6180 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x6190 */  67, 65, 76, 76, 84, 82, 49, 49, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x61a0 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x61b0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x61c0 */  48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x61d0 */  32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 49, 51, 10,
/* 0x61e0 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x61f0 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 84, 67, 76, 69, 86, 69,
/* 0x6200 */  50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x6210 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x6220 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95,
/* 0x6230 */  51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6240 */ 102,105,108,116,101,114, 95, 99,116,111, 10, 48, 48, 48, 48, 48,
/* 0x6250 */  48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x6260 */  32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 49, 49, 10, 10,
/* 0x6270 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x6280 */  68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 49, 51,
/* 0x6290 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x62a0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x62b0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 54, 32, 82, 95, 51,
/* 0x62c0 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67,
/* 0x62d0 */  65, 76, 76, 84, 82, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x62e0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x62f0 */  91, 99,116,111,107, 51, 50, 46, 48, 48, 93, 58, 10, 79, 70, 70,
/* 0x6300 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x6310 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x6320 */  48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32,
/* 0x6330 */  32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114, 95,
/* 0x6340 */ 108,101,110,103,116,104, 10, 48, 48, 48, 48, 48, 48, 48, 54, 32,
/* 0x6350 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x6360 */  32, 32, 99,116,111,107, 51, 50, 46, 50, 48, 10, 10, 82, 69, 76,
/* 0x6370 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x6380 */  70, 79, 82, 32, 91, 99,116,111,107, 51, 50, 46, 49, 48, 93, 58,
/* 0x6390 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x63a0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x63b0 */  69, 10, 48, 48, 48, 48, 48, 48, 48,100, 32, 82, 95, 51, 56, 54,
/* 0x63c0 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,
/* 0x63d0 */ 107, 51, 50, 46, 50, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x63e0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x63f0 */  99,116,111,107, 51, 50, 46, 50, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x6400 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x6410 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x6420 */  48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x6430 */  32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 52,
/* 0x6440 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82, 95, 51, 56, 54,
/* 0x6450 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,
/* 0x6460 */ 107, 51, 50, 46, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48,101, 32,
/* 0x6470 */  82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6480 */  32, 32,102,105,108,116,101,114, 95, 99,116,111, 10, 48, 48, 48,
/* 0x6490 */  48, 48, 48, 49, 48, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x64a0 */  32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 52,
/* 0x64b0 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x64c0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,116,111,107, 51,
/* 0x64d0 */  50, 46, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x64e0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x64f0 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52,
/* 0x6500 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x6510 */  32, 32, 32, 99,116,111,107, 51, 50, 46, 52, 48, 10, 48, 48, 48,
/* 0x6520 */  48, 48, 48, 48, 57, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x6530 */  32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 49,
/* 0x6540 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x6550 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,116,111,107, 51,
/* 0x6560 */  50, 46, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x6570 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6580 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52,
/* 0x6590 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x65a0 */  32, 32, 32, 99,116,111,107, 51, 50, 46, 48, 48, 10, 10, 82, 69,
/* 0x65b0 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x65c0 */  32, 70, 79, 82, 32, 91, 80, 69, 73, 77, 80, 79, 82, 84, 93, 58,
/* 0x65d0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x65e0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x65f0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54,
/* 0x6600 */  95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,111,109,
/* 0x6610 */ 112,114,101,115,115,101,100, 95,105,109,112,111,114,116,115, 10,
/* 0x6620 */  48, 48, 48, 48, 48, 48, 48, 98, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x6630 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 80, 69, 73, 77, 68,
/* 0x6640 */  79, 78, 69, 10, 48, 48, 48, 48, 48, 48, 49, 50, 32, 82, 95, 51,
/* 0x6650 */  56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,115,
/* 0x6660 */ 116, 97,114,116, 95,111,102, 95,105,109,112,111,114,116,115, 10,
/* 0x6670 */  48, 48, 48, 48, 48, 48, 49,101, 32, 82, 95, 51, 56, 54, 95, 51,
/* 0x6680 */  50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76,111, 97,100, 76,
/* 0x6690 */ 105, 98,114, 97,114,121, 65, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x66a0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x66b0 */  91, 80, 69, 73, 66, 89, 79, 82, 68, 93, 58, 10, 79, 70, 70, 83,
/* 0x66c0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x66d0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x66e0 */  48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x66f0 */  32, 32, 32, 32, 32, 32, 32, 32, 80, 69, 73, 77, 79, 82, 68, 49,
/* 0x6700 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x6710 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 75, 51, 50, 79,
/* 0x6720 */  82, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x6730 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6740 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82,
/* 0x6750 */  95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6760 */  32,107,101,114,110,101,108, 51, 50, 95,111,114,100,105,110, 97,
/* 0x6770 */ 108,115, 10, 48, 48, 48, 48, 48, 48, 48,102, 32, 82, 95, 51, 56,
/* 0x6780 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 80, 69,
/* 0x6790 */  73, 77, 80, 79, 82, 50, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x67a0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x67b0 */  80, 69, 73, 77, 80, 79, 82, 50, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x67c0 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x67d0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x67e0 */  48, 48, 48, 55, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32,
/* 0x67f0 */  32, 32, 32, 32, 32, 32, 32, 71,101,116, 80,114,111, 99, 65,100,
/* 0x6800 */ 100,114,101,115,115, 10, 48, 48, 48, 48, 48, 48, 49, 53, 32, 82,
/* 0x6810 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6820 */  32, 80, 69, 73, 77, 80, 79, 82, 84, 10, 10, 82, 69, 76, 79, 67,
/* 0x6830 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x6840 */  82, 32, 91, 80, 69, 73, 69, 82, 69, 88, 69, 93, 58, 10, 79, 70,
/* 0x6850 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x6860 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x6870 */  48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 51, 50,
/* 0x6880 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 69,120,105,116, 80,114,
/* 0x6890 */ 111, 99,101,115,115, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x68a0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80,
/* 0x68b0 */  69, 82, 69, 76, 79, 67, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x68c0 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x68d0 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x68e0 */  48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32,
/* 0x68f0 */  32, 32, 32, 32, 32, 32,115,116, 97,114,116, 95,111,102, 95,114,
/* 0x6900 */ 101,108,111, 99,115, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x6910 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 82,
/* 0x6920 */  69, 76, 79, 67, 51, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x6930 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6940 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x6950 */  48, 48, 56, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x6960 */  32, 32, 32, 32, 32, 32, 82, 69, 76, 79, 67, 51, 50, 74, 10, 10,
/* 0x6970 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x6980 */  68, 83, 32, 70, 79, 82, 32, 91, 82, 69, 76, 51, 50, 66, 73, 71,
/* 0x6990 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x69a0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x69b0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51,
/* 0x69c0 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 82,
/* 0x69d0 */  69, 76, 79, 67, 51, 50, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x69e0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x69f0 */  91, 82, 69, 76, 79, 67, 51, 50, 74, 93, 58, 10, 79, 70, 70, 83,
/* 0x6a00 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x6a10 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x6a20 */  48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x6a30 */  32, 32, 32, 32, 32, 32, 32, 32, 82, 69, 76, 79, 67, 51, 50, 48,
/* 0x6a40 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x6a50 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 82, 76, 79, 72,
/* 0x6a60 */  73, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x6a70 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6a80 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82,
/* 0x6a90 */  95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6aa0 */  32,114,101,108,111, 99, 95,100,101,108,116, 10, 10, 82, 69, 76,
/* 0x6ab0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x6ac0 */  70, 79, 82, 32, 91, 80, 69, 68, 69, 80, 72, 65, 75, 93, 58, 10,
/* 0x6ad0 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x6ae0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x6af0 */  10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95,
/* 0x6b00 */  51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,105,114,116,
/* 0x6b10 */ 117, 97,108, 80,114,111,116,101, 99,116, 10, 48, 48, 48, 48, 48,
/* 0x6b20 */  48, 48, 56, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32,
/* 0x6b30 */  32, 32, 32, 32, 32, 32,118,112, 95, 98, 97,115,101, 10, 48, 48,
/* 0x6b40 */  48, 48, 48, 48, 48,100, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32,
/* 0x6b50 */  32, 32, 32, 32, 32, 32, 32, 32, 32,118,112, 95,115,105,122,101,
/* 0x6b60 */  10, 48, 48, 48, 48, 48, 48, 49, 98, 32, 82, 95, 51, 56, 54, 95,
/* 0x6b70 */  51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,115,119,114,105,
/* 0x6b80 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x6b90 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 84, 76, 83, 67,
/* 0x6ba0 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x6bb0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x6bc0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51,
/* 0x6bd0 */  56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,116,
/* 0x6be0 */ 108,115, 95,109,111,100,117,108,101, 95, 98, 97,115,101, 10, 48,
/* 0x6bf0 */  48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 51, 56, 54, 95, 51, 50,
/* 0x6c00 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 80, 69, 84, 76, 83, 67,
/* 0x6c10 */  50, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x6c20 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 68, 79, 74,
/* 0x6c30 */  85, 77, 80, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x6c40 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6c50 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32,
/* 0x6c60 */  82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x6c70 */  32, 32,111,114,105,103,105,110, 97,108, 95,101,110,116,114,121,
/* 0x6c80 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x6c90 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 84, 76, 83, 67,
/* 0x6ca0 */  50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x6cb0 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x6cc0 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95,
/* 0x6cd0 */  51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6ce0 */ 116,108,115, 95, 99, 97,108,108, 98, 97, 99,107,115, 95,112,116,
/* 0x6cf0 */ 114, 10
};
