/*
 * This file contains D-Bus client proxy classes generated by qt-client-gen.py.
 *
 * This file can be distributed under the same terms as the specification from
 * which it was generated.
 */

#include <TelepathyQt/future-internal.h>

#include <QtGlobal>

#include <QString>
#include <QObject>
#include <QVariant>

#include <QDBusPendingReply>

#include <TelepathyQt/AbstractInterface>
#include <TelepathyQt/DBusProxy>
#include <TelepathyQt/Global>

namespace Tp
{
class PendingVariant;
class PendingOperation;
}

namespace TpFuture
{
namespace Client
{

/**
 * \class ChannelInterfaceMergeableConferenceInterface
 * \headerfile TelepathyQt/future-internal.h <TelepathyQt/future-internal.h>
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.MergeableConference.DRAFT".
 */
class TP_QT_NO_EXPORT ChannelInterfaceMergeableConferenceInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Interface.MergeableConference.DRAFT", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Interface.MergeableConference.DRAFT");
    }

    /**
     * Creates a ChannelInterfaceMergeableConferenceInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceMergeableConferenceInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceMergeableConferenceInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceMergeableConferenceInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceMergeableConferenceInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelInterfaceMergeableConferenceInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelInterfaceMergeableConferenceInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelInterfaceMergeableConferenceInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelInterfaceMergeableConferenceInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceMergeableConferenceInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c Merge on the remote object.
     * 
     * \htmlonly
     * <p>Request that the given channel be incorporated into this
     *   channel.</p>
     * 
     * <p>The given channel SHOULD be added to  \endhtmlonly org.freedesktop.Telepathy.Channel.Interface.Conference.Channels \htmlonly  if and only if the
     *   underlying protocol signals the merge in some way. It MUST NOT be
     *   added to  \endhtmlonly org.freedesktop.Telepathy.Channel.Interface.Conference.InitialChannels \htmlonly  (to preserve
     *   immutability).</p>
     * 
     * <div class="rationale">
     *   <p>In GSM it is possible to merge additional calls into an ongoing
     *     conference.</p>
     * 
     *   <p>In XMPP this method could be implemented to merge a 1-1 Text
     *     channel into a MUC Text channel by inviting the peer from the Text
     *     channel into the MUC, or to merge a 1-1 Jingle call into a Muji
     *     call by inviting the peer from the Jingle call into the Muji call.
     *     (MUC and Muji channels are both implemented by XMPP MUCs, with
     *     Handle_Type_Room.)</p>
     * </div>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param channel
     *     
     *     \htmlonly
     *     <p>A channel with the same  \endhtmlonly org.freedesktop.Telepathy.Channel.ChannelType \htmlonly 
     *       as this one, but with  \endhtmlonly org.freedesktop.Telepathy.Channel.TargetHandleType \htmlonly  = CONTACT.</p>
     *     \endhtmlonly
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> Merge(const QDBusObjectPath& channel, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("Merge"));
        callMessage << QVariant::fromValue(channel);
        return this->connection().asyncCall(callMessage, timeout);
    }

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class ChannelInterfaceSplittableInterface
 * \headerfile TelepathyQt/future-internal.h <TelepathyQt/future-internal.h>
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Channel.Interface.Splittable.DRAFT".
 */
class TP_QT_NO_EXPORT ChannelInterfaceSplittableInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Channel.Interface.Splittable.DRAFT", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Channel.Interface.Splittable.DRAFT");
    }

    /**
     * Creates a ChannelInterfaceSplittableInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceSplittableInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceSplittableInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceSplittableInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a ChannelInterfaceSplittableInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    ChannelInterfaceSplittableInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a ChannelInterfaceSplittableInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit ChannelInterfaceSplittableInterface(const Tp::Client::ChannelInterface& mainInterface);

    /**
     * Creates a ChannelInterfaceSplittableInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    ChannelInterfaceSplittableInterface(const Tp::Client::ChannelInterface& mainInterface, QObject* parent);

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c Split on the remote object.
     * 
     * \htmlonly
     * <p>Request that this channel is removed from any
     *  \endhtmlonly org.freedesktop.Telepathy.Channel.Interface.Conference \htmlonly  of which it is a part.</p>
     * 
     * <p>This implies that the media streams within the conference are put on
     *   hold and the media streams within the member channel leaving the
     *   conference are unheld.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> Split(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("Split"));
        return this->connection().asyncCall(callMessage, timeout);
    }

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};
}
}
Q_DECLARE_METATYPE(TpFuture::Client::ChannelInterfaceMergeableConferenceInterface*)
Q_DECLARE_METATYPE(TpFuture::Client::ChannelInterfaceSplittableInterface*)
