/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INSPECTOR)

#include "JSInspectorFrontendHost.h"

#include "ExceptionCode.h"
#include "InspectorFrontendHost.h"
#include "JSDOMBinding.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSInspectorFrontendHostTableValues[] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInspectorFrontendHostConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSInspectorFrontendHostTable = { 2, 1, JSInspectorFrontendHostTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSInspectorFrontendHostConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSInspectorFrontendHostConstructorTable = { 1, 0, JSInspectorFrontendHostConstructorTableValues, 0 };
const ClassInfo JSInspectorFrontendHostConstructor::s_info = { "InspectorFrontendHostConstructor", &Base::s_info, &JSInspectorFrontendHostConstructorTable, 0, CREATE_METHOD_TABLE(JSInspectorFrontendHostConstructor) };

JSInspectorFrontendHostConstructor::JSInspectorFrontendHostConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSInspectorFrontendHostConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSInspectorFrontendHostPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSInspectorFrontendHostConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSInspectorFrontendHostConstructor, JSDOMWrapper>(exec, &JSInspectorFrontendHostConstructorTable, jsCast<JSInspectorFrontendHostConstructor*>(cell), propertyName, slot);
}

bool JSInspectorFrontendHostConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSInspectorFrontendHostConstructor, JSDOMWrapper>(exec, &JSInspectorFrontendHostConstructorTable, jsCast<JSInspectorFrontendHostConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSInspectorFrontendHostPrototypeTableValues[] =
{
    { "loaded", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInspectorFrontendHostPrototypeFunctionLoaded), (intptr_t)0, NoIntrinsic },
    { "closeWindow", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInspectorFrontendHostPrototypeFunctionCloseWindow), (intptr_t)0, NoIntrinsic },
    { "bringToFront", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInspectorFrontendHostPrototypeFunctionBringToFront), (intptr_t)0, NoIntrinsic },
    { "setZoomFactor", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInspectorFrontendHostPrototypeFunctionSetZoomFactor), (intptr_t)1, NoIntrinsic },
    { "inspectedURLChanged", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInspectorFrontendHostPrototypeFunctionInspectedURLChanged), (intptr_t)1, NoIntrinsic },
    { "requestSetDockSide", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInspectorFrontendHostPrototypeFunctionRequestSetDockSide), (intptr_t)1, NoIntrinsic },
    { "setAttachedWindowHeight", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInspectorFrontendHostPrototypeFunctionSetAttachedWindowHeight), (intptr_t)1, NoIntrinsic },
    { "moveWindowBy", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInspectorFrontendHostPrototypeFunctionMoveWindowBy), (intptr_t)2, NoIntrinsic },
    { "setInjectedScriptForOrigin", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInspectorFrontendHostPrototypeFunctionSetInjectedScriptForOrigin), (intptr_t)2, NoIntrinsic },
    { "localizedStringsURL", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInspectorFrontendHostPrototypeFunctionLocalizedStringsURL), (intptr_t)0, NoIntrinsic },
    { "hiddenPanels", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInspectorFrontendHostPrototypeFunctionHiddenPanels), (intptr_t)0, NoIntrinsic },
    { "copyText", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInspectorFrontendHostPrototypeFunctionCopyText), (intptr_t)1, NoIntrinsic },
    { "openInNewTab", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInspectorFrontendHostPrototypeFunctionOpenInNewTab), (intptr_t)1, NoIntrinsic },
    { "canSave", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInspectorFrontendHostPrototypeFunctionCanSave), (intptr_t)0, NoIntrinsic },
    { "save", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInspectorFrontendHostPrototypeFunctionSave), (intptr_t)3, NoIntrinsic },
    { "append", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInspectorFrontendHostPrototypeFunctionAppend), (intptr_t)2, NoIntrinsic },
    { "close", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInspectorFrontendHostPrototypeFunctionClose), (intptr_t)1, NoIntrinsic },
    { "canInspectWorkers", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInspectorFrontendHostPrototypeFunctionCanInspectWorkers), (intptr_t)0, NoIntrinsic },
    { "platform", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInspectorFrontendHostPrototypeFunctionPlatform), (intptr_t)0, NoIntrinsic },
    { "port", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInspectorFrontendHostPrototypeFunctionPort), (intptr_t)0, NoIntrinsic },
    { "showContextMenu", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInspectorFrontendHostPrototypeFunctionShowContextMenu), (intptr_t)2, NoIntrinsic },
    { "sendMessageToBackend", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInspectorFrontendHostPrototypeFunctionSendMessageToBackend), (intptr_t)1, NoIntrinsic },
    { "recordActionTaken", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInspectorFrontendHostPrototypeFunctionRecordActionTaken), (intptr_t)1, NoIntrinsic },
    { "recordPanelShown", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInspectorFrontendHostPrototypeFunctionRecordPanelShown), (intptr_t)1, NoIntrinsic },
    { "recordSettingChanged", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInspectorFrontendHostPrototypeFunctionRecordSettingChanged), (intptr_t)1, NoIntrinsic },
    { "loadResourceSynchronously", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInspectorFrontendHostPrototypeFunctionLoadResourceSynchronously), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSInspectorFrontendHostPrototypeTable = { 68, 63, JSInspectorFrontendHostPrototypeTableValues, 0 };
const ClassInfo JSInspectorFrontendHostPrototype::s_info = { "InspectorFrontendHostPrototype", &Base::s_info, &JSInspectorFrontendHostPrototypeTable, 0, CREATE_METHOD_TABLE(JSInspectorFrontendHostPrototype) };

JSObject* JSInspectorFrontendHostPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSInspectorFrontendHost>(exec, globalObject);
}

bool JSInspectorFrontendHostPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSInspectorFrontendHostPrototype* thisObject = jsCast<JSInspectorFrontendHostPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSInspectorFrontendHostPrototypeTable, thisObject, propertyName, slot);
}

bool JSInspectorFrontendHostPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSInspectorFrontendHostPrototype* thisObject = jsCast<JSInspectorFrontendHostPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSInspectorFrontendHostPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSInspectorFrontendHost::s_info = { "InspectorFrontendHost", &Base::s_info, &JSInspectorFrontendHostTable, 0 , CREATE_METHOD_TABLE(JSInspectorFrontendHost) };

JSInspectorFrontendHost::JSInspectorFrontendHost(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<InspectorFrontendHost> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSInspectorFrontendHost::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSInspectorFrontendHost::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSInspectorFrontendHostPrototype::create(exec->globalData(), globalObject, JSInspectorFrontendHostPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSInspectorFrontendHost::destroy(JSC::JSCell* cell)
{
    JSInspectorFrontendHost* thisObject = static_cast<JSInspectorFrontendHost*>(cell);
    thisObject->JSInspectorFrontendHost::~JSInspectorFrontendHost();
}

JSInspectorFrontendHost::~JSInspectorFrontendHost()
{
    releaseImplIfNotNull();
}

bool JSInspectorFrontendHost::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSInspectorFrontendHost* thisObject = jsCast<JSInspectorFrontendHost*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSInspectorFrontendHost, Base>(exec, &JSInspectorFrontendHostTable, thisObject, propertyName, slot);
}

bool JSInspectorFrontendHost::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSInspectorFrontendHost* thisObject = jsCast<JSInspectorFrontendHost*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSInspectorFrontendHost, Base>(exec, &JSInspectorFrontendHostTable, thisObject, propertyName, descriptor);
}

JSValue jsInspectorFrontendHostConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSInspectorFrontendHost* domObject = jsCast<JSInspectorFrontendHost*>(asObject(slotBase));
    return JSInspectorFrontendHost::getConstructor(exec, domObject->globalObject());
}

JSValue JSInspectorFrontendHost::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSInspectorFrontendHostConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionLoaded(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorFrontendHost::s_info))
        return throwVMTypeError(exec);
    JSInspectorFrontendHost* castedThis = jsCast<JSInspectorFrontendHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInspectorFrontendHost::s_info);
    InspectorFrontendHost* impl = static_cast<InspectorFrontendHost*>(castedThis->impl());
    impl->loaded();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionCloseWindow(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorFrontendHost::s_info))
        return throwVMTypeError(exec);
    JSInspectorFrontendHost* castedThis = jsCast<JSInspectorFrontendHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInspectorFrontendHost::s_info);
    InspectorFrontendHost* impl = static_cast<InspectorFrontendHost*>(castedThis->impl());
    impl->closeWindow();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionBringToFront(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorFrontendHost::s_info))
        return throwVMTypeError(exec);
    JSInspectorFrontendHost* castedThis = jsCast<JSInspectorFrontendHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInspectorFrontendHost::s_info);
    InspectorFrontendHost* impl = static_cast<InspectorFrontendHost*>(castedThis->impl());
    impl->bringToFront();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionSetZoomFactor(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorFrontendHost::s_info))
        return throwVMTypeError(exec);
    JSInspectorFrontendHost* castedThis = jsCast<JSInspectorFrontendHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInspectorFrontendHost::s_info);
    InspectorFrontendHost* impl = static_cast<InspectorFrontendHost*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    float zoom(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setZoomFactor(zoom);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionInspectedURLChanged(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorFrontendHost::s_info))
        return throwVMTypeError(exec);
    JSInspectorFrontendHost* castedThis = jsCast<JSInspectorFrontendHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInspectorFrontendHost::s_info);
    InspectorFrontendHost* impl = static_cast<InspectorFrontendHost*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& newURL(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->inspectedURLChanged(newURL);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionRequestSetDockSide(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorFrontendHost::s_info))
        return throwVMTypeError(exec);
    JSInspectorFrontendHost* castedThis = jsCast<JSInspectorFrontendHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInspectorFrontendHost::s_info);
    InspectorFrontendHost* impl = static_cast<InspectorFrontendHost*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& side(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->requestSetDockSide(side);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionSetAttachedWindowHeight(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorFrontendHost::s_info))
        return throwVMTypeError(exec);
    JSInspectorFrontendHost* castedThis = jsCast<JSInspectorFrontendHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInspectorFrontendHost::s_info);
    InspectorFrontendHost* impl = static_cast<InspectorFrontendHost*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    unsigned height(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAttachedWindowHeight(height);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionMoveWindowBy(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorFrontendHost::s_info))
        return throwVMTypeError(exec);
    JSInspectorFrontendHost* castedThis = jsCast<JSInspectorFrontendHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInspectorFrontendHost::s_info);
    InspectorFrontendHost* impl = static_cast<InspectorFrontendHost*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    float x(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->moveWindowBy(x, y);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionSetInjectedScriptForOrigin(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorFrontendHost::s_info))
        return throwVMTypeError(exec);
    JSInspectorFrontendHost* castedThis = jsCast<JSInspectorFrontendHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInspectorFrontendHost::s_info);
    InspectorFrontendHost* impl = static_cast<InspectorFrontendHost*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& origin(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& script(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setInjectedScriptForOrigin(origin, script);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionLocalizedStringsURL(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorFrontendHost::s_info))
        return throwVMTypeError(exec);
    JSInspectorFrontendHost* castedThis = jsCast<JSInspectorFrontendHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInspectorFrontendHost::s_info);
    InspectorFrontendHost* impl = static_cast<InspectorFrontendHost*>(castedThis->impl());

    JSC::JSValue result = jsStringWithCache(exec, impl->localizedStringsURL());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionHiddenPanels(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorFrontendHost::s_info))
        return throwVMTypeError(exec);
    JSInspectorFrontendHost* castedThis = jsCast<JSInspectorFrontendHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInspectorFrontendHost::s_info);
    InspectorFrontendHost* impl = static_cast<InspectorFrontendHost*>(castedThis->impl());

    JSC::JSValue result = jsStringWithCache(exec, impl->hiddenPanels());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionCopyText(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorFrontendHost::s_info))
        return throwVMTypeError(exec);
    JSInspectorFrontendHost* castedThis = jsCast<JSInspectorFrontendHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInspectorFrontendHost::s_info);
    InspectorFrontendHost* impl = static_cast<InspectorFrontendHost*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& text(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->copyText(text);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionOpenInNewTab(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorFrontendHost::s_info))
        return throwVMTypeError(exec);
    JSInspectorFrontendHost* castedThis = jsCast<JSInspectorFrontendHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInspectorFrontendHost::s_info);
    InspectorFrontendHost* impl = static_cast<InspectorFrontendHost*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& url(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->openInNewTab(url);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionCanSave(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorFrontendHost::s_info))
        return throwVMTypeError(exec);
    JSInspectorFrontendHost* castedThis = jsCast<JSInspectorFrontendHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInspectorFrontendHost::s_info);
    InspectorFrontendHost* impl = static_cast<InspectorFrontendHost*>(castedThis->impl());

    JSC::JSValue result = jsBoolean(impl->canSave());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionSave(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorFrontendHost::s_info))
        return throwVMTypeError(exec);
    JSInspectorFrontendHost* castedThis = jsCast<JSInspectorFrontendHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInspectorFrontendHost::s_info);
    InspectorFrontendHost* impl = static_cast<InspectorFrontendHost*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& url(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& content(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool forceSaveAs(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->save(url, content, forceSaveAs);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionAppend(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorFrontendHost::s_info))
        return throwVMTypeError(exec);
    JSInspectorFrontendHost* castedThis = jsCast<JSInspectorFrontendHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInspectorFrontendHost::s_info);
    InspectorFrontendHost* impl = static_cast<InspectorFrontendHost*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& url(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& content(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->append(url, content);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionClose(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorFrontendHost::s_info))
        return throwVMTypeError(exec);
    JSInspectorFrontendHost* castedThis = jsCast<JSInspectorFrontendHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInspectorFrontendHost::s_info);
    InspectorFrontendHost* impl = static_cast<InspectorFrontendHost*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& url(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->close(url);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionCanInspectWorkers(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorFrontendHost::s_info))
        return throwVMTypeError(exec);
    JSInspectorFrontendHost* castedThis = jsCast<JSInspectorFrontendHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInspectorFrontendHost::s_info);
    InspectorFrontendHost* impl = static_cast<InspectorFrontendHost*>(castedThis->impl());

    JSC::JSValue result = jsBoolean(impl->canInspectWorkers());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionPlatform(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorFrontendHost::s_info))
        return throwVMTypeError(exec);
    JSInspectorFrontendHost* castedThis = jsCast<JSInspectorFrontendHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInspectorFrontendHost::s_info);
    return JSValue::encode(castedThis->platform(exec));
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionPort(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorFrontendHost::s_info))
        return throwVMTypeError(exec);
    JSInspectorFrontendHost* castedThis = jsCast<JSInspectorFrontendHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInspectorFrontendHost::s_info);
    return JSValue::encode(castedThis->port(exec));
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionShowContextMenu(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorFrontendHost::s_info))
        return throwVMTypeError(exec);
    JSInspectorFrontendHost* castedThis = jsCast<JSInspectorFrontendHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInspectorFrontendHost::s_info);
    return JSValue::encode(castedThis->showContextMenu(exec));
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionSendMessageToBackend(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorFrontendHost::s_info))
        return throwVMTypeError(exec);
    JSInspectorFrontendHost* castedThis = jsCast<JSInspectorFrontendHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInspectorFrontendHost::s_info);
    InspectorFrontendHost* impl = static_cast<InspectorFrontendHost*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& message(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->sendMessageToBackend(message);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionRecordActionTaken(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorFrontendHost::s_info))
        return throwVMTypeError(exec);
    JSInspectorFrontendHost* castedThis = jsCast<JSInspectorFrontendHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInspectorFrontendHost::s_info);
    return JSValue::encode(castedThis->recordActionTaken(exec));
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionRecordPanelShown(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorFrontendHost::s_info))
        return throwVMTypeError(exec);
    JSInspectorFrontendHost* castedThis = jsCast<JSInspectorFrontendHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInspectorFrontendHost::s_info);
    return JSValue::encode(castedThis->recordPanelShown(exec));
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionRecordSettingChanged(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorFrontendHost::s_info))
        return throwVMTypeError(exec);
    JSInspectorFrontendHost* castedThis = jsCast<JSInspectorFrontendHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInspectorFrontendHost::s_info);
    return JSValue::encode(castedThis->recordSettingChanged(exec));
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionLoadResourceSynchronously(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorFrontendHost::s_info))
        return throwVMTypeError(exec);
    JSInspectorFrontendHost* castedThis = jsCast<JSInspectorFrontendHost*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInspectorFrontendHost::s_info);
    InspectorFrontendHost* impl = static_cast<InspectorFrontendHost*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& url(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->loadResourceSynchronously(url));
    return JSValue::encode(result);
}

static inline bool isObservable(JSInspectorFrontendHost* jsInspectorFrontendHost)
{
    if (jsInspectorFrontendHost->hasCustomProperties())
        return true;
    return false;
}

bool JSInspectorFrontendHostOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSInspectorFrontendHost* jsInspectorFrontendHost = jsCast<JSInspectorFrontendHost*>(handle.get().asCell());
    if (!isObservable(jsInspectorFrontendHost))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSInspectorFrontendHostOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSInspectorFrontendHost* jsInspectorFrontendHost = jsCast<JSInspectorFrontendHost*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsInspectorFrontendHost->impl(), jsInspectorFrontendHost);
    jsInspectorFrontendHost->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, InspectorFrontendHost* impl)
{
    return wrap<JSInspectorFrontendHost>(exec, globalObject, impl);
}

InspectorFrontendHost* toInspectorFrontendHost(JSC::JSValue value)
{
    return value.inherits(&JSInspectorFrontendHost::s_info) ? jsCast<JSInspectorFrontendHost*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(INSPECTOR)
