/////////////////////////////////////////////////////////////////////////////
// Name:        translations.h
// Purpose:     List of wxWidgets available translations
// Author:      wxWidgets team
// Licence:     wxWindows licence
/////////////////////////////////////////////////////////////////////////////


/**

@page page_translations Translations to Other Languages

@tableofcontents

wxWidgets uses a certain number of user-readable strings such as
<tt>"help"</tt> or <tt>"Load file"</tt> which should be translated to the users
language if it is different from English. wxWidgets has built in support for
internationalization (@e i18n from now on) which allows for this to happen
automatically if the translations to the current language are available.

You may find here the list of all existing translations with the addresses of
the official translators whom you should contact if you would like to submit
any corrections to the translations for your language.

Also, please see @ref page_translations_howtohelp if you would like to
translate wxWidgets to your language if it is not mentioned here (or to help
with one which already is - it is quite helpful to have several translators for
one language at least for proof reading).



@section page_translations_avail Available Translations

Below is the table containing the list of languages supported by wxWidgets.
The columns of this table have the obvious meaning: in each row you will see
the language, the official translator (if any) for it and the status of the
translations.

Please note that email addresses in the table below are intentionally invalid
to foil spam robots, remove one <tt>\@</tt> from them.

<table>

<tr>
    <th>Language</th>
    <th>Status</th>
    <th>Translator(s)</th>
</tr>

<tr>
    <td>Afrikaans</td>
    <td class="orange">68%</td>
    <td>
        <a href="mailto:rkwjpj@@puk.ac.za">Petri Jooste</a>
    </td>
</tr>

<tr>
    <td>Albanian</td>
    <td class="orange">75%</td>
    <td>
        <a href="mailto:besnik@@programeshqip.org">Besnik Bleta</a>
    </td>
</tr>

<tr>
    <td>Arabic</td>
    <td class="red">45%</td>
    <td>
        <a href="mailto:abouzekry@@gmail.com">Abdullah Abouzekry</a>
    </td>
</tr>

<tr>
    <td>Basque</td>
    <td class="green">100%</td>
    <td>
        <a href="mailto:3arrano@@euskalerria.org">3ARRANO Euskalgintza Taldea</a>,
        <a href="mailto:azpidatziak@@gmail.com">Xabier Aramendi</a>
    </td>
</tr>

<tr>
    <td>Catalan</td>
    <td class="orange">65%</td>
    <td>
        <a href="mailto:paubcrespo@@hotmail.com">Pau Bosch i Crespo</a>,
        <a href="mailto:rmh@@aybabtu.com">Robert Millan</a>
    </td>
</tr>

<tr>
    <td>Chinese (simplified)</td>
    <td class="green">100%</td>
    <td>
        <a href="mailto:mrfx@@fm365.com">mrfx</a>,
        <a href="mailto:liouxiao@@hotmail.com">Liu XiaoXi</a>,
        <a href="mailto:hjiawei@@gmail.com">Huang Jiawei</a>,
        <a href="mailto:williamroot777@@qq.com">William Jiang</a>
    </td>
</tr>

<tr>
    <td>Chinese (traditional)</td>
    <td class="green">100%</td>
    <td>
        <a href="mailto:pal.tw@@yahoo.com.tw">pal.tw</a>
    </td>
</tr>

<tr>
    <td>Czech</td>
    <td class="green">100%</td>
    <td>
        <a href="mailto:v.slavik@@volny.cz">Vaclav Slavik</a>,
        <a href="mailto:deirdre_skye@@web.de">Herbert Breunung</a>,
        <a href="mailto:zbynek.schwarz@@gmail.com">Zbyněk Schwarz</a>
    </td>
</tr>

<tr>
    <td>Danish</td>
    <td class="orange">74%</td>
    <td>
        <a href="mailto:leif@@danmos.dk">Leif Jensen</a>,
        <a href="mailto:Henrik@@fangorn.dk">Henrik Ræder Clausen</a>,
        <a href="mailto:mulrich15@@yahoo.dk">Morten Råbjerg Ulrich</a>
    </td>
</tr>

<tr>
    <td>Dutch</td>
    <td class="green">100%</td>
    <td>
        <a href="mailto:phubers@@solve-i-t.com">Patrick Hubers</a>,
        <a href="mailto:gvmelle@@gmail.com">Gideon van Melle</a>,
        <a href="mailto:thomasderocker@@hotmail.com">Thomas De Rocker</a>
    </td>
</tr>

<tr>
    <td>English (UK)</td>
    <td class="green">100%</td>
    <td>N/A</td>
</tr>

<tr>
    <td>Finnish</td>
    <td class="green">91%</td>
    <td>
        <a href="mailto:kgb@@compart.fi">Kaj G Backas</a>,
        <a href="mailto:lanurmi@@iki.fi">Lauri Nurmi</a>,
        <a href="mailto:jmsalli79@@hotmail.com">Jaakko Salli</a>,
        <a href="mailto:elias.julkunen@gmail.com">Elias Julkunen</a>,
        <a href="mailto:jani.kinnunen@@wippies.fi">Jani Kinnunen</a>
    </td>
</tr>

<tr>
    <td>French (standard)</td>
    <td class="green">96%</td>
    <td>
        <a href="mailto:Stephane.Junique@@optics.kth.se">Stephane Junique</a>,
        <a href="mailto:lionel.allorge@@lunerouge.com">Lionel Allorge</a>,
        <a href="mailto:Gilles.Guyot@@Krypton.be">Gilles Guyot</a>
    </td>
</tr>

<tr>
    <td>Galician</td>
    <td class="orange">76%</td>
    <td>
        <a href="mailto:leandro.regueiro@@gmail.com">Leandro Regueiro</a>,
        <a href="mailto:correoadrian82@@hotmail.com">Adrián González Alba</a>
    </td>
</tr>

<tr>
    <td>German</td>
    <td class="green">100%</td>
    <td>
        <a href="mailto:DanR@@gmx.de">Daniel Reith</a>,
        <a href="mailto:sparhawk@@aon.at">Gerhard Gruber</a>,
        <a href="mailto:stefan@@hedemann.de">Stefan Hedemann</a>,
        <a href="mailto:D.Reymann@@geisenheim.mnd.fh-wiesbaden.de">Dr. Detlev Reymann</a>,
        Mark Johnson,
        <a href="mailto:martinnost@@users.sf.net">Martin Jost</a>,
        <a href="mailto:deirdre_skye@@web.de">Herbert Breunung</a>,
        <a href="mailto:chbuck@@gmail.com">Ch. Buck</a>,
        <a href="mailto:webmaster@@coderonline.de">Max Christian Pohle</a>,
        <a href="mailto:Thomas.Krebs@@mecadtron.de">Thomas Krebs</a>
    </td>
</tr>

<tr>
    <td>Greek</td>
    <td class="orange">73%</td>
    <td>
        <a href="mailto:tsolako1@@otenet.gr">Tsolakos Stavros</a>,
        <a href="mailto:nassosy@@compulink.gr">Nassos Yiannopoulos</a>
    </td>
</tr>

<tr>
    <td>Hindi</td>
    <td class="green">83%</td>
    <td>
        <a href="mailto:dysxhi@@yahoo.co.in">Dhananjaya Sharma</a>,
        <a href="mailto:priyank.bolia@@gmail.com">Priyank Bolia</a>
    </td>
</tr>

<tr>
    <td>Hungarian</td>
    <td class="orange">76%</td>
    <td>
        <a href="mailto:Janos_Vegh@@users.sourceforge.net">Végh János Dr.</a>
    </td>
</tr>

<tr>
    <td>Indonesian</td>
    <td class="green">100%</td>
    <td>
        <a href="mailto:bambang@@3wsi.com">Bambang Purnomosidi D. P.</a>,
        <a href="mailto:doplank@@gmx.com">Rahmat Bambang</a>
    </td>
</tr>

<tr>
    <td>Italian</td>
    <td class="green">100%</td>
    <td>
        <a href="mailto:mbarbon@@cpan.org">Mattia Barbon</a>,
        <a href="mailto:m.cavallini@@koansoftware.com">Marco Cavallini</a>,
        (<a href="http://www.koansoftware.com">Koan Software</a>),
        <a href="mailto:l.stickell@@yahoo.it">Stefano</a>
    </td>
</tr>

<tr>
    <td>Japanese</td>
    <td class="green">97%</td>
    <td>
        <a href="mailto:james.bishop1@@tiscali.co.uk">James Bishop</a>,
        <a href="mailto:saito@@inetrt.skcapi.co.jp">Hiroshi Saito</a>,
        <a href="mailto:suzumizaki@@free.japandesign.ne.jp">Suzumizaki-Kimitaka</a>,
        <a href="mailto:kaba@@shall-systemservice.co.jp">Y. KABA.</a>
    </td>
</tr>

<tr>
    <td>Korean</td>
    <td class="green">85%</td>
    <td>
        <a href="mailto:dragoneyes.org@@gmail.com">Sungkee Jung</a>
    </td>
</tr>

<tr>
    <td>Latvian</td>
    <td class="green">90%</td>
    <td>
        <a href="mailto:lauris@@nix.lv">Lauris Bukshis</a>
    </td>
</tr>

<tr>
    <td>Lithuanian</td>
    <td class="red">15%</td>
    <td>
        <a href="mailto:pieter.clarysse@@bricsys.com">Pieter</a>
    </td>
</tr>

<tr>
    <td>Malay</td>
    <td class="green">89%</td>
    <td>
        <a href="mailto:mahrazi@@gmail.com">Mahrazi Mohd Kamal</a>
    </td>
</tr>

<tr>
    <td>Nepali</td>
    <td class="green">100%</td>
    <td>
        <a href="mailto:drishtibachak@@gmail.com">Him Prasad Gautam</a>
    </td>
</tr>

<tr>
    <td>Norwegian Bokmal</td>
    <td class="orange">74%</td>
    <td>
        <a href="mailto:hans@@nordhaug.priv.no">Hans F. Nordhaug</a>
    </td>
</tr>

<tr>
    <td>Polish</td>
    <td class="green">94%</td>
    <td>
        <a href="mailto:matiso@@hoga.pl">Piotr Mackowiak</a>,
        <a href="mailto:jpiw@@go2.pl">Janusz Piwowarski</a>,
        <a href="mailto:abx@@abx.art.pl">ABX</a>,
        <a href="mailto:hippie_1968@@hotmail.com">Michał Trzebiatowski</a>,
        <a href="mailto:grzezlo@@wp.pl">Grzegorz Zlotowicz</a>
    </td>
</tr>

<tr>
    <td>Portuguese (pt)</td>
    <td class="green">89%</td>
    <td>
        <a href="mailto:bernardosw@@terra.com.br">Bernardo Santos Wernesback</a>,
        <a href="mailto:marionrpereira76@@hotmail.com">Mario Pereira</a>,
        <a href="mailto:digiplan.pt@@gmail.com">Antonio Cardoso Martins</a>,
        <a href="mailto:mail@@cgoncalves.info">Carlos Gonçalves</a>
    </td>
</tr>

<tr>
    <td>Portuguese (pt_BR)</td>
    <td class="green">100%</td>
    <td>
        <a href="mailto:e.a.tacao@@terra.com.br">E.A. Tacao</a>,
        <a href="mailto:jecdiniz@@yahoo.com.br">José Eduardo de Carvalho Diniz</a>,
        <a href="mailto:adiel@@inf.ufsc.br">Adiel Mittmann</a>,
        <a href="mailto:allanjos@@gmail.com">Allann Jones</a>,
        <a href="mailto:felipefpl@@ig.com.br">Felipe</a>
    </td>
</tr>

<tr>
    <td>Romanian</td>
    <td class="green">100%</td>
    <td>
        <a href="mailto:cata_sr@yahoo.com">Cătălin Răceanu</a>,
        <a href="mailto:adrian.haisan@gmail.com">Adrian Hăisan</a>,
        <a href="mailto:manuelrciosici@gmail.com">Manuel Ciosici</a>
    </td>
</tr>

<tr>
    <td>Russian</td>
    <td class="orange">74%</td>
    <td>
        <a href="mailto:wolfsoft@@mail.ru">Dennis Prochko</a>,
        <a href="mailto:rolinsky@@mema.ucl.ac.be">Roman Rolinsky</a>,
        <a href="mailto:vadim@@wxwidgets.org">Vadim Zeitlin</a>,
        <a href="mailto:kai@@cmail.ru">Andrew V. Samoilov</a>
    </td>
</tr>

<tr>
    <td>Slovak</td>
    <td class="orange">74%</td>
    <td>
        <a href="mailto:helix84@@centrum.sk">Ivan Masar</a>
    </td>
</tr>

<tr>
    <td>Slovenian</td>
    <td class="green">97%</td>
    <td>
        <a href="mailto:roman.plevel@@iskratr.si">Roman Plevel</a>,
        <a href="mailto:miles@@filmsi.net">Martin Srebotnjak</a>
    </td>
</tr>

<tr>
    <td>Spanish</td>
    <td class="green">89%</td>
    <td>
        <a href="mailto:guille@@iies.es">Guillermo Rodriguez Garcia</a>,
        <a href="mailto:jsj666@@hotmail.com">JSJ</a>,
        <a href="mailto:francisco.vila@@hispalinux.es">Francisco Vila</a>,
        <a href="mailto:correoadrian82@@hotmail.com">Adrián González Alba</a>
    </td>
</tr>

<tr>
    <td>Swedish</td>
    <td class="green">98%</td>
    <td>
        <a href="mailto:jor@@mindless.com">Jonas Rydberg</a>,
        <a href="mailto:kgb@@compart.fi">Kaj G Backas</a>
    </td>
</tr>

<tr>
    <td>Tamil</td>
    <td class="green">100%</td>
    <td>
        <a href="mailto:td.dinkar@@gmail.com">DINAKAR T.D.</a>
    </td>
</tr>

<tr>
    <td>Turkish</td>
    <td class="green">100%</td>
    <td>
        <a href="mailto:dogusanh@@dynaset.org">Hakki Dogusan</a>,
        <a href="mailto:kayazeren@@gmail.com">Kaya Zeren</a>
    </td>
</tr>

<tr>
    <td>Ukrainian</td>
    <td class="green">100%</td>
    <td>
        <a href="mailto:manko@@salingshot.co.nz">Eugene Manko</a>,
        <a href="mailto:yurchor@@ukr.net">Yuri Chornoivan</a>,
        <a href="mailto:k_ilya@@ukr.net">Ylia K</a>
    </td>
</tr>

<tr>
    <td>Valencian (ca\@valencia)</td>
    <td class="orange">65%</td>
    <td>
        <a href="mailto:rmh@@aybabtu.com">Robert Millan</a>
    </td>
</tr>

<tr>
    <td>Vietnamese</td>
    <td class="green">100%</td>
    <td>
        <a href="mailto:vnwildman@gmail.com">Tran Ngoc Quan</a>
    </td>
</tr>

</table>
<br>



@section page_translations_howtohelp How to Help

wxWidgets uses the standard <a href="http://www.gnu.org/software/gettext/">GNU
gettext</a> tools for i18n so if you are already familiar with them you
shouldn't have any problems with working on wxWidgets translations.

Here are the steps you should follow:

-# Get the latest version of the file <tt>locale/wxstd.pot</tt> from the
   wxWidgets source tree: if you're using
   <a href="https://www.wxwidgets.org/develop/code-repository/">git</a>
   you should already have it. Otherwise you can always retrieve it directly
   from the git repository:
   <a href="https://raw.githubusercontent.com/wxWidgets/wxWidgets/master/locale/wxstd.pot">locale/wxstd.pot</a>.
-# Rename it to <tt>XY.po</tt> where <tt>"XY"</tt> is the 2 letter
   <a href="http://www.loc.gov/standards/iso639-2/php/English_list.php">ISO 639-2 language code</a>
   for your language.
-# Translate the strings in this file using either your favourite text
   editor or a specialized tool such as Vaclav Slavik's excellent
   <a href="http://www.poedit.net/">poEdit</a> utility.
-# Verify that your translations can at least be compiled (even if they
   are yet incomplete) by running <tt>msgfmt -v XY.po</tt> command:
   please note that you <i>must</i> use the <tt>-v</tt> option. In
   particular, please fill the header fields because @c msgfmt doesn't
   accept the default values for them.
-# Send the finished translation to <a href="mailto:vadim@wxwidgets.org">Vadim Zeitlin</a>
   and it will be added to the next wxWidgets release or snapshot.

Thank you in advance for your help!

*/
