#line 5 "test_get_p5.m4"
/* Do not edit this file. It is produced from the corresponding .m4 source */
#line 7
/*********************************************************************
 *   Copyright 1996, UCAR/Unidata
 *   See netcdf/COPYRIGHT file for copying and redistribution conditions.
 *   $Id: test_get.m4 2785 2014-10-26 05:21:20Z wkliao $
 *********************************************************************/

// #define TEST_PNETCDF
#include <mpi.h>

#line 34

#include "tests.h"

#line 123

void
#line 124
test_nc_get_var1_text(void)
#line 124
{
#line 124
    int ncid;
#line 124
    int i;
#line 124
    int j;
#line 124
    int err;
#line 124
    int nok = 0;      /* count of valid comparisons */
#line 124
    size_t index[MAX_RANK];
#line 124
    double expect;
#line 124
    int canConvert;     /* Both text or both numeric */
#line 124
    text value;
#line 124

#line 124
#ifdef TEST_PNETCDF
#line 124
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 124
#else
#line 124
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 124
#endif
#line 124
    IF (err)
#line 124
	error("nc_open: %s", nc_strerror(err));
#line 124
    for (i = 0; i < numVars; i++) {
#line 124
        canConvert = (var_type[i] == NC_CHAR) == (NCT_TEXT == NCT_TEXT);
#line 124
	for (j = 0; j < var_rank[i]; j++)
#line 124
	    index[j] = 0;
#line 124
        err = nc_get_var1_text(BAD_ID, i, index, &value);
#line 124
        IF (err != NC_EBADID)
#line 124
	    error("bad ncid: status = %d", err);
#line 124
        err = nc_get_var1_text(ncid, BAD_VARID, index, &value);
#line 124
        IF (err != NC_ENOTVAR)
#line 124
	    error("bad var id: status = %d", err);
#line 124
	for (j = 0; j < var_rank[i]; j++) {
#line 124
	    index[j] = var_shape[i][j];
#line 124
	    err = nc_get_var1_text(ncid, i, index, &value);
#line 124
	    if(!canConvert) {
#line 124
		IF(err != NC_ECHAR)
#line 124
			error("conversion: status = %d", err);
#line 124
	    } else IF (err != NC_EINVALCOORDS)
#line 124
		error("bad index: status = %d", err);
#line 124
	    index[j] = 0;
#line 124
	}
#line 124
	for (j = 0; j < var_nels[i]; j++) {
#line 124
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 124
	    IF (err)
#line 124
		error("error in toMixedBase 1");
#line 124
	    expect = hash4( var_type[i], var_rank[i], index, NCT_TEXT );
#line 124
	    if (var_rank[i] == 0 && i%2 )
#line 124
		err = nc_get_var1_text(ncid, i, NULL, &value);
#line 124
	    else
#line 124
		err = nc_get_var1_text(ncid, i, index, &value);
#line 124
            if (canConvert) {
#line 124
		if (inRange3(expect,var_type[i], NCT_TEXT)) {
#line 124
		    if (expect >= text_min && expect <= text_max) {
#line 124
			IF (err) {
#line 124
			    error("%s", nc_strerror(err));
#line 124
			} else {
#line 124
			    IF (!equal(value,expect,var_type[i],NCT_TEXT)) {
#line 124
				error("expected: %G, got: %G", expect,
#line 124
				    (double) value);
#line 124
			    } else {
#line 124
				nok++;
#line 124
			    }
#line 124
			}
#line 124
		    } else {
#line 124
			IF (err != NC_ERANGE)
#line 124
			    error("Range error: status = %d", err);
#line 124
		    }
#line 124
                } else {
#line 124
                    IF (err != 0 && err != NC_ERANGE)
#line 124
                        error("OK or Range error: status = %d", err);
#line 124
		}
#line 124
	    } else {
#line 124
		IF (err != NC_ECHAR)
#line 124
		    error("wrong type: status = %d", err);
#line 124
	    }
#line 124
	}
#line 124
    }
#line 124
    err = nc_close(ncid);
#line 124
    IF (err)
#line 124
	error("nc_close: %s", nc_strerror(err));
#line 124
    print_nok(nok);
#line 124
}
#line 124

void
#line 125
test_nc_get_var1_uchar(void)
#line 125
{
#line 125
    int ncid;
#line 125
    int i;
#line 125
    int j;
#line 125
    int err;
#line 125
    int nok = 0;      /* count of valid comparisons */
#line 125
    size_t index[MAX_RANK];
#line 125
    double expect;
#line 125
    int canConvert;     /* Both text or both numeric */
#line 125
    uchar value;
#line 125

#line 125
#ifdef TEST_PNETCDF
#line 125
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 125
#else
#line 125
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 125
#endif
#line 125
    IF (err)
#line 125
	error("nc_open: %s", nc_strerror(err));
#line 125
    for (i = 0; i < numVars; i++) {
#line 125
        canConvert = (var_type[i] == NC_CHAR) == (NCT_UCHAR == NCT_TEXT);
#line 125
	for (j = 0; j < var_rank[i]; j++)
#line 125
	    index[j] = 0;
#line 125
        err = nc_get_var1_uchar(BAD_ID, i, index, &value);
#line 125
        IF (err != NC_EBADID)
#line 125
	    error("bad ncid: status = %d", err);
#line 125
        err = nc_get_var1_uchar(ncid, BAD_VARID, index, &value);
#line 125
        IF (err != NC_ENOTVAR)
#line 125
	    error("bad var id: status = %d", err);
#line 125
	for (j = 0; j < var_rank[i]; j++) {
#line 125
	    index[j] = var_shape[i][j];
#line 125
	    err = nc_get_var1_uchar(ncid, i, index, &value);
#line 125
	    if(!canConvert) {
#line 125
		IF(err != NC_ECHAR)
#line 125
			error("conversion: status = %d", err);
#line 125
	    } else IF (err != NC_EINVALCOORDS)
#line 125
		error("bad index: status = %d", err);
#line 125
	    index[j] = 0;
#line 125
	}
#line 125
	for (j = 0; j < var_nels[i]; j++) {
#line 125
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 125
	    IF (err)
#line 125
		error("error in toMixedBase 1");
#line 125
	    expect = hash4( var_type[i], var_rank[i], index, NCT_UCHAR );
#line 125
	    if (var_rank[i] == 0 && i%2 )
#line 125
		err = nc_get_var1_uchar(ncid, i, NULL, &value);
#line 125
	    else
#line 125
		err = nc_get_var1_uchar(ncid, i, index, &value);
#line 125
            if (canConvert) {
#line 125
		if (inRange3(expect,var_type[i], NCT_UCHAR)) {
#line 125
		    if (expect >= uchar_min && expect <= uchar_max) {
#line 125
			IF (err) {
#line 125
			    error("%s", nc_strerror(err));
#line 125
			} else {
#line 125
			    IF (!equal(value,expect,var_type[i],NCT_UCHAR)) {
#line 125
				error("expected: %G, got: %G", expect,
#line 125
				    (double) value);
#line 125
			    } else {
#line 125
				nok++;
#line 125
			    }
#line 125
			}
#line 125
		    } else {
#line 125
			IF (err != NC_ERANGE)
#line 125
			    error("Range error: status = %d", err);
#line 125
		    }
#line 125
                } else {
#line 125
                    IF (err != 0 && err != NC_ERANGE)
#line 125
                        error("OK or Range error: status = %d", err);
#line 125
		}
#line 125
	    } else {
#line 125
		IF (err != NC_ECHAR)
#line 125
		    error("wrong type: status = %d", err);
#line 125
	    }
#line 125
	}
#line 125
    }
#line 125
    err = nc_close(ncid);
#line 125
    IF (err)
#line 125
	error("nc_close: %s", nc_strerror(err));
#line 125
    print_nok(nok);
#line 125
}
#line 125

void
#line 126
test_nc_get_var1_schar(void)
#line 126
{
#line 126
    int ncid;
#line 126
    int i;
#line 126
    int j;
#line 126
    int err;
#line 126
    int nok = 0;      /* count of valid comparisons */
#line 126
    size_t index[MAX_RANK];
#line 126
    double expect;
#line 126
    int canConvert;     /* Both text or both numeric */
#line 126
    schar value;
#line 126

#line 126
#ifdef TEST_PNETCDF
#line 126
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 126
#else
#line 126
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 126
#endif
#line 126
    IF (err)
#line 126
	error("nc_open: %s", nc_strerror(err));
#line 126
    for (i = 0; i < numVars; i++) {
#line 126
        canConvert = (var_type[i] == NC_CHAR) == (NCT_SCHAR == NCT_TEXT);
#line 126
	for (j = 0; j < var_rank[i]; j++)
#line 126
	    index[j] = 0;
#line 126
        err = nc_get_var1_schar(BAD_ID, i, index, &value);
#line 126
        IF (err != NC_EBADID)
#line 126
	    error("bad ncid: status = %d", err);
#line 126
        err = nc_get_var1_schar(ncid, BAD_VARID, index, &value);
#line 126
        IF (err != NC_ENOTVAR)
#line 126
	    error("bad var id: status = %d", err);
#line 126
	for (j = 0; j < var_rank[i]; j++) {
#line 126
	    index[j] = var_shape[i][j];
#line 126
	    err = nc_get_var1_schar(ncid, i, index, &value);
#line 126
	    if(!canConvert) {
#line 126
		IF(err != NC_ECHAR)
#line 126
			error("conversion: status = %d", err);
#line 126
	    } else IF (err != NC_EINVALCOORDS)
#line 126
		error("bad index: status = %d", err);
#line 126
	    index[j] = 0;
#line 126
	}
#line 126
	for (j = 0; j < var_nels[i]; j++) {
#line 126
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 126
	    IF (err)
#line 126
		error("error in toMixedBase 1");
#line 126
	    expect = hash4( var_type[i], var_rank[i], index, NCT_SCHAR );
#line 126
	    if (var_rank[i] == 0 && i%2 )
#line 126
		err = nc_get_var1_schar(ncid, i, NULL, &value);
#line 126
	    else
#line 126
		err = nc_get_var1_schar(ncid, i, index, &value);
#line 126
            if (canConvert) {
#line 126
		if (inRange3(expect,var_type[i], NCT_SCHAR)) {
#line 126
		    if (expect >= schar_min && expect <= schar_max) {
#line 126
			IF (err) {
#line 126
			    error("%s", nc_strerror(err));
#line 126
			} else {
#line 126
			    IF (!equal(value,expect,var_type[i],NCT_SCHAR)) {
#line 126
				error("expected: %G, got: %G", expect,
#line 126
				    (double) value);
#line 126
			    } else {
#line 126
				nok++;
#line 126
			    }
#line 126
			}
#line 126
		    } else {
#line 126
			IF (err != NC_ERANGE)
#line 126
			    error("Range error: status = %d", err);
#line 126
		    }
#line 126
                } else {
#line 126
                    IF (err != 0 && err != NC_ERANGE)
#line 126
                        error("OK or Range error: status = %d", err);
#line 126
		}
#line 126
	    } else {
#line 126
		IF (err != NC_ECHAR)
#line 126
		    error("wrong type: status = %d", err);
#line 126
	    }
#line 126
	}
#line 126
    }
#line 126
    err = nc_close(ncid);
#line 126
    IF (err)
#line 126
	error("nc_close: %s", nc_strerror(err));
#line 126
    print_nok(nok);
#line 126
}
#line 126

void
#line 127
test_nc_get_var1_short(void)
#line 127
{
#line 127
    int ncid;
#line 127
    int i;
#line 127
    int j;
#line 127
    int err;
#line 127
    int nok = 0;      /* count of valid comparisons */
#line 127
    size_t index[MAX_RANK];
#line 127
    double expect;
#line 127
    int canConvert;     /* Both text or both numeric */
#line 127
    short value;
#line 127

#line 127
#ifdef TEST_PNETCDF
#line 127
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 127
#else
#line 127
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 127
#endif
#line 127
    IF (err)
#line 127
	error("nc_open: %s", nc_strerror(err));
#line 127
    for (i = 0; i < numVars; i++) {
#line 127
        canConvert = (var_type[i] == NC_CHAR) == (NCT_SHORT == NCT_TEXT);
#line 127
	for (j = 0; j < var_rank[i]; j++)
#line 127
	    index[j] = 0;
#line 127
        err = nc_get_var1_short(BAD_ID, i, index, &value);
#line 127
        IF (err != NC_EBADID)
#line 127
	    error("bad ncid: status = %d", err);
#line 127
        err = nc_get_var1_short(ncid, BAD_VARID, index, &value);
#line 127
        IF (err != NC_ENOTVAR)
#line 127
	    error("bad var id: status = %d", err);
#line 127
	for (j = 0; j < var_rank[i]; j++) {
#line 127
	    index[j] = var_shape[i][j];
#line 127
	    err = nc_get_var1_short(ncid, i, index, &value);
#line 127
	    if(!canConvert) {
#line 127
		IF(err != NC_ECHAR)
#line 127
			error("conversion: status = %d", err);
#line 127
	    } else IF (err != NC_EINVALCOORDS)
#line 127
		error("bad index: status = %d", err);
#line 127
	    index[j] = 0;
#line 127
	}
#line 127
	for (j = 0; j < var_nels[i]; j++) {
#line 127
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 127
	    IF (err)
#line 127
		error("error in toMixedBase 1");
#line 127
	    expect = hash4( var_type[i], var_rank[i], index, NCT_SHORT );
#line 127
	    if (var_rank[i] == 0 && i%2 )
#line 127
		err = nc_get_var1_short(ncid, i, NULL, &value);
#line 127
	    else
#line 127
		err = nc_get_var1_short(ncid, i, index, &value);
#line 127
            if (canConvert) {
#line 127
		if (inRange3(expect,var_type[i], NCT_SHORT)) {
#line 127
		    if (expect >= short_min && expect <= short_max) {
#line 127
			IF (err) {
#line 127
			    error("%s", nc_strerror(err));
#line 127
			} else {
#line 127
			    IF (!equal(value,expect,var_type[i],NCT_SHORT)) {
#line 127
				error("expected: %G, got: %G", expect,
#line 127
				    (double) value);
#line 127
			    } else {
#line 127
				nok++;
#line 127
			    }
#line 127
			}
#line 127
		    } else {
#line 127
			IF (err != NC_ERANGE)
#line 127
			    error("Range error: status = %d", err);
#line 127
		    }
#line 127
                } else {
#line 127
                    IF (err != 0 && err != NC_ERANGE)
#line 127
                        error("OK or Range error: status = %d", err);
#line 127
		}
#line 127
	    } else {
#line 127
		IF (err != NC_ECHAR)
#line 127
		    error("wrong type: status = %d", err);
#line 127
	    }
#line 127
	}
#line 127
    }
#line 127
    err = nc_close(ncid);
#line 127
    IF (err)
#line 127
	error("nc_close: %s", nc_strerror(err));
#line 127
    print_nok(nok);
#line 127
}
#line 127

void
#line 128
test_nc_get_var1_int(void)
#line 128
{
#line 128
    int ncid;
#line 128
    int i;
#line 128
    int j;
#line 128
    int err;
#line 128
    int nok = 0;      /* count of valid comparisons */
#line 128
    size_t index[MAX_RANK];
#line 128
    double expect;
#line 128
    int canConvert;     /* Both text or both numeric */
#line 128
    int value;
#line 128

#line 128
#ifdef TEST_PNETCDF
#line 128
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 128
#else
#line 128
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 128
#endif
#line 128
    IF (err)
#line 128
	error("nc_open: %s", nc_strerror(err));
#line 128
    for (i = 0; i < numVars; i++) {
#line 128
        canConvert = (var_type[i] == NC_CHAR) == (NCT_INT == NCT_TEXT);
#line 128
	for (j = 0; j < var_rank[i]; j++)
#line 128
	    index[j] = 0;
#line 128
        err = nc_get_var1_int(BAD_ID, i, index, &value);
#line 128
        IF (err != NC_EBADID)
#line 128
	    error("bad ncid: status = %d", err);
#line 128
        err = nc_get_var1_int(ncid, BAD_VARID, index, &value);
#line 128
        IF (err != NC_ENOTVAR)
#line 128
	    error("bad var id: status = %d", err);
#line 128
	for (j = 0; j < var_rank[i]; j++) {
#line 128
	    index[j] = var_shape[i][j];
#line 128
	    err = nc_get_var1_int(ncid, i, index, &value);
#line 128
	    if(!canConvert) {
#line 128
		IF(err != NC_ECHAR)
#line 128
			error("conversion: status = %d", err);
#line 128
	    } else IF (err != NC_EINVALCOORDS)
#line 128
		error("bad index: status = %d", err);
#line 128
	    index[j] = 0;
#line 128
	}
#line 128
	for (j = 0; j < var_nels[i]; j++) {
#line 128
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 128
	    IF (err)
#line 128
		error("error in toMixedBase 1");
#line 128
	    expect = hash4( var_type[i], var_rank[i], index, NCT_INT );
#line 128
	    if (var_rank[i] == 0 && i%2 )
#line 128
		err = nc_get_var1_int(ncid, i, NULL, &value);
#line 128
	    else
#line 128
		err = nc_get_var1_int(ncid, i, index, &value);
#line 128
            if (canConvert) {
#line 128
		if (inRange3(expect,var_type[i], NCT_INT)) {
#line 128
		    if (expect >= int_min && expect <= int_max) {
#line 128
			IF (err) {
#line 128
			    error("%s", nc_strerror(err));
#line 128
			} else {
#line 128
			    IF (!equal(value,expect,var_type[i],NCT_INT)) {
#line 128
				error("expected: %G, got: %G", expect,
#line 128
				    (double) value);
#line 128
			    } else {
#line 128
				nok++;
#line 128
			    }
#line 128
			}
#line 128
		    } else {
#line 128
			IF (err != NC_ERANGE)
#line 128
			    error("Range error: status = %d", err);
#line 128
		    }
#line 128
                } else {
#line 128
                    IF (err != 0 && err != NC_ERANGE)
#line 128
                        error("OK or Range error: status = %d", err);
#line 128
		}
#line 128
	    } else {
#line 128
		IF (err != NC_ECHAR)
#line 128
		    error("wrong type: status = %d", err);
#line 128
	    }
#line 128
	}
#line 128
    }
#line 128
    err = nc_close(ncid);
#line 128
    IF (err)
#line 128
	error("nc_close: %s", nc_strerror(err));
#line 128
    print_nok(nok);
#line 128
}
#line 128

void
#line 129
test_nc_get_var1_long(void)
#line 129
{
#line 129
    int ncid;
#line 129
    int i;
#line 129
    int j;
#line 129
    int err;
#line 129
    int nok = 0;      /* count of valid comparisons */
#line 129
    size_t index[MAX_RANK];
#line 129
    double expect;
#line 129
    int canConvert;     /* Both text or both numeric */
#line 129
    long value;
#line 129

#line 129
#ifdef TEST_PNETCDF
#line 129
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 129
#else
#line 129
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 129
#endif
#line 129
    IF (err)
#line 129
	error("nc_open: %s", nc_strerror(err));
#line 129
    for (i = 0; i < numVars; i++) {
#line 129
        canConvert = (var_type[i] == NC_CHAR) == (NCT_LONG == NCT_TEXT);
#line 129
	for (j = 0; j < var_rank[i]; j++)
#line 129
	    index[j] = 0;
#line 129
        err = nc_get_var1_long(BAD_ID, i, index, &value);
#line 129
        IF (err != NC_EBADID)
#line 129
	    error("bad ncid: status = %d", err);
#line 129
        err = nc_get_var1_long(ncid, BAD_VARID, index, &value);
#line 129
        IF (err != NC_ENOTVAR)
#line 129
	    error("bad var id: status = %d", err);
#line 129
	for (j = 0; j < var_rank[i]; j++) {
#line 129
	    index[j] = var_shape[i][j];
#line 129
	    err = nc_get_var1_long(ncid, i, index, &value);
#line 129
	    if(!canConvert) {
#line 129
		IF(err != NC_ECHAR)
#line 129
			error("conversion: status = %d", err);
#line 129
	    } else IF (err != NC_EINVALCOORDS)
#line 129
		error("bad index: status = %d", err);
#line 129
	    index[j] = 0;
#line 129
	}
#line 129
	for (j = 0; j < var_nels[i]; j++) {
#line 129
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 129
	    IF (err)
#line 129
		error("error in toMixedBase 1");
#line 129
	    expect = hash4( var_type[i], var_rank[i], index, NCT_LONG );
#line 129
	    if (var_rank[i] == 0 && i%2 )
#line 129
		err = nc_get_var1_long(ncid, i, NULL, &value);
#line 129
	    else
#line 129
		err = nc_get_var1_long(ncid, i, index, &value);
#line 129
            if (canConvert) {
#line 129
		if (inRange3(expect,var_type[i], NCT_LONG)) {
#line 129
		    if (expect >= long_min && expect <= long_max) {
#line 129
			IF (err) {
#line 129
			    error("%s", nc_strerror(err));
#line 129
			} else {
#line 129
			    IF (!equal(value,expect,var_type[i],NCT_LONG)) {
#line 129
				error("expected: %G, got: %G", expect,
#line 129
				    (double) value);
#line 129
			    } else {
#line 129
				nok++;
#line 129
			    }
#line 129
			}
#line 129
		    } else {
#line 129
			IF (err != NC_ERANGE)
#line 129
			    error("Range error: status = %d", err);
#line 129
		    }
#line 129
                } else {
#line 129
                    IF (err != 0 && err != NC_ERANGE)
#line 129
                        error("OK or Range error: status = %d", err);
#line 129
		}
#line 129
	    } else {
#line 129
		IF (err != NC_ECHAR)
#line 129
		    error("wrong type: status = %d", err);
#line 129
	    }
#line 129
	}
#line 129
    }
#line 129
    err = nc_close(ncid);
#line 129
    IF (err)
#line 129
	error("nc_close: %s", nc_strerror(err));
#line 129
    print_nok(nok);
#line 129
}
#line 129

void
#line 130
test_nc_get_var1_float(void)
#line 130
{
#line 130
    int ncid;
#line 130
    int i;
#line 130
    int j;
#line 130
    int err;
#line 130
    int nok = 0;      /* count of valid comparisons */
#line 130
    size_t index[MAX_RANK];
#line 130
    double expect;
#line 130
    int canConvert;     /* Both text or both numeric */
#line 130
    float value;
#line 130

#line 130
#ifdef TEST_PNETCDF
#line 130
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 130
#else
#line 130
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 130
#endif
#line 130
    IF (err)
#line 130
	error("nc_open: %s", nc_strerror(err));
#line 130
    for (i = 0; i < numVars; i++) {
#line 130
        canConvert = (var_type[i] == NC_CHAR) == (NCT_FLOAT == NCT_TEXT);
#line 130
	for (j = 0; j < var_rank[i]; j++)
#line 130
	    index[j] = 0;
#line 130
        err = nc_get_var1_float(BAD_ID, i, index, &value);
#line 130
        IF (err != NC_EBADID)
#line 130
	    error("bad ncid: status = %d", err);
#line 130
        err = nc_get_var1_float(ncid, BAD_VARID, index, &value);
#line 130
        IF (err != NC_ENOTVAR)
#line 130
	    error("bad var id: status = %d", err);
#line 130
	for (j = 0; j < var_rank[i]; j++) {
#line 130
	    index[j] = var_shape[i][j];
#line 130
	    err = nc_get_var1_float(ncid, i, index, &value);
#line 130
	    if(!canConvert) {
#line 130
		IF(err != NC_ECHAR)
#line 130
			error("conversion: status = %d", err);
#line 130
	    } else IF (err != NC_EINVALCOORDS)
#line 130
		error("bad index: status = %d", err);
#line 130
	    index[j] = 0;
#line 130
	}
#line 130
	for (j = 0; j < var_nels[i]; j++) {
#line 130
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 130
	    IF (err)
#line 130
		error("error in toMixedBase 1");
#line 130
	    expect = hash4( var_type[i], var_rank[i], index, NCT_FLOAT );
#line 130
	    if (var_rank[i] == 0 && i%2 )
#line 130
		err = nc_get_var1_float(ncid, i, NULL, &value);
#line 130
	    else
#line 130
		err = nc_get_var1_float(ncid, i, index, &value);
#line 130
            if (canConvert) {
#line 130
		if (inRange3(expect,var_type[i], NCT_FLOAT)) {
#line 130
		    if (expect >= float_min && expect <= float_max) {
#line 130
			IF (err) {
#line 130
			    error("%s", nc_strerror(err));
#line 130
			} else {
#line 130
			    IF (!equal(value,expect,var_type[i],NCT_FLOAT)) {
#line 130
				error("expected: %G, got: %G", expect,
#line 130
				    (double) value);
#line 130
			    } else {
#line 130
				nok++;
#line 130
			    }
#line 130
			}
#line 130
		    } else {
#line 130
			IF (err != NC_ERANGE)
#line 130
			    error("Range error: status = %d", err);
#line 130
		    }
#line 130
                } else {
#line 130
                    IF (err != 0 && err != NC_ERANGE)
#line 130
                        error("OK or Range error: status = %d", err);
#line 130
		}
#line 130
	    } else {
#line 130
		IF (err != NC_ECHAR)
#line 130
		    error("wrong type: status = %d", err);
#line 130
	    }
#line 130
	}
#line 130
    }
#line 130
    err = nc_close(ncid);
#line 130
    IF (err)
#line 130
	error("nc_close: %s", nc_strerror(err));
#line 130
    print_nok(nok);
#line 130
}
#line 130

void
#line 131
test_nc_get_var1_double(void)
#line 131
{
#line 131
    int ncid;
#line 131
    int i;
#line 131
    int j;
#line 131
    int err;
#line 131
    int nok = 0;      /* count of valid comparisons */
#line 131
    size_t index[MAX_RANK];
#line 131
    double expect;
#line 131
    int canConvert;     /* Both text or both numeric */
#line 131
    double value;
#line 131

#line 131
#ifdef TEST_PNETCDF
#line 131
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 131
#else
#line 131
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 131
#endif
#line 131
    IF (err)
#line 131
	error("nc_open: %s", nc_strerror(err));
#line 131
    for (i = 0; i < numVars; i++) {
#line 131
        canConvert = (var_type[i] == NC_CHAR) == (NCT_DOUBLE == NCT_TEXT);
#line 131
	for (j = 0; j < var_rank[i]; j++)
#line 131
	    index[j] = 0;
#line 131
        err = nc_get_var1_double(BAD_ID, i, index, &value);
#line 131
        IF (err != NC_EBADID)
#line 131
	    error("bad ncid: status = %d", err);
#line 131
        err = nc_get_var1_double(ncid, BAD_VARID, index, &value);
#line 131
        IF (err != NC_ENOTVAR)
#line 131
	    error("bad var id: status = %d", err);
#line 131
	for (j = 0; j < var_rank[i]; j++) {
#line 131
	    index[j] = var_shape[i][j];
#line 131
	    err = nc_get_var1_double(ncid, i, index, &value);
#line 131
	    if(!canConvert) {
#line 131
		IF(err != NC_ECHAR)
#line 131
			error("conversion: status = %d", err);
#line 131
	    } else IF (err != NC_EINVALCOORDS)
#line 131
		error("bad index: status = %d", err);
#line 131
	    index[j] = 0;
#line 131
	}
#line 131
	for (j = 0; j < var_nels[i]; j++) {
#line 131
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 131
	    IF (err)
#line 131
		error("error in toMixedBase 1");
#line 131
	    expect = hash4( var_type[i], var_rank[i], index, NCT_DOUBLE );
#line 131
	    if (var_rank[i] == 0 && i%2 )
#line 131
		err = nc_get_var1_double(ncid, i, NULL, &value);
#line 131
	    else
#line 131
		err = nc_get_var1_double(ncid, i, index, &value);
#line 131
            if (canConvert) {
#line 131
		if (inRange3(expect,var_type[i], NCT_DOUBLE)) {
#line 131
		    if (expect >= double_min && expect <= double_max) {
#line 131
			IF (err) {
#line 131
			    error("%s", nc_strerror(err));
#line 131
			} else {
#line 131
			    IF (!equal(value,expect,var_type[i],NCT_DOUBLE)) {
#line 131
				error("expected: %G, got: %G", expect,
#line 131
				    (double) value);
#line 131
			    } else {
#line 131
				nok++;
#line 131
			    }
#line 131
			}
#line 131
		    } else {
#line 131
			IF (err != NC_ERANGE)
#line 131
			    error("Range error: status = %d", err);
#line 131
		    }
#line 131
                } else {
#line 131
                    IF (err != 0 && err != NC_ERANGE)
#line 131
                        error("OK or Range error: status = %d", err);
#line 131
		}
#line 131
	    } else {
#line 131
		IF (err != NC_ECHAR)
#line 131
		    error("wrong type: status = %d", err);
#line 131
	    }
#line 131
	}
#line 131
    }
#line 131
    err = nc_close(ncid);
#line 131
    IF (err)
#line 131
	error("nc_close: %s", nc_strerror(err));
#line 131
    print_nok(nok);
#line 131
}
#line 131

void
#line 132
test_nc_get_var1_ushort(void)
#line 132
{
#line 132
    int ncid;
#line 132
    int i;
#line 132
    int j;
#line 132
    int err;
#line 132
    int nok = 0;      /* count of valid comparisons */
#line 132
    size_t index[MAX_RANK];
#line 132
    double expect;
#line 132
    int canConvert;     /* Both text or both numeric */
#line 132
    ushort value;
#line 132

#line 132
#ifdef TEST_PNETCDF
#line 132
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 132
#else
#line 132
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 132
#endif
#line 132
    IF (err)
#line 132
	error("nc_open: %s", nc_strerror(err));
#line 132
    for (i = 0; i < numVars; i++) {
#line 132
        canConvert = (var_type[i] == NC_CHAR) == (NCT_USHORT == NCT_TEXT);
#line 132
	for (j = 0; j < var_rank[i]; j++)
#line 132
	    index[j] = 0;
#line 132
        err = nc_get_var1_ushort(BAD_ID, i, index, &value);
#line 132
        IF (err != NC_EBADID)
#line 132
	    error("bad ncid: status = %d", err);
#line 132
        err = nc_get_var1_ushort(ncid, BAD_VARID, index, &value);
#line 132
        IF (err != NC_ENOTVAR)
#line 132
	    error("bad var id: status = %d", err);
#line 132
	for (j = 0; j < var_rank[i]; j++) {
#line 132
	    index[j] = var_shape[i][j];
#line 132
	    err = nc_get_var1_ushort(ncid, i, index, &value);
#line 132
	    if(!canConvert) {
#line 132
		IF(err != NC_ECHAR)
#line 132
			error("conversion: status = %d", err);
#line 132
	    } else IF (err != NC_EINVALCOORDS)
#line 132
		error("bad index: status = %d", err);
#line 132
	    index[j] = 0;
#line 132
	}
#line 132
	for (j = 0; j < var_nels[i]; j++) {
#line 132
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 132
	    IF (err)
#line 132
		error("error in toMixedBase 1");
#line 132
	    expect = hash4( var_type[i], var_rank[i], index, NCT_USHORT );
#line 132
	    if (var_rank[i] == 0 && i%2 )
#line 132
		err = nc_get_var1_ushort(ncid, i, NULL, &value);
#line 132
	    else
#line 132
		err = nc_get_var1_ushort(ncid, i, index, &value);
#line 132
            if (canConvert) {
#line 132
		if (inRange3(expect,var_type[i], NCT_USHORT)) {
#line 132
		    if (expect >= ushort_min && expect <= ushort_max) {
#line 132
			IF (err) {
#line 132
			    error("%s", nc_strerror(err));
#line 132
			} else {
#line 132
			    IF (!equal(value,expect,var_type[i],NCT_USHORT)) {
#line 132
				error("expected: %G, got: %G", expect,
#line 132
				    (double) value);
#line 132
			    } else {
#line 132
				nok++;
#line 132
			    }
#line 132
			}
#line 132
		    } else {
#line 132
			IF (err != NC_ERANGE)
#line 132
			    error("Range error: status = %d", err);
#line 132
		    }
#line 132
                } else {
#line 132
                    IF (err != 0 && err != NC_ERANGE)
#line 132
                        error("OK or Range error: status = %d", err);
#line 132
		}
#line 132
	    } else {
#line 132
		IF (err != NC_ECHAR)
#line 132
		    error("wrong type: status = %d", err);
#line 132
	    }
#line 132
	}
#line 132
    }
#line 132
    err = nc_close(ncid);
#line 132
    IF (err)
#line 132
	error("nc_close: %s", nc_strerror(err));
#line 132
    print_nok(nok);
#line 132
}
#line 132

void
#line 133
test_nc_get_var1_uint(void)
#line 133
{
#line 133
    int ncid;
#line 133
    int i;
#line 133
    int j;
#line 133
    int err;
#line 133
    int nok = 0;      /* count of valid comparisons */
#line 133
    size_t index[MAX_RANK];
#line 133
    double expect;
#line 133
    int canConvert;     /* Both text or both numeric */
#line 133
    uint value;
#line 133

#line 133
#ifdef TEST_PNETCDF
#line 133
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 133
#else
#line 133
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 133
#endif
#line 133
    IF (err)
#line 133
	error("nc_open: %s", nc_strerror(err));
#line 133
    for (i = 0; i < numVars; i++) {
#line 133
        canConvert = (var_type[i] == NC_CHAR) == (NCT_UINT == NCT_TEXT);
#line 133
	for (j = 0; j < var_rank[i]; j++)
#line 133
	    index[j] = 0;
#line 133
        err = nc_get_var1_uint(BAD_ID, i, index, &value);
#line 133
        IF (err != NC_EBADID)
#line 133
	    error("bad ncid: status = %d", err);
#line 133
        err = nc_get_var1_uint(ncid, BAD_VARID, index, &value);
#line 133
        IF (err != NC_ENOTVAR)
#line 133
	    error("bad var id: status = %d", err);
#line 133
	for (j = 0; j < var_rank[i]; j++) {
#line 133
	    index[j] = var_shape[i][j];
#line 133
	    err = nc_get_var1_uint(ncid, i, index, &value);
#line 133
	    if(!canConvert) {
#line 133
		IF(err != NC_ECHAR)
#line 133
			error("conversion: status = %d", err);
#line 133
	    } else IF (err != NC_EINVALCOORDS)
#line 133
		error("bad index: status = %d", err);
#line 133
	    index[j] = 0;
#line 133
	}
#line 133
	for (j = 0; j < var_nels[i]; j++) {
#line 133
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 133
	    IF (err)
#line 133
		error("error in toMixedBase 1");
#line 133
	    expect = hash4( var_type[i], var_rank[i], index, NCT_UINT );
#line 133
	    if (var_rank[i] == 0 && i%2 )
#line 133
		err = nc_get_var1_uint(ncid, i, NULL, &value);
#line 133
	    else
#line 133
		err = nc_get_var1_uint(ncid, i, index, &value);
#line 133
            if (canConvert) {
#line 133
		if (inRange3(expect,var_type[i], NCT_UINT)) {
#line 133
		    if (expect >= uint_min && expect <= uint_max) {
#line 133
			IF (err) {
#line 133
			    error("%s", nc_strerror(err));
#line 133
			} else {
#line 133
			    IF (!equal(value,expect,var_type[i],NCT_UINT)) {
#line 133
				error("expected: %G, got: %G", expect,
#line 133
				    (double) value);
#line 133
			    } else {
#line 133
				nok++;
#line 133
			    }
#line 133
			}
#line 133
		    } else {
#line 133
			IF (err != NC_ERANGE)
#line 133
			    error("Range error: status = %d", err);
#line 133
		    }
#line 133
                } else {
#line 133
                    IF (err != 0 && err != NC_ERANGE)
#line 133
                        error("OK or Range error: status = %d", err);
#line 133
		}
#line 133
	    } else {
#line 133
		IF (err != NC_ECHAR)
#line 133
		    error("wrong type: status = %d", err);
#line 133
	    }
#line 133
	}
#line 133
    }
#line 133
    err = nc_close(ncid);
#line 133
    IF (err)
#line 133
	error("nc_close: %s", nc_strerror(err));
#line 133
    print_nok(nok);
#line 133
}
#line 133

void
#line 134
test_nc_get_var1_longlong(void)
#line 134
{
#line 134
    int ncid;
#line 134
    int i;
#line 134
    int j;
#line 134
    int err;
#line 134
    int nok = 0;      /* count of valid comparisons */
#line 134
    size_t index[MAX_RANK];
#line 134
    double expect;
#line 134
    int canConvert;     /* Both text or both numeric */
#line 134
    longlong value;
#line 134

#line 134
#ifdef TEST_PNETCDF
#line 134
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 134
#else
#line 134
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 134
#endif
#line 134
    IF (err)
#line 134
	error("nc_open: %s", nc_strerror(err));
#line 134
    for (i = 0; i < numVars; i++) {
#line 134
        canConvert = (var_type[i] == NC_CHAR) == (NCT_LONGLONG == NCT_TEXT);
#line 134
	for (j = 0; j < var_rank[i]; j++)
#line 134
	    index[j] = 0;
#line 134
        err = nc_get_var1_longlong(BAD_ID, i, index, &value);
#line 134
        IF (err != NC_EBADID)
#line 134
	    error("bad ncid: status = %d", err);
#line 134
        err = nc_get_var1_longlong(ncid, BAD_VARID, index, &value);
#line 134
        IF (err != NC_ENOTVAR)
#line 134
	    error("bad var id: status = %d", err);
#line 134
	for (j = 0; j < var_rank[i]; j++) {
#line 134
	    index[j] = var_shape[i][j];
#line 134
	    err = nc_get_var1_longlong(ncid, i, index, &value);
#line 134
	    if(!canConvert) {
#line 134
		IF(err != NC_ECHAR)
#line 134
			error("conversion: status = %d", err);
#line 134
	    } else IF (err != NC_EINVALCOORDS)
#line 134
		error("bad index: status = %d", err);
#line 134
	    index[j] = 0;
#line 134
	}
#line 134
	for (j = 0; j < var_nels[i]; j++) {
#line 134
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 134
	    IF (err)
#line 134
		error("error in toMixedBase 1");
#line 134
	    expect = hash4( var_type[i], var_rank[i], index, NCT_LONGLONG );
#line 134
	    if (var_rank[i] == 0 && i%2 )
#line 134
		err = nc_get_var1_longlong(ncid, i, NULL, &value);
#line 134
	    else
#line 134
		err = nc_get_var1_longlong(ncid, i, index, &value);
#line 134
            if (canConvert) {
#line 134
		if (inRange3(expect,var_type[i], NCT_LONGLONG)) {
#line 134
		    if (expect >= longlong_min && expect <= longlong_max) {
#line 134
			IF (err) {
#line 134
			    error("%s", nc_strerror(err));
#line 134
			} else {
#line 134
			    IF (!equal(value,expect,var_type[i],NCT_LONGLONG)) {
#line 134
				error("expected: %G, got: %G", expect,
#line 134
				    (double) value);
#line 134
			    } else {
#line 134
				nok++;
#line 134
			    }
#line 134
			}
#line 134
		    } else {
#line 134
			IF (err != NC_ERANGE)
#line 134
			    error("Range error: status = %d", err);
#line 134
		    }
#line 134
                } else {
#line 134
                    IF (err != 0 && err != NC_ERANGE)
#line 134
                        error("OK or Range error: status = %d", err);
#line 134
		}
#line 134
	    } else {
#line 134
		IF (err != NC_ECHAR)
#line 134
		    error("wrong type: status = %d", err);
#line 134
	    }
#line 134
	}
#line 134
    }
#line 134
    err = nc_close(ncid);
#line 134
    IF (err)
#line 134
	error("nc_close: %s", nc_strerror(err));
#line 134
    print_nok(nok);
#line 134
}
#line 134

void
#line 135
test_nc_get_var1_ulonglong(void)
#line 135
{
#line 135
    int ncid;
#line 135
    int i;
#line 135
    int j;
#line 135
    int err;
#line 135
    int nok = 0;      /* count of valid comparisons */
#line 135
    size_t index[MAX_RANK];
#line 135
    double expect;
#line 135
    int canConvert;     /* Both text or both numeric */
#line 135
    ulonglong value;
#line 135

#line 135
#ifdef TEST_PNETCDF
#line 135
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 135
#else
#line 135
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 135
#endif
#line 135
    IF (err)
#line 135
	error("nc_open: %s", nc_strerror(err));
#line 135
    for (i = 0; i < numVars; i++) {
#line 135
        canConvert = (var_type[i] == NC_CHAR) == (NCT_ULONGLONG == NCT_TEXT);
#line 135
	for (j = 0; j < var_rank[i]; j++)
#line 135
	    index[j] = 0;
#line 135
        err = nc_get_var1_ulonglong(BAD_ID, i, index, &value);
#line 135
        IF (err != NC_EBADID)
#line 135
	    error("bad ncid: status = %d", err);
#line 135
        err = nc_get_var1_ulonglong(ncid, BAD_VARID, index, &value);
#line 135
        IF (err != NC_ENOTVAR)
#line 135
	    error("bad var id: status = %d", err);
#line 135
	for (j = 0; j < var_rank[i]; j++) {
#line 135
	    index[j] = var_shape[i][j];
#line 135
	    err = nc_get_var1_ulonglong(ncid, i, index, &value);
#line 135
	    if(!canConvert) {
#line 135
		IF(err != NC_ECHAR)
#line 135
			error("conversion: status = %d", err);
#line 135
	    } else IF (err != NC_EINVALCOORDS)
#line 135
		error("bad index: status = %d", err);
#line 135
	    index[j] = 0;
#line 135
	}
#line 135
	for (j = 0; j < var_nels[i]; j++) {
#line 135
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 135
	    IF (err)
#line 135
		error("error in toMixedBase 1");
#line 135
	    expect = hash4( var_type[i], var_rank[i], index, NCT_ULONGLONG );
#line 135
	    if (var_rank[i] == 0 && i%2 )
#line 135
		err = nc_get_var1_ulonglong(ncid, i, NULL, &value);
#line 135
	    else
#line 135
		err = nc_get_var1_ulonglong(ncid, i, index, &value);
#line 135
            if (canConvert) {
#line 135
		if (inRange3(expect,var_type[i], NCT_ULONGLONG)) {
#line 135
		    if (expect >= ulonglong_min && expect <= ulonglong_max) {
#line 135
			IF (err) {
#line 135
			    error("%s", nc_strerror(err));
#line 135
			} else {
#line 135
			    IF (!equal(value,expect,var_type[i],NCT_ULONGLONG)) {
#line 135
				error("expected: %G, got: %G", expect,
#line 135
				    (double) value);
#line 135
			    } else {
#line 135
				nok++;
#line 135
			    }
#line 135
			}
#line 135
		    } else {
#line 135
			IF (err != NC_ERANGE)
#line 135
			    error("Range error: status = %d", err);
#line 135
		    }
#line 135
                } else {
#line 135
                    IF (err != 0 && err != NC_ERANGE)
#line 135
                        error("OK or Range error: status = %d", err);
#line 135
		}
#line 135
	    } else {
#line 135
		IF (err != NC_ECHAR)
#line 135
		    error("wrong type: status = %d", err);
#line 135
	    }
#line 135
	}
#line 135
    }
#line 135
    err = nc_close(ncid);
#line 135
    IF (err)
#line 135
	error("nc_close: %s", nc_strerror(err));
#line 135
    print_nok(nok);
#line 135
}
#line 135



#line 236

void
#line 237
test_nc_get_var_text(void)
#line 237
{
#line 237
    int ncid;
#line 237
    int i;
#line 237
    int j;
#line 237
    int err;
#line 237
    int allInExtRange;	/* all values within external range? */
#line 237
    int allInIntRange;	/* all values within internal range? */
#line 237
    int nels;
#line 237
    int nok = 0;      /* count of valid comparisons */
#line 237
    size_t index[MAX_RANK];
#line 237
    int canConvert;     /* Both text or both numeric */
#line 237
    text value[MAX_NELS];
#line 237
    double expect[MAX_NELS];
#line 237

#line 237
#ifdef TEST_PNETCDF
#line 237
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 237
#else
#line 237
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 237
#endif
#line 237
    IF (err)
#line 237
	error("nc_open: %s", nc_strerror(err));
#line 237
    for (i = 0; i < numVars; i++) {
#line 237
        canConvert = (var_type[i] == NC_CHAR) == (NCT_TEXT == NCT_TEXT);
#line 237
        assert(var_rank[i] <= MAX_RANK);
#line 237
        assert(var_nels[i] <= MAX_NELS);
#line 237
        err = nc_get_var_text(BAD_ID, i, value);
#line 237
        IF (err != NC_EBADID)
#line 237
	    error("bad ncid: status = %d", err);
#line 237
        err = nc_get_var_text(ncid, BAD_VARID, value);
#line 237
        IF (err != NC_ENOTVAR)
#line 237
	    error("bad var id: status = %d", err);
#line 237

#line 237
	nels = 1;
#line 237
	for (j = 0; j < var_rank[i]; j++) {
#line 237
	    nels *= var_shape[i][j];
#line 237
	}
#line 237
	allInExtRange = allInIntRange = 1;
#line 237
	for (j = 0; j < nels; j++) {
#line 237
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 237
	    IF (err)
#line 237
		error("error in toMixedBase 1");
#line 237
	    expect[j] = hash4(var_type[i], var_rank[i], index, NCT_TEXT);
#line 237
	    if (inRange3(expect[j],var_type[i], NCT_TEXT)) {
#line 237
		allInIntRange = allInIntRange && expect[j] >= text_min
#line 237
			    && expect[j] <= text_max;
#line 237
	    } else {
#line 237
		allInExtRange = 0;
#line 237
	    }
#line 237
	}
#line 237
	err = nc_get_var_text(ncid, i, value);
#line 237
	if (canConvert) {
#line 237
	    if (allInExtRange) {
#line 237
		if (allInIntRange) {
#line 237
		    IF (err)
#line 237
			error("%s", nc_strerror(err));
#line 237
		} else {
#line 237
		    IF (err != NC_ERANGE)
#line 237
			error("Range error: status = %d", err);
#line 237
		}
#line 237
	    } else {
#line 237
		IF (err != 0 && err != NC_ERANGE)
#line 237
		    error("OK or Range error: status = %d", err);
#line 237
	    }
#line 237
	    for (j = 0; j < nels; j++) {
#line 237
		if (inRange3(expect[j],var_type[i],NCT_TEXT)
#line 237
			&& expect[j] >= text_min && expect[j] <= text_max) {
#line 237
		    IF (!equal(value[j],expect[j],var_type[i],NCT_TEXT)){
#line 237
			error("value read not that expected");
#line 237
			if (verbose) {
#line 237
			    error("\n");
#line 237
			    error("varid: %d, ", i);
#line 237
			    error("var_name: %s, ", var_name[i]);
#line 237
			    error("element number: %d ", j);
#line 237
			    error("expect: %g", expect[j]);
#line 237
			    error("got: %g", (double) value[j]);
#line 237
			}
#line 237
		    } else {
#line 237
			nok++;
#line 237
		    }
#line 237
		}
#line 237
	    }
#line 237
	} else {
#line 237
	    IF (nels > 0 && err != NC_ECHAR)
#line 237
		error("wrong type: status = %d", err);
#line 237
	}
#line 237
    }
#line 237
    err = nc_close(ncid);
#line 237
    IF (err)
#line 237
	error("nc_close: %s", nc_strerror(err));
#line 237
    print_nok(nok);
#line 237
}
#line 237

void
#line 238
test_nc_get_var_uchar(void)
#line 238
{
#line 238
    int ncid;
#line 238
    int i;
#line 238
    int j;
#line 238
    int err;
#line 238
    int allInExtRange;	/* all values within external range? */
#line 238
    int allInIntRange;	/* all values within internal range? */
#line 238
    int nels;
#line 238
    int nok = 0;      /* count of valid comparisons */
#line 238
    size_t index[MAX_RANK];
#line 238
    int canConvert;     /* Both text or both numeric */
#line 238
    uchar value[MAX_NELS];
#line 238
    double expect[MAX_NELS];
#line 238

#line 238
#ifdef TEST_PNETCDF
#line 238
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 238
#else
#line 238
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 238
#endif
#line 238
    IF (err)
#line 238
	error("nc_open: %s", nc_strerror(err));
#line 238
    for (i = 0; i < numVars; i++) {
#line 238
        canConvert = (var_type[i] == NC_CHAR) == (NCT_UCHAR == NCT_TEXT);
#line 238
        assert(var_rank[i] <= MAX_RANK);
#line 238
        assert(var_nels[i] <= MAX_NELS);
#line 238
        err = nc_get_var_uchar(BAD_ID, i, value);
#line 238
        IF (err != NC_EBADID)
#line 238
	    error("bad ncid: status = %d", err);
#line 238
        err = nc_get_var_uchar(ncid, BAD_VARID, value);
#line 238
        IF (err != NC_ENOTVAR)
#line 238
	    error("bad var id: status = %d", err);
#line 238

#line 238
	nels = 1;
#line 238
	for (j = 0; j < var_rank[i]; j++) {
#line 238
	    nels *= var_shape[i][j];
#line 238
	}
#line 238
	allInExtRange = allInIntRange = 1;
#line 238
	for (j = 0; j < nels; j++) {
#line 238
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 238
	    IF (err)
#line 238
		error("error in toMixedBase 1");
#line 238
	    expect[j] = hash4(var_type[i], var_rank[i], index, NCT_UCHAR);
#line 238
	    if (inRange3(expect[j],var_type[i], NCT_UCHAR)) {
#line 238
		allInIntRange = allInIntRange && expect[j] >= uchar_min
#line 238
			    && expect[j] <= uchar_max;
#line 238
	    } else {
#line 238
		allInExtRange = 0;
#line 238
	    }
#line 238
	}
#line 238
	err = nc_get_var_uchar(ncid, i, value);
#line 238
	if (canConvert) {
#line 238
	    if (allInExtRange) {
#line 238
		if (allInIntRange) {
#line 238
		    IF (err)
#line 238
			error("%s", nc_strerror(err));
#line 238
		} else {
#line 238
		    IF (err != NC_ERANGE)
#line 238
			error("Range error: status = %d", err);
#line 238
		}
#line 238
	    } else {
#line 238
		IF (err != 0 && err != NC_ERANGE)
#line 238
		    error("OK or Range error: status = %d", err);
#line 238
	    }
#line 238
	    for (j = 0; j < nels; j++) {
#line 238
		if (inRange3(expect[j],var_type[i],NCT_UCHAR)
#line 238
			&& expect[j] >= uchar_min && expect[j] <= uchar_max) {
#line 238
		    IF (!equal(value[j],expect[j],var_type[i],NCT_UCHAR)){
#line 238
			error("value read not that expected");
#line 238
			if (verbose) {
#line 238
			    error("\n");
#line 238
			    error("varid: %d, ", i);
#line 238
			    error("var_name: %s, ", var_name[i]);
#line 238
			    error("element number: %d ", j);
#line 238
			    error("expect: %g", expect[j]);
#line 238
			    error("got: %g", (double) value[j]);
#line 238
			}
#line 238
		    } else {
#line 238
			nok++;
#line 238
		    }
#line 238
		}
#line 238
	    }
#line 238
	} else {
#line 238
	    IF (nels > 0 && err != NC_ECHAR)
#line 238
		error("wrong type: status = %d", err);
#line 238
	}
#line 238
    }
#line 238
    err = nc_close(ncid);
#line 238
    IF (err)
#line 238
	error("nc_close: %s", nc_strerror(err));
#line 238
    print_nok(nok);
#line 238
}
#line 238

void
#line 239
test_nc_get_var_schar(void)
#line 239
{
#line 239
    int ncid;
#line 239
    int i;
#line 239
    int j;
#line 239
    int err;
#line 239
    int allInExtRange;	/* all values within external range? */
#line 239
    int allInIntRange;	/* all values within internal range? */
#line 239
    int nels;
#line 239
    int nok = 0;      /* count of valid comparisons */
#line 239
    size_t index[MAX_RANK];
#line 239
    int canConvert;     /* Both text or both numeric */
#line 239
    schar value[MAX_NELS];
#line 239
    double expect[MAX_NELS];
#line 239

#line 239
#ifdef TEST_PNETCDF
#line 239
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 239
#else
#line 239
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 239
#endif
#line 239
    IF (err)
#line 239
	error("nc_open: %s", nc_strerror(err));
#line 239
    for (i = 0; i < numVars; i++) {
#line 239
        canConvert = (var_type[i] == NC_CHAR) == (NCT_SCHAR == NCT_TEXT);
#line 239
        assert(var_rank[i] <= MAX_RANK);
#line 239
        assert(var_nels[i] <= MAX_NELS);
#line 239
        err = nc_get_var_schar(BAD_ID, i, value);
#line 239
        IF (err != NC_EBADID)
#line 239
	    error("bad ncid: status = %d", err);
#line 239
        err = nc_get_var_schar(ncid, BAD_VARID, value);
#line 239
        IF (err != NC_ENOTVAR)
#line 239
	    error("bad var id: status = %d", err);
#line 239

#line 239
	nels = 1;
#line 239
	for (j = 0; j < var_rank[i]; j++) {
#line 239
	    nels *= var_shape[i][j];
#line 239
	}
#line 239
	allInExtRange = allInIntRange = 1;
#line 239
	for (j = 0; j < nels; j++) {
#line 239
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 239
	    IF (err)
#line 239
		error("error in toMixedBase 1");
#line 239
	    expect[j] = hash4(var_type[i], var_rank[i], index, NCT_SCHAR);
#line 239
	    if (inRange3(expect[j],var_type[i], NCT_SCHAR)) {
#line 239
		allInIntRange = allInIntRange && expect[j] >= schar_min
#line 239
			    && expect[j] <= schar_max;
#line 239
	    } else {
#line 239
		allInExtRange = 0;
#line 239
	    }
#line 239
	}
#line 239
	err = nc_get_var_schar(ncid, i, value);
#line 239
	if (canConvert) {
#line 239
	    if (allInExtRange) {
#line 239
		if (allInIntRange) {
#line 239
		    IF (err)
#line 239
			error("%s", nc_strerror(err));
#line 239
		} else {
#line 239
		    IF (err != NC_ERANGE)
#line 239
			error("Range error: status = %d", err);
#line 239
		}
#line 239
	    } else {
#line 239
		IF (err != 0 && err != NC_ERANGE)
#line 239
		    error("OK or Range error: status = %d", err);
#line 239
	    }
#line 239
	    for (j = 0; j < nels; j++) {
#line 239
		if (inRange3(expect[j],var_type[i],NCT_SCHAR)
#line 239
			&& expect[j] >= schar_min && expect[j] <= schar_max) {
#line 239
		    IF (!equal(value[j],expect[j],var_type[i],NCT_SCHAR)){
#line 239
			error("value read not that expected");
#line 239
			if (verbose) {
#line 239
			    error("\n");
#line 239
			    error("varid: %d, ", i);
#line 239
			    error("var_name: %s, ", var_name[i]);
#line 239
			    error("element number: %d ", j);
#line 239
			    error("expect: %g", expect[j]);
#line 239
			    error("got: %g", (double) value[j]);
#line 239
			}
#line 239
		    } else {
#line 239
			nok++;
#line 239
		    }
#line 239
		}
#line 239
	    }
#line 239
	} else {
#line 239
	    IF (nels > 0 && err != NC_ECHAR)
#line 239
		error("wrong type: status = %d", err);
#line 239
	}
#line 239
    }
#line 239
    err = nc_close(ncid);
#line 239
    IF (err)
#line 239
	error("nc_close: %s", nc_strerror(err));
#line 239
    print_nok(nok);
#line 239
}
#line 239

void
#line 240
test_nc_get_var_short(void)
#line 240
{
#line 240
    int ncid;
#line 240
    int i;
#line 240
    int j;
#line 240
    int err;
#line 240
    int allInExtRange;	/* all values within external range? */
#line 240
    int allInIntRange;	/* all values within internal range? */
#line 240
    int nels;
#line 240
    int nok = 0;      /* count of valid comparisons */
#line 240
    size_t index[MAX_RANK];
#line 240
    int canConvert;     /* Both text or both numeric */
#line 240
    short value[MAX_NELS];
#line 240
    double expect[MAX_NELS];
#line 240

#line 240
#ifdef TEST_PNETCDF
#line 240
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 240
#else
#line 240
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 240
#endif
#line 240
    IF (err)
#line 240
	error("nc_open: %s", nc_strerror(err));
#line 240
    for (i = 0; i < numVars; i++) {
#line 240
        canConvert = (var_type[i] == NC_CHAR) == (NCT_SHORT == NCT_TEXT);
#line 240
        assert(var_rank[i] <= MAX_RANK);
#line 240
        assert(var_nels[i] <= MAX_NELS);
#line 240
        err = nc_get_var_short(BAD_ID, i, value);
#line 240
        IF (err != NC_EBADID)
#line 240
	    error("bad ncid: status = %d", err);
#line 240
        err = nc_get_var_short(ncid, BAD_VARID, value);
#line 240
        IF (err != NC_ENOTVAR)
#line 240
	    error("bad var id: status = %d", err);
#line 240

#line 240
	nels = 1;
#line 240
	for (j = 0; j < var_rank[i]; j++) {
#line 240
	    nels *= var_shape[i][j];
#line 240
	}
#line 240
	allInExtRange = allInIntRange = 1;
#line 240
	for (j = 0; j < nels; j++) {
#line 240
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 240
	    IF (err)
#line 240
		error("error in toMixedBase 1");
#line 240
	    expect[j] = hash4(var_type[i], var_rank[i], index, NCT_SHORT);
#line 240
	    if (inRange3(expect[j],var_type[i], NCT_SHORT)) {
#line 240
		allInIntRange = allInIntRange && expect[j] >= short_min
#line 240
			    && expect[j] <= short_max;
#line 240
	    } else {
#line 240
		allInExtRange = 0;
#line 240
	    }
#line 240
	}
#line 240
	err = nc_get_var_short(ncid, i, value);
#line 240
	if (canConvert) {
#line 240
	    if (allInExtRange) {
#line 240
		if (allInIntRange) {
#line 240
		    IF (err)
#line 240
			error("%s", nc_strerror(err));
#line 240
		} else {
#line 240
		    IF (err != NC_ERANGE)
#line 240
			error("Range error: status = %d", err);
#line 240
		}
#line 240
	    } else {
#line 240
		IF (err != 0 && err != NC_ERANGE)
#line 240
		    error("OK or Range error: status = %d", err);
#line 240
	    }
#line 240
	    for (j = 0; j < nels; j++) {
#line 240
		if (inRange3(expect[j],var_type[i],NCT_SHORT)
#line 240
			&& expect[j] >= short_min && expect[j] <= short_max) {
#line 240
		    IF (!equal(value[j],expect[j],var_type[i],NCT_SHORT)){
#line 240
			error("value read not that expected");
#line 240
			if (verbose) {
#line 240
			    error("\n");
#line 240
			    error("varid: %d, ", i);
#line 240
			    error("var_name: %s, ", var_name[i]);
#line 240
			    error("element number: %d ", j);
#line 240
			    error("expect: %g", expect[j]);
#line 240
			    error("got: %g", (double) value[j]);
#line 240
			}
#line 240
		    } else {
#line 240
			nok++;
#line 240
		    }
#line 240
		}
#line 240
	    }
#line 240
	} else {
#line 240
	    IF (nels > 0 && err != NC_ECHAR)
#line 240
		error("wrong type: status = %d", err);
#line 240
	}
#line 240
    }
#line 240
    err = nc_close(ncid);
#line 240
    IF (err)
#line 240
	error("nc_close: %s", nc_strerror(err));
#line 240
    print_nok(nok);
#line 240
}
#line 240

void
#line 241
test_nc_get_var_int(void)
#line 241
{
#line 241
    int ncid;
#line 241
    int i;
#line 241
    int j;
#line 241
    int err;
#line 241
    int allInExtRange;	/* all values within external range? */
#line 241
    int allInIntRange;	/* all values within internal range? */
#line 241
    int nels;
#line 241
    int nok = 0;      /* count of valid comparisons */
#line 241
    size_t index[MAX_RANK];
#line 241
    int canConvert;     /* Both text or both numeric */
#line 241
    int value[MAX_NELS];
#line 241
    double expect[MAX_NELS];
#line 241

#line 241
#ifdef TEST_PNETCDF
#line 241
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 241
#else
#line 241
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 241
#endif
#line 241
    IF (err)
#line 241
	error("nc_open: %s", nc_strerror(err));
#line 241
    for (i = 0; i < numVars; i++) {
#line 241
        canConvert = (var_type[i] == NC_CHAR) == (NCT_INT == NCT_TEXT);
#line 241
        assert(var_rank[i] <= MAX_RANK);
#line 241
        assert(var_nels[i] <= MAX_NELS);
#line 241
        err = nc_get_var_int(BAD_ID, i, value);
#line 241
        IF (err != NC_EBADID)
#line 241
	    error("bad ncid: status = %d", err);
#line 241
        err = nc_get_var_int(ncid, BAD_VARID, value);
#line 241
        IF (err != NC_ENOTVAR)
#line 241
	    error("bad var id: status = %d", err);
#line 241

#line 241
	nels = 1;
#line 241
	for (j = 0; j < var_rank[i]; j++) {
#line 241
	    nels *= var_shape[i][j];
#line 241
	}
#line 241
	allInExtRange = allInIntRange = 1;
#line 241
	for (j = 0; j < nels; j++) {
#line 241
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 241
	    IF (err)
#line 241
		error("error in toMixedBase 1");
#line 241
	    expect[j] = hash4(var_type[i], var_rank[i], index, NCT_INT);
#line 241
	    if (inRange3(expect[j],var_type[i], NCT_INT)) {
#line 241
		allInIntRange = allInIntRange && expect[j] >= int_min
#line 241
			    && expect[j] <= int_max;
#line 241
	    } else {
#line 241
		allInExtRange = 0;
#line 241
	    }
#line 241
	}
#line 241
	err = nc_get_var_int(ncid, i, value);
#line 241
	if (canConvert) {
#line 241
	    if (allInExtRange) {
#line 241
		if (allInIntRange) {
#line 241
		    IF (err)
#line 241
			error("%s", nc_strerror(err));
#line 241
		} else {
#line 241
		    IF (err != NC_ERANGE)
#line 241
			error("Range error: status = %d", err);
#line 241
		}
#line 241
	    } else {
#line 241
		IF (err != 0 && err != NC_ERANGE)
#line 241
		    error("OK or Range error: status = %d", err);
#line 241
	    }
#line 241
	    for (j = 0; j < nels; j++) {
#line 241
		if (inRange3(expect[j],var_type[i],NCT_INT)
#line 241
			&& expect[j] >= int_min && expect[j] <= int_max) {
#line 241
		    IF (!equal(value[j],expect[j],var_type[i],NCT_INT)){
#line 241
			error("value read not that expected");
#line 241
			if (verbose) {
#line 241
			    error("\n");
#line 241
			    error("varid: %d, ", i);
#line 241
			    error("var_name: %s, ", var_name[i]);
#line 241
			    error("element number: %d ", j);
#line 241
			    error("expect: %g", expect[j]);
#line 241
			    error("got: %g", (double) value[j]);
#line 241
			}
#line 241
		    } else {
#line 241
			nok++;
#line 241
		    }
#line 241
		}
#line 241
	    }
#line 241
	} else {
#line 241
	    IF (nels > 0 && err != NC_ECHAR)
#line 241
		error("wrong type: status = %d", err);
#line 241
	}
#line 241
    }
#line 241
    err = nc_close(ncid);
#line 241
    IF (err)
#line 241
	error("nc_close: %s", nc_strerror(err));
#line 241
    print_nok(nok);
#line 241
}
#line 241

void
#line 242
test_nc_get_var_long(void)
#line 242
{
#line 242
    int ncid;
#line 242
    int i;
#line 242
    int j;
#line 242
    int err;
#line 242
    int allInExtRange;	/* all values within external range? */
#line 242
    int allInIntRange;	/* all values within internal range? */
#line 242
    int nels;
#line 242
    int nok = 0;      /* count of valid comparisons */
#line 242
    size_t index[MAX_RANK];
#line 242
    int canConvert;     /* Both text or both numeric */
#line 242
    long value[MAX_NELS];
#line 242
    double expect[MAX_NELS];
#line 242

#line 242
#ifdef TEST_PNETCDF
#line 242
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 242
#else
#line 242
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 242
#endif
#line 242
    IF (err)
#line 242
	error("nc_open: %s", nc_strerror(err));
#line 242
    for (i = 0; i < numVars; i++) {
#line 242
        canConvert = (var_type[i] == NC_CHAR) == (NCT_LONG == NCT_TEXT);
#line 242
        assert(var_rank[i] <= MAX_RANK);
#line 242
        assert(var_nels[i] <= MAX_NELS);
#line 242
        err = nc_get_var_long(BAD_ID, i, value);
#line 242
        IF (err != NC_EBADID)
#line 242
	    error("bad ncid: status = %d", err);
#line 242
        err = nc_get_var_long(ncid, BAD_VARID, value);
#line 242
        IF (err != NC_ENOTVAR)
#line 242
	    error("bad var id: status = %d", err);
#line 242

#line 242
	nels = 1;
#line 242
	for (j = 0; j < var_rank[i]; j++) {
#line 242
	    nels *= var_shape[i][j];
#line 242
	}
#line 242
	allInExtRange = allInIntRange = 1;
#line 242
	for (j = 0; j < nels; j++) {
#line 242
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 242
	    IF (err)
#line 242
		error("error in toMixedBase 1");
#line 242
	    expect[j] = hash4(var_type[i], var_rank[i], index, NCT_LONG);
#line 242
	    if (inRange3(expect[j],var_type[i], NCT_LONG)) {
#line 242
		allInIntRange = allInIntRange && expect[j] >= long_min
#line 242
			    && expect[j] <= long_max;
#line 242
	    } else {
#line 242
		allInExtRange = 0;
#line 242
	    }
#line 242
	}
#line 242
	err = nc_get_var_long(ncid, i, value);
#line 242
	if (canConvert) {
#line 242
	    if (allInExtRange) {
#line 242
		if (allInIntRange) {
#line 242
		    IF (err)
#line 242
			error("%s", nc_strerror(err));
#line 242
		} else {
#line 242
		    IF (err != NC_ERANGE)
#line 242
			error("Range error: status = %d", err);
#line 242
		}
#line 242
	    } else {
#line 242
		IF (err != 0 && err != NC_ERANGE)
#line 242
		    error("OK or Range error: status = %d", err);
#line 242
	    }
#line 242
	    for (j = 0; j < nels; j++) {
#line 242
		if (inRange3(expect[j],var_type[i],NCT_LONG)
#line 242
			&& expect[j] >= long_min && expect[j] <= long_max) {
#line 242
		    IF (!equal(value[j],expect[j],var_type[i],NCT_LONG)){
#line 242
			error("value read not that expected");
#line 242
			if (verbose) {
#line 242
			    error("\n");
#line 242
			    error("varid: %d, ", i);
#line 242
			    error("var_name: %s, ", var_name[i]);
#line 242
			    error("element number: %d ", j);
#line 242
			    error("expect: %g", expect[j]);
#line 242
			    error("got: %g", (double) value[j]);
#line 242
			}
#line 242
		    } else {
#line 242
			nok++;
#line 242
		    }
#line 242
		}
#line 242
	    }
#line 242
	} else {
#line 242
	    IF (nels > 0 && err != NC_ECHAR)
#line 242
		error("wrong type: status = %d", err);
#line 242
	}
#line 242
    }
#line 242
    err = nc_close(ncid);
#line 242
    IF (err)
#line 242
	error("nc_close: %s", nc_strerror(err));
#line 242
    print_nok(nok);
#line 242
}
#line 242

void
#line 243
test_nc_get_var_float(void)
#line 243
{
#line 243
    int ncid;
#line 243
    int i;
#line 243
    int j;
#line 243
    int err;
#line 243
    int allInExtRange;	/* all values within external range? */
#line 243
    int allInIntRange;	/* all values within internal range? */
#line 243
    int nels;
#line 243
    int nok = 0;      /* count of valid comparisons */
#line 243
    size_t index[MAX_RANK];
#line 243
    int canConvert;     /* Both text or both numeric */
#line 243
    float value[MAX_NELS];
#line 243
    double expect[MAX_NELS];
#line 243

#line 243
#ifdef TEST_PNETCDF
#line 243
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 243
#else
#line 243
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 243
#endif
#line 243
    IF (err)
#line 243
	error("nc_open: %s", nc_strerror(err));
#line 243
    for (i = 0; i < numVars; i++) {
#line 243
        canConvert = (var_type[i] == NC_CHAR) == (NCT_FLOAT == NCT_TEXT);
#line 243
        assert(var_rank[i] <= MAX_RANK);
#line 243
        assert(var_nels[i] <= MAX_NELS);
#line 243
        err = nc_get_var_float(BAD_ID, i, value);
#line 243
        IF (err != NC_EBADID)
#line 243
	    error("bad ncid: status = %d", err);
#line 243
        err = nc_get_var_float(ncid, BAD_VARID, value);
#line 243
        IF (err != NC_ENOTVAR)
#line 243
	    error("bad var id: status = %d", err);
#line 243

#line 243
	nels = 1;
#line 243
	for (j = 0; j < var_rank[i]; j++) {
#line 243
	    nels *= var_shape[i][j];
#line 243
	}
#line 243
	allInExtRange = allInIntRange = 1;
#line 243
	for (j = 0; j < nels; j++) {
#line 243
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 243
	    IF (err)
#line 243
		error("error in toMixedBase 1");
#line 243
	    expect[j] = hash4(var_type[i], var_rank[i], index, NCT_FLOAT);
#line 243
	    if (inRange3(expect[j],var_type[i], NCT_FLOAT)) {
#line 243
		allInIntRange = allInIntRange && expect[j] >= float_min
#line 243
			    && expect[j] <= float_max;
#line 243
	    } else {
#line 243
		allInExtRange = 0;
#line 243
	    }
#line 243
	}
#line 243
	err = nc_get_var_float(ncid, i, value);
#line 243
	if (canConvert) {
#line 243
	    if (allInExtRange) {
#line 243
		if (allInIntRange) {
#line 243
		    IF (err)
#line 243
			error("%s", nc_strerror(err));
#line 243
		} else {
#line 243
		    IF (err != NC_ERANGE)
#line 243
			error("Range error: status = %d", err);
#line 243
		}
#line 243
	    } else {
#line 243
		IF (err != 0 && err != NC_ERANGE)
#line 243
		    error("OK or Range error: status = %d", err);
#line 243
	    }
#line 243
	    for (j = 0; j < nels; j++) {
#line 243
		if (inRange3(expect[j],var_type[i],NCT_FLOAT)
#line 243
			&& expect[j] >= float_min && expect[j] <= float_max) {
#line 243
		    IF (!equal(value[j],expect[j],var_type[i],NCT_FLOAT)){
#line 243
			error("value read not that expected");
#line 243
			if (verbose) {
#line 243
			    error("\n");
#line 243
			    error("varid: %d, ", i);
#line 243
			    error("var_name: %s, ", var_name[i]);
#line 243
			    error("element number: %d ", j);
#line 243
			    error("expect: %g", expect[j]);
#line 243
			    error("got: %g", (double) value[j]);
#line 243
			}
#line 243
		    } else {
#line 243
			nok++;
#line 243
		    }
#line 243
		}
#line 243
	    }
#line 243
	} else {
#line 243
	    IF (nels > 0 && err != NC_ECHAR)
#line 243
		error("wrong type: status = %d", err);
#line 243
	}
#line 243
    }
#line 243
    err = nc_close(ncid);
#line 243
    IF (err)
#line 243
	error("nc_close: %s", nc_strerror(err));
#line 243
    print_nok(nok);
#line 243
}
#line 243

void
#line 244
test_nc_get_var_double(void)
#line 244
{
#line 244
    int ncid;
#line 244
    int i;
#line 244
    int j;
#line 244
    int err;
#line 244
    int allInExtRange;	/* all values within external range? */
#line 244
    int allInIntRange;	/* all values within internal range? */
#line 244
    int nels;
#line 244
    int nok = 0;      /* count of valid comparisons */
#line 244
    size_t index[MAX_RANK];
#line 244
    int canConvert;     /* Both text or both numeric */
#line 244
    double value[MAX_NELS];
#line 244
    double expect[MAX_NELS];
#line 244

#line 244
#ifdef TEST_PNETCDF
#line 244
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 244
#else
#line 244
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 244
#endif
#line 244
    IF (err)
#line 244
	error("nc_open: %s", nc_strerror(err));
#line 244
    for (i = 0; i < numVars; i++) {
#line 244
        canConvert = (var_type[i] == NC_CHAR) == (NCT_DOUBLE == NCT_TEXT);
#line 244
        assert(var_rank[i] <= MAX_RANK);
#line 244
        assert(var_nels[i] <= MAX_NELS);
#line 244
        err = nc_get_var_double(BAD_ID, i, value);
#line 244
        IF (err != NC_EBADID)
#line 244
	    error("bad ncid: status = %d", err);
#line 244
        err = nc_get_var_double(ncid, BAD_VARID, value);
#line 244
        IF (err != NC_ENOTVAR)
#line 244
	    error("bad var id: status = %d", err);
#line 244

#line 244
	nels = 1;
#line 244
	for (j = 0; j < var_rank[i]; j++) {
#line 244
	    nels *= var_shape[i][j];
#line 244
	}
#line 244
	allInExtRange = allInIntRange = 1;
#line 244
	for (j = 0; j < nels; j++) {
#line 244
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 244
	    IF (err)
#line 244
		error("error in toMixedBase 1");
#line 244
	    expect[j] = hash4(var_type[i], var_rank[i], index, NCT_DOUBLE);
#line 244
	    if (inRange3(expect[j],var_type[i], NCT_DOUBLE)) {
#line 244
		allInIntRange = allInIntRange && expect[j] >= double_min
#line 244
			    && expect[j] <= double_max;
#line 244
	    } else {
#line 244
		allInExtRange = 0;
#line 244
	    }
#line 244
	}
#line 244
	err = nc_get_var_double(ncid, i, value);
#line 244
	if (canConvert) {
#line 244
	    if (allInExtRange) {
#line 244
		if (allInIntRange) {
#line 244
		    IF (err)
#line 244
			error("%s", nc_strerror(err));
#line 244
		} else {
#line 244
		    IF (err != NC_ERANGE)
#line 244
			error("Range error: status = %d", err);
#line 244
		}
#line 244
	    } else {
#line 244
		IF (err != 0 && err != NC_ERANGE)
#line 244
		    error("OK or Range error: status = %d", err);
#line 244
	    }
#line 244
	    for (j = 0; j < nels; j++) {
#line 244
		if (inRange3(expect[j],var_type[i],NCT_DOUBLE)
#line 244
			&& expect[j] >= double_min && expect[j] <= double_max) {
#line 244
		    IF (!equal(value[j],expect[j],var_type[i],NCT_DOUBLE)){
#line 244
			error("value read not that expected");
#line 244
			if (verbose) {
#line 244
			    error("\n");
#line 244
			    error("varid: %d, ", i);
#line 244
			    error("var_name: %s, ", var_name[i]);
#line 244
			    error("element number: %d ", j);
#line 244
			    error("expect: %g", expect[j]);
#line 244
			    error("got: %g", (double) value[j]);
#line 244
			}
#line 244
		    } else {
#line 244
			nok++;
#line 244
		    }
#line 244
		}
#line 244
	    }
#line 244
	} else {
#line 244
	    IF (nels > 0 && err != NC_ECHAR)
#line 244
		error("wrong type: status = %d", err);
#line 244
	}
#line 244
    }
#line 244
    err = nc_close(ncid);
#line 244
    IF (err)
#line 244
	error("nc_close: %s", nc_strerror(err));
#line 244
    print_nok(nok);
#line 244
}
#line 244

void
#line 245
test_nc_get_var_ushort(void)
#line 245
{
#line 245
    int ncid;
#line 245
    int i;
#line 245
    int j;
#line 245
    int err;
#line 245
    int allInExtRange;	/* all values within external range? */
#line 245
    int allInIntRange;	/* all values within internal range? */
#line 245
    int nels;
#line 245
    int nok = 0;      /* count of valid comparisons */
#line 245
    size_t index[MAX_RANK];
#line 245
    int canConvert;     /* Both text or both numeric */
#line 245
    ushort value[MAX_NELS];
#line 245
    double expect[MAX_NELS];
#line 245

#line 245
#ifdef TEST_PNETCDF
#line 245
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 245
#else
#line 245
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 245
#endif
#line 245
    IF (err)
#line 245
	error("nc_open: %s", nc_strerror(err));
#line 245
    for (i = 0; i < numVars; i++) {
#line 245
        canConvert = (var_type[i] == NC_CHAR) == (NCT_USHORT == NCT_TEXT);
#line 245
        assert(var_rank[i] <= MAX_RANK);
#line 245
        assert(var_nels[i] <= MAX_NELS);
#line 245
        err = nc_get_var_ushort(BAD_ID, i, value);
#line 245
        IF (err != NC_EBADID)
#line 245
	    error("bad ncid: status = %d", err);
#line 245
        err = nc_get_var_ushort(ncid, BAD_VARID, value);
#line 245
        IF (err != NC_ENOTVAR)
#line 245
	    error("bad var id: status = %d", err);
#line 245

#line 245
	nels = 1;
#line 245
	for (j = 0; j < var_rank[i]; j++) {
#line 245
	    nels *= var_shape[i][j];
#line 245
	}
#line 245
	allInExtRange = allInIntRange = 1;
#line 245
	for (j = 0; j < nels; j++) {
#line 245
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 245
	    IF (err)
#line 245
		error("error in toMixedBase 1");
#line 245
	    expect[j] = hash4(var_type[i], var_rank[i], index, NCT_USHORT);
#line 245
	    if (inRange3(expect[j],var_type[i], NCT_USHORT)) {
#line 245
		allInIntRange = allInIntRange && expect[j] >= ushort_min
#line 245
			    && expect[j] <= ushort_max;
#line 245
	    } else {
#line 245
		allInExtRange = 0;
#line 245
	    }
#line 245
	}
#line 245
	err = nc_get_var_ushort(ncid, i, value);
#line 245
	if (canConvert) {
#line 245
	    if (allInExtRange) {
#line 245
		if (allInIntRange) {
#line 245
		    IF (err)
#line 245
			error("%s", nc_strerror(err));
#line 245
		} else {
#line 245
		    IF (err != NC_ERANGE)
#line 245
			error("Range error: status = %d", err);
#line 245
		}
#line 245
	    } else {
#line 245
		IF (err != 0 && err != NC_ERANGE)
#line 245
		    error("OK or Range error: status = %d", err);
#line 245
	    }
#line 245
	    for (j = 0; j < nels; j++) {
#line 245
		if (inRange3(expect[j],var_type[i],NCT_USHORT)
#line 245
			&& expect[j] >= ushort_min && expect[j] <= ushort_max) {
#line 245
		    IF (!equal(value[j],expect[j],var_type[i],NCT_USHORT)){
#line 245
			error("value read not that expected");
#line 245
			if (verbose) {
#line 245
			    error("\n");
#line 245
			    error("varid: %d, ", i);
#line 245
			    error("var_name: %s, ", var_name[i]);
#line 245
			    error("element number: %d ", j);
#line 245
			    error("expect: %g", expect[j]);
#line 245
			    error("got: %g", (double) value[j]);
#line 245
			}
#line 245
		    } else {
#line 245
			nok++;
#line 245
		    }
#line 245
		}
#line 245
	    }
#line 245
	} else {
#line 245
	    IF (nels > 0 && err != NC_ECHAR)
#line 245
		error("wrong type: status = %d", err);
#line 245
	}
#line 245
    }
#line 245
    err = nc_close(ncid);
#line 245
    IF (err)
#line 245
	error("nc_close: %s", nc_strerror(err));
#line 245
    print_nok(nok);
#line 245
}
#line 245

void
#line 246
test_nc_get_var_uint(void)
#line 246
{
#line 246
    int ncid;
#line 246
    int i;
#line 246
    int j;
#line 246
    int err;
#line 246
    int allInExtRange;	/* all values within external range? */
#line 246
    int allInIntRange;	/* all values within internal range? */
#line 246
    int nels;
#line 246
    int nok = 0;      /* count of valid comparisons */
#line 246
    size_t index[MAX_RANK];
#line 246
    int canConvert;     /* Both text or both numeric */
#line 246
    uint value[MAX_NELS];
#line 246
    double expect[MAX_NELS];
#line 246

#line 246
#ifdef TEST_PNETCDF
#line 246
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 246
#else
#line 246
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 246
#endif
#line 246
    IF (err)
#line 246
	error("nc_open: %s", nc_strerror(err));
#line 246
    for (i = 0; i < numVars; i++) {
#line 246
        canConvert = (var_type[i] == NC_CHAR) == (NCT_UINT == NCT_TEXT);
#line 246
        assert(var_rank[i] <= MAX_RANK);
#line 246
        assert(var_nels[i] <= MAX_NELS);
#line 246
        err = nc_get_var_uint(BAD_ID, i, value);
#line 246
        IF (err != NC_EBADID)
#line 246
	    error("bad ncid: status = %d", err);
#line 246
        err = nc_get_var_uint(ncid, BAD_VARID, value);
#line 246
        IF (err != NC_ENOTVAR)
#line 246
	    error("bad var id: status = %d", err);
#line 246

#line 246
	nels = 1;
#line 246
	for (j = 0; j < var_rank[i]; j++) {
#line 246
	    nels *= var_shape[i][j];
#line 246
	}
#line 246
	allInExtRange = allInIntRange = 1;
#line 246
	for (j = 0; j < nels; j++) {
#line 246
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 246
	    IF (err)
#line 246
		error("error in toMixedBase 1");
#line 246
	    expect[j] = hash4(var_type[i], var_rank[i], index, NCT_UINT);
#line 246
	    if (inRange3(expect[j],var_type[i], NCT_UINT)) {
#line 246
		allInIntRange = allInIntRange && expect[j] >= uint_min
#line 246
			    && expect[j] <= uint_max;
#line 246
	    } else {
#line 246
		allInExtRange = 0;
#line 246
	    }
#line 246
	}
#line 246
	err = nc_get_var_uint(ncid, i, value);
#line 246
	if (canConvert) {
#line 246
	    if (allInExtRange) {
#line 246
		if (allInIntRange) {
#line 246
		    IF (err)
#line 246
			error("%s", nc_strerror(err));
#line 246
		} else {
#line 246
		    IF (err != NC_ERANGE)
#line 246
			error("Range error: status = %d", err);
#line 246
		}
#line 246
	    } else {
#line 246
		IF (err != 0 && err != NC_ERANGE)
#line 246
		    error("OK or Range error: status = %d", err);
#line 246
	    }
#line 246
	    for (j = 0; j < nels; j++) {
#line 246
		if (inRange3(expect[j],var_type[i],NCT_UINT)
#line 246
			&& expect[j] >= uint_min && expect[j] <= uint_max) {
#line 246
		    IF (!equal(value[j],expect[j],var_type[i],NCT_UINT)){
#line 246
			error("value read not that expected");
#line 246
			if (verbose) {
#line 246
			    error("\n");
#line 246
			    error("varid: %d, ", i);
#line 246
			    error("var_name: %s, ", var_name[i]);
#line 246
			    error("element number: %d ", j);
#line 246
			    error("expect: %g", expect[j]);
#line 246
			    error("got: %g", (double) value[j]);
#line 246
			}
#line 246
		    } else {
#line 246
			nok++;
#line 246
		    }
#line 246
		}
#line 246
	    }
#line 246
	} else {
#line 246
	    IF (nels > 0 && err != NC_ECHAR)
#line 246
		error("wrong type: status = %d", err);
#line 246
	}
#line 246
    }
#line 246
    err = nc_close(ncid);
#line 246
    IF (err)
#line 246
	error("nc_close: %s", nc_strerror(err));
#line 246
    print_nok(nok);
#line 246
}
#line 246

void
#line 247
test_nc_get_var_longlong(void)
#line 247
{
#line 247
    int ncid;
#line 247
    int i;
#line 247
    int j;
#line 247
    int err;
#line 247
    int allInExtRange;	/* all values within external range? */
#line 247
    int allInIntRange;	/* all values within internal range? */
#line 247
    int nels;
#line 247
    int nok = 0;      /* count of valid comparisons */
#line 247
    size_t index[MAX_RANK];
#line 247
    int canConvert;     /* Both text or both numeric */
#line 247
    longlong value[MAX_NELS];
#line 247
    double expect[MAX_NELS];
#line 247

#line 247
#ifdef TEST_PNETCDF
#line 247
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 247
#else
#line 247
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 247
#endif
#line 247
    IF (err)
#line 247
	error("nc_open: %s", nc_strerror(err));
#line 247
    for (i = 0; i < numVars; i++) {
#line 247
        canConvert = (var_type[i] == NC_CHAR) == (NCT_LONGLONG == NCT_TEXT);
#line 247
        assert(var_rank[i] <= MAX_RANK);
#line 247
        assert(var_nels[i] <= MAX_NELS);
#line 247
        err = nc_get_var_longlong(BAD_ID, i, value);
#line 247
        IF (err != NC_EBADID)
#line 247
	    error("bad ncid: status = %d", err);
#line 247
        err = nc_get_var_longlong(ncid, BAD_VARID, value);
#line 247
        IF (err != NC_ENOTVAR)
#line 247
	    error("bad var id: status = %d", err);
#line 247

#line 247
	nels = 1;
#line 247
	for (j = 0; j < var_rank[i]; j++) {
#line 247
	    nels *= var_shape[i][j];
#line 247
	}
#line 247
	allInExtRange = allInIntRange = 1;
#line 247
	for (j = 0; j < nels; j++) {
#line 247
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 247
	    IF (err)
#line 247
		error("error in toMixedBase 1");
#line 247
	    expect[j] = hash4(var_type[i], var_rank[i], index, NCT_LONGLONG);
#line 247
	    if (inRange3(expect[j],var_type[i], NCT_LONGLONG)) {
#line 247
		allInIntRange = allInIntRange && expect[j] >= longlong_min
#line 247
			    && expect[j] <= longlong_max;
#line 247
	    } else {
#line 247
		allInExtRange = 0;
#line 247
	    }
#line 247
	}
#line 247
	err = nc_get_var_longlong(ncid, i, value);
#line 247
	if (canConvert) {
#line 247
	    if (allInExtRange) {
#line 247
		if (allInIntRange) {
#line 247
		    IF (err)
#line 247
			error("%s", nc_strerror(err));
#line 247
		} else {
#line 247
		    IF (err != NC_ERANGE)
#line 247
			error("Range error: status = %d", err);
#line 247
		}
#line 247
	    } else {
#line 247
		IF (err != 0 && err != NC_ERANGE)
#line 247
		    error("OK or Range error: status = %d", err);
#line 247
	    }
#line 247
	    for (j = 0; j < nels; j++) {
#line 247
		if (inRange3(expect[j],var_type[i],NCT_LONGLONG)
#line 247
			&& expect[j] >= longlong_min && expect[j] <= longlong_max) {
#line 247
		    IF (!equal(value[j],expect[j],var_type[i],NCT_LONGLONG)){
#line 247
			error("value read not that expected");
#line 247
			if (verbose) {
#line 247
			    error("\n");
#line 247
			    error("varid: %d, ", i);
#line 247
			    error("var_name: %s, ", var_name[i]);
#line 247
			    error("element number: %d ", j);
#line 247
			    error("expect: %g", expect[j]);
#line 247
			    error("got: %g", (double) value[j]);
#line 247
			}
#line 247
		    } else {
#line 247
			nok++;
#line 247
		    }
#line 247
		}
#line 247
	    }
#line 247
	} else {
#line 247
	    IF (nels > 0 && err != NC_ECHAR)
#line 247
		error("wrong type: status = %d", err);
#line 247
	}
#line 247
    }
#line 247
    err = nc_close(ncid);
#line 247
    IF (err)
#line 247
	error("nc_close: %s", nc_strerror(err));
#line 247
    print_nok(nok);
#line 247
}
#line 247

void
#line 248
test_nc_get_var_ulonglong(void)
#line 248
{
#line 248
    int ncid;
#line 248
    int i;
#line 248
    int j;
#line 248
    int err;
#line 248
    int allInExtRange;	/* all values within external range? */
#line 248
    int allInIntRange;	/* all values within internal range? */
#line 248
    int nels;
#line 248
    int nok = 0;      /* count of valid comparisons */
#line 248
    size_t index[MAX_RANK];
#line 248
    int canConvert;     /* Both text or both numeric */
#line 248
    ulonglong value[MAX_NELS];
#line 248
    double expect[MAX_NELS];
#line 248

#line 248
#ifdef TEST_PNETCDF
#line 248
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 248
#else
#line 248
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 248
#endif
#line 248
    IF (err)
#line 248
	error("nc_open: %s", nc_strerror(err));
#line 248
    for (i = 0; i < numVars; i++) {
#line 248
        canConvert = (var_type[i] == NC_CHAR) == (NCT_ULONGLONG == NCT_TEXT);
#line 248
        assert(var_rank[i] <= MAX_RANK);
#line 248
        assert(var_nels[i] <= MAX_NELS);
#line 248
        err = nc_get_var_ulonglong(BAD_ID, i, value);
#line 248
        IF (err != NC_EBADID)
#line 248
	    error("bad ncid: status = %d", err);
#line 248
        err = nc_get_var_ulonglong(ncid, BAD_VARID, value);
#line 248
        IF (err != NC_ENOTVAR)
#line 248
	    error("bad var id: status = %d", err);
#line 248

#line 248
	nels = 1;
#line 248
	for (j = 0; j < var_rank[i]; j++) {
#line 248
	    nels *= var_shape[i][j];
#line 248
	}
#line 248
	allInExtRange = allInIntRange = 1;
#line 248
	for (j = 0; j < nels; j++) {
#line 248
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 248
	    IF (err)
#line 248
		error("error in toMixedBase 1");
#line 248
	    expect[j] = hash4(var_type[i], var_rank[i], index, NCT_ULONGLONG);
#line 248
	    if (inRange3(expect[j],var_type[i], NCT_ULONGLONG)) {
#line 248
		allInIntRange = allInIntRange && expect[j] >= ulonglong_min
#line 248
			    && expect[j] <= ulonglong_max;
#line 248
	    } else {
#line 248
		allInExtRange = 0;
#line 248
	    }
#line 248
	}
#line 248
	err = nc_get_var_ulonglong(ncid, i, value);
#line 248
	if (canConvert) {
#line 248
	    if (allInExtRange) {
#line 248
		if (allInIntRange) {
#line 248
		    IF (err)
#line 248
			error("%s", nc_strerror(err));
#line 248
		} else {
#line 248
		    IF (err != NC_ERANGE)
#line 248
			error("Range error: status = %d", err);
#line 248
		}
#line 248
	    } else {
#line 248
		IF (err != 0 && err != NC_ERANGE)
#line 248
		    error("OK or Range error: status = %d", err);
#line 248
	    }
#line 248
	    for (j = 0; j < nels; j++) {
#line 248
		if (inRange3(expect[j],var_type[i],NCT_ULONGLONG)
#line 248
			&& expect[j] >= ulonglong_min && expect[j] <= ulonglong_max) {
#line 248
		    IF (!equal(value[j],expect[j],var_type[i],NCT_ULONGLONG)){
#line 248
			error("value read not that expected");
#line 248
			if (verbose) {
#line 248
			    error("\n");
#line 248
			    error("varid: %d, ", i);
#line 248
			    error("var_name: %s, ", var_name[i]);
#line 248
			    error("element number: %d ", j);
#line 248
			    error("expect: %g", expect[j]);
#line 248
			    error("got: %g", (double) value[j]);
#line 248
			}
#line 248
		    } else {
#line 248
			nok++;
#line 248
		    }
#line 248
		}
#line 248
	    }
#line 248
	} else {
#line 248
	    IF (nels > 0 && err != NC_ECHAR)
#line 248
		error("wrong type: status = %d", err);
#line 248
	}
#line 248
    }
#line 248
    err = nc_close(ncid);
#line 248
    IF (err)
#line 248
	error("nc_close: %s", nc_strerror(err));
#line 248
    print_nok(nok);
#line 248
}
#line 248



#line 424

void
#line 425
test_nc_get_vara_text(void)
#line 425
{
#line 425
    int ncid;
#line 425
    int d;
#line 425
    int i;
#line 425
    int j;
#line 425
    int k;
#line 425
    int err;
#line 425
    int allInExtRange;	/* all values within external range? */
#line 425
    int allInIntRange;	/* all values within internal range? */
#line 425
    int nels;
#line 425
    int nslabs;
#line 425
    int nok = 0;      /* count of valid comparisons */
#line 425
    size_t start[MAX_RANK];
#line 425
    size_t edge[MAX_RANK];
#line 425
    size_t index[MAX_RANK];
#line 425
    size_t mid[MAX_RANK];
#line 425
    int canConvert;     /* Both text or both numeric */
#line 425
    text value[MAX_NELS];
#line 425
    double expect[MAX_NELS];
#line 425

#line 425
#ifdef TEST_PNETCDF
#line 425
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 425
#else
#line 425
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 425
#endif
#line 425
    IF (err)
#line 425
	error("nc_open: %s", nc_strerror(err));
#line 425
    for (i = 0; i < numVars; i++) {
#line 425
        canConvert = (var_type[i] == NC_CHAR) == (NCT_TEXT == NCT_TEXT);
#line 425
        assert(var_rank[i] <= MAX_RANK);
#line 425
        assert(var_nels[i] <= MAX_NELS);
#line 425
	for (j = 0; j < var_rank[i]; j++) {
#line 425
	    start[j] = 0;
#line 425
	    edge[j] = 1;
#line 425
	}
#line 425
        err = nc_get_vara_text(BAD_ID, i, start, edge, value);
#line 425
        IF (err != NC_EBADID)
#line 425
	    error("bad ncid: status = %d", err);
#line 425
        err = nc_get_vara_text(ncid, BAD_VARID, start, edge, value);
#line 425
        IF (err != NC_ENOTVAR)
#line 425
	    error("bad var id: status = %d", err);
#line 425
	for (j = 0; j < var_rank[i]; j++) {
#line 425
	    start[j] = var_shape[i][j];
#line 425
	    err = nc_get_vara_text(ncid, i, start, edge, value);
#line 425
            IF (canConvert && err != NC_EINVALCOORDS)
#line 425
                error("bad index: status = %d", err);
#line 425
	    start[j] = 0;
#line 425
	    edge[j] = var_shape[i][j] + 1;
#line 425
	    err = nc_get_vara_text(ncid, i, start, edge, value);
#line 425
            IF (canConvert && err != NC_EEDGE)
#line 425
		error("bad edge: status = %d", err);
#line 425
	    edge[j] = 1;
#line 425
	}
#line 425
            /* Check non-scalars for correct error returned even when */
#line 425
            /* there is nothing to get (edge[j]==0) */
#line 425
	if(var_rank[i] > 0) {
#line 425
	    for (j = 0; j < var_rank[i]; j++) {
#line 425
		edge[j] = 0;
#line 425
	    }
#line 425
	    err = nc_get_vara_text(BAD_ID, i, start, edge, value);
#line 425
	    IF (err != NC_EBADID) 
#line 425
		error("bad ncid: status = %d", err);
#line 425
	    err = nc_get_vara_text(ncid, BAD_VARID, start, edge, value);
#line 425
	    IF (err != NC_ENOTVAR) 
#line 425
		error("bad var id: status = %d", err);
#line 425
	    for (j = 0; j < var_rank[i]; j++) {
#line 425
		if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 425
		    start[j] = var_shape[i][j];
#line 425
		    err = nc_get_vara_text(ncid, i, start, edge, value);
#line 425
		    IF (canConvert && err != NC_EINVALCOORDS)
#line 425
			error("bad start: status = %d", err);
#line 425
		    start[j] = 0;
#line 425
		}
#line 425
	    }
#line 425
	    err = nc_get_vara_text(ncid, i, start, edge, value);
#line 425
	    if (canConvert) {
#line 425
		IF (err) 
#line 425
		    error("%s", nc_strerror(err));
#line 425
	    } else {
#line 425
		IF (err != NC_ECHAR)
#line 425
		    error("wrong type: status = %d", err);
#line 425
	    }
#line 425
	    for (j = 0; j < var_rank[i]; j++) {
#line 425
		edge[j] = 1;
#line 425
	    }
#line 425
	}            /* Choose a random point dividing each dim into 2 parts */
#line 425
            /* get 2^rank (nslabs) slabs so defined */
#line 425
        nslabs = 1;
#line 425
        for (j = 0; j < var_rank[i]; j++) {
#line 425
            mid[j] = roll( var_shape[i][j] );
#line 425
            nslabs *= 2;
#line 425
        }
#line 425
            /* bits of k determine whether to get lower or upper part of dim */
#line 425
        for (k = 0; k < nslabs; k++) {
#line 425
            nels = 1;
#line 425
            for (j = 0; j < var_rank[i]; j++) {
#line 425
                if ((k >> j) & 1) {
#line 425
                    start[j] = 0;
#line 425
                    edge[j] = mid[j];
#line 425
                }else{
#line 425
                    start[j] = mid[j];
#line 425
                    edge[j] = var_shape[i][j] - mid[j];
#line 425
                }
#line 425
                nels *= edge[j];
#line 425
            }
#line 425
	    allInExtRange = allInIntRange = 1;
#line 425
            for (j = 0; j < nels; j++) {
#line 425
                err = toMixedBase(j, var_rank[i], edge, index);
#line 425
                IF (err)
#line 425
                    error("error in toMixedBase 1");
#line 425
                for (d = 0; d < var_rank[i]; d++)
#line 425
                    index[d] += start[d];
#line 425
                expect[j] = hash4(var_type[i], var_rank[i], index, NCT_TEXT);
#line 425
		if (inRange3(expect[j],var_type[i], NCT_TEXT)) {
#line 425
		    allInIntRange = allInIntRange && expect[j] >= text_min
#line 425
				&& expect[j] <= text_max;
#line 425
		} else {
#line 425
		    allInExtRange = 0;
#line 425
		}
#line 425
	    }
#line 425
            if (var_rank[i] == 0 && i%2)
#line 425
		err = nc_get_vara_text(ncid, i, NULL, NULL, value);
#line 425
	    else
#line 425
		err = nc_get_vara_text(ncid, i, start, edge, value);
#line 425
            if (canConvert) {
#line 425
		if (allInExtRange) {
#line 425
		    if (allInIntRange) {
#line 425
			IF (err)
#line 425
			    error("%s", nc_strerror(err));
#line 425
		    } else {
#line 425
			IF (err != NC_ERANGE)
#line 425
			    error("Range error: status = %d", err);
#line 425
		    }
#line 425
		} else {
#line 425
		    IF (err != 0 && err != NC_ERANGE)
#line 425
			error("OK or Range error: status = %d", err);
#line 425
		}
#line 425
		for (j = 0; j < nels; j++) {
#line 425
		    if (inRange3(expect[j],var_type[i],NCT_TEXT)
#line 425
			    && expect[j] >= text_min && expect[j] <= text_max) {
#line 425
			IF (!equal(value[j],expect[j],var_type[i],NCT_TEXT)){
#line 425
			    error("value read not that expected");
#line 425
			    if (verbose) {
#line 425
				error("\n");
#line 425
				error("varid: %d, ", i);
#line 425
				error("var_name: %s, ", var_name[i]);
#line 425
				error("element number: %d ", j);
#line 425
				error("expect: %g", expect[j]);
#line 425
				error("got: %g", (double) value[j]);
#line 425
			    }
#line 425
			} else {
#line 425
			    nok++;
#line 425
			}
#line 425
		    }
#line 425
		}
#line 425
            } else {
#line 425
                IF (nels > 0 && err != NC_ECHAR)
#line 425
                    error("wrong type: status = %d", err);
#line 425
            }
#line 425
        }
#line 425
    }
#line 425
    err = nc_close(ncid);
#line 425
    IF (err)
#line 425
	error("nc_close: %s", nc_strerror(err));
#line 425
    print_nok(nok);
#line 425
}
#line 425

void
#line 426
test_nc_get_vara_uchar(void)
#line 426
{
#line 426
    int ncid;
#line 426
    int d;
#line 426
    int i;
#line 426
    int j;
#line 426
    int k;
#line 426
    int err;
#line 426
    int allInExtRange;	/* all values within external range? */
#line 426
    int allInIntRange;	/* all values within internal range? */
#line 426
    int nels;
#line 426
    int nslabs;
#line 426
    int nok = 0;      /* count of valid comparisons */
#line 426
    size_t start[MAX_RANK];
#line 426
    size_t edge[MAX_RANK];
#line 426
    size_t index[MAX_RANK];
#line 426
    size_t mid[MAX_RANK];
#line 426
    int canConvert;     /* Both text or both numeric */
#line 426
    uchar value[MAX_NELS];
#line 426
    double expect[MAX_NELS];
#line 426

#line 426
#ifdef TEST_PNETCDF
#line 426
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 426
#else
#line 426
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 426
#endif
#line 426
    IF (err)
#line 426
	error("nc_open: %s", nc_strerror(err));
#line 426
    for (i = 0; i < numVars; i++) {
#line 426
        canConvert = (var_type[i] == NC_CHAR) == (NCT_UCHAR == NCT_TEXT);
#line 426
        assert(var_rank[i] <= MAX_RANK);
#line 426
        assert(var_nels[i] <= MAX_NELS);
#line 426
	for (j = 0; j < var_rank[i]; j++) {
#line 426
	    start[j] = 0;
#line 426
	    edge[j] = 1;
#line 426
	}
#line 426
        err = nc_get_vara_uchar(BAD_ID, i, start, edge, value);
#line 426
        IF (err != NC_EBADID)
#line 426
	    error("bad ncid: status = %d", err);
#line 426
        err = nc_get_vara_uchar(ncid, BAD_VARID, start, edge, value);
#line 426
        IF (err != NC_ENOTVAR)
#line 426
	    error("bad var id: status = %d", err);
#line 426
	for (j = 0; j < var_rank[i]; j++) {
#line 426
	    start[j] = var_shape[i][j];
#line 426
	    err = nc_get_vara_uchar(ncid, i, start, edge, value);
#line 426
            IF (canConvert && err != NC_EINVALCOORDS)
#line 426
                error("bad index: status = %d", err);
#line 426
	    start[j] = 0;
#line 426
	    edge[j] = var_shape[i][j] + 1;
#line 426
	    err = nc_get_vara_uchar(ncid, i, start, edge, value);
#line 426
            IF (canConvert && err != NC_EEDGE)
#line 426
		error("bad edge: status = %d", err);
#line 426
	    edge[j] = 1;
#line 426
	}
#line 426
            /* Check non-scalars for correct error returned even when */
#line 426
            /* there is nothing to get (edge[j]==0) */
#line 426
	if(var_rank[i] > 0) {
#line 426
	    for (j = 0; j < var_rank[i]; j++) {
#line 426
		edge[j] = 0;
#line 426
	    }
#line 426
	    err = nc_get_vara_uchar(BAD_ID, i, start, edge, value);
#line 426
	    IF (err != NC_EBADID) 
#line 426
		error("bad ncid: status = %d", err);
#line 426
	    err = nc_get_vara_uchar(ncid, BAD_VARID, start, edge, value);
#line 426
	    IF (err != NC_ENOTVAR) 
#line 426
		error("bad var id: status = %d", err);
#line 426
	    for (j = 0; j < var_rank[i]; j++) {
#line 426
		if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 426
		    start[j] = var_shape[i][j];
#line 426
		    err = nc_get_vara_uchar(ncid, i, start, edge, value);
#line 426
		    IF (canConvert && err != NC_EINVALCOORDS)
#line 426
			error("bad start: status = %d", err);
#line 426
		    start[j] = 0;
#line 426
		}
#line 426
	    }
#line 426
	    err = nc_get_vara_uchar(ncid, i, start, edge, value);
#line 426
	    if (canConvert) {
#line 426
		IF (err) 
#line 426
		    error("%s", nc_strerror(err));
#line 426
	    } else {
#line 426
		IF (err != NC_ECHAR)
#line 426
		    error("wrong type: status = %d", err);
#line 426
	    }
#line 426
	    for (j = 0; j < var_rank[i]; j++) {
#line 426
		edge[j] = 1;
#line 426
	    }
#line 426
	}            /* Choose a random point dividing each dim into 2 parts */
#line 426
            /* get 2^rank (nslabs) slabs so defined */
#line 426
        nslabs = 1;
#line 426
        for (j = 0; j < var_rank[i]; j++) {
#line 426
            mid[j] = roll( var_shape[i][j] );
#line 426
            nslabs *= 2;
#line 426
        }
#line 426
            /* bits of k determine whether to get lower or upper part of dim */
#line 426
        for (k = 0; k < nslabs; k++) {
#line 426
            nels = 1;
#line 426
            for (j = 0; j < var_rank[i]; j++) {
#line 426
                if ((k >> j) & 1) {
#line 426
                    start[j] = 0;
#line 426
                    edge[j] = mid[j];
#line 426
                }else{
#line 426
                    start[j] = mid[j];
#line 426
                    edge[j] = var_shape[i][j] - mid[j];
#line 426
                }
#line 426
                nels *= edge[j];
#line 426
            }
#line 426
	    allInExtRange = allInIntRange = 1;
#line 426
            for (j = 0; j < nels; j++) {
#line 426
                err = toMixedBase(j, var_rank[i], edge, index);
#line 426
                IF (err)
#line 426
                    error("error in toMixedBase 1");
#line 426
                for (d = 0; d < var_rank[i]; d++)
#line 426
                    index[d] += start[d];
#line 426
                expect[j] = hash4(var_type[i], var_rank[i], index, NCT_UCHAR);
#line 426
		if (inRange3(expect[j],var_type[i], NCT_UCHAR)) {
#line 426
		    allInIntRange = allInIntRange && expect[j] >= uchar_min
#line 426
				&& expect[j] <= uchar_max;
#line 426
		} else {
#line 426
		    allInExtRange = 0;
#line 426
		}
#line 426
	    }
#line 426
            if (var_rank[i] == 0 && i%2)
#line 426
		err = nc_get_vara_uchar(ncid, i, NULL, NULL, value);
#line 426
	    else
#line 426
		err = nc_get_vara_uchar(ncid, i, start, edge, value);
#line 426
            if (canConvert) {
#line 426
		if (allInExtRange) {
#line 426
		    if (allInIntRange) {
#line 426
			IF (err)
#line 426
			    error("%s", nc_strerror(err));
#line 426
		    } else {
#line 426
			IF (err != NC_ERANGE)
#line 426
			    error("Range error: status = %d", err);
#line 426
		    }
#line 426
		} else {
#line 426
		    IF (err != 0 && err != NC_ERANGE)
#line 426
			error("OK or Range error: status = %d", err);
#line 426
		}
#line 426
		for (j = 0; j < nels; j++) {
#line 426
		    if (inRange3(expect[j],var_type[i],NCT_UCHAR)
#line 426
			    && expect[j] >= uchar_min && expect[j] <= uchar_max) {
#line 426
			IF (!equal(value[j],expect[j],var_type[i],NCT_UCHAR)){
#line 426
			    error("value read not that expected");
#line 426
			    if (verbose) {
#line 426
				error("\n");
#line 426
				error("varid: %d, ", i);
#line 426
				error("var_name: %s, ", var_name[i]);
#line 426
				error("element number: %d ", j);
#line 426
				error("expect: %g", expect[j]);
#line 426
				error("got: %g", (double) value[j]);
#line 426
			    }
#line 426
			} else {
#line 426
			    nok++;
#line 426
			}
#line 426
		    }
#line 426
		}
#line 426
            } else {
#line 426
                IF (nels > 0 && err != NC_ECHAR)
#line 426
                    error("wrong type: status = %d", err);
#line 426
            }
#line 426
        }
#line 426
    }
#line 426
    err = nc_close(ncid);
#line 426
    IF (err)
#line 426
	error("nc_close: %s", nc_strerror(err));
#line 426
    print_nok(nok);
#line 426
}
#line 426

void
#line 427
test_nc_get_vara_schar(void)
#line 427
{
#line 427
    int ncid;
#line 427
    int d;
#line 427
    int i;
#line 427
    int j;
#line 427
    int k;
#line 427
    int err;
#line 427
    int allInExtRange;	/* all values within external range? */
#line 427
    int allInIntRange;	/* all values within internal range? */
#line 427
    int nels;
#line 427
    int nslabs;
#line 427
    int nok = 0;      /* count of valid comparisons */
#line 427
    size_t start[MAX_RANK];
#line 427
    size_t edge[MAX_RANK];
#line 427
    size_t index[MAX_RANK];
#line 427
    size_t mid[MAX_RANK];
#line 427
    int canConvert;     /* Both text or both numeric */
#line 427
    schar value[MAX_NELS];
#line 427
    double expect[MAX_NELS];
#line 427

#line 427
#ifdef TEST_PNETCDF
#line 427
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 427
#else
#line 427
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 427
#endif
#line 427
    IF (err)
#line 427
	error("nc_open: %s", nc_strerror(err));
#line 427
    for (i = 0; i < numVars; i++) {
#line 427
        canConvert = (var_type[i] == NC_CHAR) == (NCT_SCHAR == NCT_TEXT);
#line 427
        assert(var_rank[i] <= MAX_RANK);
#line 427
        assert(var_nels[i] <= MAX_NELS);
#line 427
	for (j = 0; j < var_rank[i]; j++) {
#line 427
	    start[j] = 0;
#line 427
	    edge[j] = 1;
#line 427
	}
#line 427
        err = nc_get_vara_schar(BAD_ID, i, start, edge, value);
#line 427
        IF (err != NC_EBADID)
#line 427
	    error("bad ncid: status = %d", err);
#line 427
        err = nc_get_vara_schar(ncid, BAD_VARID, start, edge, value);
#line 427
        IF (err != NC_ENOTVAR)
#line 427
	    error("bad var id: status = %d", err);
#line 427
	for (j = 0; j < var_rank[i]; j++) {
#line 427
	    start[j] = var_shape[i][j];
#line 427
	    err = nc_get_vara_schar(ncid, i, start, edge, value);
#line 427
            IF (canConvert && err != NC_EINVALCOORDS)
#line 427
                error("bad index: status = %d", err);
#line 427
	    start[j] = 0;
#line 427
	    edge[j] = var_shape[i][j] + 1;
#line 427
	    err = nc_get_vara_schar(ncid, i, start, edge, value);
#line 427
            IF (canConvert && err != NC_EEDGE)
#line 427
		error("bad edge: status = %d", err);
#line 427
	    edge[j] = 1;
#line 427
	}
#line 427
            /* Check non-scalars for correct error returned even when */
#line 427
            /* there is nothing to get (edge[j]==0) */
#line 427
	if(var_rank[i] > 0) {
#line 427
	    for (j = 0; j < var_rank[i]; j++) {
#line 427
		edge[j] = 0;
#line 427
	    }
#line 427
	    err = nc_get_vara_schar(BAD_ID, i, start, edge, value);
#line 427
	    IF (err != NC_EBADID) 
#line 427
		error("bad ncid: status = %d", err);
#line 427
	    err = nc_get_vara_schar(ncid, BAD_VARID, start, edge, value);
#line 427
	    IF (err != NC_ENOTVAR) 
#line 427
		error("bad var id: status = %d", err);
#line 427
	    for (j = 0; j < var_rank[i]; j++) {
#line 427
		if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 427
		    start[j] = var_shape[i][j];
#line 427
		    err = nc_get_vara_schar(ncid, i, start, edge, value);
#line 427
		    IF (canConvert && err != NC_EINVALCOORDS)
#line 427
			error("bad start: status = %d", err);
#line 427
		    start[j] = 0;
#line 427
		}
#line 427
	    }
#line 427
	    err = nc_get_vara_schar(ncid, i, start, edge, value);
#line 427
	    if (canConvert) {
#line 427
		IF (err) 
#line 427
		    error("%s", nc_strerror(err));
#line 427
	    } else {
#line 427
		IF (err != NC_ECHAR)
#line 427
		    error("wrong type: status = %d", err);
#line 427
	    }
#line 427
	    for (j = 0; j < var_rank[i]; j++) {
#line 427
		edge[j] = 1;
#line 427
	    }
#line 427
	}            /* Choose a random point dividing each dim into 2 parts */
#line 427
            /* get 2^rank (nslabs) slabs so defined */
#line 427
        nslabs = 1;
#line 427
        for (j = 0; j < var_rank[i]; j++) {
#line 427
            mid[j] = roll( var_shape[i][j] );
#line 427
            nslabs *= 2;
#line 427
        }
#line 427
            /* bits of k determine whether to get lower or upper part of dim */
#line 427
        for (k = 0; k < nslabs; k++) {
#line 427
            nels = 1;
#line 427
            for (j = 0; j < var_rank[i]; j++) {
#line 427
                if ((k >> j) & 1) {
#line 427
                    start[j] = 0;
#line 427
                    edge[j] = mid[j];
#line 427
                }else{
#line 427
                    start[j] = mid[j];
#line 427
                    edge[j] = var_shape[i][j] - mid[j];
#line 427
                }
#line 427
                nels *= edge[j];
#line 427
            }
#line 427
	    allInExtRange = allInIntRange = 1;
#line 427
            for (j = 0; j < nels; j++) {
#line 427
                err = toMixedBase(j, var_rank[i], edge, index);
#line 427
                IF (err)
#line 427
                    error("error in toMixedBase 1");
#line 427
                for (d = 0; d < var_rank[i]; d++)
#line 427
                    index[d] += start[d];
#line 427
                expect[j] = hash4(var_type[i], var_rank[i], index, NCT_SCHAR);
#line 427
		if (inRange3(expect[j],var_type[i], NCT_SCHAR)) {
#line 427
		    allInIntRange = allInIntRange && expect[j] >= schar_min
#line 427
				&& expect[j] <= schar_max;
#line 427
		} else {
#line 427
		    allInExtRange = 0;
#line 427
		}
#line 427
	    }
#line 427
            if (var_rank[i] == 0 && i%2)
#line 427
		err = nc_get_vara_schar(ncid, i, NULL, NULL, value);
#line 427
	    else
#line 427
		err = nc_get_vara_schar(ncid, i, start, edge, value);
#line 427
            if (canConvert) {
#line 427
		if (allInExtRange) {
#line 427
		    if (allInIntRange) {
#line 427
			IF (err)
#line 427
			    error("%s", nc_strerror(err));
#line 427
		    } else {
#line 427
			IF (err != NC_ERANGE)
#line 427
			    error("Range error: status = %d", err);
#line 427
		    }
#line 427
		} else {
#line 427
		    IF (err != 0 && err != NC_ERANGE)
#line 427
			error("OK or Range error: status = %d", err);
#line 427
		}
#line 427
		for (j = 0; j < nels; j++) {
#line 427
		    if (inRange3(expect[j],var_type[i],NCT_SCHAR)
#line 427
			    && expect[j] >= schar_min && expect[j] <= schar_max) {
#line 427
			IF (!equal(value[j],expect[j],var_type[i],NCT_SCHAR)){
#line 427
			    error("value read not that expected");
#line 427
			    if (verbose) {
#line 427
				error("\n");
#line 427
				error("varid: %d, ", i);
#line 427
				error("var_name: %s, ", var_name[i]);
#line 427
				error("element number: %d ", j);
#line 427
				error("expect: %g", expect[j]);
#line 427
				error("got: %g", (double) value[j]);
#line 427
			    }
#line 427
			} else {
#line 427
			    nok++;
#line 427
			}
#line 427
		    }
#line 427
		}
#line 427
            } else {
#line 427
                IF (nels > 0 && err != NC_ECHAR)
#line 427
                    error("wrong type: status = %d", err);
#line 427
            }
#line 427
        }
#line 427
    }
#line 427
    err = nc_close(ncid);
#line 427
    IF (err)
#line 427
	error("nc_close: %s", nc_strerror(err));
#line 427
    print_nok(nok);
#line 427
}
#line 427

void
#line 428
test_nc_get_vara_short(void)
#line 428
{
#line 428
    int ncid;
#line 428
    int d;
#line 428
    int i;
#line 428
    int j;
#line 428
    int k;
#line 428
    int err;
#line 428
    int allInExtRange;	/* all values within external range? */
#line 428
    int allInIntRange;	/* all values within internal range? */
#line 428
    int nels;
#line 428
    int nslabs;
#line 428
    int nok = 0;      /* count of valid comparisons */
#line 428
    size_t start[MAX_RANK];
#line 428
    size_t edge[MAX_RANK];
#line 428
    size_t index[MAX_RANK];
#line 428
    size_t mid[MAX_RANK];
#line 428
    int canConvert;     /* Both text or both numeric */
#line 428
    short value[MAX_NELS];
#line 428
    double expect[MAX_NELS];
#line 428

#line 428
#ifdef TEST_PNETCDF
#line 428
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 428
#else
#line 428
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 428
#endif
#line 428
    IF (err)
#line 428
	error("nc_open: %s", nc_strerror(err));
#line 428
    for (i = 0; i < numVars; i++) {
#line 428
        canConvert = (var_type[i] == NC_CHAR) == (NCT_SHORT == NCT_TEXT);
#line 428
        assert(var_rank[i] <= MAX_RANK);
#line 428
        assert(var_nels[i] <= MAX_NELS);
#line 428
	for (j = 0; j < var_rank[i]; j++) {
#line 428
	    start[j] = 0;
#line 428
	    edge[j] = 1;
#line 428
	}
#line 428
        err = nc_get_vara_short(BAD_ID, i, start, edge, value);
#line 428
        IF (err != NC_EBADID)
#line 428
	    error("bad ncid: status = %d", err);
#line 428
        err = nc_get_vara_short(ncid, BAD_VARID, start, edge, value);
#line 428
        IF (err != NC_ENOTVAR)
#line 428
	    error("bad var id: status = %d", err);
#line 428
	for (j = 0; j < var_rank[i]; j++) {
#line 428
	    start[j] = var_shape[i][j];
#line 428
	    err = nc_get_vara_short(ncid, i, start, edge, value);
#line 428
            IF (canConvert && err != NC_EINVALCOORDS)
#line 428
                error("bad index: status = %d", err);
#line 428
	    start[j] = 0;
#line 428
	    edge[j] = var_shape[i][j] + 1;
#line 428
	    err = nc_get_vara_short(ncid, i, start, edge, value);
#line 428
            IF (canConvert && err != NC_EEDGE)
#line 428
		error("bad edge: status = %d", err);
#line 428
	    edge[j] = 1;
#line 428
	}
#line 428
            /* Check non-scalars for correct error returned even when */
#line 428
            /* there is nothing to get (edge[j]==0) */
#line 428
	if(var_rank[i] > 0) {
#line 428
	    for (j = 0; j < var_rank[i]; j++) {
#line 428
		edge[j] = 0;
#line 428
	    }
#line 428
	    err = nc_get_vara_short(BAD_ID, i, start, edge, value);
#line 428
	    IF (err != NC_EBADID) 
#line 428
		error("bad ncid: status = %d", err);
#line 428
	    err = nc_get_vara_short(ncid, BAD_VARID, start, edge, value);
#line 428
	    IF (err != NC_ENOTVAR) 
#line 428
		error("bad var id: status = %d", err);
#line 428
	    for (j = 0; j < var_rank[i]; j++) {
#line 428
		if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 428
		    start[j] = var_shape[i][j];
#line 428
		    err = nc_get_vara_short(ncid, i, start, edge, value);
#line 428
		    IF (canConvert && err != NC_EINVALCOORDS)
#line 428
			error("bad start: status = %d", err);
#line 428
		    start[j] = 0;
#line 428
		}
#line 428
	    }
#line 428
	    err = nc_get_vara_short(ncid, i, start, edge, value);
#line 428
	    if (canConvert) {
#line 428
		IF (err) 
#line 428
		    error("%s", nc_strerror(err));
#line 428
	    } else {
#line 428
		IF (err != NC_ECHAR)
#line 428
		    error("wrong type: status = %d", err);
#line 428
	    }
#line 428
	    for (j = 0; j < var_rank[i]; j++) {
#line 428
		edge[j] = 1;
#line 428
	    }
#line 428
	}            /* Choose a random point dividing each dim into 2 parts */
#line 428
            /* get 2^rank (nslabs) slabs so defined */
#line 428
        nslabs = 1;
#line 428
        for (j = 0; j < var_rank[i]; j++) {
#line 428
            mid[j] = roll( var_shape[i][j] );
#line 428
            nslabs *= 2;
#line 428
        }
#line 428
            /* bits of k determine whether to get lower or upper part of dim */
#line 428
        for (k = 0; k < nslabs; k++) {
#line 428
            nels = 1;
#line 428
            for (j = 0; j < var_rank[i]; j++) {
#line 428
                if ((k >> j) & 1) {
#line 428
                    start[j] = 0;
#line 428
                    edge[j] = mid[j];
#line 428
                }else{
#line 428
                    start[j] = mid[j];
#line 428
                    edge[j] = var_shape[i][j] - mid[j];
#line 428
                }
#line 428
                nels *= edge[j];
#line 428
            }
#line 428
	    allInExtRange = allInIntRange = 1;
#line 428
            for (j = 0; j < nels; j++) {
#line 428
                err = toMixedBase(j, var_rank[i], edge, index);
#line 428
                IF (err)
#line 428
                    error("error in toMixedBase 1");
#line 428
                for (d = 0; d < var_rank[i]; d++)
#line 428
                    index[d] += start[d];
#line 428
                expect[j] = hash4(var_type[i], var_rank[i], index, NCT_SHORT);
#line 428
		if (inRange3(expect[j],var_type[i], NCT_SHORT)) {
#line 428
		    allInIntRange = allInIntRange && expect[j] >= short_min
#line 428
				&& expect[j] <= short_max;
#line 428
		} else {
#line 428
		    allInExtRange = 0;
#line 428
		}
#line 428
	    }
#line 428
            if (var_rank[i] == 0 && i%2)
#line 428
		err = nc_get_vara_short(ncid, i, NULL, NULL, value);
#line 428
	    else
#line 428
		err = nc_get_vara_short(ncid, i, start, edge, value);
#line 428
            if (canConvert) {
#line 428
		if (allInExtRange) {
#line 428
		    if (allInIntRange) {
#line 428
			IF (err)
#line 428
			    error("%s", nc_strerror(err));
#line 428
		    } else {
#line 428
			IF (err != NC_ERANGE)
#line 428
			    error("Range error: status = %d", err);
#line 428
		    }
#line 428
		} else {
#line 428
		    IF (err != 0 && err != NC_ERANGE)
#line 428
			error("OK or Range error: status = %d", err);
#line 428
		}
#line 428
		for (j = 0; j < nels; j++) {
#line 428
		    if (inRange3(expect[j],var_type[i],NCT_SHORT)
#line 428
			    && expect[j] >= short_min && expect[j] <= short_max) {
#line 428
			IF (!equal(value[j],expect[j],var_type[i],NCT_SHORT)){
#line 428
			    error("value read not that expected");
#line 428
			    if (verbose) {
#line 428
				error("\n");
#line 428
				error("varid: %d, ", i);
#line 428
				error("var_name: %s, ", var_name[i]);
#line 428
				error("element number: %d ", j);
#line 428
				error("expect: %g", expect[j]);
#line 428
				error("got: %g", (double) value[j]);
#line 428
			    }
#line 428
			} else {
#line 428
			    nok++;
#line 428
			}
#line 428
		    }
#line 428
		}
#line 428
            } else {
#line 428
                IF (nels > 0 && err != NC_ECHAR)
#line 428
                    error("wrong type: status = %d", err);
#line 428
            }
#line 428
        }
#line 428
    }
#line 428
    err = nc_close(ncid);
#line 428
    IF (err)
#line 428
	error("nc_close: %s", nc_strerror(err));
#line 428
    print_nok(nok);
#line 428
}
#line 428

void
#line 429
test_nc_get_vara_int(void)
#line 429
{
#line 429
    int ncid;
#line 429
    int d;
#line 429
    int i;
#line 429
    int j;
#line 429
    int k;
#line 429
    int err;
#line 429
    int allInExtRange;	/* all values within external range? */
#line 429
    int allInIntRange;	/* all values within internal range? */
#line 429
    int nels;
#line 429
    int nslabs;
#line 429
    int nok = 0;      /* count of valid comparisons */
#line 429
    size_t start[MAX_RANK];
#line 429
    size_t edge[MAX_RANK];
#line 429
    size_t index[MAX_RANK];
#line 429
    size_t mid[MAX_RANK];
#line 429
    int canConvert;     /* Both text or both numeric */
#line 429
    int value[MAX_NELS];
#line 429
    double expect[MAX_NELS];
#line 429

#line 429
#ifdef TEST_PNETCDF
#line 429
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 429
#else
#line 429
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 429
#endif
#line 429
    IF (err)
#line 429
	error("nc_open: %s", nc_strerror(err));
#line 429
    for (i = 0; i < numVars; i++) {
#line 429
        canConvert = (var_type[i] == NC_CHAR) == (NCT_INT == NCT_TEXT);
#line 429
        assert(var_rank[i] <= MAX_RANK);
#line 429
        assert(var_nels[i] <= MAX_NELS);
#line 429
	for (j = 0; j < var_rank[i]; j++) {
#line 429
	    start[j] = 0;
#line 429
	    edge[j] = 1;
#line 429
	}
#line 429
        err = nc_get_vara_int(BAD_ID, i, start, edge, value);
#line 429
        IF (err != NC_EBADID)
#line 429
	    error("bad ncid: status = %d", err);
#line 429
        err = nc_get_vara_int(ncid, BAD_VARID, start, edge, value);
#line 429
        IF (err != NC_ENOTVAR)
#line 429
	    error("bad var id: status = %d", err);
#line 429
	for (j = 0; j < var_rank[i]; j++) {
#line 429
	    start[j] = var_shape[i][j];
#line 429
	    err = nc_get_vara_int(ncid, i, start, edge, value);
#line 429
            IF (canConvert && err != NC_EINVALCOORDS)
#line 429
                error("bad index: status = %d", err);
#line 429
	    start[j] = 0;
#line 429
	    edge[j] = var_shape[i][j] + 1;
#line 429
	    err = nc_get_vara_int(ncid, i, start, edge, value);
#line 429
            IF (canConvert && err != NC_EEDGE)
#line 429
		error("bad edge: status = %d", err);
#line 429
	    edge[j] = 1;
#line 429
	}
#line 429
            /* Check non-scalars for correct error returned even when */
#line 429
            /* there is nothing to get (edge[j]==0) */
#line 429
	if(var_rank[i] > 0) {
#line 429
	    for (j = 0; j < var_rank[i]; j++) {
#line 429
		edge[j] = 0;
#line 429
	    }
#line 429
	    err = nc_get_vara_int(BAD_ID, i, start, edge, value);
#line 429
	    IF (err != NC_EBADID) 
#line 429
		error("bad ncid: status = %d", err);
#line 429
	    err = nc_get_vara_int(ncid, BAD_VARID, start, edge, value);
#line 429
	    IF (err != NC_ENOTVAR) 
#line 429
		error("bad var id: status = %d", err);
#line 429
	    for (j = 0; j < var_rank[i]; j++) {
#line 429
		if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 429
		    start[j] = var_shape[i][j];
#line 429
		    err = nc_get_vara_int(ncid, i, start, edge, value);
#line 429
		    IF (canConvert && err != NC_EINVALCOORDS)
#line 429
			error("bad start: status = %d", err);
#line 429
		    start[j] = 0;
#line 429
		}
#line 429
	    }
#line 429
	    err = nc_get_vara_int(ncid, i, start, edge, value);
#line 429
	    if (canConvert) {
#line 429
		IF (err) 
#line 429
		    error("%s", nc_strerror(err));
#line 429
	    } else {
#line 429
		IF (err != NC_ECHAR)
#line 429
		    error("wrong type: status = %d", err);
#line 429
	    }
#line 429
	    for (j = 0; j < var_rank[i]; j++) {
#line 429
		edge[j] = 1;
#line 429
	    }
#line 429
	}            /* Choose a random point dividing each dim into 2 parts */
#line 429
            /* get 2^rank (nslabs) slabs so defined */
#line 429
        nslabs = 1;
#line 429
        for (j = 0; j < var_rank[i]; j++) {
#line 429
            mid[j] = roll( var_shape[i][j] );
#line 429
            nslabs *= 2;
#line 429
        }
#line 429
            /* bits of k determine whether to get lower or upper part of dim */
#line 429
        for (k = 0; k < nslabs; k++) {
#line 429
            nels = 1;
#line 429
            for (j = 0; j < var_rank[i]; j++) {
#line 429
                if ((k >> j) & 1) {
#line 429
                    start[j] = 0;
#line 429
                    edge[j] = mid[j];
#line 429
                }else{
#line 429
                    start[j] = mid[j];
#line 429
                    edge[j] = var_shape[i][j] - mid[j];
#line 429
                }
#line 429
                nels *= edge[j];
#line 429
            }
#line 429
	    allInExtRange = allInIntRange = 1;
#line 429
            for (j = 0; j < nels; j++) {
#line 429
                err = toMixedBase(j, var_rank[i], edge, index);
#line 429
                IF (err)
#line 429
                    error("error in toMixedBase 1");
#line 429
                for (d = 0; d < var_rank[i]; d++)
#line 429
                    index[d] += start[d];
#line 429
                expect[j] = hash4(var_type[i], var_rank[i], index, NCT_INT);
#line 429
		if (inRange3(expect[j],var_type[i], NCT_INT)) {
#line 429
		    allInIntRange = allInIntRange && expect[j] >= int_min
#line 429
				&& expect[j] <= int_max;
#line 429
		} else {
#line 429
		    allInExtRange = 0;
#line 429
		}
#line 429
	    }
#line 429
            if (var_rank[i] == 0 && i%2)
#line 429
		err = nc_get_vara_int(ncid, i, NULL, NULL, value);
#line 429
	    else
#line 429
		err = nc_get_vara_int(ncid, i, start, edge, value);
#line 429
            if (canConvert) {
#line 429
		if (allInExtRange) {
#line 429
		    if (allInIntRange) {
#line 429
			IF (err)
#line 429
			    error("%s", nc_strerror(err));
#line 429
		    } else {
#line 429
			IF (err != NC_ERANGE)
#line 429
			    error("Range error: status = %d", err);
#line 429
		    }
#line 429
		} else {
#line 429
		    IF (err != 0 && err != NC_ERANGE)
#line 429
			error("OK or Range error: status = %d", err);
#line 429
		}
#line 429
		for (j = 0; j < nels; j++) {
#line 429
		    if (inRange3(expect[j],var_type[i],NCT_INT)
#line 429
			    && expect[j] >= int_min && expect[j] <= int_max) {
#line 429
			IF (!equal(value[j],expect[j],var_type[i],NCT_INT)){
#line 429
			    error("value read not that expected");
#line 429
			    if (verbose) {
#line 429
				error("\n");
#line 429
				error("varid: %d, ", i);
#line 429
				error("var_name: %s, ", var_name[i]);
#line 429
				error("element number: %d ", j);
#line 429
				error("expect: %g", expect[j]);
#line 429
				error("got: %g", (double) value[j]);
#line 429
			    }
#line 429
			} else {
#line 429
			    nok++;
#line 429
			}
#line 429
		    }
#line 429
		}
#line 429
            } else {
#line 429
                IF (nels > 0 && err != NC_ECHAR)
#line 429
                    error("wrong type: status = %d", err);
#line 429
            }
#line 429
        }
#line 429
    }
#line 429
    err = nc_close(ncid);
#line 429
    IF (err)
#line 429
	error("nc_close: %s", nc_strerror(err));
#line 429
    print_nok(nok);
#line 429
}
#line 429

void
#line 430
test_nc_get_vara_long(void)
#line 430
{
#line 430
    int ncid;
#line 430
    int d;
#line 430
    int i;
#line 430
    int j;
#line 430
    int k;
#line 430
    int err;
#line 430
    int allInExtRange;	/* all values within external range? */
#line 430
    int allInIntRange;	/* all values within internal range? */
#line 430
    int nels;
#line 430
    int nslabs;
#line 430
    int nok = 0;      /* count of valid comparisons */
#line 430
    size_t start[MAX_RANK];
#line 430
    size_t edge[MAX_RANK];
#line 430
    size_t index[MAX_RANK];
#line 430
    size_t mid[MAX_RANK];
#line 430
    int canConvert;     /* Both text or both numeric */
#line 430
    long value[MAX_NELS];
#line 430
    double expect[MAX_NELS];
#line 430

#line 430
#ifdef TEST_PNETCDF
#line 430
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 430
#else
#line 430
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 430
#endif
#line 430
    IF (err)
#line 430
	error("nc_open: %s", nc_strerror(err));
#line 430
    for (i = 0; i < numVars; i++) {
#line 430
        canConvert = (var_type[i] == NC_CHAR) == (NCT_LONG == NCT_TEXT);
#line 430
        assert(var_rank[i] <= MAX_RANK);
#line 430
        assert(var_nels[i] <= MAX_NELS);
#line 430
	for (j = 0; j < var_rank[i]; j++) {
#line 430
	    start[j] = 0;
#line 430
	    edge[j] = 1;
#line 430
	}
#line 430
        err = nc_get_vara_long(BAD_ID, i, start, edge, value);
#line 430
        IF (err != NC_EBADID)
#line 430
	    error("bad ncid: status = %d", err);
#line 430
        err = nc_get_vara_long(ncid, BAD_VARID, start, edge, value);
#line 430
        IF (err != NC_ENOTVAR)
#line 430
	    error("bad var id: status = %d", err);
#line 430
	for (j = 0; j < var_rank[i]; j++) {
#line 430
	    start[j] = var_shape[i][j];
#line 430
	    err = nc_get_vara_long(ncid, i, start, edge, value);
#line 430
            IF (canConvert && err != NC_EINVALCOORDS)
#line 430
                error("bad index: status = %d", err);
#line 430
	    start[j] = 0;
#line 430
	    edge[j] = var_shape[i][j] + 1;
#line 430
	    err = nc_get_vara_long(ncid, i, start, edge, value);
#line 430
            IF (canConvert && err != NC_EEDGE)
#line 430
		error("bad edge: status = %d", err);
#line 430
	    edge[j] = 1;
#line 430
	}
#line 430
            /* Check non-scalars for correct error returned even when */
#line 430
            /* there is nothing to get (edge[j]==0) */
#line 430
	if(var_rank[i] > 0) {
#line 430
	    for (j = 0; j < var_rank[i]; j++) {
#line 430
		edge[j] = 0;
#line 430
	    }
#line 430
	    err = nc_get_vara_long(BAD_ID, i, start, edge, value);
#line 430
	    IF (err != NC_EBADID) 
#line 430
		error("bad ncid: status = %d", err);
#line 430
	    err = nc_get_vara_long(ncid, BAD_VARID, start, edge, value);
#line 430
	    IF (err != NC_ENOTVAR) 
#line 430
		error("bad var id: status = %d", err);
#line 430
	    for (j = 0; j < var_rank[i]; j++) {
#line 430
		if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 430
		    start[j] = var_shape[i][j];
#line 430
		    err = nc_get_vara_long(ncid, i, start, edge, value);
#line 430
		    IF (canConvert && err != NC_EINVALCOORDS)
#line 430
			error("bad start: status = %d", err);
#line 430
		    start[j] = 0;
#line 430
		}
#line 430
	    }
#line 430
	    err = nc_get_vara_long(ncid, i, start, edge, value);
#line 430
	    if (canConvert) {
#line 430
		IF (err) 
#line 430
		    error("%s", nc_strerror(err));
#line 430
	    } else {
#line 430
		IF (err != NC_ECHAR)
#line 430
		    error("wrong type: status = %d", err);
#line 430
	    }
#line 430
	    for (j = 0; j < var_rank[i]; j++) {
#line 430
		edge[j] = 1;
#line 430
	    }
#line 430
	}            /* Choose a random point dividing each dim into 2 parts */
#line 430
            /* get 2^rank (nslabs) slabs so defined */
#line 430
        nslabs = 1;
#line 430
        for (j = 0; j < var_rank[i]; j++) {
#line 430
            mid[j] = roll( var_shape[i][j] );
#line 430
            nslabs *= 2;
#line 430
        }
#line 430
            /* bits of k determine whether to get lower or upper part of dim */
#line 430
        for (k = 0; k < nslabs; k++) {
#line 430
            nels = 1;
#line 430
            for (j = 0; j < var_rank[i]; j++) {
#line 430
                if ((k >> j) & 1) {
#line 430
                    start[j] = 0;
#line 430
                    edge[j] = mid[j];
#line 430
                }else{
#line 430
                    start[j] = mid[j];
#line 430
                    edge[j] = var_shape[i][j] - mid[j];
#line 430
                }
#line 430
                nels *= edge[j];
#line 430
            }
#line 430
	    allInExtRange = allInIntRange = 1;
#line 430
            for (j = 0; j < nels; j++) {
#line 430
                err = toMixedBase(j, var_rank[i], edge, index);
#line 430
                IF (err)
#line 430
                    error("error in toMixedBase 1");
#line 430
                for (d = 0; d < var_rank[i]; d++)
#line 430
                    index[d] += start[d];
#line 430
                expect[j] = hash4(var_type[i], var_rank[i], index, NCT_LONG);
#line 430
		if (inRange3(expect[j],var_type[i], NCT_LONG)) {
#line 430
		    allInIntRange = allInIntRange && expect[j] >= long_min
#line 430
				&& expect[j] <= long_max;
#line 430
		} else {
#line 430
		    allInExtRange = 0;
#line 430
		}
#line 430
	    }
#line 430
            if (var_rank[i] == 0 && i%2)
#line 430
		err = nc_get_vara_long(ncid, i, NULL, NULL, value);
#line 430
	    else
#line 430
		err = nc_get_vara_long(ncid, i, start, edge, value);
#line 430
            if (canConvert) {
#line 430
		if (allInExtRange) {
#line 430
		    if (allInIntRange) {
#line 430
			IF (err)
#line 430
			    error("%s", nc_strerror(err));
#line 430
		    } else {
#line 430
			IF (err != NC_ERANGE)
#line 430
			    error("Range error: status = %d", err);
#line 430
		    }
#line 430
		} else {
#line 430
		    IF (err != 0 && err != NC_ERANGE)
#line 430
			error("OK or Range error: status = %d", err);
#line 430
		}
#line 430
		for (j = 0; j < nels; j++) {
#line 430
		    if (inRange3(expect[j],var_type[i],NCT_LONG)
#line 430
			    && expect[j] >= long_min && expect[j] <= long_max) {
#line 430
			IF (!equal(value[j],expect[j],var_type[i],NCT_LONG)){
#line 430
			    error("value read not that expected");
#line 430
			    if (verbose) {
#line 430
				error("\n");
#line 430
				error("varid: %d, ", i);
#line 430
				error("var_name: %s, ", var_name[i]);
#line 430
				error("element number: %d ", j);
#line 430
				error("expect: %g", expect[j]);
#line 430
				error("got: %g", (double) value[j]);
#line 430
			    }
#line 430
			} else {
#line 430
			    nok++;
#line 430
			}
#line 430
		    }
#line 430
		}
#line 430
            } else {
#line 430
                IF (nels > 0 && err != NC_ECHAR)
#line 430
                    error("wrong type: status = %d", err);
#line 430
            }
#line 430
        }
#line 430
    }
#line 430
    err = nc_close(ncid);
#line 430
    IF (err)
#line 430
	error("nc_close: %s", nc_strerror(err));
#line 430
    print_nok(nok);
#line 430
}
#line 430

void
#line 431
test_nc_get_vara_float(void)
#line 431
{
#line 431
    int ncid;
#line 431
    int d;
#line 431
    int i;
#line 431
    int j;
#line 431
    int k;
#line 431
    int err;
#line 431
    int allInExtRange;	/* all values within external range? */
#line 431
    int allInIntRange;	/* all values within internal range? */
#line 431
    int nels;
#line 431
    int nslabs;
#line 431
    int nok = 0;      /* count of valid comparisons */
#line 431
    size_t start[MAX_RANK];
#line 431
    size_t edge[MAX_RANK];
#line 431
    size_t index[MAX_RANK];
#line 431
    size_t mid[MAX_RANK];
#line 431
    int canConvert;     /* Both text or both numeric */
#line 431
    float value[MAX_NELS];
#line 431
    double expect[MAX_NELS];
#line 431

#line 431
#ifdef TEST_PNETCDF
#line 431
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 431
#else
#line 431
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 431
#endif
#line 431
    IF (err)
#line 431
	error("nc_open: %s", nc_strerror(err));
#line 431
    for (i = 0; i < numVars; i++) {
#line 431
        canConvert = (var_type[i] == NC_CHAR) == (NCT_FLOAT == NCT_TEXT);
#line 431
        assert(var_rank[i] <= MAX_RANK);
#line 431
        assert(var_nels[i] <= MAX_NELS);
#line 431
	for (j = 0; j < var_rank[i]; j++) {
#line 431
	    start[j] = 0;
#line 431
	    edge[j] = 1;
#line 431
	}
#line 431
        err = nc_get_vara_float(BAD_ID, i, start, edge, value);
#line 431
        IF (err != NC_EBADID)
#line 431
	    error("bad ncid: status = %d", err);
#line 431
        err = nc_get_vara_float(ncid, BAD_VARID, start, edge, value);
#line 431
        IF (err != NC_ENOTVAR)
#line 431
	    error("bad var id: status = %d", err);
#line 431
	for (j = 0; j < var_rank[i]; j++) {
#line 431
	    start[j] = var_shape[i][j];
#line 431
	    err = nc_get_vara_float(ncid, i, start, edge, value);
#line 431
            IF (canConvert && err != NC_EINVALCOORDS)
#line 431
                error("bad index: status = %d", err);
#line 431
	    start[j] = 0;
#line 431
	    edge[j] = var_shape[i][j] + 1;
#line 431
	    err = nc_get_vara_float(ncid, i, start, edge, value);
#line 431
            IF (canConvert && err != NC_EEDGE)
#line 431
		error("bad edge: status = %d", err);
#line 431
	    edge[j] = 1;
#line 431
	}
#line 431
            /* Check non-scalars for correct error returned even when */
#line 431
            /* there is nothing to get (edge[j]==0) */
#line 431
	if(var_rank[i] > 0) {
#line 431
	    for (j = 0; j < var_rank[i]; j++) {
#line 431
		edge[j] = 0;
#line 431
	    }
#line 431
	    err = nc_get_vara_float(BAD_ID, i, start, edge, value);
#line 431
	    IF (err != NC_EBADID) 
#line 431
		error("bad ncid: status = %d", err);
#line 431
	    err = nc_get_vara_float(ncid, BAD_VARID, start, edge, value);
#line 431
	    IF (err != NC_ENOTVAR) 
#line 431
		error("bad var id: status = %d", err);
#line 431
	    for (j = 0; j < var_rank[i]; j++) {
#line 431
		if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 431
		    start[j] = var_shape[i][j];
#line 431
		    err = nc_get_vara_float(ncid, i, start, edge, value);
#line 431
		    IF (canConvert && err != NC_EINVALCOORDS)
#line 431
			error("bad start: status = %d", err);
#line 431
		    start[j] = 0;
#line 431
		}
#line 431
	    }
#line 431
	    err = nc_get_vara_float(ncid, i, start, edge, value);
#line 431
	    if (canConvert) {
#line 431
		IF (err) 
#line 431
		    error("%s", nc_strerror(err));
#line 431
	    } else {
#line 431
		IF (err != NC_ECHAR)
#line 431
		    error("wrong type: status = %d", err);
#line 431
	    }
#line 431
	    for (j = 0; j < var_rank[i]; j++) {
#line 431
		edge[j] = 1;
#line 431
	    }
#line 431
	}            /* Choose a random point dividing each dim into 2 parts */
#line 431
            /* get 2^rank (nslabs) slabs so defined */
#line 431
        nslabs = 1;
#line 431
        for (j = 0; j < var_rank[i]; j++) {
#line 431
            mid[j] = roll( var_shape[i][j] );
#line 431
            nslabs *= 2;
#line 431
        }
#line 431
            /* bits of k determine whether to get lower or upper part of dim */
#line 431
        for (k = 0; k < nslabs; k++) {
#line 431
            nels = 1;
#line 431
            for (j = 0; j < var_rank[i]; j++) {
#line 431
                if ((k >> j) & 1) {
#line 431
                    start[j] = 0;
#line 431
                    edge[j] = mid[j];
#line 431
                }else{
#line 431
                    start[j] = mid[j];
#line 431
                    edge[j] = var_shape[i][j] - mid[j];
#line 431
                }
#line 431
                nels *= edge[j];
#line 431
            }
#line 431
	    allInExtRange = allInIntRange = 1;
#line 431
            for (j = 0; j < nels; j++) {
#line 431
                err = toMixedBase(j, var_rank[i], edge, index);
#line 431
                IF (err)
#line 431
                    error("error in toMixedBase 1");
#line 431
                for (d = 0; d < var_rank[i]; d++)
#line 431
                    index[d] += start[d];
#line 431
                expect[j] = hash4(var_type[i], var_rank[i], index, NCT_FLOAT);
#line 431
		if (inRange3(expect[j],var_type[i], NCT_FLOAT)) {
#line 431
		    allInIntRange = allInIntRange && expect[j] >= float_min
#line 431
				&& expect[j] <= float_max;
#line 431
		} else {
#line 431
		    allInExtRange = 0;
#line 431
		}
#line 431
	    }
#line 431
            if (var_rank[i] == 0 && i%2)
#line 431
		err = nc_get_vara_float(ncid, i, NULL, NULL, value);
#line 431
	    else
#line 431
		err = nc_get_vara_float(ncid, i, start, edge, value);
#line 431
            if (canConvert) {
#line 431
		if (allInExtRange) {
#line 431
		    if (allInIntRange) {
#line 431
			IF (err)
#line 431
			    error("%s", nc_strerror(err));
#line 431
		    } else {
#line 431
			IF (err != NC_ERANGE)
#line 431
			    error("Range error: status = %d", err);
#line 431
		    }
#line 431
		} else {
#line 431
		    IF (err != 0 && err != NC_ERANGE)
#line 431
			error("OK or Range error: status = %d", err);
#line 431
		}
#line 431
		for (j = 0; j < nels; j++) {
#line 431
		    if (inRange3(expect[j],var_type[i],NCT_FLOAT)
#line 431
			    && expect[j] >= float_min && expect[j] <= float_max) {
#line 431
			IF (!equal(value[j],expect[j],var_type[i],NCT_FLOAT)){
#line 431
			    error("value read not that expected");
#line 431
			    if (verbose) {
#line 431
				error("\n");
#line 431
				error("varid: %d, ", i);
#line 431
				error("var_name: %s, ", var_name[i]);
#line 431
				error("element number: %d ", j);
#line 431
				error("expect: %g", expect[j]);
#line 431
				error("got: %g", (double) value[j]);
#line 431
			    }
#line 431
			} else {
#line 431
			    nok++;
#line 431
			}
#line 431
		    }
#line 431
		}
#line 431
            } else {
#line 431
                IF (nels > 0 && err != NC_ECHAR)
#line 431
                    error("wrong type: status = %d", err);
#line 431
            }
#line 431
        }
#line 431
    }
#line 431
    err = nc_close(ncid);
#line 431
    IF (err)
#line 431
	error("nc_close: %s", nc_strerror(err));
#line 431
    print_nok(nok);
#line 431
}
#line 431

void
#line 432
test_nc_get_vara_double(void)
#line 432
{
#line 432
    int ncid;
#line 432
    int d;
#line 432
    int i;
#line 432
    int j;
#line 432
    int k;
#line 432
    int err;
#line 432
    int allInExtRange;	/* all values within external range? */
#line 432
    int allInIntRange;	/* all values within internal range? */
#line 432
    int nels;
#line 432
    int nslabs;
#line 432
    int nok = 0;      /* count of valid comparisons */
#line 432
    size_t start[MAX_RANK];
#line 432
    size_t edge[MAX_RANK];
#line 432
    size_t index[MAX_RANK];
#line 432
    size_t mid[MAX_RANK];
#line 432
    int canConvert;     /* Both text or both numeric */
#line 432
    double value[MAX_NELS];
#line 432
    double expect[MAX_NELS];
#line 432

#line 432
#ifdef TEST_PNETCDF
#line 432
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 432
#else
#line 432
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 432
#endif
#line 432
    IF (err)
#line 432
	error("nc_open: %s", nc_strerror(err));
#line 432
    for (i = 0; i < numVars; i++) {
#line 432
        canConvert = (var_type[i] == NC_CHAR) == (NCT_DOUBLE == NCT_TEXT);
#line 432
        assert(var_rank[i] <= MAX_RANK);
#line 432
        assert(var_nels[i] <= MAX_NELS);
#line 432
	for (j = 0; j < var_rank[i]; j++) {
#line 432
	    start[j] = 0;
#line 432
	    edge[j] = 1;
#line 432
	}
#line 432
        err = nc_get_vara_double(BAD_ID, i, start, edge, value);
#line 432
        IF (err != NC_EBADID)
#line 432
	    error("bad ncid: status = %d", err);
#line 432
        err = nc_get_vara_double(ncid, BAD_VARID, start, edge, value);
#line 432
        IF (err != NC_ENOTVAR)
#line 432
	    error("bad var id: status = %d", err);
#line 432
	for (j = 0; j < var_rank[i]; j++) {
#line 432
	    start[j] = var_shape[i][j];
#line 432
	    err = nc_get_vara_double(ncid, i, start, edge, value);
#line 432
            IF (canConvert && err != NC_EINVALCOORDS)
#line 432
                error("bad index: status = %d", err);
#line 432
	    start[j] = 0;
#line 432
	    edge[j] = var_shape[i][j] + 1;
#line 432
	    err = nc_get_vara_double(ncid, i, start, edge, value);
#line 432
            IF (canConvert && err != NC_EEDGE)
#line 432
		error("bad edge: status = %d", err);
#line 432
	    edge[j] = 1;
#line 432
	}
#line 432
            /* Check non-scalars for correct error returned even when */
#line 432
            /* there is nothing to get (edge[j]==0) */
#line 432
	if(var_rank[i] > 0) {
#line 432
	    for (j = 0; j < var_rank[i]; j++) {
#line 432
		edge[j] = 0;
#line 432
	    }
#line 432
	    err = nc_get_vara_double(BAD_ID, i, start, edge, value);
#line 432
	    IF (err != NC_EBADID) 
#line 432
		error("bad ncid: status = %d", err);
#line 432
	    err = nc_get_vara_double(ncid, BAD_VARID, start, edge, value);
#line 432
	    IF (err != NC_ENOTVAR) 
#line 432
		error("bad var id: status = %d", err);
#line 432
	    for (j = 0; j < var_rank[i]; j++) {
#line 432
		if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 432
		    start[j] = var_shape[i][j];
#line 432
		    err = nc_get_vara_double(ncid, i, start, edge, value);
#line 432
		    IF (canConvert && err != NC_EINVALCOORDS)
#line 432
			error("bad start: status = %d", err);
#line 432
		    start[j] = 0;
#line 432
		}
#line 432
	    }
#line 432
	    err = nc_get_vara_double(ncid, i, start, edge, value);
#line 432
	    if (canConvert) {
#line 432
		IF (err) 
#line 432
		    error("%s", nc_strerror(err));
#line 432
	    } else {
#line 432
		IF (err != NC_ECHAR)
#line 432
		    error("wrong type: status = %d", err);
#line 432
	    }
#line 432
	    for (j = 0; j < var_rank[i]; j++) {
#line 432
		edge[j] = 1;
#line 432
	    }
#line 432
	}            /* Choose a random point dividing each dim into 2 parts */
#line 432
            /* get 2^rank (nslabs) slabs so defined */
#line 432
        nslabs = 1;
#line 432
        for (j = 0; j < var_rank[i]; j++) {
#line 432
            mid[j] = roll( var_shape[i][j] );
#line 432
            nslabs *= 2;
#line 432
        }
#line 432
            /* bits of k determine whether to get lower or upper part of dim */
#line 432
        for (k = 0; k < nslabs; k++) {
#line 432
            nels = 1;
#line 432
            for (j = 0; j < var_rank[i]; j++) {
#line 432
                if ((k >> j) & 1) {
#line 432
                    start[j] = 0;
#line 432
                    edge[j] = mid[j];
#line 432
                }else{
#line 432
                    start[j] = mid[j];
#line 432
                    edge[j] = var_shape[i][j] - mid[j];
#line 432
                }
#line 432
                nels *= edge[j];
#line 432
            }
#line 432
	    allInExtRange = allInIntRange = 1;
#line 432
            for (j = 0; j < nels; j++) {
#line 432
                err = toMixedBase(j, var_rank[i], edge, index);
#line 432
                IF (err)
#line 432
                    error("error in toMixedBase 1");
#line 432
                for (d = 0; d < var_rank[i]; d++)
#line 432
                    index[d] += start[d];
#line 432
                expect[j] = hash4(var_type[i], var_rank[i], index, NCT_DOUBLE);
#line 432
		if (inRange3(expect[j],var_type[i], NCT_DOUBLE)) {
#line 432
		    allInIntRange = allInIntRange && expect[j] >= double_min
#line 432
				&& expect[j] <= double_max;
#line 432
		} else {
#line 432
		    allInExtRange = 0;
#line 432
		}
#line 432
	    }
#line 432
            if (var_rank[i] == 0 && i%2)
#line 432
		err = nc_get_vara_double(ncid, i, NULL, NULL, value);
#line 432
	    else
#line 432
		err = nc_get_vara_double(ncid, i, start, edge, value);
#line 432
            if (canConvert) {
#line 432
		if (allInExtRange) {
#line 432
		    if (allInIntRange) {
#line 432
			IF (err)
#line 432
			    error("%s", nc_strerror(err));
#line 432
		    } else {
#line 432
			IF (err != NC_ERANGE)
#line 432
			    error("Range error: status = %d", err);
#line 432
		    }
#line 432
		} else {
#line 432
		    IF (err != 0 && err != NC_ERANGE)
#line 432
			error("OK or Range error: status = %d", err);
#line 432
		}
#line 432
		for (j = 0; j < nels; j++) {
#line 432
		    if (inRange3(expect[j],var_type[i],NCT_DOUBLE)
#line 432
			    && expect[j] >= double_min && expect[j] <= double_max) {
#line 432
			IF (!equal(value[j],expect[j],var_type[i],NCT_DOUBLE)){
#line 432
			    error("value read not that expected");
#line 432
			    if (verbose) {
#line 432
				error("\n");
#line 432
				error("varid: %d, ", i);
#line 432
				error("var_name: %s, ", var_name[i]);
#line 432
				error("element number: %d ", j);
#line 432
				error("expect: %g", expect[j]);
#line 432
				error("got: %g", (double) value[j]);
#line 432
			    }
#line 432
			} else {
#line 432
			    nok++;
#line 432
			}
#line 432
		    }
#line 432
		}
#line 432
            } else {
#line 432
                IF (nels > 0 && err != NC_ECHAR)
#line 432
                    error("wrong type: status = %d", err);
#line 432
            }
#line 432
        }
#line 432
    }
#line 432
    err = nc_close(ncid);
#line 432
    IF (err)
#line 432
	error("nc_close: %s", nc_strerror(err));
#line 432
    print_nok(nok);
#line 432
}
#line 432

void
#line 433
test_nc_get_vara_ushort(void)
#line 433
{
#line 433
    int ncid;
#line 433
    int d;
#line 433
    int i;
#line 433
    int j;
#line 433
    int k;
#line 433
    int err;
#line 433
    int allInExtRange;	/* all values within external range? */
#line 433
    int allInIntRange;	/* all values within internal range? */
#line 433
    int nels;
#line 433
    int nslabs;
#line 433
    int nok = 0;      /* count of valid comparisons */
#line 433
    size_t start[MAX_RANK];
#line 433
    size_t edge[MAX_RANK];
#line 433
    size_t index[MAX_RANK];
#line 433
    size_t mid[MAX_RANK];
#line 433
    int canConvert;     /* Both text or both numeric */
#line 433
    ushort value[MAX_NELS];
#line 433
    double expect[MAX_NELS];
#line 433

#line 433
#ifdef TEST_PNETCDF
#line 433
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 433
#else
#line 433
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 433
#endif
#line 433
    IF (err)
#line 433
	error("nc_open: %s", nc_strerror(err));
#line 433
    for (i = 0; i < numVars; i++) {
#line 433
        canConvert = (var_type[i] == NC_CHAR) == (NCT_USHORT == NCT_TEXT);
#line 433
        assert(var_rank[i] <= MAX_RANK);
#line 433
        assert(var_nels[i] <= MAX_NELS);
#line 433
	for (j = 0; j < var_rank[i]; j++) {
#line 433
	    start[j] = 0;
#line 433
	    edge[j] = 1;
#line 433
	}
#line 433
        err = nc_get_vara_ushort(BAD_ID, i, start, edge, value);
#line 433
        IF (err != NC_EBADID)
#line 433
	    error("bad ncid: status = %d", err);
#line 433
        err = nc_get_vara_ushort(ncid, BAD_VARID, start, edge, value);
#line 433
        IF (err != NC_ENOTVAR)
#line 433
	    error("bad var id: status = %d", err);
#line 433
	for (j = 0; j < var_rank[i]; j++) {
#line 433
	    start[j] = var_shape[i][j];
#line 433
	    err = nc_get_vara_ushort(ncid, i, start, edge, value);
#line 433
            IF (canConvert && err != NC_EINVALCOORDS)
#line 433
                error("bad index: status = %d", err);
#line 433
	    start[j] = 0;
#line 433
	    edge[j] = var_shape[i][j] + 1;
#line 433
	    err = nc_get_vara_ushort(ncid, i, start, edge, value);
#line 433
            IF (canConvert && err != NC_EEDGE)
#line 433
		error("bad edge: status = %d", err);
#line 433
	    edge[j] = 1;
#line 433
	}
#line 433
            /* Check non-scalars for correct error returned even when */
#line 433
            /* there is nothing to get (edge[j]==0) */
#line 433
	if(var_rank[i] > 0) {
#line 433
	    for (j = 0; j < var_rank[i]; j++) {
#line 433
		edge[j] = 0;
#line 433
	    }
#line 433
	    err = nc_get_vara_ushort(BAD_ID, i, start, edge, value);
#line 433
	    IF (err != NC_EBADID) 
#line 433
		error("bad ncid: status = %d", err);
#line 433
	    err = nc_get_vara_ushort(ncid, BAD_VARID, start, edge, value);
#line 433
	    IF (err != NC_ENOTVAR) 
#line 433
		error("bad var id: status = %d", err);
#line 433
	    for (j = 0; j < var_rank[i]; j++) {
#line 433
		if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 433
		    start[j] = var_shape[i][j];
#line 433
		    err = nc_get_vara_ushort(ncid, i, start, edge, value);
#line 433
		    IF (canConvert && err != NC_EINVALCOORDS)
#line 433
			error("bad start: status = %d", err);
#line 433
		    start[j] = 0;
#line 433
		}
#line 433
	    }
#line 433
	    err = nc_get_vara_ushort(ncid, i, start, edge, value);
#line 433
	    if (canConvert) {
#line 433
		IF (err) 
#line 433
		    error("%s", nc_strerror(err));
#line 433
	    } else {
#line 433
		IF (err != NC_ECHAR)
#line 433
		    error("wrong type: status = %d", err);
#line 433
	    }
#line 433
	    for (j = 0; j < var_rank[i]; j++) {
#line 433
		edge[j] = 1;
#line 433
	    }
#line 433
	}            /* Choose a random point dividing each dim into 2 parts */
#line 433
            /* get 2^rank (nslabs) slabs so defined */
#line 433
        nslabs = 1;
#line 433
        for (j = 0; j < var_rank[i]; j++) {
#line 433
            mid[j] = roll( var_shape[i][j] );
#line 433
            nslabs *= 2;
#line 433
        }
#line 433
            /* bits of k determine whether to get lower or upper part of dim */
#line 433
        for (k = 0; k < nslabs; k++) {
#line 433
            nels = 1;
#line 433
            for (j = 0; j < var_rank[i]; j++) {
#line 433
                if ((k >> j) & 1) {
#line 433
                    start[j] = 0;
#line 433
                    edge[j] = mid[j];
#line 433
                }else{
#line 433
                    start[j] = mid[j];
#line 433
                    edge[j] = var_shape[i][j] - mid[j];
#line 433
                }
#line 433
                nels *= edge[j];
#line 433
            }
#line 433
	    allInExtRange = allInIntRange = 1;
#line 433
            for (j = 0; j < nels; j++) {
#line 433
                err = toMixedBase(j, var_rank[i], edge, index);
#line 433
                IF (err)
#line 433
                    error("error in toMixedBase 1");
#line 433
                for (d = 0; d < var_rank[i]; d++)
#line 433
                    index[d] += start[d];
#line 433
                expect[j] = hash4(var_type[i], var_rank[i], index, NCT_USHORT);
#line 433
		if (inRange3(expect[j],var_type[i], NCT_USHORT)) {
#line 433
		    allInIntRange = allInIntRange && expect[j] >= ushort_min
#line 433
				&& expect[j] <= ushort_max;
#line 433
		} else {
#line 433
		    allInExtRange = 0;
#line 433
		}
#line 433
	    }
#line 433
            if (var_rank[i] == 0 && i%2)
#line 433
		err = nc_get_vara_ushort(ncid, i, NULL, NULL, value);
#line 433
	    else
#line 433
		err = nc_get_vara_ushort(ncid, i, start, edge, value);
#line 433
            if (canConvert) {
#line 433
		if (allInExtRange) {
#line 433
		    if (allInIntRange) {
#line 433
			IF (err)
#line 433
			    error("%s", nc_strerror(err));
#line 433
		    } else {
#line 433
			IF (err != NC_ERANGE)
#line 433
			    error("Range error: status = %d", err);
#line 433
		    }
#line 433
		} else {
#line 433
		    IF (err != 0 && err != NC_ERANGE)
#line 433
			error("OK or Range error: status = %d", err);
#line 433
		}
#line 433
		for (j = 0; j < nels; j++) {
#line 433
		    if (inRange3(expect[j],var_type[i],NCT_USHORT)
#line 433
			    && expect[j] >= ushort_min && expect[j] <= ushort_max) {
#line 433
			IF (!equal(value[j],expect[j],var_type[i],NCT_USHORT)){
#line 433
			    error("value read not that expected");
#line 433
			    if (verbose) {
#line 433
				error("\n");
#line 433
				error("varid: %d, ", i);
#line 433
				error("var_name: %s, ", var_name[i]);
#line 433
				error("element number: %d ", j);
#line 433
				error("expect: %g", expect[j]);
#line 433
				error("got: %g", (double) value[j]);
#line 433
			    }
#line 433
			} else {
#line 433
			    nok++;
#line 433
			}
#line 433
		    }
#line 433
		}
#line 433
            } else {
#line 433
                IF (nels > 0 && err != NC_ECHAR)
#line 433
                    error("wrong type: status = %d", err);
#line 433
            }
#line 433
        }
#line 433
    }
#line 433
    err = nc_close(ncid);
#line 433
    IF (err)
#line 433
	error("nc_close: %s", nc_strerror(err));
#line 433
    print_nok(nok);
#line 433
}
#line 433

void
#line 434
test_nc_get_vara_uint(void)
#line 434
{
#line 434
    int ncid;
#line 434
    int d;
#line 434
    int i;
#line 434
    int j;
#line 434
    int k;
#line 434
    int err;
#line 434
    int allInExtRange;	/* all values within external range? */
#line 434
    int allInIntRange;	/* all values within internal range? */
#line 434
    int nels;
#line 434
    int nslabs;
#line 434
    int nok = 0;      /* count of valid comparisons */
#line 434
    size_t start[MAX_RANK];
#line 434
    size_t edge[MAX_RANK];
#line 434
    size_t index[MAX_RANK];
#line 434
    size_t mid[MAX_RANK];
#line 434
    int canConvert;     /* Both text or both numeric */
#line 434
    uint value[MAX_NELS];
#line 434
    double expect[MAX_NELS];
#line 434

#line 434
#ifdef TEST_PNETCDF
#line 434
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 434
#else
#line 434
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 434
#endif
#line 434
    IF (err)
#line 434
	error("nc_open: %s", nc_strerror(err));
#line 434
    for (i = 0; i < numVars; i++) {
#line 434
        canConvert = (var_type[i] == NC_CHAR) == (NCT_UINT == NCT_TEXT);
#line 434
        assert(var_rank[i] <= MAX_RANK);
#line 434
        assert(var_nels[i] <= MAX_NELS);
#line 434
	for (j = 0; j < var_rank[i]; j++) {
#line 434
	    start[j] = 0;
#line 434
	    edge[j] = 1;
#line 434
	}
#line 434
        err = nc_get_vara_uint(BAD_ID, i, start, edge, value);
#line 434
        IF (err != NC_EBADID)
#line 434
	    error("bad ncid: status = %d", err);
#line 434
        err = nc_get_vara_uint(ncid, BAD_VARID, start, edge, value);
#line 434
        IF (err != NC_ENOTVAR)
#line 434
	    error("bad var id: status = %d", err);
#line 434
	for (j = 0; j < var_rank[i]; j++) {
#line 434
	    start[j] = var_shape[i][j];
#line 434
	    err = nc_get_vara_uint(ncid, i, start, edge, value);
#line 434
            IF (canConvert && err != NC_EINVALCOORDS)
#line 434
                error("bad index: status = %d", err);
#line 434
	    start[j] = 0;
#line 434
	    edge[j] = var_shape[i][j] + 1;
#line 434
	    err = nc_get_vara_uint(ncid, i, start, edge, value);
#line 434
            IF (canConvert && err != NC_EEDGE)
#line 434
		error("bad edge: status = %d", err);
#line 434
	    edge[j] = 1;
#line 434
	}
#line 434
            /* Check non-scalars for correct error returned even when */
#line 434
            /* there is nothing to get (edge[j]==0) */
#line 434
	if(var_rank[i] > 0) {
#line 434
	    for (j = 0; j < var_rank[i]; j++) {
#line 434
		edge[j] = 0;
#line 434
	    }
#line 434
	    err = nc_get_vara_uint(BAD_ID, i, start, edge, value);
#line 434
	    IF (err != NC_EBADID) 
#line 434
		error("bad ncid: status = %d", err);
#line 434
	    err = nc_get_vara_uint(ncid, BAD_VARID, start, edge, value);
#line 434
	    IF (err != NC_ENOTVAR) 
#line 434
		error("bad var id: status = %d", err);
#line 434
	    for (j = 0; j < var_rank[i]; j++) {
#line 434
		if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 434
		    start[j] = var_shape[i][j];
#line 434
		    err = nc_get_vara_uint(ncid, i, start, edge, value);
#line 434
		    IF (canConvert && err != NC_EINVALCOORDS)
#line 434
			error("bad start: status = %d", err);
#line 434
		    start[j] = 0;
#line 434
		}
#line 434
	    }
#line 434
	    err = nc_get_vara_uint(ncid, i, start, edge, value);
#line 434
	    if (canConvert) {
#line 434
		IF (err) 
#line 434
		    error("%s", nc_strerror(err));
#line 434
	    } else {
#line 434
		IF (err != NC_ECHAR)
#line 434
		    error("wrong type: status = %d", err);
#line 434
	    }
#line 434
	    for (j = 0; j < var_rank[i]; j++) {
#line 434
		edge[j] = 1;
#line 434
	    }
#line 434
	}            /* Choose a random point dividing each dim into 2 parts */
#line 434
            /* get 2^rank (nslabs) slabs so defined */
#line 434
        nslabs = 1;
#line 434
        for (j = 0; j < var_rank[i]; j++) {
#line 434
            mid[j] = roll( var_shape[i][j] );
#line 434
            nslabs *= 2;
#line 434
        }
#line 434
            /* bits of k determine whether to get lower or upper part of dim */
#line 434
        for (k = 0; k < nslabs; k++) {
#line 434
            nels = 1;
#line 434
            for (j = 0; j < var_rank[i]; j++) {
#line 434
                if ((k >> j) & 1) {
#line 434
                    start[j] = 0;
#line 434
                    edge[j] = mid[j];
#line 434
                }else{
#line 434
                    start[j] = mid[j];
#line 434
                    edge[j] = var_shape[i][j] - mid[j];
#line 434
                }
#line 434
                nels *= edge[j];
#line 434
            }
#line 434
	    allInExtRange = allInIntRange = 1;
#line 434
            for (j = 0; j < nels; j++) {
#line 434
                err = toMixedBase(j, var_rank[i], edge, index);
#line 434
                IF (err)
#line 434
                    error("error in toMixedBase 1");
#line 434
                for (d = 0; d < var_rank[i]; d++)
#line 434
                    index[d] += start[d];
#line 434
                expect[j] = hash4(var_type[i], var_rank[i], index, NCT_UINT);
#line 434
		if (inRange3(expect[j],var_type[i], NCT_UINT)) {
#line 434
		    allInIntRange = allInIntRange && expect[j] >= uint_min
#line 434
				&& expect[j] <= uint_max;
#line 434
		} else {
#line 434
		    allInExtRange = 0;
#line 434
		}
#line 434
	    }
#line 434
            if (var_rank[i] == 0 && i%2)
#line 434
		err = nc_get_vara_uint(ncid, i, NULL, NULL, value);
#line 434
	    else
#line 434
		err = nc_get_vara_uint(ncid, i, start, edge, value);
#line 434
            if (canConvert) {
#line 434
		if (allInExtRange) {
#line 434
		    if (allInIntRange) {
#line 434
			IF (err)
#line 434
			    error("%s", nc_strerror(err));
#line 434
		    } else {
#line 434
			IF (err != NC_ERANGE)
#line 434
			    error("Range error: status = %d", err);
#line 434
		    }
#line 434
		} else {
#line 434
		    IF (err != 0 && err != NC_ERANGE)
#line 434
			error("OK or Range error: status = %d", err);
#line 434
		}
#line 434
		for (j = 0; j < nels; j++) {
#line 434
		    if (inRange3(expect[j],var_type[i],NCT_UINT)
#line 434
			    && expect[j] >= uint_min && expect[j] <= uint_max) {
#line 434
			IF (!equal(value[j],expect[j],var_type[i],NCT_UINT)){
#line 434
			    error("value read not that expected");
#line 434
			    if (verbose) {
#line 434
				error("\n");
#line 434
				error("varid: %d, ", i);
#line 434
				error("var_name: %s, ", var_name[i]);
#line 434
				error("element number: %d ", j);
#line 434
				error("expect: %g", expect[j]);
#line 434
				error("got: %g", (double) value[j]);
#line 434
			    }
#line 434
			} else {
#line 434
			    nok++;
#line 434
			}
#line 434
		    }
#line 434
		}
#line 434
            } else {
#line 434
                IF (nels > 0 && err != NC_ECHAR)
#line 434
                    error("wrong type: status = %d", err);
#line 434
            }
#line 434
        }
#line 434
    }
#line 434
    err = nc_close(ncid);
#line 434
    IF (err)
#line 434
	error("nc_close: %s", nc_strerror(err));
#line 434
    print_nok(nok);
#line 434
}
#line 434

void
#line 435
test_nc_get_vara_longlong(void)
#line 435
{
#line 435
    int ncid;
#line 435
    int d;
#line 435
    int i;
#line 435
    int j;
#line 435
    int k;
#line 435
    int err;
#line 435
    int allInExtRange;	/* all values within external range? */
#line 435
    int allInIntRange;	/* all values within internal range? */
#line 435
    int nels;
#line 435
    int nslabs;
#line 435
    int nok = 0;      /* count of valid comparisons */
#line 435
    size_t start[MAX_RANK];
#line 435
    size_t edge[MAX_RANK];
#line 435
    size_t index[MAX_RANK];
#line 435
    size_t mid[MAX_RANK];
#line 435
    int canConvert;     /* Both text or both numeric */
#line 435
    longlong value[MAX_NELS];
#line 435
    double expect[MAX_NELS];
#line 435

#line 435
#ifdef TEST_PNETCDF
#line 435
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 435
#else
#line 435
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 435
#endif
#line 435
    IF (err)
#line 435
	error("nc_open: %s", nc_strerror(err));
#line 435
    for (i = 0; i < numVars; i++) {
#line 435
        canConvert = (var_type[i] == NC_CHAR) == (NCT_LONGLONG == NCT_TEXT);
#line 435
        assert(var_rank[i] <= MAX_RANK);
#line 435
        assert(var_nels[i] <= MAX_NELS);
#line 435
	for (j = 0; j < var_rank[i]; j++) {
#line 435
	    start[j] = 0;
#line 435
	    edge[j] = 1;
#line 435
	}
#line 435
        err = nc_get_vara_longlong(BAD_ID, i, start, edge, value);
#line 435
        IF (err != NC_EBADID)
#line 435
	    error("bad ncid: status = %d", err);
#line 435
        err = nc_get_vara_longlong(ncid, BAD_VARID, start, edge, value);
#line 435
        IF (err != NC_ENOTVAR)
#line 435
	    error("bad var id: status = %d", err);
#line 435
	for (j = 0; j < var_rank[i]; j++) {
#line 435
	    start[j] = var_shape[i][j];
#line 435
	    err = nc_get_vara_longlong(ncid, i, start, edge, value);
#line 435
            IF (canConvert && err != NC_EINVALCOORDS)
#line 435
                error("bad index: status = %d", err);
#line 435
	    start[j] = 0;
#line 435
	    edge[j] = var_shape[i][j] + 1;
#line 435
	    err = nc_get_vara_longlong(ncid, i, start, edge, value);
#line 435
            IF (canConvert && err != NC_EEDGE)
#line 435
		error("bad edge: status = %d", err);
#line 435
	    edge[j] = 1;
#line 435
	}
#line 435
            /* Check non-scalars for correct error returned even when */
#line 435
            /* there is nothing to get (edge[j]==0) */
#line 435
	if(var_rank[i] > 0) {
#line 435
	    for (j = 0; j < var_rank[i]; j++) {
#line 435
		edge[j] = 0;
#line 435
	    }
#line 435
	    err = nc_get_vara_longlong(BAD_ID, i, start, edge, value);
#line 435
	    IF (err != NC_EBADID) 
#line 435
		error("bad ncid: status = %d", err);
#line 435
	    err = nc_get_vara_longlong(ncid, BAD_VARID, start, edge, value);
#line 435
	    IF (err != NC_ENOTVAR) 
#line 435
		error("bad var id: status = %d", err);
#line 435
	    for (j = 0; j < var_rank[i]; j++) {
#line 435
		if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 435
		    start[j] = var_shape[i][j];
#line 435
		    err = nc_get_vara_longlong(ncid, i, start, edge, value);
#line 435
		    IF (canConvert && err != NC_EINVALCOORDS)
#line 435
			error("bad start: status = %d", err);
#line 435
		    start[j] = 0;
#line 435
		}
#line 435
	    }
#line 435
	    err = nc_get_vara_longlong(ncid, i, start, edge, value);
#line 435
	    if (canConvert) {
#line 435
		IF (err) 
#line 435
		    error("%s", nc_strerror(err));
#line 435
	    } else {
#line 435
		IF (err != NC_ECHAR)
#line 435
		    error("wrong type: status = %d", err);
#line 435
	    }
#line 435
	    for (j = 0; j < var_rank[i]; j++) {
#line 435
		edge[j] = 1;
#line 435
	    }
#line 435
	}            /* Choose a random point dividing each dim into 2 parts */
#line 435
            /* get 2^rank (nslabs) slabs so defined */
#line 435
        nslabs = 1;
#line 435
        for (j = 0; j < var_rank[i]; j++) {
#line 435
            mid[j] = roll( var_shape[i][j] );
#line 435
            nslabs *= 2;
#line 435
        }
#line 435
            /* bits of k determine whether to get lower or upper part of dim */
#line 435
        for (k = 0; k < nslabs; k++) {
#line 435
            nels = 1;
#line 435
            for (j = 0; j < var_rank[i]; j++) {
#line 435
                if ((k >> j) & 1) {
#line 435
                    start[j] = 0;
#line 435
                    edge[j] = mid[j];
#line 435
                }else{
#line 435
                    start[j] = mid[j];
#line 435
                    edge[j] = var_shape[i][j] - mid[j];
#line 435
                }
#line 435
                nels *= edge[j];
#line 435
            }
#line 435
	    allInExtRange = allInIntRange = 1;
#line 435
            for (j = 0; j < nels; j++) {
#line 435
                err = toMixedBase(j, var_rank[i], edge, index);
#line 435
                IF (err)
#line 435
                    error("error in toMixedBase 1");
#line 435
                for (d = 0; d < var_rank[i]; d++)
#line 435
                    index[d] += start[d];
#line 435
                expect[j] = hash4(var_type[i], var_rank[i], index, NCT_LONGLONG);
#line 435
		if (inRange3(expect[j],var_type[i], NCT_LONGLONG)) {
#line 435
		    allInIntRange = allInIntRange && expect[j] >= longlong_min
#line 435
				&& expect[j] <= longlong_max;
#line 435
		} else {
#line 435
		    allInExtRange = 0;
#line 435
		}
#line 435
	    }
#line 435
            if (var_rank[i] == 0 && i%2)
#line 435
		err = nc_get_vara_longlong(ncid, i, NULL, NULL, value);
#line 435
	    else
#line 435
		err = nc_get_vara_longlong(ncid, i, start, edge, value);
#line 435
            if (canConvert) {
#line 435
		if (allInExtRange) {
#line 435
		    if (allInIntRange) {
#line 435
			IF (err)
#line 435
			    error("%s", nc_strerror(err));
#line 435
		    } else {
#line 435
			IF (err != NC_ERANGE)
#line 435
			    error("Range error: status = %d", err);
#line 435
		    }
#line 435
		} else {
#line 435
		    IF (err != 0 && err != NC_ERANGE)
#line 435
			error("OK or Range error: status = %d", err);
#line 435
		}
#line 435
		for (j = 0; j < nels; j++) {
#line 435
		    if (inRange3(expect[j],var_type[i],NCT_LONGLONG)
#line 435
			    && expect[j] >= longlong_min && expect[j] <= longlong_max) {
#line 435
			IF (!equal(value[j],expect[j],var_type[i],NCT_LONGLONG)){
#line 435
			    error("value read not that expected");
#line 435
			    if (verbose) {
#line 435
				error("\n");
#line 435
				error("varid: %d, ", i);
#line 435
				error("var_name: %s, ", var_name[i]);
#line 435
				error("element number: %d ", j);
#line 435
				error("expect: %g", expect[j]);
#line 435
				error("got: %g", (double) value[j]);
#line 435
			    }
#line 435
			} else {
#line 435
			    nok++;
#line 435
			}
#line 435
		    }
#line 435
		}
#line 435
            } else {
#line 435
                IF (nels > 0 && err != NC_ECHAR)
#line 435
                    error("wrong type: status = %d", err);
#line 435
            }
#line 435
        }
#line 435
    }
#line 435
    err = nc_close(ncid);
#line 435
    IF (err)
#line 435
	error("nc_close: %s", nc_strerror(err));
#line 435
    print_nok(nok);
#line 435
}
#line 435

void
#line 436
test_nc_get_vara_ulonglong(void)
#line 436
{
#line 436
    int ncid;
#line 436
    int d;
#line 436
    int i;
#line 436
    int j;
#line 436
    int k;
#line 436
    int err;
#line 436
    int allInExtRange;	/* all values within external range? */
#line 436
    int allInIntRange;	/* all values within internal range? */
#line 436
    int nels;
#line 436
    int nslabs;
#line 436
    int nok = 0;      /* count of valid comparisons */
#line 436
    size_t start[MAX_RANK];
#line 436
    size_t edge[MAX_RANK];
#line 436
    size_t index[MAX_RANK];
#line 436
    size_t mid[MAX_RANK];
#line 436
    int canConvert;     /* Both text or both numeric */
#line 436
    ulonglong value[MAX_NELS];
#line 436
    double expect[MAX_NELS];
#line 436

#line 436
#ifdef TEST_PNETCDF
#line 436
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 436
#else
#line 436
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 436
#endif
#line 436
    IF (err)
#line 436
	error("nc_open: %s", nc_strerror(err));
#line 436
    for (i = 0; i < numVars; i++) {
#line 436
        canConvert = (var_type[i] == NC_CHAR) == (NCT_ULONGLONG == NCT_TEXT);
#line 436
        assert(var_rank[i] <= MAX_RANK);
#line 436
        assert(var_nels[i] <= MAX_NELS);
#line 436
	for (j = 0; j < var_rank[i]; j++) {
#line 436
	    start[j] = 0;
#line 436
	    edge[j] = 1;
#line 436
	}
#line 436
        err = nc_get_vara_ulonglong(BAD_ID, i, start, edge, value);
#line 436
        IF (err != NC_EBADID)
#line 436
	    error("bad ncid: status = %d", err);
#line 436
        err = nc_get_vara_ulonglong(ncid, BAD_VARID, start, edge, value);
#line 436
        IF (err != NC_ENOTVAR)
#line 436
	    error("bad var id: status = %d", err);
#line 436
	for (j = 0; j < var_rank[i]; j++) {
#line 436
	    start[j] = var_shape[i][j];
#line 436
	    err = nc_get_vara_ulonglong(ncid, i, start, edge, value);
#line 436
            IF (canConvert && err != NC_EINVALCOORDS)
#line 436
                error("bad index: status = %d", err);
#line 436
	    start[j] = 0;
#line 436
	    edge[j] = var_shape[i][j] + 1;
#line 436
	    err = nc_get_vara_ulonglong(ncid, i, start, edge, value);
#line 436
            IF (canConvert && err != NC_EEDGE)
#line 436
		error("bad edge: status = %d", err);
#line 436
	    edge[j] = 1;
#line 436
	}
#line 436
            /* Check non-scalars for correct error returned even when */
#line 436
            /* there is nothing to get (edge[j]==0) */
#line 436
	if(var_rank[i] > 0) {
#line 436
	    for (j = 0; j < var_rank[i]; j++) {
#line 436
		edge[j] = 0;
#line 436
	    }
#line 436
	    err = nc_get_vara_ulonglong(BAD_ID, i, start, edge, value);
#line 436
	    IF (err != NC_EBADID) 
#line 436
		error("bad ncid: status = %d", err);
#line 436
	    err = nc_get_vara_ulonglong(ncid, BAD_VARID, start, edge, value);
#line 436
	    IF (err != NC_ENOTVAR) 
#line 436
		error("bad var id: status = %d", err);
#line 436
	    for (j = 0; j < var_rank[i]; j++) {
#line 436
		if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 436
		    start[j] = var_shape[i][j];
#line 436
		    err = nc_get_vara_ulonglong(ncid, i, start, edge, value);
#line 436
		    IF (canConvert && err != NC_EINVALCOORDS)
#line 436
			error("bad start: status = %d", err);
#line 436
		    start[j] = 0;
#line 436
		}
#line 436
	    }
#line 436
	    err = nc_get_vara_ulonglong(ncid, i, start, edge, value);
#line 436
	    if (canConvert) {
#line 436
		IF (err) 
#line 436
		    error("%s", nc_strerror(err));
#line 436
	    } else {
#line 436
		IF (err != NC_ECHAR)
#line 436
		    error("wrong type: status = %d", err);
#line 436
	    }
#line 436
	    for (j = 0; j < var_rank[i]; j++) {
#line 436
		edge[j] = 1;
#line 436
	    }
#line 436
	}            /* Choose a random point dividing each dim into 2 parts */
#line 436
            /* get 2^rank (nslabs) slabs so defined */
#line 436
        nslabs = 1;
#line 436
        for (j = 0; j < var_rank[i]; j++) {
#line 436
            mid[j] = roll( var_shape[i][j] );
#line 436
            nslabs *= 2;
#line 436
        }
#line 436
            /* bits of k determine whether to get lower or upper part of dim */
#line 436
        for (k = 0; k < nslabs; k++) {
#line 436
            nels = 1;
#line 436
            for (j = 0; j < var_rank[i]; j++) {
#line 436
                if ((k >> j) & 1) {
#line 436
                    start[j] = 0;
#line 436
                    edge[j] = mid[j];
#line 436
                }else{
#line 436
                    start[j] = mid[j];
#line 436
                    edge[j] = var_shape[i][j] - mid[j];
#line 436
                }
#line 436
                nels *= edge[j];
#line 436
            }
#line 436
	    allInExtRange = allInIntRange = 1;
#line 436
            for (j = 0; j < nels; j++) {
#line 436
                err = toMixedBase(j, var_rank[i], edge, index);
#line 436
                IF (err)
#line 436
                    error("error in toMixedBase 1");
#line 436
                for (d = 0; d < var_rank[i]; d++)
#line 436
                    index[d] += start[d];
#line 436
                expect[j] = hash4(var_type[i], var_rank[i], index, NCT_ULONGLONG);
#line 436
		if (inRange3(expect[j],var_type[i], NCT_ULONGLONG)) {
#line 436
		    allInIntRange = allInIntRange && expect[j] >= ulonglong_min
#line 436
				&& expect[j] <= ulonglong_max;
#line 436
		} else {
#line 436
		    allInExtRange = 0;
#line 436
		}
#line 436
	    }
#line 436
            if (var_rank[i] == 0 && i%2)
#line 436
		err = nc_get_vara_ulonglong(ncid, i, NULL, NULL, value);
#line 436
	    else
#line 436
		err = nc_get_vara_ulonglong(ncid, i, start, edge, value);
#line 436
            if (canConvert) {
#line 436
		if (allInExtRange) {
#line 436
		    if (allInIntRange) {
#line 436
			IF (err)
#line 436
			    error("%s", nc_strerror(err));
#line 436
		    } else {
#line 436
			IF (err != NC_ERANGE)
#line 436
			    error("Range error: status = %d", err);
#line 436
		    }
#line 436
		} else {
#line 436
		    IF (err != 0 && err != NC_ERANGE)
#line 436
			error("OK or Range error: status = %d", err);
#line 436
		}
#line 436
		for (j = 0; j < nels; j++) {
#line 436
		    if (inRange3(expect[j],var_type[i],NCT_ULONGLONG)
#line 436
			    && expect[j] >= ulonglong_min && expect[j] <= ulonglong_max) {
#line 436
			IF (!equal(value[j],expect[j],var_type[i],NCT_ULONGLONG)){
#line 436
			    error("value read not that expected");
#line 436
			    if (verbose) {
#line 436
				error("\n");
#line 436
				error("varid: %d, ", i);
#line 436
				error("var_name: %s, ", var_name[i]);
#line 436
				error("element number: %d ", j);
#line 436
				error("expect: %g", expect[j]);
#line 436
				error("got: %g", (double) value[j]);
#line 436
			    }
#line 436
			} else {
#line 436
			    nok++;
#line 436
			}
#line 436
		    }
#line 436
		}
#line 436
            } else {
#line 436
                IF (nels > 0 && err != NC_ECHAR)
#line 436
                    error("wrong type: status = %d", err);
#line 436
            }
#line 436
        }
#line 436
    }
#line 436
    err = nc_close(ncid);
#line 436
    IF (err)
#line 436
	error("nc_close: %s", nc_strerror(err));
#line 436
    print_nok(nok);
#line 436
}
#line 436



#line 622

void
#line 623
test_nc_get_vars_text(void)
#line 623
{
#line 623
    int ncid;
#line 623
    int d;
#line 623
    int i;
#line 623
    int j;
#line 623
    int k;
#line 623
    int m;
#line 623
    int err;
#line 623
    int allInExtRange;	/* all values within external range? */
#line 623
    int allInIntRange;	/* all values within internal range? */
#line 623
    int nels;
#line 623
    int nslabs;
#line 623
    int nstarts;        /* number of different starts */
#line 623
    int nok = 0;      /* count of valid comparisons */
#line 623
    size_t start[MAX_RANK];
#line 623
    size_t edge[MAX_RANK];
#line 623
    size_t index[MAX_RANK];
#line 623
    size_t index2[MAX_RANK];
#line 623
    size_t mid[MAX_RANK];
#line 623
    size_t count[MAX_RANK];
#line 623
    size_t sstride[MAX_RANK];
#line 623
    ptrdiff_t stride[MAX_RANK];
#line 623
    int canConvert;     /* Both text or both numeric */
#line 623
    text value[MAX_NELS];
#line 623
    double expect[MAX_NELS];
#line 623

#line 623
#ifdef TEST_PNETCDF
#line 623
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 623
#else
#line 623
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 623
#endif
#line 623
    IF (err)
#line 623
        error("nc_open: %s", nc_strerror(err));
#line 623
    for (i = 0; i < numVars; i++) {
#line 623
        canConvert = (var_type[i] == NC_CHAR) == (NCT_TEXT == NCT_TEXT);
#line 623
        assert(var_rank[i] <= MAX_RANK);
#line 623
        assert(var_nels[i] <= MAX_NELS);
#line 623
        for (j = 0; j < var_rank[i]; j++) {
#line 623
            start[j] = 0;
#line 623
            edge[j] = 1;
#line 623
            stride[j] = 1;
#line 623
        }
#line 623
        err = nc_get_vars_text(BAD_ID, i, start, edge, stride, value);
#line 623
        IF (err != NC_EBADID)
#line 623
            error("bad ncid: status = %d", err);
#line 623
        err = nc_get_vars_text(ncid, BAD_VARID, start, edge, stride, value);
#line 623
        IF (err != NC_ENOTVAR)
#line 623
            error("bad var id: status = %d", err);
#line 623
        for (j = 0; j < var_rank[i]; j++) {
#line 623
            start[j] = var_shape[i][j];
#line 623
            err = nc_get_vars_text(ncid, i, start, edge, stride, value);
#line 623
	  if(!canConvert) {
#line 623
		IF (err != NC_ECHAR)
#line 623
               	    error("conversion: status = %d", err);
#line 623
	  } else {
#line 623
            IF (err != NC_EINVALCOORDS)
#line 623
                error("bad index: status = %d", err);
#line 623
            start[j] = 0;
#line 623
            edge[j] = var_shape[i][j] + 1;
#line 623
            err = nc_get_vars_text(ncid, i, start, edge, stride, value);
#line 623
            IF (err != NC_EEDGE)
#line 623
                error("bad edge: status = %d", err);
#line 623
            edge[j] = 1;
#line 623
            stride[j] = 0;
#line 623
            err = nc_get_vars_text(ncid, i, start, edge, stride, value);
#line 623
            IF (err != NC_ESTRIDE)
#line 623
                error("bad stride: status = %d", err);
#line 623
            stride[j] = 1;
#line 623
	  }
#line 623
        }
#line 623
            /* Choose a random point dividing each dim into 2 parts */
#line 623
            /* get 2^rank (nslabs) slabs so defined */
#line 623
        nslabs = 1;
#line 623
        for (j = 0; j < var_rank[i]; j++) {
#line 623
            mid[j] = roll( var_shape[i][j] );
#line 623
            nslabs *= 2;
#line 623
        }
#line 623
            /* bits of k determine whether to get lower or upper part of dim */
#line 623
            /* choose random stride from 1 to edge */
#line 623
        for (k = 0; k < nslabs; k++) {
#line 623
            nstarts = 1;
#line 623
            for (j = 0; j < var_rank[i]; j++) {
#line 623
                if ((k >> j) & 1) {
#line 623
                    start[j] = 0;
#line 623
                    edge[j] = mid[j];
#line 623
                }else{
#line 623
                    start[j] = mid[j];
#line 623
                    edge[j] = var_shape[i][j] - mid[j];
#line 623
                }
#line 623
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 623
                nstarts *= stride[j];
#line 623
            }
#line 623
            for (m = 0; m < nstarts; m++) {
#line 623
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 623
                IF (err)
#line 623
                    error("error in toMixedBase");
#line 623
                nels = 1;
#line 623
                for (j = 0; j < var_rank[i]; j++) {
#line 623
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 623
                    nels *= count[j];
#line 623
                    index[j] += start[j];
#line 623
                }
#line 623
                        /* Random choice of forward or backward */
#line 623
/* TODO
#line 623
                if ( roll(2) ) {
#line 623
                    for (j = 0; j < var_rank[i]; j++) {
#line 623
                        index[j] += (count[j] - 1) * stride[j];
#line 623
                        stride[j] = -stride[j];
#line 623
                    }
#line 623
                }
#line 623
*/
#line 623
		allInExtRange = allInIntRange = 1;
#line 623
		for (j = 0; j < nels; j++) {
#line 623
		    err = toMixedBase(j, var_rank[i], count, index2);
#line 623
		    IF (err)
#line 623
			error("error in toMixedBase 1");
#line 623
		    for (d = 0; d < var_rank[i]; d++)
#line 623
			index2[d] = index[d] + index2[d] * stride[d];
#line 623
		    expect[j] = hash4(var_type[i], var_rank[i], index2, 
#line 623
			NCT_TEXT);
#line 623
		    if (inRange3(expect[j],var_type[i],NCT_TEXT)) {
#line 623
			allInIntRange = allInIntRange && expect[j] >= text_min
#line 623
			    && expect[j] <= text_max;
#line 623
		    } else {
#line 623
			allInExtRange = 0;
#line 623
		    }
#line 623
		}
#line 623
                if (var_rank[i] == 0 && i%2 )
#line 623
                    err = nc_get_vars_text(ncid, i, NULL, NULL, NULL, value);
#line 623
                else
#line 623
                    err = nc_get_vars_text(ncid, i, index, count, stride, value);
#line 623
		if (canConvert) {
#line 623
		    if (allInExtRange) {
#line 623
			if (allInIntRange) {
#line 623
			    IF (err)
#line 623
				error("%s", nc_strerror(err));
#line 623
			} else {
#line 623
			    IF (err != NC_ERANGE)
#line 623
				error("Range error: status = %d", err);
#line 623
			}
#line 623
		    } else {
#line 623
			IF (err != 0 && err != NC_ERANGE)
#line 623
			    error("OK or Range error: status = %d", err);
#line 623
		    }
#line 623
		    for (j = 0; j < nels; j++) {
#line 623
			if (inRange3(expect[j],var_type[i],NCT_TEXT)
#line 623
				&& expect[j] >= text_min && expect[j] <= text_max) {
#line 623
			    IF (!equal(value[j],expect[j],var_type[i],
#line 623
				    NCT_TEXT)){
#line 623
				error("value read not that expected");
#line 623
				if (verbose) {
#line 623
				    error("\n");
#line 623
				    error("varid: %d, ", i);
#line 623
				    error("var_name: %s, ", var_name[i]);
#line 623
				    error("element number: %d ", j);
#line 623
                                    error("expect: %g, ", expect[j]);
#line 623
				    error("got: %g", (double) value[j]);
#line 623
				}
#line 623
			    } else {
#line 623
				nok++;
#line 623
			    }
#line 623
			}
#line 623
		    }
#line 623
		} else {
#line 623
		    IF (nels > 0 && err != NC_ECHAR)
#line 623
			error("wrong type: status = %d", err);
#line 623
		}
#line 623
	    }
#line 623
	}
#line 623

#line 623
    }
#line 623
    err = nc_close(ncid);
#line 623
    IF (err)
#line 623
        error("nc_close: %s", nc_strerror(err));
#line 623
    print_nok(nok);
#line 623
}
#line 623

void
#line 624
test_nc_get_vars_uchar(void)
#line 624
{
#line 624
    int ncid;
#line 624
    int d;
#line 624
    int i;
#line 624
    int j;
#line 624
    int k;
#line 624
    int m;
#line 624
    int err;
#line 624
    int allInExtRange;	/* all values within external range? */
#line 624
    int allInIntRange;	/* all values within internal range? */
#line 624
    int nels;
#line 624
    int nslabs;
#line 624
    int nstarts;        /* number of different starts */
#line 624
    int nok = 0;      /* count of valid comparisons */
#line 624
    size_t start[MAX_RANK];
#line 624
    size_t edge[MAX_RANK];
#line 624
    size_t index[MAX_RANK];
#line 624
    size_t index2[MAX_RANK];
#line 624
    size_t mid[MAX_RANK];
#line 624
    size_t count[MAX_RANK];
#line 624
    size_t sstride[MAX_RANK];
#line 624
    ptrdiff_t stride[MAX_RANK];
#line 624
    int canConvert;     /* Both text or both numeric */
#line 624
    uchar value[MAX_NELS];
#line 624
    double expect[MAX_NELS];
#line 624

#line 624
#ifdef TEST_PNETCDF
#line 624
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 624
#else
#line 624
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 624
#endif
#line 624
    IF (err)
#line 624
        error("nc_open: %s", nc_strerror(err));
#line 624
    for (i = 0; i < numVars; i++) {
#line 624
        canConvert = (var_type[i] == NC_CHAR) == (NCT_UCHAR == NCT_TEXT);
#line 624
        assert(var_rank[i] <= MAX_RANK);
#line 624
        assert(var_nels[i] <= MAX_NELS);
#line 624
        for (j = 0; j < var_rank[i]; j++) {
#line 624
            start[j] = 0;
#line 624
            edge[j] = 1;
#line 624
            stride[j] = 1;
#line 624
        }
#line 624
        err = nc_get_vars_uchar(BAD_ID, i, start, edge, stride, value);
#line 624
        IF (err != NC_EBADID)
#line 624
            error("bad ncid: status = %d", err);
#line 624
        err = nc_get_vars_uchar(ncid, BAD_VARID, start, edge, stride, value);
#line 624
        IF (err != NC_ENOTVAR)
#line 624
            error("bad var id: status = %d", err);
#line 624
        for (j = 0; j < var_rank[i]; j++) {
#line 624
            start[j] = var_shape[i][j];
#line 624
            err = nc_get_vars_uchar(ncid, i, start, edge, stride, value);
#line 624
	  if(!canConvert) {
#line 624
		IF (err != NC_ECHAR)
#line 624
               	    error("conversion: status = %d", err);
#line 624
	  } else {
#line 624
            IF (err != NC_EINVALCOORDS)
#line 624
                error("bad index: status = %d", err);
#line 624
            start[j] = 0;
#line 624
            edge[j] = var_shape[i][j] + 1;
#line 624
            err = nc_get_vars_uchar(ncid, i, start, edge, stride, value);
#line 624
            IF (err != NC_EEDGE)
#line 624
                error("bad edge: status = %d", err);
#line 624
            edge[j] = 1;
#line 624
            stride[j] = 0;
#line 624
            err = nc_get_vars_uchar(ncid, i, start, edge, stride, value);
#line 624
            IF (err != NC_ESTRIDE)
#line 624
                error("bad stride: status = %d", err);
#line 624
            stride[j] = 1;
#line 624
	  }
#line 624
        }
#line 624
            /* Choose a random point dividing each dim into 2 parts */
#line 624
            /* get 2^rank (nslabs) slabs so defined */
#line 624
        nslabs = 1;
#line 624
        for (j = 0; j < var_rank[i]; j++) {
#line 624
            mid[j] = roll( var_shape[i][j] );
#line 624
            nslabs *= 2;
#line 624
        }
#line 624
            /* bits of k determine whether to get lower or upper part of dim */
#line 624
            /* choose random stride from 1 to edge */
#line 624
        for (k = 0; k < nslabs; k++) {
#line 624
            nstarts = 1;
#line 624
            for (j = 0; j < var_rank[i]; j++) {
#line 624
                if ((k >> j) & 1) {
#line 624
                    start[j] = 0;
#line 624
                    edge[j] = mid[j];
#line 624
                }else{
#line 624
                    start[j] = mid[j];
#line 624
                    edge[j] = var_shape[i][j] - mid[j];
#line 624
                }
#line 624
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 624
                nstarts *= stride[j];
#line 624
            }
#line 624
            for (m = 0; m < nstarts; m++) {
#line 624
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 624
                IF (err)
#line 624
                    error("error in toMixedBase");
#line 624
                nels = 1;
#line 624
                for (j = 0; j < var_rank[i]; j++) {
#line 624
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 624
                    nels *= count[j];
#line 624
                    index[j] += start[j];
#line 624
                }
#line 624
                        /* Random choice of forward or backward */
#line 624
/* TODO
#line 624
                if ( roll(2) ) {
#line 624
                    for (j = 0; j < var_rank[i]; j++) {
#line 624
                        index[j] += (count[j] - 1) * stride[j];
#line 624
                        stride[j] = -stride[j];
#line 624
                    }
#line 624
                }
#line 624
*/
#line 624
		allInExtRange = allInIntRange = 1;
#line 624
		for (j = 0; j < nels; j++) {
#line 624
		    err = toMixedBase(j, var_rank[i], count, index2);
#line 624
		    IF (err)
#line 624
			error("error in toMixedBase 1");
#line 624
		    for (d = 0; d < var_rank[i]; d++)
#line 624
			index2[d] = index[d] + index2[d] * stride[d];
#line 624
		    expect[j] = hash4(var_type[i], var_rank[i], index2, 
#line 624
			NCT_UCHAR);
#line 624
		    if (inRange3(expect[j],var_type[i],NCT_UCHAR)) {
#line 624
			allInIntRange = allInIntRange && expect[j] >= uchar_min
#line 624
			    && expect[j] <= uchar_max;
#line 624
		    } else {
#line 624
			allInExtRange = 0;
#line 624
		    }
#line 624
		}
#line 624
                if (var_rank[i] == 0 && i%2 )
#line 624
                    err = nc_get_vars_uchar(ncid, i, NULL, NULL, NULL, value);
#line 624
                else
#line 624
                    err = nc_get_vars_uchar(ncid, i, index, count, stride, value);
#line 624
		if (canConvert) {
#line 624
		    if (allInExtRange) {
#line 624
			if (allInIntRange) {
#line 624
			    IF (err)
#line 624
				error("%s", nc_strerror(err));
#line 624
			} else {
#line 624
			    IF (err != NC_ERANGE)
#line 624
				error("Range error: status = %d", err);
#line 624
			}
#line 624
		    } else {
#line 624
			IF (err != 0 && err != NC_ERANGE)
#line 624
			    error("OK or Range error: status = %d", err);
#line 624
		    }
#line 624
		    for (j = 0; j < nels; j++) {
#line 624
			if (inRange3(expect[j],var_type[i],NCT_UCHAR)
#line 624
				&& expect[j] >= uchar_min && expect[j] <= uchar_max) {
#line 624
			    IF (!equal(value[j],expect[j],var_type[i],
#line 624
				    NCT_UCHAR)){
#line 624
				error("value read not that expected");
#line 624
				if (verbose) {
#line 624
				    error("\n");
#line 624
				    error("varid: %d, ", i);
#line 624
				    error("var_name: %s, ", var_name[i]);
#line 624
				    error("element number: %d ", j);
#line 624
                                    error("expect: %g, ", expect[j]);
#line 624
				    error("got: %g", (double) value[j]);
#line 624
				}
#line 624
			    } else {
#line 624
				nok++;
#line 624
			    }
#line 624
			}
#line 624
		    }
#line 624
		} else {
#line 624
		    IF (nels > 0 && err != NC_ECHAR)
#line 624
			error("wrong type: status = %d", err);
#line 624
		}
#line 624
	    }
#line 624
	}
#line 624

#line 624
    }
#line 624
    err = nc_close(ncid);
#line 624
    IF (err)
#line 624
        error("nc_close: %s", nc_strerror(err));
#line 624
    print_nok(nok);
#line 624
}
#line 624

void
#line 625
test_nc_get_vars_schar(void)
#line 625
{
#line 625
    int ncid;
#line 625
    int d;
#line 625
    int i;
#line 625
    int j;
#line 625
    int k;
#line 625
    int m;
#line 625
    int err;
#line 625
    int allInExtRange;	/* all values within external range? */
#line 625
    int allInIntRange;	/* all values within internal range? */
#line 625
    int nels;
#line 625
    int nslabs;
#line 625
    int nstarts;        /* number of different starts */
#line 625
    int nok = 0;      /* count of valid comparisons */
#line 625
    size_t start[MAX_RANK];
#line 625
    size_t edge[MAX_RANK];
#line 625
    size_t index[MAX_RANK];
#line 625
    size_t index2[MAX_RANK];
#line 625
    size_t mid[MAX_RANK];
#line 625
    size_t count[MAX_RANK];
#line 625
    size_t sstride[MAX_RANK];
#line 625
    ptrdiff_t stride[MAX_RANK];
#line 625
    int canConvert;     /* Both text or both numeric */
#line 625
    schar value[MAX_NELS];
#line 625
    double expect[MAX_NELS];
#line 625

#line 625
#ifdef TEST_PNETCDF
#line 625
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 625
#else
#line 625
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 625
#endif
#line 625
    IF (err)
#line 625
        error("nc_open: %s", nc_strerror(err));
#line 625
    for (i = 0; i < numVars; i++) {
#line 625
        canConvert = (var_type[i] == NC_CHAR) == (NCT_SCHAR == NCT_TEXT);
#line 625
        assert(var_rank[i] <= MAX_RANK);
#line 625
        assert(var_nels[i] <= MAX_NELS);
#line 625
        for (j = 0; j < var_rank[i]; j++) {
#line 625
            start[j] = 0;
#line 625
            edge[j] = 1;
#line 625
            stride[j] = 1;
#line 625
        }
#line 625
        err = nc_get_vars_schar(BAD_ID, i, start, edge, stride, value);
#line 625
        IF (err != NC_EBADID)
#line 625
            error("bad ncid: status = %d", err);
#line 625
        err = nc_get_vars_schar(ncid, BAD_VARID, start, edge, stride, value);
#line 625
        IF (err != NC_ENOTVAR)
#line 625
            error("bad var id: status = %d", err);
#line 625
        for (j = 0; j < var_rank[i]; j++) {
#line 625
            start[j] = var_shape[i][j];
#line 625
            err = nc_get_vars_schar(ncid, i, start, edge, stride, value);
#line 625
	  if(!canConvert) {
#line 625
		IF (err != NC_ECHAR)
#line 625
               	    error("conversion: status = %d", err);
#line 625
	  } else {
#line 625
            IF (err != NC_EINVALCOORDS)
#line 625
                error("bad index: status = %d", err);
#line 625
            start[j] = 0;
#line 625
            edge[j] = var_shape[i][j] + 1;
#line 625
            err = nc_get_vars_schar(ncid, i, start, edge, stride, value);
#line 625
            IF (err != NC_EEDGE)
#line 625
                error("bad edge: status = %d", err);
#line 625
            edge[j] = 1;
#line 625
            stride[j] = 0;
#line 625
            err = nc_get_vars_schar(ncid, i, start, edge, stride, value);
#line 625
            IF (err != NC_ESTRIDE)
#line 625
                error("bad stride: status = %d", err);
#line 625
            stride[j] = 1;
#line 625
	  }
#line 625
        }
#line 625
            /* Choose a random point dividing each dim into 2 parts */
#line 625
            /* get 2^rank (nslabs) slabs so defined */
#line 625
        nslabs = 1;
#line 625
        for (j = 0; j < var_rank[i]; j++) {
#line 625
            mid[j] = roll( var_shape[i][j] );
#line 625
            nslabs *= 2;
#line 625
        }
#line 625
            /* bits of k determine whether to get lower or upper part of dim */
#line 625
            /* choose random stride from 1 to edge */
#line 625
        for (k = 0; k < nslabs; k++) {
#line 625
            nstarts = 1;
#line 625
            for (j = 0; j < var_rank[i]; j++) {
#line 625
                if ((k >> j) & 1) {
#line 625
                    start[j] = 0;
#line 625
                    edge[j] = mid[j];
#line 625
                }else{
#line 625
                    start[j] = mid[j];
#line 625
                    edge[j] = var_shape[i][j] - mid[j];
#line 625
                }
#line 625
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 625
                nstarts *= stride[j];
#line 625
            }
#line 625
            for (m = 0; m < nstarts; m++) {
#line 625
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 625
                IF (err)
#line 625
                    error("error in toMixedBase");
#line 625
                nels = 1;
#line 625
                for (j = 0; j < var_rank[i]; j++) {
#line 625
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 625
                    nels *= count[j];
#line 625
                    index[j] += start[j];
#line 625
                }
#line 625
                        /* Random choice of forward or backward */
#line 625
/* TODO
#line 625
                if ( roll(2) ) {
#line 625
                    for (j = 0; j < var_rank[i]; j++) {
#line 625
                        index[j] += (count[j] - 1) * stride[j];
#line 625
                        stride[j] = -stride[j];
#line 625
                    }
#line 625
                }
#line 625
*/
#line 625
		allInExtRange = allInIntRange = 1;
#line 625
		for (j = 0; j < nels; j++) {
#line 625
		    err = toMixedBase(j, var_rank[i], count, index2);
#line 625
		    IF (err)
#line 625
			error("error in toMixedBase 1");
#line 625
		    for (d = 0; d < var_rank[i]; d++)
#line 625
			index2[d] = index[d] + index2[d] * stride[d];
#line 625
		    expect[j] = hash4(var_type[i], var_rank[i], index2, 
#line 625
			NCT_SCHAR);
#line 625
		    if (inRange3(expect[j],var_type[i],NCT_SCHAR)) {
#line 625
			allInIntRange = allInIntRange && expect[j] >= schar_min
#line 625
			    && expect[j] <= schar_max;
#line 625
		    } else {
#line 625
			allInExtRange = 0;
#line 625
		    }
#line 625
		}
#line 625
                if (var_rank[i] == 0 && i%2 )
#line 625
                    err = nc_get_vars_schar(ncid, i, NULL, NULL, NULL, value);
#line 625
                else
#line 625
                    err = nc_get_vars_schar(ncid, i, index, count, stride, value);
#line 625
		if (canConvert) {
#line 625
		    if (allInExtRange) {
#line 625
			if (allInIntRange) {
#line 625
			    IF (err)
#line 625
				error("%s", nc_strerror(err));
#line 625
			} else {
#line 625
			    IF (err != NC_ERANGE)
#line 625
				error("Range error: status = %d", err);
#line 625
			}
#line 625
		    } else {
#line 625
			IF (err != 0 && err != NC_ERANGE)
#line 625
			    error("OK or Range error: status = %d", err);
#line 625
		    }
#line 625
		    for (j = 0; j < nels; j++) {
#line 625
			if (inRange3(expect[j],var_type[i],NCT_SCHAR)
#line 625
				&& expect[j] >= schar_min && expect[j] <= schar_max) {
#line 625
			    IF (!equal(value[j],expect[j],var_type[i],
#line 625
				    NCT_SCHAR)){
#line 625
				error("value read not that expected");
#line 625
				if (verbose) {
#line 625
				    error("\n");
#line 625
				    error("varid: %d, ", i);
#line 625
				    error("var_name: %s, ", var_name[i]);
#line 625
				    error("element number: %d ", j);
#line 625
                                    error("expect: %g, ", expect[j]);
#line 625
				    error("got: %g", (double) value[j]);
#line 625
				}
#line 625
			    } else {
#line 625
				nok++;
#line 625
			    }
#line 625
			}
#line 625
		    }
#line 625
		} else {
#line 625
		    IF (nels > 0 && err != NC_ECHAR)
#line 625
			error("wrong type: status = %d", err);
#line 625
		}
#line 625
	    }
#line 625
	}
#line 625

#line 625
    }
#line 625
    err = nc_close(ncid);
#line 625
    IF (err)
#line 625
        error("nc_close: %s", nc_strerror(err));
#line 625
    print_nok(nok);
#line 625
}
#line 625

void
#line 626
test_nc_get_vars_short(void)
#line 626
{
#line 626
    int ncid;
#line 626
    int d;
#line 626
    int i;
#line 626
    int j;
#line 626
    int k;
#line 626
    int m;
#line 626
    int err;
#line 626
    int allInExtRange;	/* all values within external range? */
#line 626
    int allInIntRange;	/* all values within internal range? */
#line 626
    int nels;
#line 626
    int nslabs;
#line 626
    int nstarts;        /* number of different starts */
#line 626
    int nok = 0;      /* count of valid comparisons */
#line 626
    size_t start[MAX_RANK];
#line 626
    size_t edge[MAX_RANK];
#line 626
    size_t index[MAX_RANK];
#line 626
    size_t index2[MAX_RANK];
#line 626
    size_t mid[MAX_RANK];
#line 626
    size_t count[MAX_RANK];
#line 626
    size_t sstride[MAX_RANK];
#line 626
    ptrdiff_t stride[MAX_RANK];
#line 626
    int canConvert;     /* Both text or both numeric */
#line 626
    short value[MAX_NELS];
#line 626
    double expect[MAX_NELS];
#line 626

#line 626
#ifdef TEST_PNETCDF
#line 626
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 626
#else
#line 626
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 626
#endif
#line 626
    IF (err)
#line 626
        error("nc_open: %s", nc_strerror(err));
#line 626
    for (i = 0; i < numVars; i++) {
#line 626
        canConvert = (var_type[i] == NC_CHAR) == (NCT_SHORT == NCT_TEXT);
#line 626
        assert(var_rank[i] <= MAX_RANK);
#line 626
        assert(var_nels[i] <= MAX_NELS);
#line 626
        for (j = 0; j < var_rank[i]; j++) {
#line 626
            start[j] = 0;
#line 626
            edge[j] = 1;
#line 626
            stride[j] = 1;
#line 626
        }
#line 626
        err = nc_get_vars_short(BAD_ID, i, start, edge, stride, value);
#line 626
        IF (err != NC_EBADID)
#line 626
            error("bad ncid: status = %d", err);
#line 626
        err = nc_get_vars_short(ncid, BAD_VARID, start, edge, stride, value);
#line 626
        IF (err != NC_ENOTVAR)
#line 626
            error("bad var id: status = %d", err);
#line 626
        for (j = 0; j < var_rank[i]; j++) {
#line 626
            start[j] = var_shape[i][j];
#line 626
            err = nc_get_vars_short(ncid, i, start, edge, stride, value);
#line 626
	  if(!canConvert) {
#line 626
		IF (err != NC_ECHAR)
#line 626
               	    error("conversion: status = %d", err);
#line 626
	  } else {
#line 626
            IF (err != NC_EINVALCOORDS)
#line 626
                error("bad index: status = %d", err);
#line 626
            start[j] = 0;
#line 626
            edge[j] = var_shape[i][j] + 1;
#line 626
            err = nc_get_vars_short(ncid, i, start, edge, stride, value);
#line 626
            IF (err != NC_EEDGE)
#line 626
                error("bad edge: status = %d", err);
#line 626
            edge[j] = 1;
#line 626
            stride[j] = 0;
#line 626
            err = nc_get_vars_short(ncid, i, start, edge, stride, value);
#line 626
            IF (err != NC_ESTRIDE)
#line 626
                error("bad stride: status = %d", err);
#line 626
            stride[j] = 1;
#line 626
	  }
#line 626
        }
#line 626
            /* Choose a random point dividing each dim into 2 parts */
#line 626
            /* get 2^rank (nslabs) slabs so defined */
#line 626
        nslabs = 1;
#line 626
        for (j = 0; j < var_rank[i]; j++) {
#line 626
            mid[j] = roll( var_shape[i][j] );
#line 626
            nslabs *= 2;
#line 626
        }
#line 626
            /* bits of k determine whether to get lower or upper part of dim */
#line 626
            /* choose random stride from 1 to edge */
#line 626
        for (k = 0; k < nslabs; k++) {
#line 626
            nstarts = 1;
#line 626
            for (j = 0; j < var_rank[i]; j++) {
#line 626
                if ((k >> j) & 1) {
#line 626
                    start[j] = 0;
#line 626
                    edge[j] = mid[j];
#line 626
                }else{
#line 626
                    start[j] = mid[j];
#line 626
                    edge[j] = var_shape[i][j] - mid[j];
#line 626
                }
#line 626
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 626
                nstarts *= stride[j];
#line 626
            }
#line 626
            for (m = 0; m < nstarts; m++) {
#line 626
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 626
                IF (err)
#line 626
                    error("error in toMixedBase");
#line 626
                nels = 1;
#line 626
                for (j = 0; j < var_rank[i]; j++) {
#line 626
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 626
                    nels *= count[j];
#line 626
                    index[j] += start[j];
#line 626
                }
#line 626
                        /* Random choice of forward or backward */
#line 626
/* TODO
#line 626
                if ( roll(2) ) {
#line 626
                    for (j = 0; j < var_rank[i]; j++) {
#line 626
                        index[j] += (count[j] - 1) * stride[j];
#line 626
                        stride[j] = -stride[j];
#line 626
                    }
#line 626
                }
#line 626
*/
#line 626
		allInExtRange = allInIntRange = 1;
#line 626
		for (j = 0; j < nels; j++) {
#line 626
		    err = toMixedBase(j, var_rank[i], count, index2);
#line 626
		    IF (err)
#line 626
			error("error in toMixedBase 1");
#line 626
		    for (d = 0; d < var_rank[i]; d++)
#line 626
			index2[d] = index[d] + index2[d] * stride[d];
#line 626
		    expect[j] = hash4(var_type[i], var_rank[i], index2, 
#line 626
			NCT_SHORT);
#line 626
		    if (inRange3(expect[j],var_type[i],NCT_SHORT)) {
#line 626
			allInIntRange = allInIntRange && expect[j] >= short_min
#line 626
			    && expect[j] <= short_max;
#line 626
		    } else {
#line 626
			allInExtRange = 0;
#line 626
		    }
#line 626
		}
#line 626
                if (var_rank[i] == 0 && i%2 )
#line 626
                    err = nc_get_vars_short(ncid, i, NULL, NULL, NULL, value);
#line 626
                else
#line 626
                    err = nc_get_vars_short(ncid, i, index, count, stride, value);
#line 626
		if (canConvert) {
#line 626
		    if (allInExtRange) {
#line 626
			if (allInIntRange) {
#line 626
			    IF (err)
#line 626
				error("%s", nc_strerror(err));
#line 626
			} else {
#line 626
			    IF (err != NC_ERANGE)
#line 626
				error("Range error: status = %d", err);
#line 626
			}
#line 626
		    } else {
#line 626
			IF (err != 0 && err != NC_ERANGE)
#line 626
			    error("OK or Range error: status = %d", err);
#line 626
		    }
#line 626
		    for (j = 0; j < nels; j++) {
#line 626
			if (inRange3(expect[j],var_type[i],NCT_SHORT)
#line 626
				&& expect[j] >= short_min && expect[j] <= short_max) {
#line 626
			    IF (!equal(value[j],expect[j],var_type[i],
#line 626
				    NCT_SHORT)){
#line 626
				error("value read not that expected");
#line 626
				if (verbose) {
#line 626
				    error("\n");
#line 626
				    error("varid: %d, ", i);
#line 626
				    error("var_name: %s, ", var_name[i]);
#line 626
				    error("element number: %d ", j);
#line 626
                                    error("expect: %g, ", expect[j]);
#line 626
				    error("got: %g", (double) value[j]);
#line 626
				}
#line 626
			    } else {
#line 626
				nok++;
#line 626
			    }
#line 626
			}
#line 626
		    }
#line 626
		} else {
#line 626
		    IF (nels > 0 && err != NC_ECHAR)
#line 626
			error("wrong type: status = %d", err);
#line 626
		}
#line 626
	    }
#line 626
	}
#line 626

#line 626
    }
#line 626
    err = nc_close(ncid);
#line 626
    IF (err)
#line 626
        error("nc_close: %s", nc_strerror(err));
#line 626
    print_nok(nok);
#line 626
}
#line 626

void
#line 627
test_nc_get_vars_int(void)
#line 627
{
#line 627
    int ncid;
#line 627
    int d;
#line 627
    int i;
#line 627
    int j;
#line 627
    int k;
#line 627
    int m;
#line 627
    int err;
#line 627
    int allInExtRange;	/* all values within external range? */
#line 627
    int allInIntRange;	/* all values within internal range? */
#line 627
    int nels;
#line 627
    int nslabs;
#line 627
    int nstarts;        /* number of different starts */
#line 627
    int nok = 0;      /* count of valid comparisons */
#line 627
    size_t start[MAX_RANK];
#line 627
    size_t edge[MAX_RANK];
#line 627
    size_t index[MAX_RANK];
#line 627
    size_t index2[MAX_RANK];
#line 627
    size_t mid[MAX_RANK];
#line 627
    size_t count[MAX_RANK];
#line 627
    size_t sstride[MAX_RANK];
#line 627
    ptrdiff_t stride[MAX_RANK];
#line 627
    int canConvert;     /* Both text or both numeric */
#line 627
    int value[MAX_NELS];
#line 627
    double expect[MAX_NELS];
#line 627

#line 627
#ifdef TEST_PNETCDF
#line 627
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 627
#else
#line 627
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 627
#endif
#line 627
    IF (err)
#line 627
        error("nc_open: %s", nc_strerror(err));
#line 627
    for (i = 0; i < numVars; i++) {
#line 627
        canConvert = (var_type[i] == NC_CHAR) == (NCT_INT == NCT_TEXT);
#line 627
        assert(var_rank[i] <= MAX_RANK);
#line 627
        assert(var_nels[i] <= MAX_NELS);
#line 627
        for (j = 0; j < var_rank[i]; j++) {
#line 627
            start[j] = 0;
#line 627
            edge[j] = 1;
#line 627
            stride[j] = 1;
#line 627
        }
#line 627
        err = nc_get_vars_int(BAD_ID, i, start, edge, stride, value);
#line 627
        IF (err != NC_EBADID)
#line 627
            error("bad ncid: status = %d", err);
#line 627
        err = nc_get_vars_int(ncid, BAD_VARID, start, edge, stride, value);
#line 627
        IF (err != NC_ENOTVAR)
#line 627
            error("bad var id: status = %d", err);
#line 627
        for (j = 0; j < var_rank[i]; j++) {
#line 627
            start[j] = var_shape[i][j];
#line 627
            err = nc_get_vars_int(ncid, i, start, edge, stride, value);
#line 627
	  if(!canConvert) {
#line 627
		IF (err != NC_ECHAR)
#line 627
               	    error("conversion: status = %d", err);
#line 627
	  } else {
#line 627
            IF (err != NC_EINVALCOORDS)
#line 627
                error("bad index: status = %d", err);
#line 627
            start[j] = 0;
#line 627
            edge[j] = var_shape[i][j] + 1;
#line 627
            err = nc_get_vars_int(ncid, i, start, edge, stride, value);
#line 627
            IF (err != NC_EEDGE)
#line 627
                error("bad edge: status = %d", err);
#line 627
            edge[j] = 1;
#line 627
            stride[j] = 0;
#line 627
            err = nc_get_vars_int(ncid, i, start, edge, stride, value);
#line 627
            IF (err != NC_ESTRIDE)
#line 627
                error("bad stride: status = %d", err);
#line 627
            stride[j] = 1;
#line 627
	  }
#line 627
        }
#line 627
            /* Choose a random point dividing each dim into 2 parts */
#line 627
            /* get 2^rank (nslabs) slabs so defined */
#line 627
        nslabs = 1;
#line 627
        for (j = 0; j < var_rank[i]; j++) {
#line 627
            mid[j] = roll( var_shape[i][j] );
#line 627
            nslabs *= 2;
#line 627
        }
#line 627
            /* bits of k determine whether to get lower or upper part of dim */
#line 627
            /* choose random stride from 1 to edge */
#line 627
        for (k = 0; k < nslabs; k++) {
#line 627
            nstarts = 1;
#line 627
            for (j = 0; j < var_rank[i]; j++) {
#line 627
                if ((k >> j) & 1) {
#line 627
                    start[j] = 0;
#line 627
                    edge[j] = mid[j];
#line 627
                }else{
#line 627
                    start[j] = mid[j];
#line 627
                    edge[j] = var_shape[i][j] - mid[j];
#line 627
                }
#line 627
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 627
                nstarts *= stride[j];
#line 627
            }
#line 627
            for (m = 0; m < nstarts; m++) {
#line 627
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 627
                IF (err)
#line 627
                    error("error in toMixedBase");
#line 627
                nels = 1;
#line 627
                for (j = 0; j < var_rank[i]; j++) {
#line 627
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 627
                    nels *= count[j];
#line 627
                    index[j] += start[j];
#line 627
                }
#line 627
                        /* Random choice of forward or backward */
#line 627
/* TODO
#line 627
                if ( roll(2) ) {
#line 627
                    for (j = 0; j < var_rank[i]; j++) {
#line 627
                        index[j] += (count[j] - 1) * stride[j];
#line 627
                        stride[j] = -stride[j];
#line 627
                    }
#line 627
                }
#line 627
*/
#line 627
		allInExtRange = allInIntRange = 1;
#line 627
		for (j = 0; j < nels; j++) {
#line 627
		    err = toMixedBase(j, var_rank[i], count, index2);
#line 627
		    IF (err)
#line 627
			error("error in toMixedBase 1");
#line 627
		    for (d = 0; d < var_rank[i]; d++)
#line 627
			index2[d] = index[d] + index2[d] * stride[d];
#line 627
		    expect[j] = hash4(var_type[i], var_rank[i], index2, 
#line 627
			NCT_INT);
#line 627
		    if (inRange3(expect[j],var_type[i],NCT_INT)) {
#line 627
			allInIntRange = allInIntRange && expect[j] >= int_min
#line 627
			    && expect[j] <= int_max;
#line 627
		    } else {
#line 627
			allInExtRange = 0;
#line 627
		    }
#line 627
		}
#line 627
                if (var_rank[i] == 0 && i%2 )
#line 627
                    err = nc_get_vars_int(ncid, i, NULL, NULL, NULL, value);
#line 627
                else
#line 627
                    err = nc_get_vars_int(ncid, i, index, count, stride, value);
#line 627
		if (canConvert) {
#line 627
		    if (allInExtRange) {
#line 627
			if (allInIntRange) {
#line 627
			    IF (err)
#line 627
				error("%s", nc_strerror(err));
#line 627
			} else {
#line 627
			    IF (err != NC_ERANGE)
#line 627
				error("Range error: status = %d", err);
#line 627
			}
#line 627
		    } else {
#line 627
			IF (err != 0 && err != NC_ERANGE)
#line 627
			    error("OK or Range error: status = %d", err);
#line 627
		    }
#line 627
		    for (j = 0; j < nels; j++) {
#line 627
			if (inRange3(expect[j],var_type[i],NCT_INT)
#line 627
				&& expect[j] >= int_min && expect[j] <= int_max) {
#line 627
			    IF (!equal(value[j],expect[j],var_type[i],
#line 627
				    NCT_INT)){
#line 627
				error("value read not that expected");
#line 627
				if (verbose) {
#line 627
				    error("\n");
#line 627
				    error("varid: %d, ", i);
#line 627
				    error("var_name: %s, ", var_name[i]);
#line 627
				    error("element number: %d ", j);
#line 627
                                    error("expect: %g, ", expect[j]);
#line 627
				    error("got: %g", (double) value[j]);
#line 627
				}
#line 627
			    } else {
#line 627
				nok++;
#line 627
			    }
#line 627
			}
#line 627
		    }
#line 627
		} else {
#line 627
		    IF (nels > 0 && err != NC_ECHAR)
#line 627
			error("wrong type: status = %d", err);
#line 627
		}
#line 627
	    }
#line 627
	}
#line 627

#line 627
    }
#line 627
    err = nc_close(ncid);
#line 627
    IF (err)
#line 627
        error("nc_close: %s", nc_strerror(err));
#line 627
    print_nok(nok);
#line 627
}
#line 627

void
#line 628
test_nc_get_vars_long(void)
#line 628
{
#line 628
    int ncid;
#line 628
    int d;
#line 628
    int i;
#line 628
    int j;
#line 628
    int k;
#line 628
    int m;
#line 628
    int err;
#line 628
    int allInExtRange;	/* all values within external range? */
#line 628
    int allInIntRange;	/* all values within internal range? */
#line 628
    int nels;
#line 628
    int nslabs;
#line 628
    int nstarts;        /* number of different starts */
#line 628
    int nok = 0;      /* count of valid comparisons */
#line 628
    size_t start[MAX_RANK];
#line 628
    size_t edge[MAX_RANK];
#line 628
    size_t index[MAX_RANK];
#line 628
    size_t index2[MAX_RANK];
#line 628
    size_t mid[MAX_RANK];
#line 628
    size_t count[MAX_RANK];
#line 628
    size_t sstride[MAX_RANK];
#line 628
    ptrdiff_t stride[MAX_RANK];
#line 628
    int canConvert;     /* Both text or both numeric */
#line 628
    long value[MAX_NELS];
#line 628
    double expect[MAX_NELS];
#line 628

#line 628
#ifdef TEST_PNETCDF
#line 628
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 628
#else
#line 628
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 628
#endif
#line 628
    IF (err)
#line 628
        error("nc_open: %s", nc_strerror(err));
#line 628
    for (i = 0; i < numVars; i++) {
#line 628
        canConvert = (var_type[i] == NC_CHAR) == (NCT_LONG == NCT_TEXT);
#line 628
        assert(var_rank[i] <= MAX_RANK);
#line 628
        assert(var_nels[i] <= MAX_NELS);
#line 628
        for (j = 0; j < var_rank[i]; j++) {
#line 628
            start[j] = 0;
#line 628
            edge[j] = 1;
#line 628
            stride[j] = 1;
#line 628
        }
#line 628
        err = nc_get_vars_long(BAD_ID, i, start, edge, stride, value);
#line 628
        IF (err != NC_EBADID)
#line 628
            error("bad ncid: status = %d", err);
#line 628
        err = nc_get_vars_long(ncid, BAD_VARID, start, edge, stride, value);
#line 628
        IF (err != NC_ENOTVAR)
#line 628
            error("bad var id: status = %d", err);
#line 628
        for (j = 0; j < var_rank[i]; j++) {
#line 628
            start[j] = var_shape[i][j];
#line 628
            err = nc_get_vars_long(ncid, i, start, edge, stride, value);
#line 628
	  if(!canConvert) {
#line 628
		IF (err != NC_ECHAR)
#line 628
               	    error("conversion: status = %d", err);
#line 628
	  } else {
#line 628
            IF (err != NC_EINVALCOORDS)
#line 628
                error("bad index: status = %d", err);
#line 628
            start[j] = 0;
#line 628
            edge[j] = var_shape[i][j] + 1;
#line 628
            err = nc_get_vars_long(ncid, i, start, edge, stride, value);
#line 628
            IF (err != NC_EEDGE)
#line 628
                error("bad edge: status = %d", err);
#line 628
            edge[j] = 1;
#line 628
            stride[j] = 0;
#line 628
            err = nc_get_vars_long(ncid, i, start, edge, stride, value);
#line 628
            IF (err != NC_ESTRIDE)
#line 628
                error("bad stride: status = %d", err);
#line 628
            stride[j] = 1;
#line 628
	  }
#line 628
        }
#line 628
            /* Choose a random point dividing each dim into 2 parts */
#line 628
            /* get 2^rank (nslabs) slabs so defined */
#line 628
        nslabs = 1;
#line 628
        for (j = 0; j < var_rank[i]; j++) {
#line 628
            mid[j] = roll( var_shape[i][j] );
#line 628
            nslabs *= 2;
#line 628
        }
#line 628
            /* bits of k determine whether to get lower or upper part of dim */
#line 628
            /* choose random stride from 1 to edge */
#line 628
        for (k = 0; k < nslabs; k++) {
#line 628
            nstarts = 1;
#line 628
            for (j = 0; j < var_rank[i]; j++) {
#line 628
                if ((k >> j) & 1) {
#line 628
                    start[j] = 0;
#line 628
                    edge[j] = mid[j];
#line 628
                }else{
#line 628
                    start[j] = mid[j];
#line 628
                    edge[j] = var_shape[i][j] - mid[j];
#line 628
                }
#line 628
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 628
                nstarts *= stride[j];
#line 628
            }
#line 628
            for (m = 0; m < nstarts; m++) {
#line 628
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 628
                IF (err)
#line 628
                    error("error in toMixedBase");
#line 628
                nels = 1;
#line 628
                for (j = 0; j < var_rank[i]; j++) {
#line 628
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 628
                    nels *= count[j];
#line 628
                    index[j] += start[j];
#line 628
                }
#line 628
                        /* Random choice of forward or backward */
#line 628
/* TODO
#line 628
                if ( roll(2) ) {
#line 628
                    for (j = 0; j < var_rank[i]; j++) {
#line 628
                        index[j] += (count[j] - 1) * stride[j];
#line 628
                        stride[j] = -stride[j];
#line 628
                    }
#line 628
                }
#line 628
*/
#line 628
		allInExtRange = allInIntRange = 1;
#line 628
		for (j = 0; j < nels; j++) {
#line 628
		    err = toMixedBase(j, var_rank[i], count, index2);
#line 628
		    IF (err)
#line 628
			error("error in toMixedBase 1");
#line 628
		    for (d = 0; d < var_rank[i]; d++)
#line 628
			index2[d] = index[d] + index2[d] * stride[d];
#line 628
		    expect[j] = hash4(var_type[i], var_rank[i], index2, 
#line 628
			NCT_LONG);
#line 628
		    if (inRange3(expect[j],var_type[i],NCT_LONG)) {
#line 628
			allInIntRange = allInIntRange && expect[j] >= long_min
#line 628
			    && expect[j] <= long_max;
#line 628
		    } else {
#line 628
			allInExtRange = 0;
#line 628
		    }
#line 628
		}
#line 628
                if (var_rank[i] == 0 && i%2 )
#line 628
                    err = nc_get_vars_long(ncid, i, NULL, NULL, NULL, value);
#line 628
                else
#line 628
                    err = nc_get_vars_long(ncid, i, index, count, stride, value);
#line 628
		if (canConvert) {
#line 628
		    if (allInExtRange) {
#line 628
			if (allInIntRange) {
#line 628
			    IF (err)
#line 628
				error("%s", nc_strerror(err));
#line 628
			} else {
#line 628
			    IF (err != NC_ERANGE)
#line 628
				error("Range error: status = %d", err);
#line 628
			}
#line 628
		    } else {
#line 628
			IF (err != 0 && err != NC_ERANGE)
#line 628
			    error("OK or Range error: status = %d", err);
#line 628
		    }
#line 628
		    for (j = 0; j < nels; j++) {
#line 628
			if (inRange3(expect[j],var_type[i],NCT_LONG)
#line 628
				&& expect[j] >= long_min && expect[j] <= long_max) {
#line 628
			    IF (!equal(value[j],expect[j],var_type[i],
#line 628
				    NCT_LONG)){
#line 628
				error("value read not that expected");
#line 628
				if (verbose) {
#line 628
				    error("\n");
#line 628
				    error("varid: %d, ", i);
#line 628
				    error("var_name: %s, ", var_name[i]);
#line 628
				    error("element number: %d ", j);
#line 628
                                    error("expect: %g, ", expect[j]);
#line 628
				    error("got: %g", (double) value[j]);
#line 628
				}
#line 628
			    } else {
#line 628
				nok++;
#line 628
			    }
#line 628
			}
#line 628
		    }
#line 628
		} else {
#line 628
		    IF (nels > 0 && err != NC_ECHAR)
#line 628
			error("wrong type: status = %d", err);
#line 628
		}
#line 628
	    }
#line 628
	}
#line 628

#line 628
    }
#line 628
    err = nc_close(ncid);
#line 628
    IF (err)
#line 628
        error("nc_close: %s", nc_strerror(err));
#line 628
    print_nok(nok);
#line 628
}
#line 628

void
#line 629
test_nc_get_vars_float(void)
#line 629
{
#line 629
    int ncid;
#line 629
    int d;
#line 629
    int i;
#line 629
    int j;
#line 629
    int k;
#line 629
    int m;
#line 629
    int err;
#line 629
    int allInExtRange;	/* all values within external range? */
#line 629
    int allInIntRange;	/* all values within internal range? */
#line 629
    int nels;
#line 629
    int nslabs;
#line 629
    int nstarts;        /* number of different starts */
#line 629
    int nok = 0;      /* count of valid comparisons */
#line 629
    size_t start[MAX_RANK];
#line 629
    size_t edge[MAX_RANK];
#line 629
    size_t index[MAX_RANK];
#line 629
    size_t index2[MAX_RANK];
#line 629
    size_t mid[MAX_RANK];
#line 629
    size_t count[MAX_RANK];
#line 629
    size_t sstride[MAX_RANK];
#line 629
    ptrdiff_t stride[MAX_RANK];
#line 629
    int canConvert;     /* Both text or both numeric */
#line 629
    float value[MAX_NELS];
#line 629
    double expect[MAX_NELS];
#line 629

#line 629
#ifdef TEST_PNETCDF
#line 629
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 629
#else
#line 629
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 629
#endif
#line 629
    IF (err)
#line 629
        error("nc_open: %s", nc_strerror(err));
#line 629
    for (i = 0; i < numVars; i++) {
#line 629
        canConvert = (var_type[i] == NC_CHAR) == (NCT_FLOAT == NCT_TEXT);
#line 629
        assert(var_rank[i] <= MAX_RANK);
#line 629
        assert(var_nels[i] <= MAX_NELS);
#line 629
        for (j = 0; j < var_rank[i]; j++) {
#line 629
            start[j] = 0;
#line 629
            edge[j] = 1;
#line 629
            stride[j] = 1;
#line 629
        }
#line 629
        err = nc_get_vars_float(BAD_ID, i, start, edge, stride, value);
#line 629
        IF (err != NC_EBADID)
#line 629
            error("bad ncid: status = %d", err);
#line 629
        err = nc_get_vars_float(ncid, BAD_VARID, start, edge, stride, value);
#line 629
        IF (err != NC_ENOTVAR)
#line 629
            error("bad var id: status = %d", err);
#line 629
        for (j = 0; j < var_rank[i]; j++) {
#line 629
            start[j] = var_shape[i][j];
#line 629
            err = nc_get_vars_float(ncid, i, start, edge, stride, value);
#line 629
	  if(!canConvert) {
#line 629
		IF (err != NC_ECHAR)
#line 629
               	    error("conversion: status = %d", err);
#line 629
	  } else {
#line 629
            IF (err != NC_EINVALCOORDS)
#line 629
                error("bad index: status = %d", err);
#line 629
            start[j] = 0;
#line 629
            edge[j] = var_shape[i][j] + 1;
#line 629
            err = nc_get_vars_float(ncid, i, start, edge, stride, value);
#line 629
            IF (err != NC_EEDGE)
#line 629
                error("bad edge: status = %d", err);
#line 629
            edge[j] = 1;
#line 629
            stride[j] = 0;
#line 629
            err = nc_get_vars_float(ncid, i, start, edge, stride, value);
#line 629
            IF (err != NC_ESTRIDE)
#line 629
                error("bad stride: status = %d", err);
#line 629
            stride[j] = 1;
#line 629
	  }
#line 629
        }
#line 629
            /* Choose a random point dividing each dim into 2 parts */
#line 629
            /* get 2^rank (nslabs) slabs so defined */
#line 629
        nslabs = 1;
#line 629
        for (j = 0; j < var_rank[i]; j++) {
#line 629
            mid[j] = roll( var_shape[i][j] );
#line 629
            nslabs *= 2;
#line 629
        }
#line 629
            /* bits of k determine whether to get lower or upper part of dim */
#line 629
            /* choose random stride from 1 to edge */
#line 629
        for (k = 0; k < nslabs; k++) {
#line 629
            nstarts = 1;
#line 629
            for (j = 0; j < var_rank[i]; j++) {
#line 629
                if ((k >> j) & 1) {
#line 629
                    start[j] = 0;
#line 629
                    edge[j] = mid[j];
#line 629
                }else{
#line 629
                    start[j] = mid[j];
#line 629
                    edge[j] = var_shape[i][j] - mid[j];
#line 629
                }
#line 629
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 629
                nstarts *= stride[j];
#line 629
            }
#line 629
            for (m = 0; m < nstarts; m++) {
#line 629
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 629
                IF (err)
#line 629
                    error("error in toMixedBase");
#line 629
                nels = 1;
#line 629
                for (j = 0; j < var_rank[i]; j++) {
#line 629
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 629
                    nels *= count[j];
#line 629
                    index[j] += start[j];
#line 629
                }
#line 629
                        /* Random choice of forward or backward */
#line 629
/* TODO
#line 629
                if ( roll(2) ) {
#line 629
                    for (j = 0; j < var_rank[i]; j++) {
#line 629
                        index[j] += (count[j] - 1) * stride[j];
#line 629
                        stride[j] = -stride[j];
#line 629
                    }
#line 629
                }
#line 629
*/
#line 629
		allInExtRange = allInIntRange = 1;
#line 629
		for (j = 0; j < nels; j++) {
#line 629
		    err = toMixedBase(j, var_rank[i], count, index2);
#line 629
		    IF (err)
#line 629
			error("error in toMixedBase 1");
#line 629
		    for (d = 0; d < var_rank[i]; d++)
#line 629
			index2[d] = index[d] + index2[d] * stride[d];
#line 629
		    expect[j] = hash4(var_type[i], var_rank[i], index2, 
#line 629
			NCT_FLOAT);
#line 629
		    if (inRange3(expect[j],var_type[i],NCT_FLOAT)) {
#line 629
			allInIntRange = allInIntRange && expect[j] >= float_min
#line 629
			    && expect[j] <= float_max;
#line 629
		    } else {
#line 629
			allInExtRange = 0;
#line 629
		    }
#line 629
		}
#line 629
                if (var_rank[i] == 0 && i%2 )
#line 629
                    err = nc_get_vars_float(ncid, i, NULL, NULL, NULL, value);
#line 629
                else
#line 629
                    err = nc_get_vars_float(ncid, i, index, count, stride, value);
#line 629
		if (canConvert) {
#line 629
		    if (allInExtRange) {
#line 629
			if (allInIntRange) {
#line 629
			    IF (err)
#line 629
				error("%s", nc_strerror(err));
#line 629
			} else {
#line 629
			    IF (err != NC_ERANGE)
#line 629
				error("Range error: status = %d", err);
#line 629
			}
#line 629
		    } else {
#line 629
			IF (err != 0 && err != NC_ERANGE)
#line 629
			    error("OK or Range error: status = %d", err);
#line 629
		    }
#line 629
		    for (j = 0; j < nels; j++) {
#line 629
			if (inRange3(expect[j],var_type[i],NCT_FLOAT)
#line 629
				&& expect[j] >= float_min && expect[j] <= float_max) {
#line 629
			    IF (!equal(value[j],expect[j],var_type[i],
#line 629
				    NCT_FLOAT)){
#line 629
				error("value read not that expected");
#line 629
				if (verbose) {
#line 629
				    error("\n");
#line 629
				    error("varid: %d, ", i);
#line 629
				    error("var_name: %s, ", var_name[i]);
#line 629
				    error("element number: %d ", j);
#line 629
                                    error("expect: %g, ", expect[j]);
#line 629
				    error("got: %g", (double) value[j]);
#line 629
				}
#line 629
			    } else {
#line 629
				nok++;
#line 629
			    }
#line 629
			}
#line 629
		    }
#line 629
		} else {
#line 629
		    IF (nels > 0 && err != NC_ECHAR)
#line 629
			error("wrong type: status = %d", err);
#line 629
		}
#line 629
	    }
#line 629
	}
#line 629

#line 629
    }
#line 629
    err = nc_close(ncid);
#line 629
    IF (err)
#line 629
        error("nc_close: %s", nc_strerror(err));
#line 629
    print_nok(nok);
#line 629
}
#line 629

void
#line 630
test_nc_get_vars_double(void)
#line 630
{
#line 630
    int ncid;
#line 630
    int d;
#line 630
    int i;
#line 630
    int j;
#line 630
    int k;
#line 630
    int m;
#line 630
    int err;
#line 630
    int allInExtRange;	/* all values within external range? */
#line 630
    int allInIntRange;	/* all values within internal range? */
#line 630
    int nels;
#line 630
    int nslabs;
#line 630
    int nstarts;        /* number of different starts */
#line 630
    int nok = 0;      /* count of valid comparisons */
#line 630
    size_t start[MAX_RANK];
#line 630
    size_t edge[MAX_RANK];
#line 630
    size_t index[MAX_RANK];
#line 630
    size_t index2[MAX_RANK];
#line 630
    size_t mid[MAX_RANK];
#line 630
    size_t count[MAX_RANK];
#line 630
    size_t sstride[MAX_RANK];
#line 630
    ptrdiff_t stride[MAX_RANK];
#line 630
    int canConvert;     /* Both text or both numeric */
#line 630
    double value[MAX_NELS];
#line 630
    double expect[MAX_NELS];
#line 630

#line 630
#ifdef TEST_PNETCDF
#line 630
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 630
#else
#line 630
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 630
#endif
#line 630
    IF (err)
#line 630
        error("nc_open: %s", nc_strerror(err));
#line 630
    for (i = 0; i < numVars; i++) {
#line 630
        canConvert = (var_type[i] == NC_CHAR) == (NCT_DOUBLE == NCT_TEXT);
#line 630
        assert(var_rank[i] <= MAX_RANK);
#line 630
        assert(var_nels[i] <= MAX_NELS);
#line 630
        for (j = 0; j < var_rank[i]; j++) {
#line 630
            start[j] = 0;
#line 630
            edge[j] = 1;
#line 630
            stride[j] = 1;
#line 630
        }
#line 630
        err = nc_get_vars_double(BAD_ID, i, start, edge, stride, value);
#line 630
        IF (err != NC_EBADID)
#line 630
            error("bad ncid: status = %d", err);
#line 630
        err = nc_get_vars_double(ncid, BAD_VARID, start, edge, stride, value);
#line 630
        IF (err != NC_ENOTVAR)
#line 630
            error("bad var id: status = %d", err);
#line 630
        for (j = 0; j < var_rank[i]; j++) {
#line 630
            start[j] = var_shape[i][j];
#line 630
            err = nc_get_vars_double(ncid, i, start, edge, stride, value);
#line 630
	  if(!canConvert) {
#line 630
		IF (err != NC_ECHAR)
#line 630
               	    error("conversion: status = %d", err);
#line 630
	  } else {
#line 630
            IF (err != NC_EINVALCOORDS)
#line 630
                error("bad index: status = %d", err);
#line 630
            start[j] = 0;
#line 630
            edge[j] = var_shape[i][j] + 1;
#line 630
            err = nc_get_vars_double(ncid, i, start, edge, stride, value);
#line 630
            IF (err != NC_EEDGE)
#line 630
                error("bad edge: status = %d", err);
#line 630
            edge[j] = 1;
#line 630
            stride[j] = 0;
#line 630
            err = nc_get_vars_double(ncid, i, start, edge, stride, value);
#line 630
            IF (err != NC_ESTRIDE)
#line 630
                error("bad stride: status = %d", err);
#line 630
            stride[j] = 1;
#line 630
	  }
#line 630
        }
#line 630
            /* Choose a random point dividing each dim into 2 parts */
#line 630
            /* get 2^rank (nslabs) slabs so defined */
#line 630
        nslabs = 1;
#line 630
        for (j = 0; j < var_rank[i]; j++) {
#line 630
            mid[j] = roll( var_shape[i][j] );
#line 630
            nslabs *= 2;
#line 630
        }
#line 630
            /* bits of k determine whether to get lower or upper part of dim */
#line 630
            /* choose random stride from 1 to edge */
#line 630
        for (k = 0; k < nslabs; k++) {
#line 630
            nstarts = 1;
#line 630
            for (j = 0; j < var_rank[i]; j++) {
#line 630
                if ((k >> j) & 1) {
#line 630
                    start[j] = 0;
#line 630
                    edge[j] = mid[j];
#line 630
                }else{
#line 630
                    start[j] = mid[j];
#line 630
                    edge[j] = var_shape[i][j] - mid[j];
#line 630
                }
#line 630
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 630
                nstarts *= stride[j];
#line 630
            }
#line 630
            for (m = 0; m < nstarts; m++) {
#line 630
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 630
                IF (err)
#line 630
                    error("error in toMixedBase");
#line 630
                nels = 1;
#line 630
                for (j = 0; j < var_rank[i]; j++) {
#line 630
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 630
                    nels *= count[j];
#line 630
                    index[j] += start[j];
#line 630
                }
#line 630
                        /* Random choice of forward or backward */
#line 630
/* TODO
#line 630
                if ( roll(2) ) {
#line 630
                    for (j = 0; j < var_rank[i]; j++) {
#line 630
                        index[j] += (count[j] - 1) * stride[j];
#line 630
                        stride[j] = -stride[j];
#line 630
                    }
#line 630
                }
#line 630
*/
#line 630
		allInExtRange = allInIntRange = 1;
#line 630
		for (j = 0; j < nels; j++) {
#line 630
		    err = toMixedBase(j, var_rank[i], count, index2);
#line 630
		    IF (err)
#line 630
			error("error in toMixedBase 1");
#line 630
		    for (d = 0; d < var_rank[i]; d++)
#line 630
			index2[d] = index[d] + index2[d] * stride[d];
#line 630
		    expect[j] = hash4(var_type[i], var_rank[i], index2, 
#line 630
			NCT_DOUBLE);
#line 630
		    if (inRange3(expect[j],var_type[i],NCT_DOUBLE)) {
#line 630
			allInIntRange = allInIntRange && expect[j] >= double_min
#line 630
			    && expect[j] <= double_max;
#line 630
		    } else {
#line 630
			allInExtRange = 0;
#line 630
		    }
#line 630
		}
#line 630
                if (var_rank[i] == 0 && i%2 )
#line 630
                    err = nc_get_vars_double(ncid, i, NULL, NULL, NULL, value);
#line 630
                else
#line 630
                    err = nc_get_vars_double(ncid, i, index, count, stride, value);
#line 630
		if (canConvert) {
#line 630
		    if (allInExtRange) {
#line 630
			if (allInIntRange) {
#line 630
			    IF (err)
#line 630
				error("%s", nc_strerror(err));
#line 630
			} else {
#line 630
			    IF (err != NC_ERANGE)
#line 630
				error("Range error: status = %d", err);
#line 630
			}
#line 630
		    } else {
#line 630
			IF (err != 0 && err != NC_ERANGE)
#line 630
			    error("OK or Range error: status = %d", err);
#line 630
		    }
#line 630
		    for (j = 0; j < nels; j++) {
#line 630
			if (inRange3(expect[j],var_type[i],NCT_DOUBLE)
#line 630
				&& expect[j] >= double_min && expect[j] <= double_max) {
#line 630
			    IF (!equal(value[j],expect[j],var_type[i],
#line 630
				    NCT_DOUBLE)){
#line 630
				error("value read not that expected");
#line 630
				if (verbose) {
#line 630
				    error("\n");
#line 630
				    error("varid: %d, ", i);
#line 630
				    error("var_name: %s, ", var_name[i]);
#line 630
				    error("element number: %d ", j);
#line 630
                                    error("expect: %g, ", expect[j]);
#line 630
				    error("got: %g", (double) value[j]);
#line 630
				}
#line 630
			    } else {
#line 630
				nok++;
#line 630
			    }
#line 630
			}
#line 630
		    }
#line 630
		} else {
#line 630
		    IF (nels > 0 && err != NC_ECHAR)
#line 630
			error("wrong type: status = %d", err);
#line 630
		}
#line 630
	    }
#line 630
	}
#line 630

#line 630
    }
#line 630
    err = nc_close(ncid);
#line 630
    IF (err)
#line 630
        error("nc_close: %s", nc_strerror(err));
#line 630
    print_nok(nok);
#line 630
}
#line 630

void
#line 631
test_nc_get_vars_ushort(void)
#line 631
{
#line 631
    int ncid;
#line 631
    int d;
#line 631
    int i;
#line 631
    int j;
#line 631
    int k;
#line 631
    int m;
#line 631
    int err;
#line 631
    int allInExtRange;	/* all values within external range? */
#line 631
    int allInIntRange;	/* all values within internal range? */
#line 631
    int nels;
#line 631
    int nslabs;
#line 631
    int nstarts;        /* number of different starts */
#line 631
    int nok = 0;      /* count of valid comparisons */
#line 631
    size_t start[MAX_RANK];
#line 631
    size_t edge[MAX_RANK];
#line 631
    size_t index[MAX_RANK];
#line 631
    size_t index2[MAX_RANK];
#line 631
    size_t mid[MAX_RANK];
#line 631
    size_t count[MAX_RANK];
#line 631
    size_t sstride[MAX_RANK];
#line 631
    ptrdiff_t stride[MAX_RANK];
#line 631
    int canConvert;     /* Both text or both numeric */
#line 631
    ushort value[MAX_NELS];
#line 631
    double expect[MAX_NELS];
#line 631

#line 631
#ifdef TEST_PNETCDF
#line 631
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 631
#else
#line 631
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 631
#endif
#line 631
    IF (err)
#line 631
        error("nc_open: %s", nc_strerror(err));
#line 631
    for (i = 0; i < numVars; i++) {
#line 631
        canConvert = (var_type[i] == NC_CHAR) == (NCT_USHORT == NCT_TEXT);
#line 631
        assert(var_rank[i] <= MAX_RANK);
#line 631
        assert(var_nels[i] <= MAX_NELS);
#line 631
        for (j = 0; j < var_rank[i]; j++) {
#line 631
            start[j] = 0;
#line 631
            edge[j] = 1;
#line 631
            stride[j] = 1;
#line 631
        }
#line 631
        err = nc_get_vars_ushort(BAD_ID, i, start, edge, stride, value);
#line 631
        IF (err != NC_EBADID)
#line 631
            error("bad ncid: status = %d", err);
#line 631
        err = nc_get_vars_ushort(ncid, BAD_VARID, start, edge, stride, value);
#line 631
        IF (err != NC_ENOTVAR)
#line 631
            error("bad var id: status = %d", err);
#line 631
        for (j = 0; j < var_rank[i]; j++) {
#line 631
            start[j] = var_shape[i][j];
#line 631
            err = nc_get_vars_ushort(ncid, i, start, edge, stride, value);
#line 631
	  if(!canConvert) {
#line 631
		IF (err != NC_ECHAR)
#line 631
               	    error("conversion: status = %d", err);
#line 631
	  } else {
#line 631
            IF (err != NC_EINVALCOORDS)
#line 631
                error("bad index: status = %d", err);
#line 631
            start[j] = 0;
#line 631
            edge[j] = var_shape[i][j] + 1;
#line 631
            err = nc_get_vars_ushort(ncid, i, start, edge, stride, value);
#line 631
            IF (err != NC_EEDGE)
#line 631
                error("bad edge: status = %d", err);
#line 631
            edge[j] = 1;
#line 631
            stride[j] = 0;
#line 631
            err = nc_get_vars_ushort(ncid, i, start, edge, stride, value);
#line 631
            IF (err != NC_ESTRIDE)
#line 631
                error("bad stride: status = %d", err);
#line 631
            stride[j] = 1;
#line 631
	  }
#line 631
        }
#line 631
            /* Choose a random point dividing each dim into 2 parts */
#line 631
            /* get 2^rank (nslabs) slabs so defined */
#line 631
        nslabs = 1;
#line 631
        for (j = 0; j < var_rank[i]; j++) {
#line 631
            mid[j] = roll( var_shape[i][j] );
#line 631
            nslabs *= 2;
#line 631
        }
#line 631
            /* bits of k determine whether to get lower or upper part of dim */
#line 631
            /* choose random stride from 1 to edge */
#line 631
        for (k = 0; k < nslabs; k++) {
#line 631
            nstarts = 1;
#line 631
            for (j = 0; j < var_rank[i]; j++) {
#line 631
                if ((k >> j) & 1) {
#line 631
                    start[j] = 0;
#line 631
                    edge[j] = mid[j];
#line 631
                }else{
#line 631
                    start[j] = mid[j];
#line 631
                    edge[j] = var_shape[i][j] - mid[j];
#line 631
                }
#line 631
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 631
                nstarts *= stride[j];
#line 631
            }
#line 631
            for (m = 0; m < nstarts; m++) {
#line 631
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 631
                IF (err)
#line 631
                    error("error in toMixedBase");
#line 631
                nels = 1;
#line 631
                for (j = 0; j < var_rank[i]; j++) {
#line 631
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 631
                    nels *= count[j];
#line 631
                    index[j] += start[j];
#line 631
                }
#line 631
                        /* Random choice of forward or backward */
#line 631
/* TODO
#line 631
                if ( roll(2) ) {
#line 631
                    for (j = 0; j < var_rank[i]; j++) {
#line 631
                        index[j] += (count[j] - 1) * stride[j];
#line 631
                        stride[j] = -stride[j];
#line 631
                    }
#line 631
                }
#line 631
*/
#line 631
		allInExtRange = allInIntRange = 1;
#line 631
		for (j = 0; j < nels; j++) {
#line 631
		    err = toMixedBase(j, var_rank[i], count, index2);
#line 631
		    IF (err)
#line 631
			error("error in toMixedBase 1");
#line 631
		    for (d = 0; d < var_rank[i]; d++)
#line 631
			index2[d] = index[d] + index2[d] * stride[d];
#line 631
		    expect[j] = hash4(var_type[i], var_rank[i], index2, 
#line 631
			NCT_USHORT);
#line 631
		    if (inRange3(expect[j],var_type[i],NCT_USHORT)) {
#line 631
			allInIntRange = allInIntRange && expect[j] >= ushort_min
#line 631
			    && expect[j] <= ushort_max;
#line 631
		    } else {
#line 631
			allInExtRange = 0;
#line 631
		    }
#line 631
		}
#line 631
                if (var_rank[i] == 0 && i%2 )
#line 631
                    err = nc_get_vars_ushort(ncid, i, NULL, NULL, NULL, value);
#line 631
                else
#line 631
                    err = nc_get_vars_ushort(ncid, i, index, count, stride, value);
#line 631
		if (canConvert) {
#line 631
		    if (allInExtRange) {
#line 631
			if (allInIntRange) {
#line 631
			    IF (err)
#line 631
				error("%s", nc_strerror(err));
#line 631
			} else {
#line 631
			    IF (err != NC_ERANGE)
#line 631
				error("Range error: status = %d", err);
#line 631
			}
#line 631
		    } else {
#line 631
			IF (err != 0 && err != NC_ERANGE)
#line 631
			    error("OK or Range error: status = %d", err);
#line 631
		    }
#line 631
		    for (j = 0; j < nels; j++) {
#line 631
			if (inRange3(expect[j],var_type[i],NCT_USHORT)
#line 631
				&& expect[j] >= ushort_min && expect[j] <= ushort_max) {
#line 631
			    IF (!equal(value[j],expect[j],var_type[i],
#line 631
				    NCT_USHORT)){
#line 631
				error("value read not that expected");
#line 631
				if (verbose) {
#line 631
				    error("\n");
#line 631
				    error("varid: %d, ", i);
#line 631
				    error("var_name: %s, ", var_name[i]);
#line 631
				    error("element number: %d ", j);
#line 631
                                    error("expect: %g, ", expect[j]);
#line 631
				    error("got: %g", (double) value[j]);
#line 631
				}
#line 631
			    } else {
#line 631
				nok++;
#line 631
			    }
#line 631
			}
#line 631
		    }
#line 631
		} else {
#line 631
		    IF (nels > 0 && err != NC_ECHAR)
#line 631
			error("wrong type: status = %d", err);
#line 631
		}
#line 631
	    }
#line 631
	}
#line 631

#line 631
    }
#line 631
    err = nc_close(ncid);
#line 631
    IF (err)
#line 631
        error("nc_close: %s", nc_strerror(err));
#line 631
    print_nok(nok);
#line 631
}
#line 631

void
#line 632
test_nc_get_vars_uint(void)
#line 632
{
#line 632
    int ncid;
#line 632
    int d;
#line 632
    int i;
#line 632
    int j;
#line 632
    int k;
#line 632
    int m;
#line 632
    int err;
#line 632
    int allInExtRange;	/* all values within external range? */
#line 632
    int allInIntRange;	/* all values within internal range? */
#line 632
    int nels;
#line 632
    int nslabs;
#line 632
    int nstarts;        /* number of different starts */
#line 632
    int nok = 0;      /* count of valid comparisons */
#line 632
    size_t start[MAX_RANK];
#line 632
    size_t edge[MAX_RANK];
#line 632
    size_t index[MAX_RANK];
#line 632
    size_t index2[MAX_RANK];
#line 632
    size_t mid[MAX_RANK];
#line 632
    size_t count[MAX_RANK];
#line 632
    size_t sstride[MAX_RANK];
#line 632
    ptrdiff_t stride[MAX_RANK];
#line 632
    int canConvert;     /* Both text or both numeric */
#line 632
    uint value[MAX_NELS];
#line 632
    double expect[MAX_NELS];
#line 632

#line 632
#ifdef TEST_PNETCDF
#line 632
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 632
#else
#line 632
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 632
#endif
#line 632
    IF (err)
#line 632
        error("nc_open: %s", nc_strerror(err));
#line 632
    for (i = 0; i < numVars; i++) {
#line 632
        canConvert = (var_type[i] == NC_CHAR) == (NCT_UINT == NCT_TEXT);
#line 632
        assert(var_rank[i] <= MAX_RANK);
#line 632
        assert(var_nels[i] <= MAX_NELS);
#line 632
        for (j = 0; j < var_rank[i]; j++) {
#line 632
            start[j] = 0;
#line 632
            edge[j] = 1;
#line 632
            stride[j] = 1;
#line 632
        }
#line 632
        err = nc_get_vars_uint(BAD_ID, i, start, edge, stride, value);
#line 632
        IF (err != NC_EBADID)
#line 632
            error("bad ncid: status = %d", err);
#line 632
        err = nc_get_vars_uint(ncid, BAD_VARID, start, edge, stride, value);
#line 632
        IF (err != NC_ENOTVAR)
#line 632
            error("bad var id: status = %d", err);
#line 632
        for (j = 0; j < var_rank[i]; j++) {
#line 632
            start[j] = var_shape[i][j];
#line 632
            err = nc_get_vars_uint(ncid, i, start, edge, stride, value);
#line 632
	  if(!canConvert) {
#line 632
		IF (err != NC_ECHAR)
#line 632
               	    error("conversion: status = %d", err);
#line 632
	  } else {
#line 632
            IF (err != NC_EINVALCOORDS)
#line 632
                error("bad index: status = %d", err);
#line 632
            start[j] = 0;
#line 632
            edge[j] = var_shape[i][j] + 1;
#line 632
            err = nc_get_vars_uint(ncid, i, start, edge, stride, value);
#line 632
            IF (err != NC_EEDGE)
#line 632
                error("bad edge: status = %d", err);
#line 632
            edge[j] = 1;
#line 632
            stride[j] = 0;
#line 632
            err = nc_get_vars_uint(ncid, i, start, edge, stride, value);
#line 632
            IF (err != NC_ESTRIDE)
#line 632
                error("bad stride: status = %d", err);
#line 632
            stride[j] = 1;
#line 632
	  }
#line 632
        }
#line 632
            /* Choose a random point dividing each dim into 2 parts */
#line 632
            /* get 2^rank (nslabs) slabs so defined */
#line 632
        nslabs = 1;
#line 632
        for (j = 0; j < var_rank[i]; j++) {
#line 632
            mid[j] = roll( var_shape[i][j] );
#line 632
            nslabs *= 2;
#line 632
        }
#line 632
            /* bits of k determine whether to get lower or upper part of dim */
#line 632
            /* choose random stride from 1 to edge */
#line 632
        for (k = 0; k < nslabs; k++) {
#line 632
            nstarts = 1;
#line 632
            for (j = 0; j < var_rank[i]; j++) {
#line 632
                if ((k >> j) & 1) {
#line 632
                    start[j] = 0;
#line 632
                    edge[j] = mid[j];
#line 632
                }else{
#line 632
                    start[j] = mid[j];
#line 632
                    edge[j] = var_shape[i][j] - mid[j];
#line 632
                }
#line 632
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 632
                nstarts *= stride[j];
#line 632
            }
#line 632
            for (m = 0; m < nstarts; m++) {
#line 632
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 632
                IF (err)
#line 632
                    error("error in toMixedBase");
#line 632
                nels = 1;
#line 632
                for (j = 0; j < var_rank[i]; j++) {
#line 632
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 632
                    nels *= count[j];
#line 632
                    index[j] += start[j];
#line 632
                }
#line 632
                        /* Random choice of forward or backward */
#line 632
/* TODO
#line 632
                if ( roll(2) ) {
#line 632
                    for (j = 0; j < var_rank[i]; j++) {
#line 632
                        index[j] += (count[j] - 1) * stride[j];
#line 632
                        stride[j] = -stride[j];
#line 632
                    }
#line 632
                }
#line 632
*/
#line 632
		allInExtRange = allInIntRange = 1;
#line 632
		for (j = 0; j < nels; j++) {
#line 632
		    err = toMixedBase(j, var_rank[i], count, index2);
#line 632
		    IF (err)
#line 632
			error("error in toMixedBase 1");
#line 632
		    for (d = 0; d < var_rank[i]; d++)
#line 632
			index2[d] = index[d] + index2[d] * stride[d];
#line 632
		    expect[j] = hash4(var_type[i], var_rank[i], index2, 
#line 632
			NCT_UINT);
#line 632
		    if (inRange3(expect[j],var_type[i],NCT_UINT)) {
#line 632
			allInIntRange = allInIntRange && expect[j] >= uint_min
#line 632
			    && expect[j] <= uint_max;
#line 632
		    } else {
#line 632
			allInExtRange = 0;
#line 632
		    }
#line 632
		}
#line 632
                if (var_rank[i] == 0 && i%2 )
#line 632
                    err = nc_get_vars_uint(ncid, i, NULL, NULL, NULL, value);
#line 632
                else
#line 632
                    err = nc_get_vars_uint(ncid, i, index, count, stride, value);
#line 632
		if (canConvert) {
#line 632
		    if (allInExtRange) {
#line 632
			if (allInIntRange) {
#line 632
			    IF (err)
#line 632
				error("%s", nc_strerror(err));
#line 632
			} else {
#line 632
			    IF (err != NC_ERANGE)
#line 632
				error("Range error: status = %d", err);
#line 632
			}
#line 632
		    } else {
#line 632
			IF (err != 0 && err != NC_ERANGE)
#line 632
			    error("OK or Range error: status = %d", err);
#line 632
		    }
#line 632
		    for (j = 0; j < nels; j++) {
#line 632
			if (inRange3(expect[j],var_type[i],NCT_UINT)
#line 632
				&& expect[j] >= uint_min && expect[j] <= uint_max) {
#line 632
			    IF (!equal(value[j],expect[j],var_type[i],
#line 632
				    NCT_UINT)){
#line 632
				error("value read not that expected");
#line 632
				if (verbose) {
#line 632
				    error("\n");
#line 632
				    error("varid: %d, ", i);
#line 632
				    error("var_name: %s, ", var_name[i]);
#line 632
				    error("element number: %d ", j);
#line 632
                                    error("expect: %g, ", expect[j]);
#line 632
				    error("got: %g", (double) value[j]);
#line 632
				}
#line 632
			    } else {
#line 632
				nok++;
#line 632
			    }
#line 632
			}
#line 632
		    }
#line 632
		} else {
#line 632
		    IF (nels > 0 && err != NC_ECHAR)
#line 632
			error("wrong type: status = %d", err);
#line 632
		}
#line 632
	    }
#line 632
	}
#line 632

#line 632
    }
#line 632
    err = nc_close(ncid);
#line 632
    IF (err)
#line 632
        error("nc_close: %s", nc_strerror(err));
#line 632
    print_nok(nok);
#line 632
}
#line 632

void
#line 633
test_nc_get_vars_longlong(void)
#line 633
{
#line 633
    int ncid;
#line 633
    int d;
#line 633
    int i;
#line 633
    int j;
#line 633
    int k;
#line 633
    int m;
#line 633
    int err;
#line 633
    int allInExtRange;	/* all values within external range? */
#line 633
    int allInIntRange;	/* all values within internal range? */
#line 633
    int nels;
#line 633
    int nslabs;
#line 633
    int nstarts;        /* number of different starts */
#line 633
    int nok = 0;      /* count of valid comparisons */
#line 633
    size_t start[MAX_RANK];
#line 633
    size_t edge[MAX_RANK];
#line 633
    size_t index[MAX_RANK];
#line 633
    size_t index2[MAX_RANK];
#line 633
    size_t mid[MAX_RANK];
#line 633
    size_t count[MAX_RANK];
#line 633
    size_t sstride[MAX_RANK];
#line 633
    ptrdiff_t stride[MAX_RANK];
#line 633
    int canConvert;     /* Both text or both numeric */
#line 633
    longlong value[MAX_NELS];
#line 633
    double expect[MAX_NELS];
#line 633

#line 633
#ifdef TEST_PNETCDF
#line 633
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 633
#else
#line 633
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 633
#endif
#line 633
    IF (err)
#line 633
        error("nc_open: %s", nc_strerror(err));
#line 633
    for (i = 0; i < numVars; i++) {
#line 633
        canConvert = (var_type[i] == NC_CHAR) == (NCT_LONGLONG == NCT_TEXT);
#line 633
        assert(var_rank[i] <= MAX_RANK);
#line 633
        assert(var_nels[i] <= MAX_NELS);
#line 633
        for (j = 0; j < var_rank[i]; j++) {
#line 633
            start[j] = 0;
#line 633
            edge[j] = 1;
#line 633
            stride[j] = 1;
#line 633
        }
#line 633
        err = nc_get_vars_longlong(BAD_ID, i, start, edge, stride, value);
#line 633
        IF (err != NC_EBADID)
#line 633
            error("bad ncid: status = %d", err);
#line 633
        err = nc_get_vars_longlong(ncid, BAD_VARID, start, edge, stride, value);
#line 633
        IF (err != NC_ENOTVAR)
#line 633
            error("bad var id: status = %d", err);
#line 633
        for (j = 0; j < var_rank[i]; j++) {
#line 633
            start[j] = var_shape[i][j];
#line 633
            err = nc_get_vars_longlong(ncid, i, start, edge, stride, value);
#line 633
	  if(!canConvert) {
#line 633
		IF (err != NC_ECHAR)
#line 633
               	    error("conversion: status = %d", err);
#line 633
	  } else {
#line 633
            IF (err != NC_EINVALCOORDS)
#line 633
                error("bad index: status = %d", err);
#line 633
            start[j] = 0;
#line 633
            edge[j] = var_shape[i][j] + 1;
#line 633
            err = nc_get_vars_longlong(ncid, i, start, edge, stride, value);
#line 633
            IF (err != NC_EEDGE)
#line 633
                error("bad edge: status = %d", err);
#line 633
            edge[j] = 1;
#line 633
            stride[j] = 0;
#line 633
            err = nc_get_vars_longlong(ncid, i, start, edge, stride, value);
#line 633
            IF (err != NC_ESTRIDE)
#line 633
                error("bad stride: status = %d", err);
#line 633
            stride[j] = 1;
#line 633
	  }
#line 633
        }
#line 633
            /* Choose a random point dividing each dim into 2 parts */
#line 633
            /* get 2^rank (nslabs) slabs so defined */
#line 633
        nslabs = 1;
#line 633
        for (j = 0; j < var_rank[i]; j++) {
#line 633
            mid[j] = roll( var_shape[i][j] );
#line 633
            nslabs *= 2;
#line 633
        }
#line 633
            /* bits of k determine whether to get lower or upper part of dim */
#line 633
            /* choose random stride from 1 to edge */
#line 633
        for (k = 0; k < nslabs; k++) {
#line 633
            nstarts = 1;
#line 633
            for (j = 0; j < var_rank[i]; j++) {
#line 633
                if ((k >> j) & 1) {
#line 633
                    start[j] = 0;
#line 633
                    edge[j] = mid[j];
#line 633
                }else{
#line 633
                    start[j] = mid[j];
#line 633
                    edge[j] = var_shape[i][j] - mid[j];
#line 633
                }
#line 633
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 633
                nstarts *= stride[j];
#line 633
            }
#line 633
            for (m = 0; m < nstarts; m++) {
#line 633
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 633
                IF (err)
#line 633
                    error("error in toMixedBase");
#line 633
                nels = 1;
#line 633
                for (j = 0; j < var_rank[i]; j++) {
#line 633
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 633
                    nels *= count[j];
#line 633
                    index[j] += start[j];
#line 633
                }
#line 633
                        /* Random choice of forward or backward */
#line 633
/* TODO
#line 633
                if ( roll(2) ) {
#line 633
                    for (j = 0; j < var_rank[i]; j++) {
#line 633
                        index[j] += (count[j] - 1) * stride[j];
#line 633
                        stride[j] = -stride[j];
#line 633
                    }
#line 633
                }
#line 633
*/
#line 633
		allInExtRange = allInIntRange = 1;
#line 633
		for (j = 0; j < nels; j++) {
#line 633
		    err = toMixedBase(j, var_rank[i], count, index2);
#line 633
		    IF (err)
#line 633
			error("error in toMixedBase 1");
#line 633
		    for (d = 0; d < var_rank[i]; d++)
#line 633
			index2[d] = index[d] + index2[d] * stride[d];
#line 633
		    expect[j] = hash4(var_type[i], var_rank[i], index2, 
#line 633
			NCT_LONGLONG);
#line 633
		    if (inRange3(expect[j],var_type[i],NCT_LONGLONG)) {
#line 633
			allInIntRange = allInIntRange && expect[j] >= longlong_min
#line 633
			    && expect[j] <= longlong_max;
#line 633
		    } else {
#line 633
			allInExtRange = 0;
#line 633
		    }
#line 633
		}
#line 633
                if (var_rank[i] == 0 && i%2 )
#line 633
                    err = nc_get_vars_longlong(ncid, i, NULL, NULL, NULL, value);
#line 633
                else
#line 633
                    err = nc_get_vars_longlong(ncid, i, index, count, stride, value);
#line 633
		if (canConvert) {
#line 633
		    if (allInExtRange) {
#line 633
			if (allInIntRange) {
#line 633
			    IF (err)
#line 633
				error("%s", nc_strerror(err));
#line 633
			} else {
#line 633
			    IF (err != NC_ERANGE)
#line 633
				error("Range error: status = %d", err);
#line 633
			}
#line 633
		    } else {
#line 633
			IF (err != 0 && err != NC_ERANGE)
#line 633
			    error("OK or Range error: status = %d", err);
#line 633
		    }
#line 633
		    for (j = 0; j < nels; j++) {
#line 633
			if (inRange3(expect[j],var_type[i],NCT_LONGLONG)
#line 633
				&& expect[j] >= longlong_min && expect[j] <= longlong_max) {
#line 633
			    IF (!equal(value[j],expect[j],var_type[i],
#line 633
				    NCT_LONGLONG)){
#line 633
				error("value read not that expected");
#line 633
				if (verbose) {
#line 633
				    error("\n");
#line 633
				    error("varid: %d, ", i);
#line 633
				    error("var_name: %s, ", var_name[i]);
#line 633
				    error("element number: %d ", j);
#line 633
                                    error("expect: %g, ", expect[j]);
#line 633
				    error("got: %g", (double) value[j]);
#line 633
				}
#line 633
			    } else {
#line 633
				nok++;
#line 633
			    }
#line 633
			}
#line 633
		    }
#line 633
		} else {
#line 633
		    IF (nels > 0 && err != NC_ECHAR)
#line 633
			error("wrong type: status = %d", err);
#line 633
		}
#line 633
	    }
#line 633
	}
#line 633

#line 633
    }
#line 633
    err = nc_close(ncid);
#line 633
    IF (err)
#line 633
        error("nc_close: %s", nc_strerror(err));
#line 633
    print_nok(nok);
#line 633
}
#line 633

void
#line 634
test_nc_get_vars_ulonglong(void)
#line 634
{
#line 634
    int ncid;
#line 634
    int d;
#line 634
    int i;
#line 634
    int j;
#line 634
    int k;
#line 634
    int m;
#line 634
    int err;
#line 634
    int allInExtRange;	/* all values within external range? */
#line 634
    int allInIntRange;	/* all values within internal range? */
#line 634
    int nels;
#line 634
    int nslabs;
#line 634
    int nstarts;        /* number of different starts */
#line 634
    int nok = 0;      /* count of valid comparisons */
#line 634
    size_t start[MAX_RANK];
#line 634
    size_t edge[MAX_RANK];
#line 634
    size_t index[MAX_RANK];
#line 634
    size_t index2[MAX_RANK];
#line 634
    size_t mid[MAX_RANK];
#line 634
    size_t count[MAX_RANK];
#line 634
    size_t sstride[MAX_RANK];
#line 634
    ptrdiff_t stride[MAX_RANK];
#line 634
    int canConvert;     /* Both text or both numeric */
#line 634
    ulonglong value[MAX_NELS];
#line 634
    double expect[MAX_NELS];
#line 634

#line 634
#ifdef TEST_PNETCDF
#line 634
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 634
#else
#line 634
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 634
#endif
#line 634
    IF (err)
#line 634
        error("nc_open: %s", nc_strerror(err));
#line 634
    for (i = 0; i < numVars; i++) {
#line 634
        canConvert = (var_type[i] == NC_CHAR) == (NCT_ULONGLONG == NCT_TEXT);
#line 634
        assert(var_rank[i] <= MAX_RANK);
#line 634
        assert(var_nels[i] <= MAX_NELS);
#line 634
        for (j = 0; j < var_rank[i]; j++) {
#line 634
            start[j] = 0;
#line 634
            edge[j] = 1;
#line 634
            stride[j] = 1;
#line 634
        }
#line 634
        err = nc_get_vars_ulonglong(BAD_ID, i, start, edge, stride, value);
#line 634
        IF (err != NC_EBADID)
#line 634
            error("bad ncid: status = %d", err);
#line 634
        err = nc_get_vars_ulonglong(ncid, BAD_VARID, start, edge, stride, value);
#line 634
        IF (err != NC_ENOTVAR)
#line 634
            error("bad var id: status = %d", err);
#line 634
        for (j = 0; j < var_rank[i]; j++) {
#line 634
            start[j] = var_shape[i][j];
#line 634
            err = nc_get_vars_ulonglong(ncid, i, start, edge, stride, value);
#line 634
	  if(!canConvert) {
#line 634
		IF (err != NC_ECHAR)
#line 634
               	    error("conversion: status = %d", err);
#line 634
	  } else {
#line 634
            IF (err != NC_EINVALCOORDS)
#line 634
                error("bad index: status = %d", err);
#line 634
            start[j] = 0;
#line 634
            edge[j] = var_shape[i][j] + 1;
#line 634
            err = nc_get_vars_ulonglong(ncid, i, start, edge, stride, value);
#line 634
            IF (err != NC_EEDGE)
#line 634
                error("bad edge: status = %d", err);
#line 634
            edge[j] = 1;
#line 634
            stride[j] = 0;
#line 634
            err = nc_get_vars_ulonglong(ncid, i, start, edge, stride, value);
#line 634
            IF (err != NC_ESTRIDE)
#line 634
                error("bad stride: status = %d", err);
#line 634
            stride[j] = 1;
#line 634
	  }
#line 634
        }
#line 634
            /* Choose a random point dividing each dim into 2 parts */
#line 634
            /* get 2^rank (nslabs) slabs so defined */
#line 634
        nslabs = 1;
#line 634
        for (j = 0; j < var_rank[i]; j++) {
#line 634
            mid[j] = roll( var_shape[i][j] );
#line 634
            nslabs *= 2;
#line 634
        }
#line 634
            /* bits of k determine whether to get lower or upper part of dim */
#line 634
            /* choose random stride from 1 to edge */
#line 634
        for (k = 0; k < nslabs; k++) {
#line 634
            nstarts = 1;
#line 634
            for (j = 0; j < var_rank[i]; j++) {
#line 634
                if ((k >> j) & 1) {
#line 634
                    start[j] = 0;
#line 634
                    edge[j] = mid[j];
#line 634
                }else{
#line 634
                    start[j] = mid[j];
#line 634
                    edge[j] = var_shape[i][j] - mid[j];
#line 634
                }
#line 634
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 634
                nstarts *= stride[j];
#line 634
            }
#line 634
            for (m = 0; m < nstarts; m++) {
#line 634
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 634
                IF (err)
#line 634
                    error("error in toMixedBase");
#line 634
                nels = 1;
#line 634
                for (j = 0; j < var_rank[i]; j++) {
#line 634
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 634
                    nels *= count[j];
#line 634
                    index[j] += start[j];
#line 634
                }
#line 634
                        /* Random choice of forward or backward */
#line 634
/* TODO
#line 634
                if ( roll(2) ) {
#line 634
                    for (j = 0; j < var_rank[i]; j++) {
#line 634
                        index[j] += (count[j] - 1) * stride[j];
#line 634
                        stride[j] = -stride[j];
#line 634
                    }
#line 634
                }
#line 634
*/
#line 634
		allInExtRange = allInIntRange = 1;
#line 634
		for (j = 0; j < nels; j++) {
#line 634
		    err = toMixedBase(j, var_rank[i], count, index2);
#line 634
		    IF (err)
#line 634
			error("error in toMixedBase 1");
#line 634
		    for (d = 0; d < var_rank[i]; d++)
#line 634
			index2[d] = index[d] + index2[d] * stride[d];
#line 634
		    expect[j] = hash4(var_type[i], var_rank[i], index2, 
#line 634
			NCT_ULONGLONG);
#line 634
		    if (inRange3(expect[j],var_type[i],NCT_ULONGLONG)) {
#line 634
			allInIntRange = allInIntRange && expect[j] >= ulonglong_min
#line 634
			    && expect[j] <= ulonglong_max;
#line 634
		    } else {
#line 634
			allInExtRange = 0;
#line 634
		    }
#line 634
		}
#line 634
                if (var_rank[i] == 0 && i%2 )
#line 634
                    err = nc_get_vars_ulonglong(ncid, i, NULL, NULL, NULL, value);
#line 634
                else
#line 634
                    err = nc_get_vars_ulonglong(ncid, i, index, count, stride, value);
#line 634
		if (canConvert) {
#line 634
		    if (allInExtRange) {
#line 634
			if (allInIntRange) {
#line 634
			    IF (err)
#line 634
				error("%s", nc_strerror(err));
#line 634
			} else {
#line 634
			    IF (err != NC_ERANGE)
#line 634
				error("Range error: status = %d", err);
#line 634
			}
#line 634
		    } else {
#line 634
			IF (err != 0 && err != NC_ERANGE)
#line 634
			    error("OK or Range error: status = %d", err);
#line 634
		    }
#line 634
		    for (j = 0; j < nels; j++) {
#line 634
			if (inRange3(expect[j],var_type[i],NCT_ULONGLONG)
#line 634
				&& expect[j] >= ulonglong_min && expect[j] <= ulonglong_max) {
#line 634
			    IF (!equal(value[j],expect[j],var_type[i],
#line 634
				    NCT_ULONGLONG)){
#line 634
				error("value read not that expected");
#line 634
				if (verbose) {
#line 634
				    error("\n");
#line 634
				    error("varid: %d, ", i);
#line 634
				    error("var_name: %s, ", var_name[i]);
#line 634
				    error("element number: %d ", j);
#line 634
                                    error("expect: %g, ", expect[j]);
#line 634
				    error("got: %g", (double) value[j]);
#line 634
				}
#line 634
			    } else {
#line 634
				nok++;
#line 634
			    }
#line 634
			}
#line 634
		    }
#line 634
		} else {
#line 634
		    IF (nels > 0 && err != NC_ECHAR)
#line 634
			error("wrong type: status = %d", err);
#line 634
		}
#line 634
	    }
#line 634
	}
#line 634

#line 634
    }
#line 634
    err = nc_close(ncid);
#line 634
    IF (err)
#line 634
        error("nc_close: %s", nc_strerror(err));
#line 634
    print_nok(nok);
#line 634
}
#line 634



#line 828

void
#line 829
test_nc_get_varm_text(void)
#line 829
{
#line 829
    int ncid;
#line 829
    int d;
#line 829
    int i;
#line 829
    int j;
#line 829
    int k;
#line 829
    int m;
#line 829
    int err;
#line 829
    int allInExtRange;	/* all values within external range? */
#line 829
    int allInIntRange;	/* all values within internal range? */
#line 829
    int nels;
#line 829
    int nslabs;
#line 829
    int nstarts;        /* number of different starts */
#line 829
    int nok = 0;      /* count of valid comparisons */
#line 829
    size_t start[MAX_RANK];
#line 829
    size_t edge[MAX_RANK];
#line 829
    size_t index[MAX_RANK];
#line 829
    size_t index2[MAX_RANK];
#line 829
    size_t mid[MAX_RANK];
#line 829
    size_t count[MAX_RANK];
#line 829
    size_t sstride[MAX_RANK];
#line 829
    ptrdiff_t stride[MAX_RANK];
#line 829
    ptrdiff_t imap[MAX_RANK];
#line 829
    int canConvert;     /* Both text or both numeric */
#line 829
    text value[MAX_NELS];
#line 829
    double expect[MAX_NELS];
#line 829

#line 829
#ifdef TEST_PNETCDF
#line 829
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 829
#else
#line 829
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 829
#endif
#line 829
    IF (err)
#line 829
        error("nc_open: %s", nc_strerror(err));
#line 829
    for (i = 0; i < numVars; i++) {
#line 829
        canConvert = (var_type[i] == NC_CHAR) == (NCT_TEXT == NCT_TEXT);
#line 829
        assert(var_rank[i] <= MAX_RANK);
#line 829
        assert(var_nels[i] <= MAX_NELS);
#line 829
        for (j = 0; j < var_rank[i]; j++) {
#line 829
            start[j] = 0;
#line 829
            edge[j] = 1;
#line 829
            stride[j] = 1;
#line 829
            imap[j] = 1;
#line 829
        }
#line 829
        err = nc_get_varm_text(BAD_ID, i, start, edge, stride, imap, value);
#line 829
        IF (err != NC_EBADID)
#line 829
            error("bad ncid: status = %d", err);
#line 829
        err = nc_get_varm_text(ncid, BAD_VARID, start, edge, stride, imap, value);
#line 829
        IF (err != NC_ENOTVAR)
#line 829
            error("bad var id: status = %d", err);
#line 829
        for (j = 0; j < var_rank[i]; j++) {
#line 829
            start[j] = var_shape[i][j];
#line 829
            err = nc_get_varm_text(ncid, i, start, edge, stride, imap, value);
#line 829
	  if(!canConvert) {
#line 829
		IF (err != NC_ECHAR)
#line 829
               	    error("conversion: status = %d", err);
#line 829
	  } else {
#line 829
	    IF (err != NC_EINVALCOORDS)
#line 829
                error("bad index: status = %d", err);
#line 829
            start[j] = 0;
#line 829
            edge[j] = var_shape[i][j] + 1;
#line 829
            err = nc_get_varm_text(ncid, i, start, edge, stride, imap, value);
#line 829
            IF (err != NC_EEDGE)
#line 829
                error("bad edge: status = %d", err);
#line 829
            edge[j] = 1;
#line 829
            stride[j] = 0;
#line 829
            err = nc_get_varm_text(ncid, i, start, edge, stride, imap, value);
#line 829
            IF (err != NC_ESTRIDE)
#line 829
                error("bad stride: status = %d", err);
#line 829
            stride[j] = 1;
#line 829
           }
#line 829
        }
#line 829
            /* Choose a random point dividing each dim into 2 parts */
#line 829
            /* get 2^rank (nslabs) slabs so defined */
#line 829
        nslabs = 1;
#line 829
        for (j = 0; j < var_rank[i]; j++) {
#line 829
            mid[j] = roll( var_shape[i][j] );
#line 829
            nslabs *= 2;
#line 829
        }
#line 829
            /* bits of k determine whether to get lower or upper part of dim */
#line 829
            /* choose random stride from 1 to edge */
#line 829
        for (k = 0; k < nslabs; k++) {
#line 829
            nstarts = 1;
#line 829
            for (j = 0; j < var_rank[i]; j++) {
#line 829
                if ((k >> j) & 1) {
#line 829
                    start[j] = 0;
#line 829
                    edge[j] = mid[j];
#line 829
                }else{
#line 829
                    start[j] = mid[j];
#line 829
                    edge[j] = var_shape[i][j] - mid[j];
#line 829
                }
#line 829
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 829
                nstarts *= stride[j];
#line 829
            }
#line 829
            for (m = 0; m < nstarts; m++) {
#line 829
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 829
                IF (err)
#line 829
                    error("error in toMixedBase");
#line 829
                nels = 1;
#line 829
                for (j = 0; j < var_rank[i]; j++) {
#line 829
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 829
                    nels *= count[j];
#line 829
                    index[j] += start[j];
#line 829
                }
#line 829
		    /* Random choice of forward or backward */
#line 829
/* TODO
#line 829
		if ( roll(2) ) {
#line 829
		    for (j = 0; j < var_rank[i]; j++) {
#line 829
			index[j] += (count[j] - 1) * stride[j];
#line 829
			stride[j] = -stride[j];
#line 829
		    }
#line 829
		}
#line 829
 */
#line 829
		if (var_rank[i] > 0) {
#line 829
		    j = var_rank[i] - 1;
#line 829
		    imap[j] = 1;
#line 829
		    for (; j > 0; j--)
#line 829
			imap[j-1] = imap[j] * count[j];
#line 829
		}
#line 829
                allInExtRange = allInIntRange = 1;
#line 829
                for (j = 0; j < nels; j++) {
#line 829
                    err = toMixedBase(j, var_rank[i], count, index2);
#line 829
                    IF (err)
#line 829
                        error("error in toMixedBase 1");
#line 829
                    for (d = 0; d < var_rank[i]; d++)
#line 829
                        index2[d] = index[d] + index2[d] * stride[d];
#line 829
                    expect[j] = hash4(var_type[i], var_rank[i], index2,
#line 829
                        NCT_TEXT);
#line 829
                    if (inRange3(expect[j],var_type[i],NCT_TEXT)) {
#line 829
                        allInIntRange = allInIntRange && expect[j] >= text_min
#line 829
                            && expect[j] <= text_max;
#line 829
                    } else {
#line 829
                        allInExtRange = 0;
#line 829
                    }
#line 829
                }
#line 829
                if (var_rank[i] == 0 && i%2 )
#line 829
                    err = nc_get_varm_text(ncid,i,NULL,NULL,NULL,NULL,value);
#line 829
                else
#line 829
                    err = nc_get_varm_text(ncid,i,index,count,stride,imap,value);
#line 829
                if (canConvert) {
#line 829
                    if (allInExtRange) {
#line 829
                        if (allInIntRange) {
#line 829
                            IF (err)
#line 829
                                error("%s", nc_strerror(err));
#line 829
                        } else {
#line 829
                            IF (err != NC_ERANGE)
#line 829
                                error("Range error: status = %d", err);
#line 829
                        }
#line 829
                    } else {
#line 829
                        IF (err != 0 && err != NC_ERANGE)
#line 829
                            error("OK or Range error: status = %d", err);
#line 829
                    }
#line 829
                    for (j = 0; j < nels; j++) {
#line 829
                        if (inRange3(expect[j],var_type[i],NCT_TEXT)
#line 829
                                && expect[j] >= text_min 
#line 829
				&& expect[j] <= text_max) {
#line 829
			    IF (!equal(value[j],expect[j],var_type[i],
#line 829
				    NCT_TEXT)){
#line 829
                                error("value read not that expected");
#line 829
                                if (verbose) {
#line 829
                                    error("\n");
#line 829
                                    error("varid: %d, ", i);
#line 829
                                    error("var_name: %s, ", var_name[i]);
#line 829
                                    error("element number: %d ", j);
#line 829
                                    error("expect: %g, ", expect[j]);
#line 829
                                    error("got: %g", (double) value[j]);
#line 829
                                }
#line 829
                            } else {
#line 829
                                nok++;
#line 829
                            }
#line 829
                        }
#line 829
                    }
#line 829
                } else {
#line 829
                    IF (nels > 0 && err != NC_ECHAR)
#line 829
                        error("wrong type: status = %d", err);
#line 829
                }
#line 829
            }
#line 829
        }
#line 829
    }
#line 829
    err = nc_close(ncid);
#line 829
    IF (err)
#line 829
        error("nc_close: %s", nc_strerror(err));
#line 829
    print_nok(nok);
#line 829
}
#line 829

void
#line 830
test_nc_get_varm_uchar(void)
#line 830
{
#line 830
    int ncid;
#line 830
    int d;
#line 830
    int i;
#line 830
    int j;
#line 830
    int k;
#line 830
    int m;
#line 830
    int err;
#line 830
    int allInExtRange;	/* all values within external range? */
#line 830
    int allInIntRange;	/* all values within internal range? */
#line 830
    int nels;
#line 830
    int nslabs;
#line 830
    int nstarts;        /* number of different starts */
#line 830
    int nok = 0;      /* count of valid comparisons */
#line 830
    size_t start[MAX_RANK];
#line 830
    size_t edge[MAX_RANK];
#line 830
    size_t index[MAX_RANK];
#line 830
    size_t index2[MAX_RANK];
#line 830
    size_t mid[MAX_RANK];
#line 830
    size_t count[MAX_RANK];
#line 830
    size_t sstride[MAX_RANK];
#line 830
    ptrdiff_t stride[MAX_RANK];
#line 830
    ptrdiff_t imap[MAX_RANK];
#line 830
    int canConvert;     /* Both text or both numeric */
#line 830
    uchar value[MAX_NELS];
#line 830
    double expect[MAX_NELS];
#line 830

#line 830
#ifdef TEST_PNETCDF
#line 830
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 830
#else
#line 830
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 830
#endif
#line 830
    IF (err)
#line 830
        error("nc_open: %s", nc_strerror(err));
#line 830
    for (i = 0; i < numVars; i++) {
#line 830
        canConvert = (var_type[i] == NC_CHAR) == (NCT_UCHAR == NCT_TEXT);
#line 830
        assert(var_rank[i] <= MAX_RANK);
#line 830
        assert(var_nels[i] <= MAX_NELS);
#line 830
        for (j = 0; j < var_rank[i]; j++) {
#line 830
            start[j] = 0;
#line 830
            edge[j] = 1;
#line 830
            stride[j] = 1;
#line 830
            imap[j] = 1;
#line 830
        }
#line 830
        err = nc_get_varm_uchar(BAD_ID, i, start, edge, stride, imap, value);
#line 830
        IF (err != NC_EBADID)
#line 830
            error("bad ncid: status = %d", err);
#line 830
        err = nc_get_varm_uchar(ncid, BAD_VARID, start, edge, stride, imap, value);
#line 830
        IF (err != NC_ENOTVAR)
#line 830
            error("bad var id: status = %d", err);
#line 830
        for (j = 0; j < var_rank[i]; j++) {
#line 830
            start[j] = var_shape[i][j];
#line 830
            err = nc_get_varm_uchar(ncid, i, start, edge, stride, imap, value);
#line 830
	  if(!canConvert) {
#line 830
		IF (err != NC_ECHAR)
#line 830
               	    error("conversion: status = %d", err);
#line 830
	  } else {
#line 830
	    IF (err != NC_EINVALCOORDS)
#line 830
                error("bad index: status = %d", err);
#line 830
            start[j] = 0;
#line 830
            edge[j] = var_shape[i][j] + 1;
#line 830
            err = nc_get_varm_uchar(ncid, i, start, edge, stride, imap, value);
#line 830
            IF (err != NC_EEDGE)
#line 830
                error("bad edge: status = %d", err);
#line 830
            edge[j] = 1;
#line 830
            stride[j] = 0;
#line 830
            err = nc_get_varm_uchar(ncid, i, start, edge, stride, imap, value);
#line 830
            IF (err != NC_ESTRIDE)
#line 830
                error("bad stride: status = %d", err);
#line 830
            stride[j] = 1;
#line 830
           }
#line 830
        }
#line 830
            /* Choose a random point dividing each dim into 2 parts */
#line 830
            /* get 2^rank (nslabs) slabs so defined */
#line 830
        nslabs = 1;
#line 830
        for (j = 0; j < var_rank[i]; j++) {
#line 830
            mid[j] = roll( var_shape[i][j] );
#line 830
            nslabs *= 2;
#line 830
        }
#line 830
            /* bits of k determine whether to get lower or upper part of dim */
#line 830
            /* choose random stride from 1 to edge */
#line 830
        for (k = 0; k < nslabs; k++) {
#line 830
            nstarts = 1;
#line 830
            for (j = 0; j < var_rank[i]; j++) {
#line 830
                if ((k >> j) & 1) {
#line 830
                    start[j] = 0;
#line 830
                    edge[j] = mid[j];
#line 830
                }else{
#line 830
                    start[j] = mid[j];
#line 830
                    edge[j] = var_shape[i][j] - mid[j];
#line 830
                }
#line 830
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 830
                nstarts *= stride[j];
#line 830
            }
#line 830
            for (m = 0; m < nstarts; m++) {
#line 830
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 830
                IF (err)
#line 830
                    error("error in toMixedBase");
#line 830
                nels = 1;
#line 830
                for (j = 0; j < var_rank[i]; j++) {
#line 830
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 830
                    nels *= count[j];
#line 830
                    index[j] += start[j];
#line 830
                }
#line 830
		    /* Random choice of forward or backward */
#line 830
/* TODO
#line 830
		if ( roll(2) ) {
#line 830
		    for (j = 0; j < var_rank[i]; j++) {
#line 830
			index[j] += (count[j] - 1) * stride[j];
#line 830
			stride[j] = -stride[j];
#line 830
		    }
#line 830
		}
#line 830
 */
#line 830
		if (var_rank[i] > 0) {
#line 830
		    j = var_rank[i] - 1;
#line 830
		    imap[j] = 1;
#line 830
		    for (; j > 0; j--)
#line 830
			imap[j-1] = imap[j] * count[j];
#line 830
		}
#line 830
                allInExtRange = allInIntRange = 1;
#line 830
                for (j = 0; j < nels; j++) {
#line 830
                    err = toMixedBase(j, var_rank[i], count, index2);
#line 830
                    IF (err)
#line 830
                        error("error in toMixedBase 1");
#line 830
                    for (d = 0; d < var_rank[i]; d++)
#line 830
                        index2[d] = index[d] + index2[d] * stride[d];
#line 830
                    expect[j] = hash4(var_type[i], var_rank[i], index2,
#line 830
                        NCT_UCHAR);
#line 830
                    if (inRange3(expect[j],var_type[i],NCT_UCHAR)) {
#line 830
                        allInIntRange = allInIntRange && expect[j] >= uchar_min
#line 830
                            && expect[j] <= uchar_max;
#line 830
                    } else {
#line 830
                        allInExtRange = 0;
#line 830
                    }
#line 830
                }
#line 830
                if (var_rank[i] == 0 && i%2 )
#line 830
                    err = nc_get_varm_uchar(ncid,i,NULL,NULL,NULL,NULL,value);
#line 830
                else
#line 830
                    err = nc_get_varm_uchar(ncid,i,index,count,stride,imap,value);
#line 830
                if (canConvert) {
#line 830
                    if (allInExtRange) {
#line 830
                        if (allInIntRange) {
#line 830
                            IF (err)
#line 830
                                error("%s", nc_strerror(err));
#line 830
                        } else {
#line 830
                            IF (err != NC_ERANGE)
#line 830
                                error("Range error: status = %d", err);
#line 830
                        }
#line 830
                    } else {
#line 830
                        IF (err != 0 && err != NC_ERANGE)
#line 830
                            error("OK or Range error: status = %d", err);
#line 830
                    }
#line 830
                    for (j = 0; j < nels; j++) {
#line 830
                        if (inRange3(expect[j],var_type[i],NCT_UCHAR)
#line 830
                                && expect[j] >= uchar_min 
#line 830
				&& expect[j] <= uchar_max) {
#line 830
			    IF (!equal(value[j],expect[j],var_type[i],
#line 830
				    NCT_UCHAR)){
#line 830
                                error("value read not that expected");
#line 830
                                if (verbose) {
#line 830
                                    error("\n");
#line 830
                                    error("varid: %d, ", i);
#line 830
                                    error("var_name: %s, ", var_name[i]);
#line 830
                                    error("element number: %d ", j);
#line 830
                                    error("expect: %g, ", expect[j]);
#line 830
                                    error("got: %g", (double) value[j]);
#line 830
                                }
#line 830
                            } else {
#line 830
                                nok++;
#line 830
                            }
#line 830
                        }
#line 830
                    }
#line 830
                } else {
#line 830
                    IF (nels > 0 && err != NC_ECHAR)
#line 830
                        error("wrong type: status = %d", err);
#line 830
                }
#line 830
            }
#line 830
        }
#line 830
    }
#line 830
    err = nc_close(ncid);
#line 830
    IF (err)
#line 830
        error("nc_close: %s", nc_strerror(err));
#line 830
    print_nok(nok);
#line 830
}
#line 830

void
#line 831
test_nc_get_varm_schar(void)
#line 831
{
#line 831
    int ncid;
#line 831
    int d;
#line 831
    int i;
#line 831
    int j;
#line 831
    int k;
#line 831
    int m;
#line 831
    int err;
#line 831
    int allInExtRange;	/* all values within external range? */
#line 831
    int allInIntRange;	/* all values within internal range? */
#line 831
    int nels;
#line 831
    int nslabs;
#line 831
    int nstarts;        /* number of different starts */
#line 831
    int nok = 0;      /* count of valid comparisons */
#line 831
    size_t start[MAX_RANK];
#line 831
    size_t edge[MAX_RANK];
#line 831
    size_t index[MAX_RANK];
#line 831
    size_t index2[MAX_RANK];
#line 831
    size_t mid[MAX_RANK];
#line 831
    size_t count[MAX_RANK];
#line 831
    size_t sstride[MAX_RANK];
#line 831
    ptrdiff_t stride[MAX_RANK];
#line 831
    ptrdiff_t imap[MAX_RANK];
#line 831
    int canConvert;     /* Both text or both numeric */
#line 831
    schar value[MAX_NELS];
#line 831
    double expect[MAX_NELS];
#line 831

#line 831
#ifdef TEST_PNETCDF
#line 831
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 831
#else
#line 831
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 831
#endif
#line 831
    IF (err)
#line 831
        error("nc_open: %s", nc_strerror(err));
#line 831
    for (i = 0; i < numVars; i++) {
#line 831
        canConvert = (var_type[i] == NC_CHAR) == (NCT_SCHAR == NCT_TEXT);
#line 831
        assert(var_rank[i] <= MAX_RANK);
#line 831
        assert(var_nels[i] <= MAX_NELS);
#line 831
        for (j = 0; j < var_rank[i]; j++) {
#line 831
            start[j] = 0;
#line 831
            edge[j] = 1;
#line 831
            stride[j] = 1;
#line 831
            imap[j] = 1;
#line 831
        }
#line 831
        err = nc_get_varm_schar(BAD_ID, i, start, edge, stride, imap, value);
#line 831
        IF (err != NC_EBADID)
#line 831
            error("bad ncid: status = %d", err);
#line 831
        err = nc_get_varm_schar(ncid, BAD_VARID, start, edge, stride, imap, value);
#line 831
        IF (err != NC_ENOTVAR)
#line 831
            error("bad var id: status = %d", err);
#line 831
        for (j = 0; j < var_rank[i]; j++) {
#line 831
            start[j] = var_shape[i][j];
#line 831
            err = nc_get_varm_schar(ncid, i, start, edge, stride, imap, value);
#line 831
	  if(!canConvert) {
#line 831
		IF (err != NC_ECHAR)
#line 831
               	    error("conversion: status = %d", err);
#line 831
	  } else {
#line 831
	    IF (err != NC_EINVALCOORDS)
#line 831
                error("bad index: status = %d", err);
#line 831
            start[j] = 0;
#line 831
            edge[j] = var_shape[i][j] + 1;
#line 831
            err = nc_get_varm_schar(ncid, i, start, edge, stride, imap, value);
#line 831
            IF (err != NC_EEDGE)
#line 831
                error("bad edge: status = %d", err);
#line 831
            edge[j] = 1;
#line 831
            stride[j] = 0;
#line 831
            err = nc_get_varm_schar(ncid, i, start, edge, stride, imap, value);
#line 831
            IF (err != NC_ESTRIDE)
#line 831
                error("bad stride: status = %d", err);
#line 831
            stride[j] = 1;
#line 831
           }
#line 831
        }
#line 831
            /* Choose a random point dividing each dim into 2 parts */
#line 831
            /* get 2^rank (nslabs) slabs so defined */
#line 831
        nslabs = 1;
#line 831
        for (j = 0; j < var_rank[i]; j++) {
#line 831
            mid[j] = roll( var_shape[i][j] );
#line 831
            nslabs *= 2;
#line 831
        }
#line 831
            /* bits of k determine whether to get lower or upper part of dim */
#line 831
            /* choose random stride from 1 to edge */
#line 831
        for (k = 0; k < nslabs; k++) {
#line 831
            nstarts = 1;
#line 831
            for (j = 0; j < var_rank[i]; j++) {
#line 831
                if ((k >> j) & 1) {
#line 831
                    start[j] = 0;
#line 831
                    edge[j] = mid[j];
#line 831
                }else{
#line 831
                    start[j] = mid[j];
#line 831
                    edge[j] = var_shape[i][j] - mid[j];
#line 831
                }
#line 831
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 831
                nstarts *= stride[j];
#line 831
            }
#line 831
            for (m = 0; m < nstarts; m++) {
#line 831
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 831
                IF (err)
#line 831
                    error("error in toMixedBase");
#line 831
                nels = 1;
#line 831
                for (j = 0; j < var_rank[i]; j++) {
#line 831
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 831
                    nels *= count[j];
#line 831
                    index[j] += start[j];
#line 831
                }
#line 831
		    /* Random choice of forward or backward */
#line 831
/* TODO
#line 831
		if ( roll(2) ) {
#line 831
		    for (j = 0; j < var_rank[i]; j++) {
#line 831
			index[j] += (count[j] - 1) * stride[j];
#line 831
			stride[j] = -stride[j];
#line 831
		    }
#line 831
		}
#line 831
 */
#line 831
		if (var_rank[i] > 0) {
#line 831
		    j = var_rank[i] - 1;
#line 831
		    imap[j] = 1;
#line 831
		    for (; j > 0; j--)
#line 831
			imap[j-1] = imap[j] * count[j];
#line 831
		}
#line 831
                allInExtRange = allInIntRange = 1;
#line 831
                for (j = 0; j < nels; j++) {
#line 831
                    err = toMixedBase(j, var_rank[i], count, index2);
#line 831
                    IF (err)
#line 831
                        error("error in toMixedBase 1");
#line 831
                    for (d = 0; d < var_rank[i]; d++)
#line 831
                        index2[d] = index[d] + index2[d] * stride[d];
#line 831
                    expect[j] = hash4(var_type[i], var_rank[i], index2,
#line 831
                        NCT_SCHAR);
#line 831
                    if (inRange3(expect[j],var_type[i],NCT_SCHAR)) {
#line 831
                        allInIntRange = allInIntRange && expect[j] >= schar_min
#line 831
                            && expect[j] <= schar_max;
#line 831
                    } else {
#line 831
                        allInExtRange = 0;
#line 831
                    }
#line 831
                }
#line 831
                if (var_rank[i] == 0 && i%2 )
#line 831
                    err = nc_get_varm_schar(ncid,i,NULL,NULL,NULL,NULL,value);
#line 831
                else
#line 831
                    err = nc_get_varm_schar(ncid,i,index,count,stride,imap,value);
#line 831
                if (canConvert) {
#line 831
                    if (allInExtRange) {
#line 831
                        if (allInIntRange) {
#line 831
                            IF (err)
#line 831
                                error("%s", nc_strerror(err));
#line 831
                        } else {
#line 831
                            IF (err != NC_ERANGE)
#line 831
                                error("Range error: status = %d", err);
#line 831
                        }
#line 831
                    } else {
#line 831
                        IF (err != 0 && err != NC_ERANGE)
#line 831
                            error("OK or Range error: status = %d", err);
#line 831
                    }
#line 831
                    for (j = 0; j < nels; j++) {
#line 831
                        if (inRange3(expect[j],var_type[i],NCT_SCHAR)
#line 831
                                && expect[j] >= schar_min 
#line 831
				&& expect[j] <= schar_max) {
#line 831
			    IF (!equal(value[j],expect[j],var_type[i],
#line 831
				    NCT_SCHAR)){
#line 831
                                error("value read not that expected");
#line 831
                                if (verbose) {
#line 831
                                    error("\n");
#line 831
                                    error("varid: %d, ", i);
#line 831
                                    error("var_name: %s, ", var_name[i]);
#line 831
                                    error("element number: %d ", j);
#line 831
                                    error("expect: %g, ", expect[j]);
#line 831
                                    error("got: %g", (double) value[j]);
#line 831
                                }
#line 831
                            } else {
#line 831
                                nok++;
#line 831
                            }
#line 831
                        }
#line 831
                    }
#line 831
                } else {
#line 831
                    IF (nels > 0 && err != NC_ECHAR)
#line 831
                        error("wrong type: status = %d", err);
#line 831
                }
#line 831
            }
#line 831
        }
#line 831
    }
#line 831
    err = nc_close(ncid);
#line 831
    IF (err)
#line 831
        error("nc_close: %s", nc_strerror(err));
#line 831
    print_nok(nok);
#line 831
}
#line 831

void
#line 832
test_nc_get_varm_short(void)
#line 832
{
#line 832
    int ncid;
#line 832
    int d;
#line 832
    int i;
#line 832
    int j;
#line 832
    int k;
#line 832
    int m;
#line 832
    int err;
#line 832
    int allInExtRange;	/* all values within external range? */
#line 832
    int allInIntRange;	/* all values within internal range? */
#line 832
    int nels;
#line 832
    int nslabs;
#line 832
    int nstarts;        /* number of different starts */
#line 832
    int nok = 0;      /* count of valid comparisons */
#line 832
    size_t start[MAX_RANK];
#line 832
    size_t edge[MAX_RANK];
#line 832
    size_t index[MAX_RANK];
#line 832
    size_t index2[MAX_RANK];
#line 832
    size_t mid[MAX_RANK];
#line 832
    size_t count[MAX_RANK];
#line 832
    size_t sstride[MAX_RANK];
#line 832
    ptrdiff_t stride[MAX_RANK];
#line 832
    ptrdiff_t imap[MAX_RANK];
#line 832
    int canConvert;     /* Both text or both numeric */
#line 832
    short value[MAX_NELS];
#line 832
    double expect[MAX_NELS];
#line 832

#line 832
#ifdef TEST_PNETCDF
#line 832
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 832
#else
#line 832
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 832
#endif
#line 832
    IF (err)
#line 832
        error("nc_open: %s", nc_strerror(err));
#line 832
    for (i = 0; i < numVars; i++) {
#line 832
        canConvert = (var_type[i] == NC_CHAR) == (NCT_SHORT == NCT_TEXT);
#line 832
        assert(var_rank[i] <= MAX_RANK);
#line 832
        assert(var_nels[i] <= MAX_NELS);
#line 832
        for (j = 0; j < var_rank[i]; j++) {
#line 832
            start[j] = 0;
#line 832
            edge[j] = 1;
#line 832
            stride[j] = 1;
#line 832
            imap[j] = 1;
#line 832
        }
#line 832
        err = nc_get_varm_short(BAD_ID, i, start, edge, stride, imap, value);
#line 832
        IF (err != NC_EBADID)
#line 832
            error("bad ncid: status = %d", err);
#line 832
        err = nc_get_varm_short(ncid, BAD_VARID, start, edge, stride, imap, value);
#line 832
        IF (err != NC_ENOTVAR)
#line 832
            error("bad var id: status = %d", err);
#line 832
        for (j = 0; j < var_rank[i]; j++) {
#line 832
            start[j] = var_shape[i][j];
#line 832
            err = nc_get_varm_short(ncid, i, start, edge, stride, imap, value);
#line 832
	  if(!canConvert) {
#line 832
		IF (err != NC_ECHAR)
#line 832
               	    error("conversion: status = %d", err);
#line 832
	  } else {
#line 832
	    IF (err != NC_EINVALCOORDS)
#line 832
                error("bad index: status = %d", err);
#line 832
            start[j] = 0;
#line 832
            edge[j] = var_shape[i][j] + 1;
#line 832
            err = nc_get_varm_short(ncid, i, start, edge, stride, imap, value);
#line 832
            IF (err != NC_EEDGE)
#line 832
                error("bad edge: status = %d", err);
#line 832
            edge[j] = 1;
#line 832
            stride[j] = 0;
#line 832
            err = nc_get_varm_short(ncid, i, start, edge, stride, imap, value);
#line 832
            IF (err != NC_ESTRIDE)
#line 832
                error("bad stride: status = %d", err);
#line 832
            stride[j] = 1;
#line 832
           }
#line 832
        }
#line 832
            /* Choose a random point dividing each dim into 2 parts */
#line 832
            /* get 2^rank (nslabs) slabs so defined */
#line 832
        nslabs = 1;
#line 832
        for (j = 0; j < var_rank[i]; j++) {
#line 832
            mid[j] = roll( var_shape[i][j] );
#line 832
            nslabs *= 2;
#line 832
        }
#line 832
            /* bits of k determine whether to get lower or upper part of dim */
#line 832
            /* choose random stride from 1 to edge */
#line 832
        for (k = 0; k < nslabs; k++) {
#line 832
            nstarts = 1;
#line 832
            for (j = 0; j < var_rank[i]; j++) {
#line 832
                if ((k >> j) & 1) {
#line 832
                    start[j] = 0;
#line 832
                    edge[j] = mid[j];
#line 832
                }else{
#line 832
                    start[j] = mid[j];
#line 832
                    edge[j] = var_shape[i][j] - mid[j];
#line 832
                }
#line 832
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 832
                nstarts *= stride[j];
#line 832
            }
#line 832
            for (m = 0; m < nstarts; m++) {
#line 832
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 832
                IF (err)
#line 832
                    error("error in toMixedBase");
#line 832
                nels = 1;
#line 832
                for (j = 0; j < var_rank[i]; j++) {
#line 832
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 832
                    nels *= count[j];
#line 832
                    index[j] += start[j];
#line 832
                }
#line 832
		    /* Random choice of forward or backward */
#line 832
/* TODO
#line 832
		if ( roll(2) ) {
#line 832
		    for (j = 0; j < var_rank[i]; j++) {
#line 832
			index[j] += (count[j] - 1) * stride[j];
#line 832
			stride[j] = -stride[j];
#line 832
		    }
#line 832
		}
#line 832
 */
#line 832
		if (var_rank[i] > 0) {
#line 832
		    j = var_rank[i] - 1;
#line 832
		    imap[j] = 1;
#line 832
		    for (; j > 0; j--)
#line 832
			imap[j-1] = imap[j] * count[j];
#line 832
		}
#line 832
                allInExtRange = allInIntRange = 1;
#line 832
                for (j = 0; j < nels; j++) {
#line 832
                    err = toMixedBase(j, var_rank[i], count, index2);
#line 832
                    IF (err)
#line 832
                        error("error in toMixedBase 1");
#line 832
                    for (d = 0; d < var_rank[i]; d++)
#line 832
                        index2[d] = index[d] + index2[d] * stride[d];
#line 832
                    expect[j] = hash4(var_type[i], var_rank[i], index2,
#line 832
                        NCT_SHORT);
#line 832
                    if (inRange3(expect[j],var_type[i],NCT_SHORT)) {
#line 832
                        allInIntRange = allInIntRange && expect[j] >= short_min
#line 832
                            && expect[j] <= short_max;
#line 832
                    } else {
#line 832
                        allInExtRange = 0;
#line 832
                    }
#line 832
                }
#line 832
                if (var_rank[i] == 0 && i%2 )
#line 832
                    err = nc_get_varm_short(ncid,i,NULL,NULL,NULL,NULL,value);
#line 832
                else
#line 832
                    err = nc_get_varm_short(ncid,i,index,count,stride,imap,value);
#line 832
                if (canConvert) {
#line 832
                    if (allInExtRange) {
#line 832
                        if (allInIntRange) {
#line 832
                            IF (err)
#line 832
                                error("%s", nc_strerror(err));
#line 832
                        } else {
#line 832
                            IF (err != NC_ERANGE)
#line 832
                                error("Range error: status = %d", err);
#line 832
                        }
#line 832
                    } else {
#line 832
                        IF (err != 0 && err != NC_ERANGE)
#line 832
                            error("OK or Range error: status = %d", err);
#line 832
                    }
#line 832
                    for (j = 0; j < nels; j++) {
#line 832
                        if (inRange3(expect[j],var_type[i],NCT_SHORT)
#line 832
                                && expect[j] >= short_min 
#line 832
				&& expect[j] <= short_max) {
#line 832
			    IF (!equal(value[j],expect[j],var_type[i],
#line 832
				    NCT_SHORT)){
#line 832
                                error("value read not that expected");
#line 832
                                if (verbose) {
#line 832
                                    error("\n");
#line 832
                                    error("varid: %d, ", i);
#line 832
                                    error("var_name: %s, ", var_name[i]);
#line 832
                                    error("element number: %d ", j);
#line 832
                                    error("expect: %g, ", expect[j]);
#line 832
                                    error("got: %g", (double) value[j]);
#line 832
                                }
#line 832
                            } else {
#line 832
                                nok++;
#line 832
                            }
#line 832
                        }
#line 832
                    }
#line 832
                } else {
#line 832
                    IF (nels > 0 && err != NC_ECHAR)
#line 832
                        error("wrong type: status = %d", err);
#line 832
                }
#line 832
            }
#line 832
        }
#line 832
    }
#line 832
    err = nc_close(ncid);
#line 832
    IF (err)
#line 832
        error("nc_close: %s", nc_strerror(err));
#line 832
    print_nok(nok);
#line 832
}
#line 832

void
#line 833
test_nc_get_varm_int(void)
#line 833
{
#line 833
    int ncid;
#line 833
    int d;
#line 833
    int i;
#line 833
    int j;
#line 833
    int k;
#line 833
    int m;
#line 833
    int err;
#line 833
    int allInExtRange;	/* all values within external range? */
#line 833
    int allInIntRange;	/* all values within internal range? */
#line 833
    int nels;
#line 833
    int nslabs;
#line 833
    int nstarts;        /* number of different starts */
#line 833
    int nok = 0;      /* count of valid comparisons */
#line 833
    size_t start[MAX_RANK];
#line 833
    size_t edge[MAX_RANK];
#line 833
    size_t index[MAX_RANK];
#line 833
    size_t index2[MAX_RANK];
#line 833
    size_t mid[MAX_RANK];
#line 833
    size_t count[MAX_RANK];
#line 833
    size_t sstride[MAX_RANK];
#line 833
    ptrdiff_t stride[MAX_RANK];
#line 833
    ptrdiff_t imap[MAX_RANK];
#line 833
    int canConvert;     /* Both text or both numeric */
#line 833
    int value[MAX_NELS];
#line 833
    double expect[MAX_NELS];
#line 833

#line 833
#ifdef TEST_PNETCDF
#line 833
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 833
#else
#line 833
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 833
#endif
#line 833
    IF (err)
#line 833
        error("nc_open: %s", nc_strerror(err));
#line 833
    for (i = 0; i < numVars; i++) {
#line 833
        canConvert = (var_type[i] == NC_CHAR) == (NCT_INT == NCT_TEXT);
#line 833
        assert(var_rank[i] <= MAX_RANK);
#line 833
        assert(var_nels[i] <= MAX_NELS);
#line 833
        for (j = 0; j < var_rank[i]; j++) {
#line 833
            start[j] = 0;
#line 833
            edge[j] = 1;
#line 833
            stride[j] = 1;
#line 833
            imap[j] = 1;
#line 833
        }
#line 833
        err = nc_get_varm_int(BAD_ID, i, start, edge, stride, imap, value);
#line 833
        IF (err != NC_EBADID)
#line 833
            error("bad ncid: status = %d", err);
#line 833
        err = nc_get_varm_int(ncid, BAD_VARID, start, edge, stride, imap, value);
#line 833
        IF (err != NC_ENOTVAR)
#line 833
            error("bad var id: status = %d", err);
#line 833
        for (j = 0; j < var_rank[i]; j++) {
#line 833
            start[j] = var_shape[i][j];
#line 833
            err = nc_get_varm_int(ncid, i, start, edge, stride, imap, value);
#line 833
	  if(!canConvert) {
#line 833
		IF (err != NC_ECHAR)
#line 833
               	    error("conversion: status = %d", err);
#line 833
	  } else {
#line 833
	    IF (err != NC_EINVALCOORDS)
#line 833
                error("bad index: status = %d", err);
#line 833
            start[j] = 0;
#line 833
            edge[j] = var_shape[i][j] + 1;
#line 833
            err = nc_get_varm_int(ncid, i, start, edge, stride, imap, value);
#line 833
            IF (err != NC_EEDGE)
#line 833
                error("bad edge: status = %d", err);
#line 833
            edge[j] = 1;
#line 833
            stride[j] = 0;
#line 833
            err = nc_get_varm_int(ncid, i, start, edge, stride, imap, value);
#line 833
            IF (err != NC_ESTRIDE)
#line 833
                error("bad stride: status = %d", err);
#line 833
            stride[j] = 1;
#line 833
           }
#line 833
        }
#line 833
            /* Choose a random point dividing each dim into 2 parts */
#line 833
            /* get 2^rank (nslabs) slabs so defined */
#line 833
        nslabs = 1;
#line 833
        for (j = 0; j < var_rank[i]; j++) {
#line 833
            mid[j] = roll( var_shape[i][j] );
#line 833
            nslabs *= 2;
#line 833
        }
#line 833
            /* bits of k determine whether to get lower or upper part of dim */
#line 833
            /* choose random stride from 1 to edge */
#line 833
        for (k = 0; k < nslabs; k++) {
#line 833
            nstarts = 1;
#line 833
            for (j = 0; j < var_rank[i]; j++) {
#line 833
                if ((k >> j) & 1) {
#line 833
                    start[j] = 0;
#line 833
                    edge[j] = mid[j];
#line 833
                }else{
#line 833
                    start[j] = mid[j];
#line 833
                    edge[j] = var_shape[i][j] - mid[j];
#line 833
                }
#line 833
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 833
                nstarts *= stride[j];
#line 833
            }
#line 833
            for (m = 0; m < nstarts; m++) {
#line 833
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 833
                IF (err)
#line 833
                    error("error in toMixedBase");
#line 833
                nels = 1;
#line 833
                for (j = 0; j < var_rank[i]; j++) {
#line 833
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 833
                    nels *= count[j];
#line 833
                    index[j] += start[j];
#line 833
                }
#line 833
		    /* Random choice of forward or backward */
#line 833
/* TODO
#line 833
		if ( roll(2) ) {
#line 833
		    for (j = 0; j < var_rank[i]; j++) {
#line 833
			index[j] += (count[j] - 1) * stride[j];
#line 833
			stride[j] = -stride[j];
#line 833
		    }
#line 833
		}
#line 833
 */
#line 833
		if (var_rank[i] > 0) {
#line 833
		    j = var_rank[i] - 1;
#line 833
		    imap[j] = 1;
#line 833
		    for (; j > 0; j--)
#line 833
			imap[j-1] = imap[j] * count[j];
#line 833
		}
#line 833
                allInExtRange = allInIntRange = 1;
#line 833
                for (j = 0; j < nels; j++) {
#line 833
                    err = toMixedBase(j, var_rank[i], count, index2);
#line 833
                    IF (err)
#line 833
                        error("error in toMixedBase 1");
#line 833
                    for (d = 0; d < var_rank[i]; d++)
#line 833
                        index2[d] = index[d] + index2[d] * stride[d];
#line 833
                    expect[j] = hash4(var_type[i], var_rank[i], index2,
#line 833
                        NCT_INT);
#line 833
                    if (inRange3(expect[j],var_type[i],NCT_INT)) {
#line 833
                        allInIntRange = allInIntRange && expect[j] >= int_min
#line 833
                            && expect[j] <= int_max;
#line 833
                    } else {
#line 833
                        allInExtRange = 0;
#line 833
                    }
#line 833
                }
#line 833
                if (var_rank[i] == 0 && i%2 )
#line 833
                    err = nc_get_varm_int(ncid,i,NULL,NULL,NULL,NULL,value);
#line 833
                else
#line 833
                    err = nc_get_varm_int(ncid,i,index,count,stride,imap,value);
#line 833
                if (canConvert) {
#line 833
                    if (allInExtRange) {
#line 833
                        if (allInIntRange) {
#line 833
                            IF (err)
#line 833
                                error("%s", nc_strerror(err));
#line 833
                        } else {
#line 833
                            IF (err != NC_ERANGE)
#line 833
                                error("Range error: status = %d", err);
#line 833
                        }
#line 833
                    } else {
#line 833
                        IF (err != 0 && err != NC_ERANGE)
#line 833
                            error("OK or Range error: status = %d", err);
#line 833
                    }
#line 833
                    for (j = 0; j < nels; j++) {
#line 833
                        if (inRange3(expect[j],var_type[i],NCT_INT)
#line 833
                                && expect[j] >= int_min 
#line 833
				&& expect[j] <= int_max) {
#line 833
			    IF (!equal(value[j],expect[j],var_type[i],
#line 833
				    NCT_INT)){
#line 833
                                error("value read not that expected");
#line 833
                                if (verbose) {
#line 833
                                    error("\n");
#line 833
                                    error("varid: %d, ", i);
#line 833
                                    error("var_name: %s, ", var_name[i]);
#line 833
                                    error("element number: %d ", j);
#line 833
                                    error("expect: %g, ", expect[j]);
#line 833
                                    error("got: %g", (double) value[j]);
#line 833
                                }
#line 833
                            } else {
#line 833
                                nok++;
#line 833
                            }
#line 833
                        }
#line 833
                    }
#line 833
                } else {
#line 833
                    IF (nels > 0 && err != NC_ECHAR)
#line 833
                        error("wrong type: status = %d", err);
#line 833
                }
#line 833
            }
#line 833
        }
#line 833
    }
#line 833
    err = nc_close(ncid);
#line 833
    IF (err)
#line 833
        error("nc_close: %s", nc_strerror(err));
#line 833
    print_nok(nok);
#line 833
}
#line 833

void
#line 834
test_nc_get_varm_long(void)
#line 834
{
#line 834
    int ncid;
#line 834
    int d;
#line 834
    int i;
#line 834
    int j;
#line 834
    int k;
#line 834
    int m;
#line 834
    int err;
#line 834
    int allInExtRange;	/* all values within external range? */
#line 834
    int allInIntRange;	/* all values within internal range? */
#line 834
    int nels;
#line 834
    int nslabs;
#line 834
    int nstarts;        /* number of different starts */
#line 834
    int nok = 0;      /* count of valid comparisons */
#line 834
    size_t start[MAX_RANK];
#line 834
    size_t edge[MAX_RANK];
#line 834
    size_t index[MAX_RANK];
#line 834
    size_t index2[MAX_RANK];
#line 834
    size_t mid[MAX_RANK];
#line 834
    size_t count[MAX_RANK];
#line 834
    size_t sstride[MAX_RANK];
#line 834
    ptrdiff_t stride[MAX_RANK];
#line 834
    ptrdiff_t imap[MAX_RANK];
#line 834
    int canConvert;     /* Both text or both numeric */
#line 834
    long value[MAX_NELS];
#line 834
    double expect[MAX_NELS];
#line 834

#line 834
#ifdef TEST_PNETCDF
#line 834
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 834
#else
#line 834
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 834
#endif
#line 834
    IF (err)
#line 834
        error("nc_open: %s", nc_strerror(err));
#line 834
    for (i = 0; i < numVars; i++) {
#line 834
        canConvert = (var_type[i] == NC_CHAR) == (NCT_LONG == NCT_TEXT);
#line 834
        assert(var_rank[i] <= MAX_RANK);
#line 834
        assert(var_nels[i] <= MAX_NELS);
#line 834
        for (j = 0; j < var_rank[i]; j++) {
#line 834
            start[j] = 0;
#line 834
            edge[j] = 1;
#line 834
            stride[j] = 1;
#line 834
            imap[j] = 1;
#line 834
        }
#line 834
        err = nc_get_varm_long(BAD_ID, i, start, edge, stride, imap, value);
#line 834
        IF (err != NC_EBADID)
#line 834
            error("bad ncid: status = %d", err);
#line 834
        err = nc_get_varm_long(ncid, BAD_VARID, start, edge, stride, imap, value);
#line 834
        IF (err != NC_ENOTVAR)
#line 834
            error("bad var id: status = %d", err);
#line 834
        for (j = 0; j < var_rank[i]; j++) {
#line 834
            start[j] = var_shape[i][j];
#line 834
            err = nc_get_varm_long(ncid, i, start, edge, stride, imap, value);
#line 834
	  if(!canConvert) {
#line 834
		IF (err != NC_ECHAR)
#line 834
               	    error("conversion: status = %d", err);
#line 834
	  } else {
#line 834
	    IF (err != NC_EINVALCOORDS)
#line 834
                error("bad index: status = %d", err);
#line 834
            start[j] = 0;
#line 834
            edge[j] = var_shape[i][j] + 1;
#line 834
            err = nc_get_varm_long(ncid, i, start, edge, stride, imap, value);
#line 834
            IF (err != NC_EEDGE)
#line 834
                error("bad edge: status = %d", err);
#line 834
            edge[j] = 1;
#line 834
            stride[j] = 0;
#line 834
            err = nc_get_varm_long(ncid, i, start, edge, stride, imap, value);
#line 834
            IF (err != NC_ESTRIDE)
#line 834
                error("bad stride: status = %d", err);
#line 834
            stride[j] = 1;
#line 834
           }
#line 834
        }
#line 834
            /* Choose a random point dividing each dim into 2 parts */
#line 834
            /* get 2^rank (nslabs) slabs so defined */
#line 834
        nslabs = 1;
#line 834
        for (j = 0; j < var_rank[i]; j++) {
#line 834
            mid[j] = roll( var_shape[i][j] );
#line 834
            nslabs *= 2;
#line 834
        }
#line 834
            /* bits of k determine whether to get lower or upper part of dim */
#line 834
            /* choose random stride from 1 to edge */
#line 834
        for (k = 0; k < nslabs; k++) {
#line 834
            nstarts = 1;
#line 834
            for (j = 0; j < var_rank[i]; j++) {
#line 834
                if ((k >> j) & 1) {
#line 834
                    start[j] = 0;
#line 834
                    edge[j] = mid[j];
#line 834
                }else{
#line 834
                    start[j] = mid[j];
#line 834
                    edge[j] = var_shape[i][j] - mid[j];
#line 834
                }
#line 834
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 834
                nstarts *= stride[j];
#line 834
            }
#line 834
            for (m = 0; m < nstarts; m++) {
#line 834
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 834
                IF (err)
#line 834
                    error("error in toMixedBase");
#line 834
                nels = 1;
#line 834
                for (j = 0; j < var_rank[i]; j++) {
#line 834
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 834
                    nels *= count[j];
#line 834
                    index[j] += start[j];
#line 834
                }
#line 834
		    /* Random choice of forward or backward */
#line 834
/* TODO
#line 834
		if ( roll(2) ) {
#line 834
		    for (j = 0; j < var_rank[i]; j++) {
#line 834
			index[j] += (count[j] - 1) * stride[j];
#line 834
			stride[j] = -stride[j];
#line 834
		    }
#line 834
		}
#line 834
 */
#line 834
		if (var_rank[i] > 0) {
#line 834
		    j = var_rank[i] - 1;
#line 834
		    imap[j] = 1;
#line 834
		    for (; j > 0; j--)
#line 834
			imap[j-1] = imap[j] * count[j];
#line 834
		}
#line 834
                allInExtRange = allInIntRange = 1;
#line 834
                for (j = 0; j < nels; j++) {
#line 834
                    err = toMixedBase(j, var_rank[i], count, index2);
#line 834
                    IF (err)
#line 834
                        error("error in toMixedBase 1");
#line 834
                    for (d = 0; d < var_rank[i]; d++)
#line 834
                        index2[d] = index[d] + index2[d] * stride[d];
#line 834
                    expect[j] = hash4(var_type[i], var_rank[i], index2,
#line 834
                        NCT_LONG);
#line 834
                    if (inRange3(expect[j],var_type[i],NCT_LONG)) {
#line 834
                        allInIntRange = allInIntRange && expect[j] >= long_min
#line 834
                            && expect[j] <= long_max;
#line 834
                    } else {
#line 834
                        allInExtRange = 0;
#line 834
                    }
#line 834
                }
#line 834
                if (var_rank[i] == 0 && i%2 )
#line 834
                    err = nc_get_varm_long(ncid,i,NULL,NULL,NULL,NULL,value);
#line 834
                else
#line 834
                    err = nc_get_varm_long(ncid,i,index,count,stride,imap,value);
#line 834
                if (canConvert) {
#line 834
                    if (allInExtRange) {
#line 834
                        if (allInIntRange) {
#line 834
                            IF (err)
#line 834
                                error("%s", nc_strerror(err));
#line 834
                        } else {
#line 834
                            IF (err != NC_ERANGE)
#line 834
                                error("Range error: status = %d", err);
#line 834
                        }
#line 834
                    } else {
#line 834
                        IF (err != 0 && err != NC_ERANGE)
#line 834
                            error("OK or Range error: status = %d", err);
#line 834
                    }
#line 834
                    for (j = 0; j < nels; j++) {
#line 834
                        if (inRange3(expect[j],var_type[i],NCT_LONG)
#line 834
                                && expect[j] >= long_min 
#line 834
				&& expect[j] <= long_max) {
#line 834
			    IF (!equal(value[j],expect[j],var_type[i],
#line 834
				    NCT_LONG)){
#line 834
                                error("value read not that expected");
#line 834
                                if (verbose) {
#line 834
                                    error("\n");
#line 834
                                    error("varid: %d, ", i);
#line 834
                                    error("var_name: %s, ", var_name[i]);
#line 834
                                    error("element number: %d ", j);
#line 834
                                    error("expect: %g, ", expect[j]);
#line 834
                                    error("got: %g", (double) value[j]);
#line 834
                                }
#line 834
                            } else {
#line 834
                                nok++;
#line 834
                            }
#line 834
                        }
#line 834
                    }
#line 834
                } else {
#line 834
                    IF (nels > 0 && err != NC_ECHAR)
#line 834
                        error("wrong type: status = %d", err);
#line 834
                }
#line 834
            }
#line 834
        }
#line 834
    }
#line 834
    err = nc_close(ncid);
#line 834
    IF (err)
#line 834
        error("nc_close: %s", nc_strerror(err));
#line 834
    print_nok(nok);
#line 834
}
#line 834

void
#line 835
test_nc_get_varm_float(void)
#line 835
{
#line 835
    int ncid;
#line 835
    int d;
#line 835
    int i;
#line 835
    int j;
#line 835
    int k;
#line 835
    int m;
#line 835
    int err;
#line 835
    int allInExtRange;	/* all values within external range? */
#line 835
    int allInIntRange;	/* all values within internal range? */
#line 835
    int nels;
#line 835
    int nslabs;
#line 835
    int nstarts;        /* number of different starts */
#line 835
    int nok = 0;      /* count of valid comparisons */
#line 835
    size_t start[MAX_RANK];
#line 835
    size_t edge[MAX_RANK];
#line 835
    size_t index[MAX_RANK];
#line 835
    size_t index2[MAX_RANK];
#line 835
    size_t mid[MAX_RANK];
#line 835
    size_t count[MAX_RANK];
#line 835
    size_t sstride[MAX_RANK];
#line 835
    ptrdiff_t stride[MAX_RANK];
#line 835
    ptrdiff_t imap[MAX_RANK];
#line 835
    int canConvert;     /* Both text or both numeric */
#line 835
    float value[MAX_NELS];
#line 835
    double expect[MAX_NELS];
#line 835

#line 835
#ifdef TEST_PNETCDF
#line 835
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 835
#else
#line 835
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 835
#endif
#line 835
    IF (err)
#line 835
        error("nc_open: %s", nc_strerror(err));
#line 835
    for (i = 0; i < numVars; i++) {
#line 835
        canConvert = (var_type[i] == NC_CHAR) == (NCT_FLOAT == NCT_TEXT);
#line 835
        assert(var_rank[i] <= MAX_RANK);
#line 835
        assert(var_nels[i] <= MAX_NELS);
#line 835
        for (j = 0; j < var_rank[i]; j++) {
#line 835
            start[j] = 0;
#line 835
            edge[j] = 1;
#line 835
            stride[j] = 1;
#line 835
            imap[j] = 1;
#line 835
        }
#line 835
        err = nc_get_varm_float(BAD_ID, i, start, edge, stride, imap, value);
#line 835
        IF (err != NC_EBADID)
#line 835
            error("bad ncid: status = %d", err);
#line 835
        err = nc_get_varm_float(ncid, BAD_VARID, start, edge, stride, imap, value);
#line 835
        IF (err != NC_ENOTVAR)
#line 835
            error("bad var id: status = %d", err);
#line 835
        for (j = 0; j < var_rank[i]; j++) {
#line 835
            start[j] = var_shape[i][j];
#line 835
            err = nc_get_varm_float(ncid, i, start, edge, stride, imap, value);
#line 835
	  if(!canConvert) {
#line 835
		IF (err != NC_ECHAR)
#line 835
               	    error("conversion: status = %d", err);
#line 835
	  } else {
#line 835
	    IF (err != NC_EINVALCOORDS)
#line 835
                error("bad index: status = %d", err);
#line 835
            start[j] = 0;
#line 835
            edge[j] = var_shape[i][j] + 1;
#line 835
            err = nc_get_varm_float(ncid, i, start, edge, stride, imap, value);
#line 835
            IF (err != NC_EEDGE)
#line 835
                error("bad edge: status = %d", err);
#line 835
            edge[j] = 1;
#line 835
            stride[j] = 0;
#line 835
            err = nc_get_varm_float(ncid, i, start, edge, stride, imap, value);
#line 835
            IF (err != NC_ESTRIDE)
#line 835
                error("bad stride: status = %d", err);
#line 835
            stride[j] = 1;
#line 835
           }
#line 835
        }
#line 835
            /* Choose a random point dividing each dim into 2 parts */
#line 835
            /* get 2^rank (nslabs) slabs so defined */
#line 835
        nslabs = 1;
#line 835
        for (j = 0; j < var_rank[i]; j++) {
#line 835
            mid[j] = roll( var_shape[i][j] );
#line 835
            nslabs *= 2;
#line 835
        }
#line 835
            /* bits of k determine whether to get lower or upper part of dim */
#line 835
            /* choose random stride from 1 to edge */
#line 835
        for (k = 0; k < nslabs; k++) {
#line 835
            nstarts = 1;
#line 835
            for (j = 0; j < var_rank[i]; j++) {
#line 835
                if ((k >> j) & 1) {
#line 835
                    start[j] = 0;
#line 835
                    edge[j] = mid[j];
#line 835
                }else{
#line 835
                    start[j] = mid[j];
#line 835
                    edge[j] = var_shape[i][j] - mid[j];
#line 835
                }
#line 835
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 835
                nstarts *= stride[j];
#line 835
            }
#line 835
            for (m = 0; m < nstarts; m++) {
#line 835
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 835
                IF (err)
#line 835
                    error("error in toMixedBase");
#line 835
                nels = 1;
#line 835
                for (j = 0; j < var_rank[i]; j++) {
#line 835
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 835
                    nels *= count[j];
#line 835
                    index[j] += start[j];
#line 835
                }
#line 835
		    /* Random choice of forward or backward */
#line 835
/* TODO
#line 835
		if ( roll(2) ) {
#line 835
		    for (j = 0; j < var_rank[i]; j++) {
#line 835
			index[j] += (count[j] - 1) * stride[j];
#line 835
			stride[j] = -stride[j];
#line 835
		    }
#line 835
		}
#line 835
 */
#line 835
		if (var_rank[i] > 0) {
#line 835
		    j = var_rank[i] - 1;
#line 835
		    imap[j] = 1;
#line 835
		    for (; j > 0; j--)
#line 835
			imap[j-1] = imap[j] * count[j];
#line 835
		}
#line 835
                allInExtRange = allInIntRange = 1;
#line 835
                for (j = 0; j < nels; j++) {
#line 835
                    err = toMixedBase(j, var_rank[i], count, index2);
#line 835
                    IF (err)
#line 835
                        error("error in toMixedBase 1");
#line 835
                    for (d = 0; d < var_rank[i]; d++)
#line 835
                        index2[d] = index[d] + index2[d] * stride[d];
#line 835
                    expect[j] = hash4(var_type[i], var_rank[i], index2,
#line 835
                        NCT_FLOAT);
#line 835
                    if (inRange3(expect[j],var_type[i],NCT_FLOAT)) {
#line 835
                        allInIntRange = allInIntRange && expect[j] >= float_min
#line 835
                            && expect[j] <= float_max;
#line 835
                    } else {
#line 835
                        allInExtRange = 0;
#line 835
                    }
#line 835
                }
#line 835
                if (var_rank[i] == 0 && i%2 )
#line 835
                    err = nc_get_varm_float(ncid,i,NULL,NULL,NULL,NULL,value);
#line 835
                else
#line 835
                    err = nc_get_varm_float(ncid,i,index,count,stride,imap,value);
#line 835
                if (canConvert) {
#line 835
                    if (allInExtRange) {
#line 835
                        if (allInIntRange) {
#line 835
                            IF (err)
#line 835
                                error("%s", nc_strerror(err));
#line 835
                        } else {
#line 835
                            IF (err != NC_ERANGE)
#line 835
                                error("Range error: status = %d", err);
#line 835
                        }
#line 835
                    } else {
#line 835
                        IF (err != 0 && err != NC_ERANGE)
#line 835
                            error("OK or Range error: status = %d", err);
#line 835
                    }
#line 835
                    for (j = 0; j < nels; j++) {
#line 835
                        if (inRange3(expect[j],var_type[i],NCT_FLOAT)
#line 835
                                && expect[j] >= float_min 
#line 835
				&& expect[j] <= float_max) {
#line 835
			    IF (!equal(value[j],expect[j],var_type[i],
#line 835
				    NCT_FLOAT)){
#line 835
                                error("value read not that expected");
#line 835
                                if (verbose) {
#line 835
                                    error("\n");
#line 835
                                    error("varid: %d, ", i);
#line 835
                                    error("var_name: %s, ", var_name[i]);
#line 835
                                    error("element number: %d ", j);
#line 835
                                    error("expect: %g, ", expect[j]);
#line 835
                                    error("got: %g", (double) value[j]);
#line 835
                                }
#line 835
                            } else {
#line 835
                                nok++;
#line 835
                            }
#line 835
                        }
#line 835
                    }
#line 835
                } else {
#line 835
                    IF (nels > 0 && err != NC_ECHAR)
#line 835
                        error("wrong type: status = %d", err);
#line 835
                }
#line 835
            }
#line 835
        }
#line 835
    }
#line 835
    err = nc_close(ncid);
#line 835
    IF (err)
#line 835
        error("nc_close: %s", nc_strerror(err));
#line 835
    print_nok(nok);
#line 835
}
#line 835

void
#line 836
test_nc_get_varm_double(void)
#line 836
{
#line 836
    int ncid;
#line 836
    int d;
#line 836
    int i;
#line 836
    int j;
#line 836
    int k;
#line 836
    int m;
#line 836
    int err;
#line 836
    int allInExtRange;	/* all values within external range? */
#line 836
    int allInIntRange;	/* all values within internal range? */
#line 836
    int nels;
#line 836
    int nslabs;
#line 836
    int nstarts;        /* number of different starts */
#line 836
    int nok = 0;      /* count of valid comparisons */
#line 836
    size_t start[MAX_RANK];
#line 836
    size_t edge[MAX_RANK];
#line 836
    size_t index[MAX_RANK];
#line 836
    size_t index2[MAX_RANK];
#line 836
    size_t mid[MAX_RANK];
#line 836
    size_t count[MAX_RANK];
#line 836
    size_t sstride[MAX_RANK];
#line 836
    ptrdiff_t stride[MAX_RANK];
#line 836
    ptrdiff_t imap[MAX_RANK];
#line 836
    int canConvert;     /* Both text or both numeric */
#line 836
    double value[MAX_NELS];
#line 836
    double expect[MAX_NELS];
#line 836

#line 836
#ifdef TEST_PNETCDF
#line 836
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 836
#else
#line 836
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 836
#endif
#line 836
    IF (err)
#line 836
        error("nc_open: %s", nc_strerror(err));
#line 836
    for (i = 0; i < numVars; i++) {
#line 836
        canConvert = (var_type[i] == NC_CHAR) == (NCT_DOUBLE == NCT_TEXT);
#line 836
        assert(var_rank[i] <= MAX_RANK);
#line 836
        assert(var_nels[i] <= MAX_NELS);
#line 836
        for (j = 0; j < var_rank[i]; j++) {
#line 836
            start[j] = 0;
#line 836
            edge[j] = 1;
#line 836
            stride[j] = 1;
#line 836
            imap[j] = 1;
#line 836
        }
#line 836
        err = nc_get_varm_double(BAD_ID, i, start, edge, stride, imap, value);
#line 836
        IF (err != NC_EBADID)
#line 836
            error("bad ncid: status = %d", err);
#line 836
        err = nc_get_varm_double(ncid, BAD_VARID, start, edge, stride, imap, value);
#line 836
        IF (err != NC_ENOTVAR)
#line 836
            error("bad var id: status = %d", err);
#line 836
        for (j = 0; j < var_rank[i]; j++) {
#line 836
            start[j] = var_shape[i][j];
#line 836
            err = nc_get_varm_double(ncid, i, start, edge, stride, imap, value);
#line 836
	  if(!canConvert) {
#line 836
		IF (err != NC_ECHAR)
#line 836
               	    error("conversion: status = %d", err);
#line 836
	  } else {
#line 836
	    IF (err != NC_EINVALCOORDS)
#line 836
                error("bad index: status = %d", err);
#line 836
            start[j] = 0;
#line 836
            edge[j] = var_shape[i][j] + 1;
#line 836
            err = nc_get_varm_double(ncid, i, start, edge, stride, imap, value);
#line 836
            IF (err != NC_EEDGE)
#line 836
                error("bad edge: status = %d", err);
#line 836
            edge[j] = 1;
#line 836
            stride[j] = 0;
#line 836
            err = nc_get_varm_double(ncid, i, start, edge, stride, imap, value);
#line 836
            IF (err != NC_ESTRIDE)
#line 836
                error("bad stride: status = %d", err);
#line 836
            stride[j] = 1;
#line 836
           }
#line 836
        }
#line 836
            /* Choose a random point dividing each dim into 2 parts */
#line 836
            /* get 2^rank (nslabs) slabs so defined */
#line 836
        nslabs = 1;
#line 836
        for (j = 0; j < var_rank[i]; j++) {
#line 836
            mid[j] = roll( var_shape[i][j] );
#line 836
            nslabs *= 2;
#line 836
        }
#line 836
            /* bits of k determine whether to get lower or upper part of dim */
#line 836
            /* choose random stride from 1 to edge */
#line 836
        for (k = 0; k < nslabs; k++) {
#line 836
            nstarts = 1;
#line 836
            for (j = 0; j < var_rank[i]; j++) {
#line 836
                if ((k >> j) & 1) {
#line 836
                    start[j] = 0;
#line 836
                    edge[j] = mid[j];
#line 836
                }else{
#line 836
                    start[j] = mid[j];
#line 836
                    edge[j] = var_shape[i][j] - mid[j];
#line 836
                }
#line 836
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 836
                nstarts *= stride[j];
#line 836
            }
#line 836
            for (m = 0; m < nstarts; m++) {
#line 836
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 836
                IF (err)
#line 836
                    error("error in toMixedBase");
#line 836
                nels = 1;
#line 836
                for (j = 0; j < var_rank[i]; j++) {
#line 836
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 836
                    nels *= count[j];
#line 836
                    index[j] += start[j];
#line 836
                }
#line 836
		    /* Random choice of forward or backward */
#line 836
/* TODO
#line 836
		if ( roll(2) ) {
#line 836
		    for (j = 0; j < var_rank[i]; j++) {
#line 836
			index[j] += (count[j] - 1) * stride[j];
#line 836
			stride[j] = -stride[j];
#line 836
		    }
#line 836
		}
#line 836
 */
#line 836
		if (var_rank[i] > 0) {
#line 836
		    j = var_rank[i] - 1;
#line 836
		    imap[j] = 1;
#line 836
		    for (; j > 0; j--)
#line 836
			imap[j-1] = imap[j] * count[j];
#line 836
		}
#line 836
                allInExtRange = allInIntRange = 1;
#line 836
                for (j = 0; j < nels; j++) {
#line 836
                    err = toMixedBase(j, var_rank[i], count, index2);
#line 836
                    IF (err)
#line 836
                        error("error in toMixedBase 1");
#line 836
                    for (d = 0; d < var_rank[i]; d++)
#line 836
                        index2[d] = index[d] + index2[d] * stride[d];
#line 836
                    expect[j] = hash4(var_type[i], var_rank[i], index2,
#line 836
                        NCT_DOUBLE);
#line 836
                    if (inRange3(expect[j],var_type[i],NCT_DOUBLE)) {
#line 836
                        allInIntRange = allInIntRange && expect[j] >= double_min
#line 836
                            && expect[j] <= double_max;
#line 836
                    } else {
#line 836
                        allInExtRange = 0;
#line 836
                    }
#line 836
                }
#line 836
                if (var_rank[i] == 0 && i%2 )
#line 836
                    err = nc_get_varm_double(ncid,i,NULL,NULL,NULL,NULL,value);
#line 836
                else
#line 836
                    err = nc_get_varm_double(ncid,i,index,count,stride,imap,value);
#line 836
                if (canConvert) {
#line 836
                    if (allInExtRange) {
#line 836
                        if (allInIntRange) {
#line 836
                            IF (err)
#line 836
                                error("%s", nc_strerror(err));
#line 836
                        } else {
#line 836
                            IF (err != NC_ERANGE)
#line 836
                                error("Range error: status = %d", err);
#line 836
                        }
#line 836
                    } else {
#line 836
                        IF (err != 0 && err != NC_ERANGE)
#line 836
                            error("OK or Range error: status = %d", err);
#line 836
                    }
#line 836
                    for (j = 0; j < nels; j++) {
#line 836
                        if (inRange3(expect[j],var_type[i],NCT_DOUBLE)
#line 836
                                && expect[j] >= double_min 
#line 836
				&& expect[j] <= double_max) {
#line 836
			    IF (!equal(value[j],expect[j],var_type[i],
#line 836
				    NCT_DOUBLE)){
#line 836
                                error("value read not that expected");
#line 836
                                if (verbose) {
#line 836
                                    error("\n");
#line 836
                                    error("varid: %d, ", i);
#line 836
                                    error("var_name: %s, ", var_name[i]);
#line 836
                                    error("element number: %d ", j);
#line 836
                                    error("expect: %g, ", expect[j]);
#line 836
                                    error("got: %g", (double) value[j]);
#line 836
                                }
#line 836
                            } else {
#line 836
                                nok++;
#line 836
                            }
#line 836
                        }
#line 836
                    }
#line 836
                } else {
#line 836
                    IF (nels > 0 && err != NC_ECHAR)
#line 836
                        error("wrong type: status = %d", err);
#line 836
                }
#line 836
            }
#line 836
        }
#line 836
    }
#line 836
    err = nc_close(ncid);
#line 836
    IF (err)
#line 836
        error("nc_close: %s", nc_strerror(err));
#line 836
    print_nok(nok);
#line 836
}
#line 836

void
#line 837
test_nc_get_varm_ushort(void)
#line 837
{
#line 837
    int ncid;
#line 837
    int d;
#line 837
    int i;
#line 837
    int j;
#line 837
    int k;
#line 837
    int m;
#line 837
    int err;
#line 837
    int allInExtRange;	/* all values within external range? */
#line 837
    int allInIntRange;	/* all values within internal range? */
#line 837
    int nels;
#line 837
    int nslabs;
#line 837
    int nstarts;        /* number of different starts */
#line 837
    int nok = 0;      /* count of valid comparisons */
#line 837
    size_t start[MAX_RANK];
#line 837
    size_t edge[MAX_RANK];
#line 837
    size_t index[MAX_RANK];
#line 837
    size_t index2[MAX_RANK];
#line 837
    size_t mid[MAX_RANK];
#line 837
    size_t count[MAX_RANK];
#line 837
    size_t sstride[MAX_RANK];
#line 837
    ptrdiff_t stride[MAX_RANK];
#line 837
    ptrdiff_t imap[MAX_RANK];
#line 837
    int canConvert;     /* Both text or both numeric */
#line 837
    ushort value[MAX_NELS];
#line 837
    double expect[MAX_NELS];
#line 837

#line 837
#ifdef TEST_PNETCDF
#line 837
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 837
#else
#line 837
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 837
#endif
#line 837
    IF (err)
#line 837
        error("nc_open: %s", nc_strerror(err));
#line 837
    for (i = 0; i < numVars; i++) {
#line 837
        canConvert = (var_type[i] == NC_CHAR) == (NCT_USHORT == NCT_TEXT);
#line 837
        assert(var_rank[i] <= MAX_RANK);
#line 837
        assert(var_nels[i] <= MAX_NELS);
#line 837
        for (j = 0; j < var_rank[i]; j++) {
#line 837
            start[j] = 0;
#line 837
            edge[j] = 1;
#line 837
            stride[j] = 1;
#line 837
            imap[j] = 1;
#line 837
        }
#line 837
        err = nc_get_varm_ushort(BAD_ID, i, start, edge, stride, imap, value);
#line 837
        IF (err != NC_EBADID)
#line 837
            error("bad ncid: status = %d", err);
#line 837
        err = nc_get_varm_ushort(ncid, BAD_VARID, start, edge, stride, imap, value);
#line 837
        IF (err != NC_ENOTVAR)
#line 837
            error("bad var id: status = %d", err);
#line 837
        for (j = 0; j < var_rank[i]; j++) {
#line 837
            start[j] = var_shape[i][j];
#line 837
            err = nc_get_varm_ushort(ncid, i, start, edge, stride, imap, value);
#line 837
	  if(!canConvert) {
#line 837
		IF (err != NC_ECHAR)
#line 837
               	    error("conversion: status = %d", err);
#line 837
	  } else {
#line 837
	    IF (err != NC_EINVALCOORDS)
#line 837
                error("bad index: status = %d", err);
#line 837
            start[j] = 0;
#line 837
            edge[j] = var_shape[i][j] + 1;
#line 837
            err = nc_get_varm_ushort(ncid, i, start, edge, stride, imap, value);
#line 837
            IF (err != NC_EEDGE)
#line 837
                error("bad edge: status = %d", err);
#line 837
            edge[j] = 1;
#line 837
            stride[j] = 0;
#line 837
            err = nc_get_varm_ushort(ncid, i, start, edge, stride, imap, value);
#line 837
            IF (err != NC_ESTRIDE)
#line 837
                error("bad stride: status = %d", err);
#line 837
            stride[j] = 1;
#line 837
           }
#line 837
        }
#line 837
            /* Choose a random point dividing each dim into 2 parts */
#line 837
            /* get 2^rank (nslabs) slabs so defined */
#line 837
        nslabs = 1;
#line 837
        for (j = 0; j < var_rank[i]; j++) {
#line 837
            mid[j] = roll( var_shape[i][j] );
#line 837
            nslabs *= 2;
#line 837
        }
#line 837
            /* bits of k determine whether to get lower or upper part of dim */
#line 837
            /* choose random stride from 1 to edge */
#line 837
        for (k = 0; k < nslabs; k++) {
#line 837
            nstarts = 1;
#line 837
            for (j = 0; j < var_rank[i]; j++) {
#line 837
                if ((k >> j) & 1) {
#line 837
                    start[j] = 0;
#line 837
                    edge[j] = mid[j];
#line 837
                }else{
#line 837
                    start[j] = mid[j];
#line 837
                    edge[j] = var_shape[i][j] - mid[j];
#line 837
                }
#line 837
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 837
                nstarts *= stride[j];
#line 837
            }
#line 837
            for (m = 0; m < nstarts; m++) {
#line 837
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 837
                IF (err)
#line 837
                    error("error in toMixedBase");
#line 837
                nels = 1;
#line 837
                for (j = 0; j < var_rank[i]; j++) {
#line 837
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 837
                    nels *= count[j];
#line 837
                    index[j] += start[j];
#line 837
                }
#line 837
		    /* Random choice of forward or backward */
#line 837
/* TODO
#line 837
		if ( roll(2) ) {
#line 837
		    for (j = 0; j < var_rank[i]; j++) {
#line 837
			index[j] += (count[j] - 1) * stride[j];
#line 837
			stride[j] = -stride[j];
#line 837
		    }
#line 837
		}
#line 837
 */
#line 837
		if (var_rank[i] > 0) {
#line 837
		    j = var_rank[i] - 1;
#line 837
		    imap[j] = 1;
#line 837
		    for (; j > 0; j--)
#line 837
			imap[j-1] = imap[j] * count[j];
#line 837
		}
#line 837
                allInExtRange = allInIntRange = 1;
#line 837
                for (j = 0; j < nels; j++) {
#line 837
                    err = toMixedBase(j, var_rank[i], count, index2);
#line 837
                    IF (err)
#line 837
                        error("error in toMixedBase 1");
#line 837
                    for (d = 0; d < var_rank[i]; d++)
#line 837
                        index2[d] = index[d] + index2[d] * stride[d];
#line 837
                    expect[j] = hash4(var_type[i], var_rank[i], index2,
#line 837
                        NCT_USHORT);
#line 837
                    if (inRange3(expect[j],var_type[i],NCT_USHORT)) {
#line 837
                        allInIntRange = allInIntRange && expect[j] >= ushort_min
#line 837
                            && expect[j] <= ushort_max;
#line 837
                    } else {
#line 837
                        allInExtRange = 0;
#line 837
                    }
#line 837
                }
#line 837
                if (var_rank[i] == 0 && i%2 )
#line 837
                    err = nc_get_varm_ushort(ncid,i,NULL,NULL,NULL,NULL,value);
#line 837
                else
#line 837
                    err = nc_get_varm_ushort(ncid,i,index,count,stride,imap,value);
#line 837
                if (canConvert) {
#line 837
                    if (allInExtRange) {
#line 837
                        if (allInIntRange) {
#line 837
                            IF (err)
#line 837
                                error("%s", nc_strerror(err));
#line 837
                        } else {
#line 837
                            IF (err != NC_ERANGE)
#line 837
                                error("Range error: status = %d", err);
#line 837
                        }
#line 837
                    } else {
#line 837
                        IF (err != 0 && err != NC_ERANGE)
#line 837
                            error("OK or Range error: status = %d", err);
#line 837
                    }
#line 837
                    for (j = 0; j < nels; j++) {
#line 837
                        if (inRange3(expect[j],var_type[i],NCT_USHORT)
#line 837
                                && expect[j] >= ushort_min 
#line 837
				&& expect[j] <= ushort_max) {
#line 837
			    IF (!equal(value[j],expect[j],var_type[i],
#line 837
				    NCT_USHORT)){
#line 837
                                error("value read not that expected");
#line 837
                                if (verbose) {
#line 837
                                    error("\n");
#line 837
                                    error("varid: %d, ", i);
#line 837
                                    error("var_name: %s, ", var_name[i]);
#line 837
                                    error("element number: %d ", j);
#line 837
                                    error("expect: %g, ", expect[j]);
#line 837
                                    error("got: %g", (double) value[j]);
#line 837
                                }
#line 837
                            } else {
#line 837
                                nok++;
#line 837
                            }
#line 837
                        }
#line 837
                    }
#line 837
                } else {
#line 837
                    IF (nels > 0 && err != NC_ECHAR)
#line 837
                        error("wrong type: status = %d", err);
#line 837
                }
#line 837
            }
#line 837
        }
#line 837
    }
#line 837
    err = nc_close(ncid);
#line 837
    IF (err)
#line 837
        error("nc_close: %s", nc_strerror(err));
#line 837
    print_nok(nok);
#line 837
}
#line 837

void
#line 838
test_nc_get_varm_uint(void)
#line 838
{
#line 838
    int ncid;
#line 838
    int d;
#line 838
    int i;
#line 838
    int j;
#line 838
    int k;
#line 838
    int m;
#line 838
    int err;
#line 838
    int allInExtRange;	/* all values within external range? */
#line 838
    int allInIntRange;	/* all values within internal range? */
#line 838
    int nels;
#line 838
    int nslabs;
#line 838
    int nstarts;        /* number of different starts */
#line 838
    int nok = 0;      /* count of valid comparisons */
#line 838
    size_t start[MAX_RANK];
#line 838
    size_t edge[MAX_RANK];
#line 838
    size_t index[MAX_RANK];
#line 838
    size_t index2[MAX_RANK];
#line 838
    size_t mid[MAX_RANK];
#line 838
    size_t count[MAX_RANK];
#line 838
    size_t sstride[MAX_RANK];
#line 838
    ptrdiff_t stride[MAX_RANK];
#line 838
    ptrdiff_t imap[MAX_RANK];
#line 838
    int canConvert;     /* Both text or both numeric */
#line 838
    uint value[MAX_NELS];
#line 838
    double expect[MAX_NELS];
#line 838

#line 838
#ifdef TEST_PNETCDF
#line 838
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 838
#else
#line 838
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 838
#endif
#line 838
    IF (err)
#line 838
        error("nc_open: %s", nc_strerror(err));
#line 838
    for (i = 0; i < numVars; i++) {
#line 838
        canConvert = (var_type[i] == NC_CHAR) == (NCT_UINT == NCT_TEXT);
#line 838
        assert(var_rank[i] <= MAX_RANK);
#line 838
        assert(var_nels[i] <= MAX_NELS);
#line 838
        for (j = 0; j < var_rank[i]; j++) {
#line 838
            start[j] = 0;
#line 838
            edge[j] = 1;
#line 838
            stride[j] = 1;
#line 838
            imap[j] = 1;
#line 838
        }
#line 838
        err = nc_get_varm_uint(BAD_ID, i, start, edge, stride, imap, value);
#line 838
        IF (err != NC_EBADID)
#line 838
            error("bad ncid: status = %d", err);
#line 838
        err = nc_get_varm_uint(ncid, BAD_VARID, start, edge, stride, imap, value);
#line 838
        IF (err != NC_ENOTVAR)
#line 838
            error("bad var id: status = %d", err);
#line 838
        for (j = 0; j < var_rank[i]; j++) {
#line 838
            start[j] = var_shape[i][j];
#line 838
            err = nc_get_varm_uint(ncid, i, start, edge, stride, imap, value);
#line 838
	  if(!canConvert) {
#line 838
		IF (err != NC_ECHAR)
#line 838
               	    error("conversion: status = %d", err);
#line 838
	  } else {
#line 838
	    IF (err != NC_EINVALCOORDS)
#line 838
                error("bad index: status = %d", err);
#line 838
            start[j] = 0;
#line 838
            edge[j] = var_shape[i][j] + 1;
#line 838
            err = nc_get_varm_uint(ncid, i, start, edge, stride, imap, value);
#line 838
            IF (err != NC_EEDGE)
#line 838
                error("bad edge: status = %d", err);
#line 838
            edge[j] = 1;
#line 838
            stride[j] = 0;
#line 838
            err = nc_get_varm_uint(ncid, i, start, edge, stride, imap, value);
#line 838
            IF (err != NC_ESTRIDE)
#line 838
                error("bad stride: status = %d", err);
#line 838
            stride[j] = 1;
#line 838
           }
#line 838
        }
#line 838
            /* Choose a random point dividing each dim into 2 parts */
#line 838
            /* get 2^rank (nslabs) slabs so defined */
#line 838
        nslabs = 1;
#line 838
        for (j = 0; j < var_rank[i]; j++) {
#line 838
            mid[j] = roll( var_shape[i][j] );
#line 838
            nslabs *= 2;
#line 838
        }
#line 838
            /* bits of k determine whether to get lower or upper part of dim */
#line 838
            /* choose random stride from 1 to edge */
#line 838
        for (k = 0; k < nslabs; k++) {
#line 838
            nstarts = 1;
#line 838
            for (j = 0; j < var_rank[i]; j++) {
#line 838
                if ((k >> j) & 1) {
#line 838
                    start[j] = 0;
#line 838
                    edge[j] = mid[j];
#line 838
                }else{
#line 838
                    start[j] = mid[j];
#line 838
                    edge[j] = var_shape[i][j] - mid[j];
#line 838
                }
#line 838
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 838
                nstarts *= stride[j];
#line 838
            }
#line 838
            for (m = 0; m < nstarts; m++) {
#line 838
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 838
                IF (err)
#line 838
                    error("error in toMixedBase");
#line 838
                nels = 1;
#line 838
                for (j = 0; j < var_rank[i]; j++) {
#line 838
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 838
                    nels *= count[j];
#line 838
                    index[j] += start[j];
#line 838
                }
#line 838
		    /* Random choice of forward or backward */
#line 838
/* TODO
#line 838
		if ( roll(2) ) {
#line 838
		    for (j = 0; j < var_rank[i]; j++) {
#line 838
			index[j] += (count[j] - 1) * stride[j];
#line 838
			stride[j] = -stride[j];
#line 838
		    }
#line 838
		}
#line 838
 */
#line 838
		if (var_rank[i] > 0) {
#line 838
		    j = var_rank[i] - 1;
#line 838
		    imap[j] = 1;
#line 838
		    for (; j > 0; j--)
#line 838
			imap[j-1] = imap[j] * count[j];
#line 838
		}
#line 838
                allInExtRange = allInIntRange = 1;
#line 838
                for (j = 0; j < nels; j++) {
#line 838
                    err = toMixedBase(j, var_rank[i], count, index2);
#line 838
                    IF (err)
#line 838
                        error("error in toMixedBase 1");
#line 838
                    for (d = 0; d < var_rank[i]; d++)
#line 838
                        index2[d] = index[d] + index2[d] * stride[d];
#line 838
                    expect[j] = hash4(var_type[i], var_rank[i], index2,
#line 838
                        NCT_UINT);
#line 838
                    if (inRange3(expect[j],var_type[i],NCT_UINT)) {
#line 838
                        allInIntRange = allInIntRange && expect[j] >= uint_min
#line 838
                            && expect[j] <= uint_max;
#line 838
                    } else {
#line 838
                        allInExtRange = 0;
#line 838
                    }
#line 838
                }
#line 838
                if (var_rank[i] == 0 && i%2 )
#line 838
                    err = nc_get_varm_uint(ncid,i,NULL,NULL,NULL,NULL,value);
#line 838
                else
#line 838
                    err = nc_get_varm_uint(ncid,i,index,count,stride,imap,value);
#line 838
                if (canConvert) {
#line 838
                    if (allInExtRange) {
#line 838
                        if (allInIntRange) {
#line 838
                            IF (err)
#line 838
                                error("%s", nc_strerror(err));
#line 838
                        } else {
#line 838
                            IF (err != NC_ERANGE)
#line 838
                                error("Range error: status = %d", err);
#line 838
                        }
#line 838
                    } else {
#line 838
                        IF (err != 0 && err != NC_ERANGE)
#line 838
                            error("OK or Range error: status = %d", err);
#line 838
                    }
#line 838
                    for (j = 0; j < nels; j++) {
#line 838
                        if (inRange3(expect[j],var_type[i],NCT_UINT)
#line 838
                                && expect[j] >= uint_min 
#line 838
				&& expect[j] <= uint_max) {
#line 838
			    IF (!equal(value[j],expect[j],var_type[i],
#line 838
				    NCT_UINT)){
#line 838
                                error("value read not that expected");
#line 838
                                if (verbose) {
#line 838
                                    error("\n");
#line 838
                                    error("varid: %d, ", i);
#line 838
                                    error("var_name: %s, ", var_name[i]);
#line 838
                                    error("element number: %d ", j);
#line 838
                                    error("expect: %g, ", expect[j]);
#line 838
                                    error("got: %g", (double) value[j]);
#line 838
                                }
#line 838
                            } else {
#line 838
                                nok++;
#line 838
                            }
#line 838
                        }
#line 838
                    }
#line 838
                } else {
#line 838
                    IF (nels > 0 && err != NC_ECHAR)
#line 838
                        error("wrong type: status = %d", err);
#line 838
                }
#line 838
            }
#line 838
        }
#line 838
    }
#line 838
    err = nc_close(ncid);
#line 838
    IF (err)
#line 838
        error("nc_close: %s", nc_strerror(err));
#line 838
    print_nok(nok);
#line 838
}
#line 838

void
#line 839
test_nc_get_varm_longlong(void)
#line 839
{
#line 839
    int ncid;
#line 839
    int d;
#line 839
    int i;
#line 839
    int j;
#line 839
    int k;
#line 839
    int m;
#line 839
    int err;
#line 839
    int allInExtRange;	/* all values within external range? */
#line 839
    int allInIntRange;	/* all values within internal range? */
#line 839
    int nels;
#line 839
    int nslabs;
#line 839
    int nstarts;        /* number of different starts */
#line 839
    int nok = 0;      /* count of valid comparisons */
#line 839
    size_t start[MAX_RANK];
#line 839
    size_t edge[MAX_RANK];
#line 839
    size_t index[MAX_RANK];
#line 839
    size_t index2[MAX_RANK];
#line 839
    size_t mid[MAX_RANK];
#line 839
    size_t count[MAX_RANK];
#line 839
    size_t sstride[MAX_RANK];
#line 839
    ptrdiff_t stride[MAX_RANK];
#line 839
    ptrdiff_t imap[MAX_RANK];
#line 839
    int canConvert;     /* Both text or both numeric */
#line 839
    longlong value[MAX_NELS];
#line 839
    double expect[MAX_NELS];
#line 839

#line 839
#ifdef TEST_PNETCDF
#line 839
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 839
#else
#line 839
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 839
#endif
#line 839
    IF (err)
#line 839
        error("nc_open: %s", nc_strerror(err));
#line 839
    for (i = 0; i < numVars; i++) {
#line 839
        canConvert = (var_type[i] == NC_CHAR) == (NCT_LONGLONG == NCT_TEXT);
#line 839
        assert(var_rank[i] <= MAX_RANK);
#line 839
        assert(var_nels[i] <= MAX_NELS);
#line 839
        for (j = 0; j < var_rank[i]; j++) {
#line 839
            start[j] = 0;
#line 839
            edge[j] = 1;
#line 839
            stride[j] = 1;
#line 839
            imap[j] = 1;
#line 839
        }
#line 839
        err = nc_get_varm_longlong(BAD_ID, i, start, edge, stride, imap, value);
#line 839
        IF (err != NC_EBADID)
#line 839
            error("bad ncid: status = %d", err);
#line 839
        err = nc_get_varm_longlong(ncid, BAD_VARID, start, edge, stride, imap, value);
#line 839
        IF (err != NC_ENOTVAR)
#line 839
            error("bad var id: status = %d", err);
#line 839
        for (j = 0; j < var_rank[i]; j++) {
#line 839
            start[j] = var_shape[i][j];
#line 839
            err = nc_get_varm_longlong(ncid, i, start, edge, stride, imap, value);
#line 839
	  if(!canConvert) {
#line 839
		IF (err != NC_ECHAR)
#line 839
               	    error("conversion: status = %d", err);
#line 839
	  } else {
#line 839
	    IF (err != NC_EINVALCOORDS)
#line 839
                error("bad index: status = %d", err);
#line 839
            start[j] = 0;
#line 839
            edge[j] = var_shape[i][j] + 1;
#line 839
            err = nc_get_varm_longlong(ncid, i, start, edge, stride, imap, value);
#line 839
            IF (err != NC_EEDGE)
#line 839
                error("bad edge: status = %d", err);
#line 839
            edge[j] = 1;
#line 839
            stride[j] = 0;
#line 839
            err = nc_get_varm_longlong(ncid, i, start, edge, stride, imap, value);
#line 839
            IF (err != NC_ESTRIDE)
#line 839
                error("bad stride: status = %d", err);
#line 839
            stride[j] = 1;
#line 839
           }
#line 839
        }
#line 839
            /* Choose a random point dividing each dim into 2 parts */
#line 839
            /* get 2^rank (nslabs) slabs so defined */
#line 839
        nslabs = 1;
#line 839
        for (j = 0; j < var_rank[i]; j++) {
#line 839
            mid[j] = roll( var_shape[i][j] );
#line 839
            nslabs *= 2;
#line 839
        }
#line 839
            /* bits of k determine whether to get lower or upper part of dim */
#line 839
            /* choose random stride from 1 to edge */
#line 839
        for (k = 0; k < nslabs; k++) {
#line 839
            nstarts = 1;
#line 839
            for (j = 0; j < var_rank[i]; j++) {
#line 839
                if ((k >> j) & 1) {
#line 839
                    start[j] = 0;
#line 839
                    edge[j] = mid[j];
#line 839
                }else{
#line 839
                    start[j] = mid[j];
#line 839
                    edge[j] = var_shape[i][j] - mid[j];
#line 839
                }
#line 839
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 839
                nstarts *= stride[j];
#line 839
            }
#line 839
            for (m = 0; m < nstarts; m++) {
#line 839
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 839
                IF (err)
#line 839
                    error("error in toMixedBase");
#line 839
                nels = 1;
#line 839
                for (j = 0; j < var_rank[i]; j++) {
#line 839
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 839
                    nels *= count[j];
#line 839
                    index[j] += start[j];
#line 839
                }
#line 839
		    /* Random choice of forward or backward */
#line 839
/* TODO
#line 839
		if ( roll(2) ) {
#line 839
		    for (j = 0; j < var_rank[i]; j++) {
#line 839
			index[j] += (count[j] - 1) * stride[j];
#line 839
			stride[j] = -stride[j];
#line 839
		    }
#line 839
		}
#line 839
 */
#line 839
		if (var_rank[i] > 0) {
#line 839
		    j = var_rank[i] - 1;
#line 839
		    imap[j] = 1;
#line 839
		    for (; j > 0; j--)
#line 839
			imap[j-1] = imap[j] * count[j];
#line 839
		}
#line 839
                allInExtRange = allInIntRange = 1;
#line 839
                for (j = 0; j < nels; j++) {
#line 839
                    err = toMixedBase(j, var_rank[i], count, index2);
#line 839
                    IF (err)
#line 839
                        error("error in toMixedBase 1");
#line 839
                    for (d = 0; d < var_rank[i]; d++)
#line 839
                        index2[d] = index[d] + index2[d] * stride[d];
#line 839
                    expect[j] = hash4(var_type[i], var_rank[i], index2,
#line 839
                        NCT_LONGLONG);
#line 839
                    if (inRange3(expect[j],var_type[i],NCT_LONGLONG)) {
#line 839
                        allInIntRange = allInIntRange && expect[j] >= longlong_min
#line 839
                            && expect[j] <= longlong_max;
#line 839
                    } else {
#line 839
                        allInExtRange = 0;
#line 839
                    }
#line 839
                }
#line 839
                if (var_rank[i] == 0 && i%2 )
#line 839
                    err = nc_get_varm_longlong(ncid,i,NULL,NULL,NULL,NULL,value);
#line 839
                else
#line 839
                    err = nc_get_varm_longlong(ncid,i,index,count,stride,imap,value);
#line 839
                if (canConvert) {
#line 839
                    if (allInExtRange) {
#line 839
                        if (allInIntRange) {
#line 839
                            IF (err)
#line 839
                                error("%s", nc_strerror(err));
#line 839
                        } else {
#line 839
                            IF (err != NC_ERANGE)
#line 839
                                error("Range error: status = %d", err);
#line 839
                        }
#line 839
                    } else {
#line 839
                        IF (err != 0 && err != NC_ERANGE)
#line 839
                            error("OK or Range error: status = %d", err);
#line 839
                    }
#line 839
                    for (j = 0; j < nels; j++) {
#line 839
                        if (inRange3(expect[j],var_type[i],NCT_LONGLONG)
#line 839
                                && expect[j] >= longlong_min 
#line 839
				&& expect[j] <= longlong_max) {
#line 839
			    IF (!equal(value[j],expect[j],var_type[i],
#line 839
				    NCT_LONGLONG)){
#line 839
                                error("value read not that expected");
#line 839
                                if (verbose) {
#line 839
                                    error("\n");
#line 839
                                    error("varid: %d, ", i);
#line 839
                                    error("var_name: %s, ", var_name[i]);
#line 839
                                    error("element number: %d ", j);
#line 839
                                    error("expect: %g, ", expect[j]);
#line 839
                                    error("got: %g", (double) value[j]);
#line 839
                                }
#line 839
                            } else {
#line 839
                                nok++;
#line 839
                            }
#line 839
                        }
#line 839
                    }
#line 839
                } else {
#line 839
                    IF (nels > 0 && err != NC_ECHAR)
#line 839
                        error("wrong type: status = %d", err);
#line 839
                }
#line 839
            }
#line 839
        }
#line 839
    }
#line 839
    err = nc_close(ncid);
#line 839
    IF (err)
#line 839
        error("nc_close: %s", nc_strerror(err));
#line 839
    print_nok(nok);
#line 839
}
#line 839

void
#line 840
test_nc_get_varm_ulonglong(void)
#line 840
{
#line 840
    int ncid;
#line 840
    int d;
#line 840
    int i;
#line 840
    int j;
#line 840
    int k;
#line 840
    int m;
#line 840
    int err;
#line 840
    int allInExtRange;	/* all values within external range? */
#line 840
    int allInIntRange;	/* all values within internal range? */
#line 840
    int nels;
#line 840
    int nslabs;
#line 840
    int nstarts;        /* number of different starts */
#line 840
    int nok = 0;      /* count of valid comparisons */
#line 840
    size_t start[MAX_RANK];
#line 840
    size_t edge[MAX_RANK];
#line 840
    size_t index[MAX_RANK];
#line 840
    size_t index2[MAX_RANK];
#line 840
    size_t mid[MAX_RANK];
#line 840
    size_t count[MAX_RANK];
#line 840
    size_t sstride[MAX_RANK];
#line 840
    ptrdiff_t stride[MAX_RANK];
#line 840
    ptrdiff_t imap[MAX_RANK];
#line 840
    int canConvert;     /* Both text or both numeric */
#line 840
    ulonglong value[MAX_NELS];
#line 840
    double expect[MAX_NELS];
#line 840

#line 840
#ifdef TEST_PNETCDF
#line 840
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 840
#else
#line 840
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 840
#endif
#line 840
    IF (err)
#line 840
        error("nc_open: %s", nc_strerror(err));
#line 840
    for (i = 0; i < numVars; i++) {
#line 840
        canConvert = (var_type[i] == NC_CHAR) == (NCT_ULONGLONG == NCT_TEXT);
#line 840
        assert(var_rank[i] <= MAX_RANK);
#line 840
        assert(var_nels[i] <= MAX_NELS);
#line 840
        for (j = 0; j < var_rank[i]; j++) {
#line 840
            start[j] = 0;
#line 840
            edge[j] = 1;
#line 840
            stride[j] = 1;
#line 840
            imap[j] = 1;
#line 840
        }
#line 840
        err = nc_get_varm_ulonglong(BAD_ID, i, start, edge, stride, imap, value);
#line 840
        IF (err != NC_EBADID)
#line 840
            error("bad ncid: status = %d", err);
#line 840
        err = nc_get_varm_ulonglong(ncid, BAD_VARID, start, edge, stride, imap, value);
#line 840
        IF (err != NC_ENOTVAR)
#line 840
            error("bad var id: status = %d", err);
#line 840
        for (j = 0; j < var_rank[i]; j++) {
#line 840
            start[j] = var_shape[i][j];
#line 840
            err = nc_get_varm_ulonglong(ncid, i, start, edge, stride, imap, value);
#line 840
	  if(!canConvert) {
#line 840
		IF (err != NC_ECHAR)
#line 840
               	    error("conversion: status = %d", err);
#line 840
	  } else {
#line 840
	    IF (err != NC_EINVALCOORDS)
#line 840
                error("bad index: status = %d", err);
#line 840
            start[j] = 0;
#line 840
            edge[j] = var_shape[i][j] + 1;
#line 840
            err = nc_get_varm_ulonglong(ncid, i, start, edge, stride, imap, value);
#line 840
            IF (err != NC_EEDGE)
#line 840
                error("bad edge: status = %d", err);
#line 840
            edge[j] = 1;
#line 840
            stride[j] = 0;
#line 840
            err = nc_get_varm_ulonglong(ncid, i, start, edge, stride, imap, value);
#line 840
            IF (err != NC_ESTRIDE)
#line 840
                error("bad stride: status = %d", err);
#line 840
            stride[j] = 1;
#line 840
           }
#line 840
        }
#line 840
            /* Choose a random point dividing each dim into 2 parts */
#line 840
            /* get 2^rank (nslabs) slabs so defined */
#line 840
        nslabs = 1;
#line 840
        for (j = 0; j < var_rank[i]; j++) {
#line 840
            mid[j] = roll( var_shape[i][j] );
#line 840
            nslabs *= 2;
#line 840
        }
#line 840
            /* bits of k determine whether to get lower or upper part of dim */
#line 840
            /* choose random stride from 1 to edge */
#line 840
        for (k = 0; k < nslabs; k++) {
#line 840
            nstarts = 1;
#line 840
            for (j = 0; j < var_rank[i]; j++) {
#line 840
                if ((k >> j) & 1) {
#line 840
                    start[j] = 0;
#line 840
                    edge[j] = mid[j];
#line 840
                }else{
#line 840
                    start[j] = mid[j];
#line 840
                    edge[j] = var_shape[i][j] - mid[j];
#line 840
                }
#line 840
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 840
                nstarts *= stride[j];
#line 840
            }
#line 840
            for (m = 0; m < nstarts; m++) {
#line 840
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 840
                IF (err)
#line 840
                    error("error in toMixedBase");
#line 840
                nels = 1;
#line 840
                for (j = 0; j < var_rank[i]; j++) {
#line 840
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 840
                    nels *= count[j];
#line 840
                    index[j] += start[j];
#line 840
                }
#line 840
		    /* Random choice of forward or backward */
#line 840
/* TODO
#line 840
		if ( roll(2) ) {
#line 840
		    for (j = 0; j < var_rank[i]; j++) {
#line 840
			index[j] += (count[j] - 1) * stride[j];
#line 840
			stride[j] = -stride[j];
#line 840
		    }
#line 840
		}
#line 840
 */
#line 840
		if (var_rank[i] > 0) {
#line 840
		    j = var_rank[i] - 1;
#line 840
		    imap[j] = 1;
#line 840
		    for (; j > 0; j--)
#line 840
			imap[j-1] = imap[j] * count[j];
#line 840
		}
#line 840
                allInExtRange = allInIntRange = 1;
#line 840
                for (j = 0; j < nels; j++) {
#line 840
                    err = toMixedBase(j, var_rank[i], count, index2);
#line 840
                    IF (err)
#line 840
                        error("error in toMixedBase 1");
#line 840
                    for (d = 0; d < var_rank[i]; d++)
#line 840
                        index2[d] = index[d] + index2[d] * stride[d];
#line 840
                    expect[j] = hash4(var_type[i], var_rank[i], index2,
#line 840
                        NCT_ULONGLONG);
#line 840
                    if (inRange3(expect[j],var_type[i],NCT_ULONGLONG)) {
#line 840
                        allInIntRange = allInIntRange && expect[j] >= ulonglong_min
#line 840
                            && expect[j] <= ulonglong_max;
#line 840
                    } else {
#line 840
                        allInExtRange = 0;
#line 840
                    }
#line 840
                }
#line 840
                if (var_rank[i] == 0 && i%2 )
#line 840
                    err = nc_get_varm_ulonglong(ncid,i,NULL,NULL,NULL,NULL,value);
#line 840
                else
#line 840
                    err = nc_get_varm_ulonglong(ncid,i,index,count,stride,imap,value);
#line 840
                if (canConvert) {
#line 840
                    if (allInExtRange) {
#line 840
                        if (allInIntRange) {
#line 840
                            IF (err)
#line 840
                                error("%s", nc_strerror(err));
#line 840
                        } else {
#line 840
                            IF (err != NC_ERANGE)
#line 840
                                error("Range error: status = %d", err);
#line 840
                        }
#line 840
                    } else {
#line 840
                        IF (err != 0 && err != NC_ERANGE)
#line 840
                            error("OK or Range error: status = %d", err);
#line 840
                    }
#line 840
                    for (j = 0; j < nels; j++) {
#line 840
                        if (inRange3(expect[j],var_type[i],NCT_ULONGLONG)
#line 840
                                && expect[j] >= ulonglong_min 
#line 840
				&& expect[j] <= ulonglong_max) {
#line 840
			    IF (!equal(value[j],expect[j],var_type[i],
#line 840
				    NCT_ULONGLONG)){
#line 840
                                error("value read not that expected");
#line 840
                                if (verbose) {
#line 840
                                    error("\n");
#line 840
                                    error("varid: %d, ", i);
#line 840
                                    error("var_name: %s, ", var_name[i]);
#line 840
                                    error("element number: %d ", j);
#line 840
                                    error("expect: %g, ", expect[j]);
#line 840
                                    error("got: %g", (double) value[j]);
#line 840
                                }
#line 840
                            } else {
#line 840
                                nok++;
#line 840
                            }
#line 840
                        }
#line 840
                    }
#line 840
                } else {
#line 840
                    IF (nels > 0 && err != NC_ECHAR)
#line 840
                        error("wrong type: status = %d", err);
#line 840
                }
#line 840
            }
#line 840
        }
#line 840
    }
#line 840
    err = nc_close(ncid);
#line 840
    IF (err)
#line 840
        error("nc_close: %s", nc_strerror(err));
#line 840
    print_nok(nok);
#line 840
}
#line 840



#line 938

void
#line 939
test_nc_get_att_text(void)
#line 939
{
#line 939
    int ncid;
#line 939
    int i;
#line 939
    int j;
#line 939
    size_t k;
#line 939
    int err;
#line 939
    int allInExtRange;
#line 939
    int allInIntRange;
#line 939
    int canConvert;     /* Both text or both numeric */
#line 939
    text value[MAX_NELS];
#line 939
    double expect[MAX_NELS];
#line 939
    int nok = 0;      /* count of valid comparisons */
#line 939

#line 939
#ifdef TEST_PNETCDF
#line 939
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 939
#else
#line 939
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 939
#endif
#line 939
    IF (err) 
#line 939
	error("nc_open: %s", nc_strerror(err));
#line 939

#line 939
    for (i = -1; i < numVars; i++) {
#line 939
        for (j = 0; j < NATTS(i); j++) {
#line 939
	    canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_TEXT == NCT_TEXT);
#line 939
	    err = nc_get_att_text(BAD_ID, i, ATT_NAME(i,j), value);
#line 939
	    IF (err != NC_EBADID) 
#line 939
		error("bad ncid: status = %d", err);
#line 939
	    err = nc_get_att_text(ncid, BAD_VARID, ATT_NAME(i,j), value);
#line 939
	    IF (err != NC_ENOTVAR) 
#line 939
		error("bad var id: status = %d", err);
#line 939
	    err = nc_get_att_text(ncid, i, "noSuch", value);
#line 939
	    IF (err != NC_ENOTATT) 
#line 939
		error("Bad attribute name: status = %d", err);
#line 939
	    allInExtRange = allInIntRange = 1;
#line 939
            for (k = 0; k < ATT_LEN(i,j); k++) {
#line 939
		expect[k] = hash4(ATT_TYPE(i,j), -1, &k, NCT_TEXT);
#line 939
                if (inRange3(expect[k],ATT_TYPE(i,j),NCT_TEXT)) {
#line 939
                    allInIntRange = allInIntRange && expect[k] >= text_min
#line 939
                                && expect[k] <= text_max;
#line 939
                } else {
#line 939
                    allInExtRange = 0;
#line 939
                }
#line 939
	    }
#line 939
	    err = nc_get_att_text(ncid, i, ATT_NAME(i,j), value);
#line 939
            if (canConvert || ATT_LEN(i,j) == 0) {
#line 939
                if (allInExtRange) {
#line 939
                    if (allInIntRange) {
#line 939
                        IF (err)
#line 939
                            error("%s", nc_strerror(err));
#line 939
                    } else {
#line 939
                        IF (err != NC_ERANGE)
#line 939
                            error("Range error: status = %d", err);
#line 939
                    }
#line 939
                } else {
#line 939
                    IF (err != 0 && err != NC_ERANGE)
#line 939
                        error("OK or Range error: status = %d", err);
#line 939
                }
#line 939
		for (k = 0; k < ATT_LEN(i,j); k++) {
#line 939
		    if (inRange3(expect[k],ATT_TYPE(i,j),NCT_TEXT)
#line 939
                            && expect[k] >= text_min && expect[k] <= text_max) {
#line 939
			IF (!equal(value[k],expect[k],ATT_TYPE(i,j),
#line 939
				NCT_TEXT)){
#line 939
			    error("value read not that expected");
#line 939
                            if (verbose) {
#line 939
                                error("\n");
#line 939
                                error("varid: %d, ", i);
#line 939
                                error("att_name: %s, ", ATT_NAME(i,j));
#line 939
                                error("element number: %d ", k);
#line 939
                                error("expect: %g", expect[k]);
#line 939
                                error("got: %g", (double) value[k]);
#line 939
                            }
#line 939
			} else {
#line 939
			    nok++;
#line 939
                        }
#line 939
		    }
#line 939
		}
#line 939
	    } else {
#line 939
		IF (err != NC_ECHAR)
#line 939
		    error("wrong type: status = %d", err);
#line 939
	    }
#line 939
	}
#line 939
    }
#line 939

#line 939
    err = nc_close(ncid);
#line 939
    IF (err)
#line 939
	error("nc_close: %s", nc_strerror(err));
#line 939
    print_nok(nok);
#line 939
}
#line 939

void
#line 940
test_nc_get_att_uchar(void)
#line 940
{
#line 940
    int ncid;
#line 940
    int i;
#line 940
    int j;
#line 940
    size_t k;
#line 940
    int err;
#line 940
    int allInExtRange;
#line 940
    int allInIntRange;
#line 940
    int canConvert;     /* Both text or both numeric */
#line 940
    uchar value[MAX_NELS];
#line 940
    double expect[MAX_NELS];
#line 940
    int nok = 0;      /* count of valid comparisons */
#line 940

#line 940
#ifdef TEST_PNETCDF
#line 940
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 940
#else
#line 940
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 940
#endif
#line 940
    IF (err) 
#line 940
	error("nc_open: %s", nc_strerror(err));
#line 940

#line 940
    for (i = -1; i < numVars; i++) {
#line 940
        for (j = 0; j < NATTS(i); j++) {
#line 940
	    canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_UCHAR == NCT_TEXT);
#line 940
	    err = nc_get_att_uchar(BAD_ID, i, ATT_NAME(i,j), value);
#line 940
	    IF (err != NC_EBADID) 
#line 940
		error("bad ncid: status = %d", err);
#line 940
	    err = nc_get_att_uchar(ncid, BAD_VARID, ATT_NAME(i,j), value);
#line 940
	    IF (err != NC_ENOTVAR) 
#line 940
		error("bad var id: status = %d", err);
#line 940
	    err = nc_get_att_uchar(ncid, i, "noSuch", value);
#line 940
	    IF (err != NC_ENOTATT) 
#line 940
		error("Bad attribute name: status = %d", err);
#line 940
	    allInExtRange = allInIntRange = 1;
#line 940
            for (k = 0; k < ATT_LEN(i,j); k++) {
#line 940
		expect[k] = hash4(ATT_TYPE(i,j), -1, &k, NCT_UCHAR);
#line 940
                if (inRange3(expect[k],ATT_TYPE(i,j),NCT_UCHAR)) {
#line 940
                    allInIntRange = allInIntRange && expect[k] >= uchar_min
#line 940
                                && expect[k] <= uchar_max;
#line 940
                } else {
#line 940
                    allInExtRange = 0;
#line 940
                }
#line 940
	    }
#line 940
	    err = nc_get_att_uchar(ncid, i, ATT_NAME(i,j), value);
#line 940
            if (canConvert || ATT_LEN(i,j) == 0) {
#line 940
                if (allInExtRange) {
#line 940
                    if (allInIntRange) {
#line 940
                        IF (err)
#line 940
                            error("%s", nc_strerror(err));
#line 940
                    } else {
#line 940
                        IF (err != NC_ERANGE)
#line 940
                            error("Range error: status = %d", err);
#line 940
                    }
#line 940
                } else {
#line 940
                    IF (err != 0 && err != NC_ERANGE)
#line 940
                        error("OK or Range error: status = %d", err);
#line 940
                }
#line 940
		for (k = 0; k < ATT_LEN(i,j); k++) {
#line 940
		    if (inRange3(expect[k],ATT_TYPE(i,j),NCT_UCHAR)
#line 940
                            && expect[k] >= uchar_min && expect[k] <= uchar_max) {
#line 940
			IF (!equal(value[k],expect[k],ATT_TYPE(i,j),
#line 940
				NCT_UCHAR)){
#line 940
			    error("value read not that expected");
#line 940
                            if (verbose) {
#line 940
                                error("\n");
#line 940
                                error("varid: %d, ", i);
#line 940
                                error("att_name: %s, ", ATT_NAME(i,j));
#line 940
                                error("element number: %d ", k);
#line 940
                                error("expect: %g", expect[k]);
#line 940
                                error("got: %g", (double) value[k]);
#line 940
                            }
#line 940
			} else {
#line 940
			    nok++;
#line 940
                        }
#line 940
		    }
#line 940
		}
#line 940
	    } else {
#line 940
		IF (err != NC_ECHAR)
#line 940
		    error("wrong type: status = %d", err);
#line 940
	    }
#line 940
	}
#line 940
    }
#line 940

#line 940
    err = nc_close(ncid);
#line 940
    IF (err)
#line 940
	error("nc_close: %s", nc_strerror(err));
#line 940
    print_nok(nok);
#line 940
}
#line 940

void
#line 941
test_nc_get_att_schar(void)
#line 941
{
#line 941
    int ncid;
#line 941
    int i;
#line 941
    int j;
#line 941
    size_t k;
#line 941
    int err;
#line 941
    int allInExtRange;
#line 941
    int allInIntRange;
#line 941
    int canConvert;     /* Both text or both numeric */
#line 941
    schar value[MAX_NELS];
#line 941
    double expect[MAX_NELS];
#line 941
    int nok = 0;      /* count of valid comparisons */
#line 941

#line 941
#ifdef TEST_PNETCDF
#line 941
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 941
#else
#line 941
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 941
#endif
#line 941
    IF (err) 
#line 941
	error("nc_open: %s", nc_strerror(err));
#line 941

#line 941
    for (i = -1; i < numVars; i++) {
#line 941
        for (j = 0; j < NATTS(i); j++) {
#line 941
	    canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_SCHAR == NCT_TEXT);
#line 941
	    err = nc_get_att_schar(BAD_ID, i, ATT_NAME(i,j), value);
#line 941
	    IF (err != NC_EBADID) 
#line 941
		error("bad ncid: status = %d", err);
#line 941
	    err = nc_get_att_schar(ncid, BAD_VARID, ATT_NAME(i,j), value);
#line 941
	    IF (err != NC_ENOTVAR) 
#line 941
		error("bad var id: status = %d", err);
#line 941
	    err = nc_get_att_schar(ncid, i, "noSuch", value);
#line 941
	    IF (err != NC_ENOTATT) 
#line 941
		error("Bad attribute name: status = %d", err);
#line 941
	    allInExtRange = allInIntRange = 1;
#line 941
            for (k = 0; k < ATT_LEN(i,j); k++) {
#line 941
		expect[k] = hash4(ATT_TYPE(i,j), -1, &k, NCT_SCHAR);
#line 941
                if (inRange3(expect[k],ATT_TYPE(i,j),NCT_SCHAR)) {
#line 941
                    allInIntRange = allInIntRange && expect[k] >= schar_min
#line 941
                                && expect[k] <= schar_max;
#line 941
                } else {
#line 941
                    allInExtRange = 0;
#line 941
                }
#line 941
	    }
#line 941
	    err = nc_get_att_schar(ncid, i, ATT_NAME(i,j), value);
#line 941
            if (canConvert || ATT_LEN(i,j) == 0) {
#line 941
                if (allInExtRange) {
#line 941
                    if (allInIntRange) {
#line 941
                        IF (err)
#line 941
                            error("%s", nc_strerror(err));
#line 941
                    } else {
#line 941
                        IF (err != NC_ERANGE)
#line 941
                            error("Range error: status = %d", err);
#line 941
                    }
#line 941
                } else {
#line 941
                    IF (err != 0 && err != NC_ERANGE)
#line 941
                        error("OK or Range error: status = %d", err);
#line 941
                }
#line 941
		for (k = 0; k < ATT_LEN(i,j); k++) {
#line 941
		    if (inRange3(expect[k],ATT_TYPE(i,j),NCT_SCHAR)
#line 941
                            && expect[k] >= schar_min && expect[k] <= schar_max) {
#line 941
			IF (!equal(value[k],expect[k],ATT_TYPE(i,j),
#line 941
				NCT_SCHAR)){
#line 941
			    error("value read not that expected");
#line 941
                            if (verbose) {
#line 941
                                error("\n");
#line 941
                                error("varid: %d, ", i);
#line 941
                                error("att_name: %s, ", ATT_NAME(i,j));
#line 941
                                error("element number: %d ", k);
#line 941
                                error("expect: %g", expect[k]);
#line 941
                                error("got: %g", (double) value[k]);
#line 941
                            }
#line 941
			} else {
#line 941
			    nok++;
#line 941
                        }
#line 941
		    }
#line 941
		}
#line 941
	    } else {
#line 941
		IF (err != NC_ECHAR)
#line 941
		    error("wrong type: status = %d", err);
#line 941
	    }
#line 941
	}
#line 941
    }
#line 941

#line 941
    err = nc_close(ncid);
#line 941
    IF (err)
#line 941
	error("nc_close: %s", nc_strerror(err));
#line 941
    print_nok(nok);
#line 941
}
#line 941

void
#line 942
test_nc_get_att_short(void)
#line 942
{
#line 942
    int ncid;
#line 942
    int i;
#line 942
    int j;
#line 942
    size_t k;
#line 942
    int err;
#line 942
    int allInExtRange;
#line 942
    int allInIntRange;
#line 942
    int canConvert;     /* Both text or both numeric */
#line 942
    short value[MAX_NELS];
#line 942
    double expect[MAX_NELS];
#line 942
    int nok = 0;      /* count of valid comparisons */
#line 942

#line 942
#ifdef TEST_PNETCDF
#line 942
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 942
#else
#line 942
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 942
#endif
#line 942
    IF (err) 
#line 942
	error("nc_open: %s", nc_strerror(err));
#line 942

#line 942
    for (i = -1; i < numVars; i++) {
#line 942
        for (j = 0; j < NATTS(i); j++) {
#line 942
	    canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_SHORT == NCT_TEXT);
#line 942
	    err = nc_get_att_short(BAD_ID, i, ATT_NAME(i,j), value);
#line 942
	    IF (err != NC_EBADID) 
#line 942
		error("bad ncid: status = %d", err);
#line 942
	    err = nc_get_att_short(ncid, BAD_VARID, ATT_NAME(i,j), value);
#line 942
	    IF (err != NC_ENOTVAR) 
#line 942
		error("bad var id: status = %d", err);
#line 942
	    err = nc_get_att_short(ncid, i, "noSuch", value);
#line 942
	    IF (err != NC_ENOTATT) 
#line 942
		error("Bad attribute name: status = %d", err);
#line 942
	    allInExtRange = allInIntRange = 1;
#line 942
            for (k = 0; k < ATT_LEN(i,j); k++) {
#line 942
		expect[k] = hash4(ATT_TYPE(i,j), -1, &k, NCT_SHORT);
#line 942
                if (inRange3(expect[k],ATT_TYPE(i,j),NCT_SHORT)) {
#line 942
                    allInIntRange = allInIntRange && expect[k] >= short_min
#line 942
                                && expect[k] <= short_max;
#line 942
                } else {
#line 942
                    allInExtRange = 0;
#line 942
                }
#line 942
	    }
#line 942
	    err = nc_get_att_short(ncid, i, ATT_NAME(i,j), value);
#line 942
            if (canConvert || ATT_LEN(i,j) == 0) {
#line 942
                if (allInExtRange) {
#line 942
                    if (allInIntRange) {
#line 942
                        IF (err)
#line 942
                            error("%s", nc_strerror(err));
#line 942
                    } else {
#line 942
                        IF (err != NC_ERANGE)
#line 942
                            error("Range error: status = %d", err);
#line 942
                    }
#line 942
                } else {
#line 942
                    IF (err != 0 && err != NC_ERANGE)
#line 942
                        error("OK or Range error: status = %d", err);
#line 942
                }
#line 942
		for (k = 0; k < ATT_LEN(i,j); k++) {
#line 942
		    if (inRange3(expect[k],ATT_TYPE(i,j),NCT_SHORT)
#line 942
                            && expect[k] >= short_min && expect[k] <= short_max) {
#line 942
			IF (!equal(value[k],expect[k],ATT_TYPE(i,j),
#line 942
				NCT_SHORT)){
#line 942
			    error("value read not that expected");
#line 942
                            if (verbose) {
#line 942
                                error("\n");
#line 942
                                error("varid: %d, ", i);
#line 942
                                error("att_name: %s, ", ATT_NAME(i,j));
#line 942
                                error("element number: %d ", k);
#line 942
                                error("expect: %g", expect[k]);
#line 942
                                error("got: %g", (double) value[k]);
#line 942
                            }
#line 942
			} else {
#line 942
			    nok++;
#line 942
                        }
#line 942
		    }
#line 942
		}
#line 942
	    } else {
#line 942
		IF (err != NC_ECHAR)
#line 942
		    error("wrong type: status = %d", err);
#line 942
	    }
#line 942
	}
#line 942
    }
#line 942

#line 942
    err = nc_close(ncid);
#line 942
    IF (err)
#line 942
	error("nc_close: %s", nc_strerror(err));
#line 942
    print_nok(nok);
#line 942
}
#line 942

void
#line 943
test_nc_get_att_int(void)
#line 943
{
#line 943
    int ncid;
#line 943
    int i;
#line 943
    int j;
#line 943
    size_t k;
#line 943
    int err;
#line 943
    int allInExtRange;
#line 943
    int allInIntRange;
#line 943
    int canConvert;     /* Both text or both numeric */
#line 943
    int value[MAX_NELS];
#line 943
    double expect[MAX_NELS];
#line 943
    int nok = 0;      /* count of valid comparisons */
#line 943

#line 943
#ifdef TEST_PNETCDF
#line 943
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 943
#else
#line 943
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 943
#endif
#line 943
    IF (err) 
#line 943
	error("nc_open: %s", nc_strerror(err));
#line 943

#line 943
    for (i = -1; i < numVars; i++) {
#line 943
        for (j = 0; j < NATTS(i); j++) {
#line 943
	    canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_INT == NCT_TEXT);
#line 943
	    err = nc_get_att_int(BAD_ID, i, ATT_NAME(i,j), value);
#line 943
	    IF (err != NC_EBADID) 
#line 943
		error("bad ncid: status = %d", err);
#line 943
	    err = nc_get_att_int(ncid, BAD_VARID, ATT_NAME(i,j), value);
#line 943
	    IF (err != NC_ENOTVAR) 
#line 943
		error("bad var id: status = %d", err);
#line 943
	    err = nc_get_att_int(ncid, i, "noSuch", value);
#line 943
	    IF (err != NC_ENOTATT) 
#line 943
		error("Bad attribute name: status = %d", err);
#line 943
	    allInExtRange = allInIntRange = 1;
#line 943
            for (k = 0; k < ATT_LEN(i,j); k++) {
#line 943
		expect[k] = hash4(ATT_TYPE(i,j), -1, &k, NCT_INT);
#line 943
                if (inRange3(expect[k],ATT_TYPE(i,j),NCT_INT)) {
#line 943
                    allInIntRange = allInIntRange && expect[k] >= int_min
#line 943
                                && expect[k] <= int_max;
#line 943
                } else {
#line 943
                    allInExtRange = 0;
#line 943
                }
#line 943
	    }
#line 943
	    err = nc_get_att_int(ncid, i, ATT_NAME(i,j), value);
#line 943
            if (canConvert || ATT_LEN(i,j) == 0) {
#line 943
                if (allInExtRange) {
#line 943
                    if (allInIntRange) {
#line 943
                        IF (err)
#line 943
                            error("%s", nc_strerror(err));
#line 943
                    } else {
#line 943
                        IF (err != NC_ERANGE)
#line 943
                            error("Range error: status = %d", err);
#line 943
                    }
#line 943
                } else {
#line 943
                    IF (err != 0 && err != NC_ERANGE)
#line 943
                        error("OK or Range error: status = %d", err);
#line 943
                }
#line 943
		for (k = 0; k < ATT_LEN(i,j); k++) {
#line 943
		    if (inRange3(expect[k],ATT_TYPE(i,j),NCT_INT)
#line 943
                            && expect[k] >= int_min && expect[k] <= int_max) {
#line 943
			IF (!equal(value[k],expect[k],ATT_TYPE(i,j),
#line 943
				NCT_INT)){
#line 943
			    error("value read not that expected");
#line 943
                            if (verbose) {
#line 943
                                error("\n");
#line 943
                                error("varid: %d, ", i);
#line 943
                                error("att_name: %s, ", ATT_NAME(i,j));
#line 943
                                error("element number: %d ", k);
#line 943
                                error("expect: %g", expect[k]);
#line 943
                                error("got: %g", (double) value[k]);
#line 943
                            }
#line 943
			} else {
#line 943
			    nok++;
#line 943
                        }
#line 943
		    }
#line 943
		}
#line 943
	    } else {
#line 943
		IF (err != NC_ECHAR)
#line 943
		    error("wrong type: status = %d", err);
#line 943
	    }
#line 943
	}
#line 943
    }
#line 943

#line 943
    err = nc_close(ncid);
#line 943
    IF (err)
#line 943
	error("nc_close: %s", nc_strerror(err));
#line 943
    print_nok(nok);
#line 943
}
#line 943

void
#line 944
test_nc_get_att_long(void)
#line 944
{
#line 944
    int ncid;
#line 944
    int i;
#line 944
    int j;
#line 944
    size_t k;
#line 944
    int err;
#line 944
    int allInExtRange;
#line 944
    int allInIntRange;
#line 944
    int canConvert;     /* Both text or both numeric */
#line 944
    long value[MAX_NELS];
#line 944
    double expect[MAX_NELS];
#line 944
    int nok = 0;      /* count of valid comparisons */
#line 944

#line 944
#ifdef TEST_PNETCDF
#line 944
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 944
#else
#line 944
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 944
#endif
#line 944
    IF (err) 
#line 944
	error("nc_open: %s", nc_strerror(err));
#line 944

#line 944
    for (i = -1; i < numVars; i++) {
#line 944
        for (j = 0; j < NATTS(i); j++) {
#line 944
	    canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_LONG == NCT_TEXT);
#line 944
	    err = nc_get_att_long(BAD_ID, i, ATT_NAME(i,j), value);
#line 944
	    IF (err != NC_EBADID) 
#line 944
		error("bad ncid: status = %d", err);
#line 944
	    err = nc_get_att_long(ncid, BAD_VARID, ATT_NAME(i,j), value);
#line 944
	    IF (err != NC_ENOTVAR) 
#line 944
		error("bad var id: status = %d", err);
#line 944
	    err = nc_get_att_long(ncid, i, "noSuch", value);
#line 944
	    IF (err != NC_ENOTATT) 
#line 944
		error("Bad attribute name: status = %d", err);
#line 944
	    allInExtRange = allInIntRange = 1;
#line 944
            for (k = 0; k < ATT_LEN(i,j); k++) {
#line 944
		expect[k] = hash4(ATT_TYPE(i,j), -1, &k, NCT_LONG);
#line 944
                if (inRange3(expect[k],ATT_TYPE(i,j),NCT_LONG)) {
#line 944
                    allInIntRange = allInIntRange && expect[k] >= long_min
#line 944
                                && expect[k] <= long_max;
#line 944
                } else {
#line 944
                    allInExtRange = 0;
#line 944
                }
#line 944
	    }
#line 944
	    err = nc_get_att_long(ncid, i, ATT_NAME(i,j), value);
#line 944
            if (canConvert || ATT_LEN(i,j) == 0) {
#line 944
                if (allInExtRange) {
#line 944
                    if (allInIntRange) {
#line 944
                        IF (err)
#line 944
                            error("%s", nc_strerror(err));
#line 944
                    } else {
#line 944
                        IF (err != NC_ERANGE)
#line 944
                            error("Range error: status = %d", err);
#line 944
                    }
#line 944
                } else {
#line 944
                    IF (err != 0 && err != NC_ERANGE)
#line 944
                        error("OK or Range error: status = %d", err);
#line 944
                }
#line 944
		for (k = 0; k < ATT_LEN(i,j); k++) {
#line 944
		    if (inRange3(expect[k],ATT_TYPE(i,j),NCT_LONG)
#line 944
                            && expect[k] >= long_min && expect[k] <= long_max) {
#line 944
			IF (!equal(value[k],expect[k],ATT_TYPE(i,j),
#line 944
				NCT_LONG)){
#line 944
			    error("value read not that expected");
#line 944
                            if (verbose) {
#line 944
                                error("\n");
#line 944
                                error("varid: %d, ", i);
#line 944
                                error("att_name: %s, ", ATT_NAME(i,j));
#line 944
                                error("element number: %d ", k);
#line 944
                                error("expect: %g", expect[k]);
#line 944
                                error("got: %g", (double) value[k]);
#line 944
                            }
#line 944
			} else {
#line 944
			    nok++;
#line 944
                        }
#line 944
		    }
#line 944
		}
#line 944
	    } else {
#line 944
		IF (err != NC_ECHAR)
#line 944
		    error("wrong type: status = %d", err);
#line 944
	    }
#line 944
	}
#line 944
    }
#line 944

#line 944
    err = nc_close(ncid);
#line 944
    IF (err)
#line 944
	error("nc_close: %s", nc_strerror(err));
#line 944
    print_nok(nok);
#line 944
}
#line 944

void
#line 945
test_nc_get_att_float(void)
#line 945
{
#line 945
    int ncid;
#line 945
    int i;
#line 945
    int j;
#line 945
    size_t k;
#line 945
    int err;
#line 945
    int allInExtRange;
#line 945
    int allInIntRange;
#line 945
    int canConvert;     /* Both text or both numeric */
#line 945
    float value[MAX_NELS];
#line 945
    double expect[MAX_NELS];
#line 945
    int nok = 0;      /* count of valid comparisons */
#line 945

#line 945
#ifdef TEST_PNETCDF
#line 945
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 945
#else
#line 945
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 945
#endif
#line 945
    IF (err) 
#line 945
	error("nc_open: %s", nc_strerror(err));
#line 945

#line 945
    for (i = -1; i < numVars; i++) {
#line 945
        for (j = 0; j < NATTS(i); j++) {
#line 945
	    canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_FLOAT == NCT_TEXT);
#line 945
	    err = nc_get_att_float(BAD_ID, i, ATT_NAME(i,j), value);
#line 945
	    IF (err != NC_EBADID) 
#line 945
		error("bad ncid: status = %d", err);
#line 945
	    err = nc_get_att_float(ncid, BAD_VARID, ATT_NAME(i,j), value);
#line 945
	    IF (err != NC_ENOTVAR) 
#line 945
		error("bad var id: status = %d", err);
#line 945
	    err = nc_get_att_float(ncid, i, "noSuch", value);
#line 945
	    IF (err != NC_ENOTATT) 
#line 945
		error("Bad attribute name: status = %d", err);
#line 945
	    allInExtRange = allInIntRange = 1;
#line 945
            for (k = 0; k < ATT_LEN(i,j); k++) {
#line 945
		expect[k] = hash4(ATT_TYPE(i,j), -1, &k, NCT_FLOAT);
#line 945
                if (inRange3(expect[k],ATT_TYPE(i,j),NCT_FLOAT)) {
#line 945
                    allInIntRange = allInIntRange && expect[k] >= float_min
#line 945
                                && expect[k] <= float_max;
#line 945
                } else {
#line 945
                    allInExtRange = 0;
#line 945
                }
#line 945
	    }
#line 945
	    err = nc_get_att_float(ncid, i, ATT_NAME(i,j), value);
#line 945
            if (canConvert || ATT_LEN(i,j) == 0) {
#line 945
                if (allInExtRange) {
#line 945
                    if (allInIntRange) {
#line 945
                        IF (err)
#line 945
                            error("%s", nc_strerror(err));
#line 945
                    } else {
#line 945
                        IF (err != NC_ERANGE)
#line 945
                            error("Range error: status = %d", err);
#line 945
                    }
#line 945
                } else {
#line 945
                    IF (err != 0 && err != NC_ERANGE)
#line 945
                        error("OK or Range error: status = %d", err);
#line 945
                }
#line 945
		for (k = 0; k < ATT_LEN(i,j); k++) {
#line 945
		    if (inRange3(expect[k],ATT_TYPE(i,j),NCT_FLOAT)
#line 945
                            && expect[k] >= float_min && expect[k] <= float_max) {
#line 945
			IF (!equal(value[k],expect[k],ATT_TYPE(i,j),
#line 945
				NCT_FLOAT)){
#line 945
			    error("value read not that expected");
#line 945
                            if (verbose) {
#line 945
                                error("\n");
#line 945
                                error("varid: %d, ", i);
#line 945
                                error("att_name: %s, ", ATT_NAME(i,j));
#line 945
                                error("element number: %d ", k);
#line 945
                                error("expect: %g", expect[k]);
#line 945
                                error("got: %g", (double) value[k]);
#line 945
                            }
#line 945
			} else {
#line 945
			    nok++;
#line 945
                        }
#line 945
		    }
#line 945
		}
#line 945
	    } else {
#line 945
		IF (err != NC_ECHAR)
#line 945
		    error("wrong type: status = %d", err);
#line 945
	    }
#line 945
	}
#line 945
    }
#line 945

#line 945
    err = nc_close(ncid);
#line 945
    IF (err)
#line 945
	error("nc_close: %s", nc_strerror(err));
#line 945
    print_nok(nok);
#line 945
}
#line 945

void
#line 946
test_nc_get_att_double(void)
#line 946
{
#line 946
    int ncid;
#line 946
    int i;
#line 946
    int j;
#line 946
    size_t k;
#line 946
    int err;
#line 946
    int allInExtRange;
#line 946
    int allInIntRange;
#line 946
    int canConvert;     /* Both text or both numeric */
#line 946
    double value[MAX_NELS];
#line 946
    double expect[MAX_NELS];
#line 946
    int nok = 0;      /* count of valid comparisons */
#line 946

#line 946
#ifdef TEST_PNETCDF
#line 946
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 946
#else
#line 946
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 946
#endif
#line 946
    IF (err) 
#line 946
	error("nc_open: %s", nc_strerror(err));
#line 946

#line 946
    for (i = -1; i < numVars; i++) {
#line 946
        for (j = 0; j < NATTS(i); j++) {
#line 946
	    canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_DOUBLE == NCT_TEXT);
#line 946
	    err = nc_get_att_double(BAD_ID, i, ATT_NAME(i,j), value);
#line 946
	    IF (err != NC_EBADID) 
#line 946
		error("bad ncid: status = %d", err);
#line 946
	    err = nc_get_att_double(ncid, BAD_VARID, ATT_NAME(i,j), value);
#line 946
	    IF (err != NC_ENOTVAR) 
#line 946
		error("bad var id: status = %d", err);
#line 946
	    err = nc_get_att_double(ncid, i, "noSuch", value);
#line 946
	    IF (err != NC_ENOTATT) 
#line 946
		error("Bad attribute name: status = %d", err);
#line 946
	    allInExtRange = allInIntRange = 1;
#line 946
            for (k = 0; k < ATT_LEN(i,j); k++) {
#line 946
		expect[k] = hash4(ATT_TYPE(i,j), -1, &k, NCT_DOUBLE);
#line 946
                if (inRange3(expect[k],ATT_TYPE(i,j),NCT_DOUBLE)) {
#line 946
                    allInIntRange = allInIntRange && expect[k] >= double_min
#line 946
                                && expect[k] <= double_max;
#line 946
                } else {
#line 946
                    allInExtRange = 0;
#line 946
                }
#line 946
	    }
#line 946
	    err = nc_get_att_double(ncid, i, ATT_NAME(i,j), value);
#line 946
            if (canConvert || ATT_LEN(i,j) == 0) {
#line 946
                if (allInExtRange) {
#line 946
                    if (allInIntRange) {
#line 946
                        IF (err)
#line 946
                            error("%s", nc_strerror(err));
#line 946
                    } else {
#line 946
                        IF (err != NC_ERANGE)
#line 946
                            error("Range error: status = %d", err);
#line 946
                    }
#line 946
                } else {
#line 946
                    IF (err != 0 && err != NC_ERANGE)
#line 946
                        error("OK or Range error: status = %d", err);
#line 946
                }
#line 946
		for (k = 0; k < ATT_LEN(i,j); k++) {
#line 946
		    if (inRange3(expect[k],ATT_TYPE(i,j),NCT_DOUBLE)
#line 946
                            && expect[k] >= double_min && expect[k] <= double_max) {
#line 946
			IF (!equal(value[k],expect[k],ATT_TYPE(i,j),
#line 946
				NCT_DOUBLE)){
#line 946
			    error("value read not that expected");
#line 946
                            if (verbose) {
#line 946
                                error("\n");
#line 946
                                error("varid: %d, ", i);
#line 946
                                error("att_name: %s, ", ATT_NAME(i,j));
#line 946
                                error("element number: %d ", k);
#line 946
                                error("expect: %g", expect[k]);
#line 946
                                error("got: %g", (double) value[k]);
#line 946
                            }
#line 946
			} else {
#line 946
			    nok++;
#line 946
                        }
#line 946
		    }
#line 946
		}
#line 946
	    } else {
#line 946
		IF (err != NC_ECHAR)
#line 946
		    error("wrong type: status = %d", err);
#line 946
	    }
#line 946
	}
#line 946
    }
#line 946

#line 946
    err = nc_close(ncid);
#line 946
    IF (err)
#line 946
	error("nc_close: %s", nc_strerror(err));
#line 946
    print_nok(nok);
#line 946
}
#line 946

void
#line 947
test_nc_get_att_ushort(void)
#line 947
{
#line 947
    int ncid;
#line 947
    int i;
#line 947
    int j;
#line 947
    size_t k;
#line 947
    int err;
#line 947
    int allInExtRange;
#line 947
    int allInIntRange;
#line 947
    int canConvert;     /* Both text or both numeric */
#line 947
    ushort value[MAX_NELS];
#line 947
    double expect[MAX_NELS];
#line 947
    int nok = 0;      /* count of valid comparisons */
#line 947

#line 947
#ifdef TEST_PNETCDF
#line 947
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 947
#else
#line 947
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 947
#endif
#line 947
    IF (err) 
#line 947
	error("nc_open: %s", nc_strerror(err));
#line 947

#line 947
    for (i = -1; i < numVars; i++) {
#line 947
        for (j = 0; j < NATTS(i); j++) {
#line 947
	    canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_USHORT == NCT_TEXT);
#line 947
	    err = nc_get_att_ushort(BAD_ID, i, ATT_NAME(i,j), value);
#line 947
	    IF (err != NC_EBADID) 
#line 947
		error("bad ncid: status = %d", err);
#line 947
	    err = nc_get_att_ushort(ncid, BAD_VARID, ATT_NAME(i,j), value);
#line 947
	    IF (err != NC_ENOTVAR) 
#line 947
		error("bad var id: status = %d", err);
#line 947
	    err = nc_get_att_ushort(ncid, i, "noSuch", value);
#line 947
	    IF (err != NC_ENOTATT) 
#line 947
		error("Bad attribute name: status = %d", err);
#line 947
	    allInExtRange = allInIntRange = 1;
#line 947
            for (k = 0; k < ATT_LEN(i,j); k++) {
#line 947
		expect[k] = hash4(ATT_TYPE(i,j), -1, &k, NCT_USHORT);
#line 947
                if (inRange3(expect[k],ATT_TYPE(i,j),NCT_USHORT)) {
#line 947
                    allInIntRange = allInIntRange && expect[k] >= ushort_min
#line 947
                                && expect[k] <= ushort_max;
#line 947
                } else {
#line 947
                    allInExtRange = 0;
#line 947
                }
#line 947
	    }
#line 947
	    err = nc_get_att_ushort(ncid, i, ATT_NAME(i,j), value);
#line 947
            if (canConvert || ATT_LEN(i,j) == 0) {
#line 947
                if (allInExtRange) {
#line 947
                    if (allInIntRange) {
#line 947
                        IF (err)
#line 947
                            error("%s", nc_strerror(err));
#line 947
                    } else {
#line 947
                        IF (err != NC_ERANGE)
#line 947
                            error("Range error: status = %d", err);
#line 947
                    }
#line 947
                } else {
#line 947
                    IF (err != 0 && err != NC_ERANGE)
#line 947
                        error("OK or Range error: status = %d", err);
#line 947
                }
#line 947
		for (k = 0; k < ATT_LEN(i,j); k++) {
#line 947
		    if (inRange3(expect[k],ATT_TYPE(i,j),NCT_USHORT)
#line 947
                            && expect[k] >= ushort_min && expect[k] <= ushort_max) {
#line 947
			IF (!equal(value[k],expect[k],ATT_TYPE(i,j),
#line 947
				NCT_USHORT)){
#line 947
			    error("value read not that expected");
#line 947
                            if (verbose) {
#line 947
                                error("\n");
#line 947
                                error("varid: %d, ", i);
#line 947
                                error("att_name: %s, ", ATT_NAME(i,j));
#line 947
                                error("element number: %d ", k);
#line 947
                                error("expect: %g", expect[k]);
#line 947
                                error("got: %g", (double) value[k]);
#line 947
                            }
#line 947
			} else {
#line 947
			    nok++;
#line 947
                        }
#line 947
		    }
#line 947
		}
#line 947
	    } else {
#line 947
		IF (err != NC_ECHAR)
#line 947
		    error("wrong type: status = %d", err);
#line 947
	    }
#line 947
	}
#line 947
    }
#line 947

#line 947
    err = nc_close(ncid);
#line 947
    IF (err)
#line 947
	error("nc_close: %s", nc_strerror(err));
#line 947
    print_nok(nok);
#line 947
}
#line 947

void
#line 948
test_nc_get_att_uint(void)
#line 948
{
#line 948
    int ncid;
#line 948
    int i;
#line 948
    int j;
#line 948
    size_t k;
#line 948
    int err;
#line 948
    int allInExtRange;
#line 948
    int allInIntRange;
#line 948
    int canConvert;     /* Both text or both numeric */
#line 948
    uint value[MAX_NELS];
#line 948
    double expect[MAX_NELS];
#line 948
    int nok = 0;      /* count of valid comparisons */
#line 948

#line 948
#ifdef TEST_PNETCDF
#line 948
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 948
#else
#line 948
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 948
#endif
#line 948
    IF (err) 
#line 948
	error("nc_open: %s", nc_strerror(err));
#line 948

#line 948
    for (i = -1; i < numVars; i++) {
#line 948
        for (j = 0; j < NATTS(i); j++) {
#line 948
	    canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_UINT == NCT_TEXT);
#line 948
	    err = nc_get_att_uint(BAD_ID, i, ATT_NAME(i,j), value);
#line 948
	    IF (err != NC_EBADID) 
#line 948
		error("bad ncid: status = %d", err);
#line 948
	    err = nc_get_att_uint(ncid, BAD_VARID, ATT_NAME(i,j), value);
#line 948
	    IF (err != NC_ENOTVAR) 
#line 948
		error("bad var id: status = %d", err);
#line 948
	    err = nc_get_att_uint(ncid, i, "noSuch", value);
#line 948
	    IF (err != NC_ENOTATT) 
#line 948
		error("Bad attribute name: status = %d", err);
#line 948
	    allInExtRange = allInIntRange = 1;
#line 948
            for (k = 0; k < ATT_LEN(i,j); k++) {
#line 948
		expect[k] = hash4(ATT_TYPE(i,j), -1, &k, NCT_UINT);
#line 948
                if (inRange3(expect[k],ATT_TYPE(i,j),NCT_UINT)) {
#line 948
                    allInIntRange = allInIntRange && expect[k] >= uint_min
#line 948
                                && expect[k] <= uint_max;
#line 948
                } else {
#line 948
                    allInExtRange = 0;
#line 948
                }
#line 948
	    }
#line 948
	    err = nc_get_att_uint(ncid, i, ATT_NAME(i,j), value);
#line 948
            if (canConvert || ATT_LEN(i,j) == 0) {
#line 948
                if (allInExtRange) {
#line 948
                    if (allInIntRange) {
#line 948
                        IF (err)
#line 948
                            error("%s", nc_strerror(err));
#line 948
                    } else {
#line 948
                        IF (err != NC_ERANGE)
#line 948
                            error("Range error: status = %d", err);
#line 948
                    }
#line 948
                } else {
#line 948
                    IF (err != 0 && err != NC_ERANGE)
#line 948
                        error("OK or Range error: status = %d", err);
#line 948
                }
#line 948
		for (k = 0; k < ATT_LEN(i,j); k++) {
#line 948
		    if (inRange3(expect[k],ATT_TYPE(i,j),NCT_UINT)
#line 948
                            && expect[k] >= uint_min && expect[k] <= uint_max) {
#line 948
			IF (!equal(value[k],expect[k],ATT_TYPE(i,j),
#line 948
				NCT_UINT)){
#line 948
			    error("value read not that expected");
#line 948
                            if (verbose) {
#line 948
                                error("\n");
#line 948
                                error("varid: %d, ", i);
#line 948
                                error("att_name: %s, ", ATT_NAME(i,j));
#line 948
                                error("element number: %d ", k);
#line 948
                                error("expect: %g", expect[k]);
#line 948
                                error("got: %g", (double) value[k]);
#line 948
                            }
#line 948
			} else {
#line 948
			    nok++;
#line 948
                        }
#line 948
		    }
#line 948
		}
#line 948
	    } else {
#line 948
		IF (err != NC_ECHAR)
#line 948
		    error("wrong type: status = %d", err);
#line 948
	    }
#line 948
	}
#line 948
    }
#line 948

#line 948
    err = nc_close(ncid);
#line 948
    IF (err)
#line 948
	error("nc_close: %s", nc_strerror(err));
#line 948
    print_nok(nok);
#line 948
}
#line 948

void
#line 949
test_nc_get_att_longlong(void)
#line 949
{
#line 949
    int ncid;
#line 949
    int i;
#line 949
    int j;
#line 949
    size_t k;
#line 949
    int err;
#line 949
    int allInExtRange;
#line 949
    int allInIntRange;
#line 949
    int canConvert;     /* Both text or both numeric */
#line 949
    longlong value[MAX_NELS];
#line 949
    double expect[MAX_NELS];
#line 949
    int nok = 0;      /* count of valid comparisons */
#line 949

#line 949
#ifdef TEST_PNETCDF
#line 949
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 949
#else
#line 949
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 949
#endif
#line 949
    IF (err) 
#line 949
	error("nc_open: %s", nc_strerror(err));
#line 949

#line 949
    for (i = -1; i < numVars; i++) {
#line 949
        for (j = 0; j < NATTS(i); j++) {
#line 949
	    canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_LONGLONG == NCT_TEXT);
#line 949
	    err = nc_get_att_longlong(BAD_ID, i, ATT_NAME(i,j), value);
#line 949
	    IF (err != NC_EBADID) 
#line 949
		error("bad ncid: status = %d", err);
#line 949
	    err = nc_get_att_longlong(ncid, BAD_VARID, ATT_NAME(i,j), value);
#line 949
	    IF (err != NC_ENOTVAR) 
#line 949
		error("bad var id: status = %d", err);
#line 949
	    err = nc_get_att_longlong(ncid, i, "noSuch", value);
#line 949
	    IF (err != NC_ENOTATT) 
#line 949
		error("Bad attribute name: status = %d", err);
#line 949
	    allInExtRange = allInIntRange = 1;
#line 949
            for (k = 0; k < ATT_LEN(i,j); k++) {
#line 949
		expect[k] = hash4(ATT_TYPE(i,j), -1, &k, NCT_LONGLONG);
#line 949
                if (inRange3(expect[k],ATT_TYPE(i,j),NCT_LONGLONG)) {
#line 949
                    allInIntRange = allInIntRange && expect[k] >= longlong_min
#line 949
                                && expect[k] <= longlong_max;
#line 949
                } else {
#line 949
                    allInExtRange = 0;
#line 949
                }
#line 949
	    }
#line 949
	    err = nc_get_att_longlong(ncid, i, ATT_NAME(i,j), value);
#line 949
            if (canConvert || ATT_LEN(i,j) == 0) {
#line 949
                if (allInExtRange) {
#line 949
                    if (allInIntRange) {
#line 949
                        IF (err)
#line 949
                            error("%s", nc_strerror(err));
#line 949
                    } else {
#line 949
                        IF (err != NC_ERANGE)
#line 949
                            error("Range error: status = %d", err);
#line 949
                    }
#line 949
                } else {
#line 949
                    IF (err != 0 && err != NC_ERANGE)
#line 949
                        error("OK or Range error: status = %d", err);
#line 949
                }
#line 949
		for (k = 0; k < ATT_LEN(i,j); k++) {
#line 949
		    if (inRange3(expect[k],ATT_TYPE(i,j),NCT_LONGLONG)
#line 949
                            && expect[k] >= longlong_min && expect[k] <= longlong_max) {
#line 949
			IF (!equal(value[k],expect[k],ATT_TYPE(i,j),
#line 949
				NCT_LONGLONG)){
#line 949
			    error("value read not that expected");
#line 949
                            if (verbose) {
#line 949
                                error("\n");
#line 949
                                error("varid: %d, ", i);
#line 949
                                error("att_name: %s, ", ATT_NAME(i,j));
#line 949
                                error("element number: %d ", k);
#line 949
                                error("expect: %g", expect[k]);
#line 949
                                error("got: %g", (double) value[k]);
#line 949
                            }
#line 949
			} else {
#line 949
			    nok++;
#line 949
                        }
#line 949
		    }
#line 949
		}
#line 949
	    } else {
#line 949
		IF (err != NC_ECHAR)
#line 949
		    error("wrong type: status = %d", err);
#line 949
	    }
#line 949
	}
#line 949
    }
#line 949

#line 949
    err = nc_close(ncid);
#line 949
    IF (err)
#line 949
	error("nc_close: %s", nc_strerror(err));
#line 949
    print_nok(nok);
#line 949
}
#line 949

void
#line 950
test_nc_get_att_ulonglong(void)
#line 950
{
#line 950
    int ncid;
#line 950
    int i;
#line 950
    int j;
#line 950
    size_t k;
#line 950
    int err;
#line 950
    int allInExtRange;
#line 950
    int allInIntRange;
#line 950
    int canConvert;     /* Both text or both numeric */
#line 950
    ulonglong value[MAX_NELS];
#line 950
    double expect[MAX_NELS];
#line 950
    int nok = 0;      /* count of valid comparisons */
#line 950

#line 950
#ifdef TEST_PNETCDF
#line 950
    err = nc_open_par(testfile, NC_NOWRITE|NC_PNETCDF, MPI_COMM_WORLD, MPI_INFO_NULL, &ncid);
#line 950
#else
#line 950
    err = nc_open(testfile, NC_NOWRITE, &ncid);
#line 950
#endif
#line 950
    IF (err) 
#line 950
	error("nc_open: %s", nc_strerror(err));
#line 950

#line 950
    for (i = -1; i < numVars; i++) {
#line 950
        for (j = 0; j < NATTS(i); j++) {
#line 950
	    canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_ULONGLONG == NCT_TEXT);
#line 950
	    err = nc_get_att_ulonglong(BAD_ID, i, ATT_NAME(i,j), value);
#line 950
	    IF (err != NC_EBADID) 
#line 950
		error("bad ncid: status = %d", err);
#line 950
	    err = nc_get_att_ulonglong(ncid, BAD_VARID, ATT_NAME(i,j), value);
#line 950
	    IF (err != NC_ENOTVAR) 
#line 950
		error("bad var id: status = %d", err);
#line 950
	    err = nc_get_att_ulonglong(ncid, i, "noSuch", value);
#line 950
	    IF (err != NC_ENOTATT) 
#line 950
		error("Bad attribute name: status = %d", err);
#line 950
	    allInExtRange = allInIntRange = 1;
#line 950
            for (k = 0; k < ATT_LEN(i,j); k++) {
#line 950
		expect[k] = hash4(ATT_TYPE(i,j), -1, &k, NCT_ULONGLONG);
#line 950
                if (inRange3(expect[k],ATT_TYPE(i,j),NCT_ULONGLONG)) {
#line 950
                    allInIntRange = allInIntRange && expect[k] >= ulonglong_min
#line 950
                                && expect[k] <= ulonglong_max;
#line 950
                } else {
#line 950
                    allInExtRange = 0;
#line 950
                }
#line 950
	    }
#line 950
	    err = nc_get_att_ulonglong(ncid, i, ATT_NAME(i,j), value);
#line 950
            if (canConvert || ATT_LEN(i,j) == 0) {
#line 950
                if (allInExtRange) {
#line 950
                    if (allInIntRange) {
#line 950
                        IF (err)
#line 950
                            error("%s", nc_strerror(err));
#line 950
                    } else {
#line 950
                        IF (err != NC_ERANGE)
#line 950
                            error("Range error: status = %d", err);
#line 950
                    }
#line 950
                } else {
#line 950
                    IF (err != 0 && err != NC_ERANGE)
#line 950
                        error("OK or Range error: status = %d", err);
#line 950
                }
#line 950
		for (k = 0; k < ATT_LEN(i,j); k++) {
#line 950
		    if (inRange3(expect[k],ATT_TYPE(i,j),NCT_ULONGLONG)
#line 950
                            && expect[k] >= ulonglong_min && expect[k] <= ulonglong_max) {
#line 950
			IF (!equal(value[k],expect[k],ATT_TYPE(i,j),
#line 950
				NCT_ULONGLONG)){
#line 950
			    error("value read not that expected");
#line 950
                            if (verbose) {
#line 950
                                error("\n");
#line 950
                                error("varid: %d, ", i);
#line 950
                                error("att_name: %s, ", ATT_NAME(i,j));
#line 950
                                error("element number: %d ", k);
#line 950
                                error("expect: %g", expect[k]);
#line 950
                                error("got: %g", (double) value[k]);
#line 950
                            }
#line 950
			} else {
#line 950
			    nok++;
#line 950
                        }
#line 950
		    }
#line 950
		}
#line 950
	    } else {
#line 950
		IF (err != NC_ECHAR)
#line 950
		    error("wrong type: status = %d", err);
#line 950
	    }
#line 950
	}
#line 950
    }
#line 950

#line 950
    err = nc_close(ncid);
#line 950
    IF (err)
#line 950
	error("nc_close: %s", nc_strerror(err));
#line 950
    print_nok(nok);
#line 950
}
#line 950


