; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; Test the use of TEST UNDER MASK for 64-bit operations.
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z10 | FileCheck %s
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z196 | FileCheck %s

@g = global i32 0

; Check the lowest useful TMLL value.
define void @f1(i64 %a) {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    tmll %r2, 1
; CHECK-NEXT:    ber %r14
; CHECK-NEXT:  .LBB0_1: # %store
; CHECK-NEXT:    lgrl %r1, g@GOT
; CHECK-NEXT:    mvhi 0(%r1), 1
; CHECK-NEXT:    br %r14
entry:
  %and = and i64 %a, 1
  %cmp = icmp eq i64 %and, 0
  br i1 %cmp, label %exit, label %store

store:
  store i32 1, ptr@g
  br label %exit

exit:
  ret void
}

; Check the high end of the TMLL range.
define void @f2(i64 %a) {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    tmll %r2, 65535
; CHECK-NEXT:    bner %r14
; CHECK-NEXT:  .LBB1_1: # %store
; CHECK-NEXT:    lgrl %r1, g@GOT
; CHECK-NEXT:    mvhi 0(%r1), 1
; CHECK-NEXT:    br %r14
entry:
  %and = and i64 %a, 65535
  %cmp = icmp ne i64 %and, 0
  br i1 %cmp, label %exit, label %store

store:
  store i32 1, ptr@g
  br label %exit

exit:
  ret void
}

; Check the lowest useful TMLH value, which is the next value up.
define void @f3(i64 %a) {
; CHECK-LABEL: f3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    tmlh %r2, 1
; CHECK-NEXT:    bner %r14
; CHECK-NEXT:  .LBB2_1: # %store
; CHECK-NEXT:    lgrl %r1, g@GOT
; CHECK-NEXT:    mvhi 0(%r1), 1
; CHECK-NEXT:    br %r14
entry:
  %and = and i64 %a, 65536
  %cmp = icmp ne i64 %and, 0
  br i1 %cmp, label %exit, label %store

store:
  store i32 1, ptr@g
  br label %exit

exit:
  ret void
}

; Check the next value up again, which cannot use TM.
define void @f4(i64 %a) {
; CHECK-LABEL: f4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    llilf %r0, 4294901759
; CHECK-NEXT:    ngr %r0, %r2
; CHECK-NEXT:    ber %r14
; CHECK-NEXT:  .LBB3_1: # %store
; CHECK-NEXT:    lgrl %r1, g@GOT
; CHECK-NEXT:    mvhi 0(%r1), 1
; CHECK-NEXT:    br %r14
entry:
  %and = and i64 %a, 4294901759
  %cmp = icmp eq i64 %and, 0
  br i1 %cmp, label %exit, label %store

store:
  store i32 1, ptr@g
  br label %exit

exit:
  ret void
}

; Check the high end of the TMLH range.
define void @f5(i64 %a) {
; CHECK-LABEL: f5:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    tmlh %r2, 65535
; CHECK-NEXT:    ber %r14
; CHECK-NEXT:  .LBB4_1: # %store
; CHECK-NEXT:    lgrl %r1, g@GOT
; CHECK-NEXT:    mvhi 0(%r1), 1
; CHECK-NEXT:    br %r14
entry:
  %and = and i64 %a, 4294901760
  %cmp = icmp eq i64 %and, 0
  br i1 %cmp, label %exit, label %store

store:
  store i32 1, ptr@g
  br label %exit

exit:
  ret void
}

; Check the lowest useful TMHL value.
define void @f6(i64 %a) {
; CHECK-LABEL: f6:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    tmhl %r2, 1
; CHECK-NEXT:    ber %r14
; CHECK-NEXT:  .LBB5_1: # %store
; CHECK-NEXT:    lgrl %r1, g@GOT
; CHECK-NEXT:    mvhi 0(%r1), 1
; CHECK-NEXT:    br %r14
entry:
  %and = and i64 %a, 4294967296
  %cmp = icmp eq i64 %and, 0
  br i1 %cmp, label %exit, label %store

store:
  store i32 1, ptr@g
  br label %exit

exit:
  ret void
}

; Check the next value up again, which cannot use TM.
define void @f7(i64 %a) {
; CHECK-LABEL: f7:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    llihl %r0, 1
; CHECK-NEXT:    oill %r0, 1
; CHECK-NEXT:    ngr %r0, %r2
; CHECK-NEXT:    blr %r14
; CHECK-NEXT:  .LBB6_1: # %store
; CHECK-NEXT:    lgrl %r1, g@GOT
; CHECK-NEXT:    mvhi 0(%r1), 1
; CHECK-NEXT:    br %r14
entry:
  %and = and i64 %a, 4294967297
  %cmp = icmp ne i64 %and, 0
  br i1 %cmp, label %exit, label %store

store:
  store i32 1, ptr@g
  br label %exit

exit:
  ret void
}

; Check the high end of the TMHL range.
define void @f8(i64 %a) {
; CHECK-LABEL: f8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    tmhl %r2, 65535
; CHECK-NEXT:    bner %r14
; CHECK-NEXT:  .LBB7_1: # %store
; CHECK-NEXT:    lgrl %r1, g@GOT
; CHECK-NEXT:    mvhi 0(%r1), 1
; CHECK-NEXT:    br %r14
entry:
  %and = and i64 %a, 281470681743360
  %cmp = icmp ne i64 %and, 0
  br i1 %cmp, label %exit, label %store

store:
  store i32 1, ptr@g
  br label %exit

exit:
  ret void
}

; Check the lowest useful TMHH value.
define void @f9(i64 %a) {
; CHECK-LABEL: f9:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    tmhh %r2, 1
; CHECK-NEXT:    bner %r14
; CHECK-NEXT:  .LBB8_1: # %store
; CHECK-NEXT:    lgrl %r1, g@GOT
; CHECK-NEXT:    mvhi 0(%r1), 1
; CHECK-NEXT:    br %r14
entry:
  %and = and i64 %a, 281474976710656
  %cmp = icmp ne i64 %and, 0
  br i1 %cmp, label %exit, label %store

store:
  store i32 1, ptr@g
  br label %exit

exit:
  ret void
}

; Check the high end of the TMHH range.
define void @f10(i64 %a) {
; CHECK-LABEL: f10:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    tmhh %r2, 65535
; CHECK-NEXT:    ber %r14
; CHECK-NEXT:  .LBB9_1: # %store
; CHECK-NEXT:    lgrl %r1, g@GOT
; CHECK-NEXT:    mvhi 0(%r1), 1
; CHECK-NEXT:    br %r14
entry:
  %and = and i64 %a, 18446462598732840960
  %cmp = icmp eq i64 %and, 0
  br i1 %cmp, label %exit, label %store

store:
  store i32 1, ptr@g
  br label %exit

exit:
  ret void
}

; Check that we can fold an SHL into a TMxx mask.
define void @f11(i64 %a) {
; CHECK-LABEL: f11:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    tmhl %r2, 32768
; CHECK-NEXT:    bner %r14
; CHECK-NEXT:  .LBB10_1: # %store
; CHECK-NEXT:    lgrl %r1, g@GOT
; CHECK-NEXT:    mvhi 0(%r1), 1
; CHECK-NEXT:    br %r14
entry:
  %shl = shl i64 %a, 1
  %and = and i64 %shl, 281474976710656
  %cmp = icmp ne i64 %and, 0
  br i1 %cmp, label %exit, label %store

store:
  store i32 1, ptr@g
  br label %exit

exit:
  ret void
}

; Check that we can fold an SHR into a TMxx mask.
define void @f12(i64 %a) {
; CHECK-LABEL: f12:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    tmhh %r2, 256
; CHECK-NEXT:    bner %r14
; CHECK-NEXT:  .LBB11_1: # %store
; CHECK-NEXT:    lgrl %r1, g@GOT
; CHECK-NEXT:    mvhi 0(%r1), 1
; CHECK-NEXT:    br %r14
entry:
  %shr = lshr i64 %a, 56
  %and = and i64 %shr, 1
  %cmp = icmp ne i64 %and, 0
  br i1 %cmp, label %exit, label %store

store:
  store i32 1, ptr@g
  br label %exit

exit:
  ret void
}

; Check a case where TMHH can be used to implement a ult comparison.
define void @f13(i64 %a) {
; CHECK-LABEL: f13:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    tmhh %r2, 49152
; CHECK-NEXT:    bnor %r14
; CHECK-NEXT:  .LBB12_1: # %store
; CHECK-NEXT:    lgrl %r1, g@GOT
; CHECK-NEXT:    mvhi 0(%r1), 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ult i64 %a, 13835058055282163712
  br i1 %cmp, label %exit, label %store

store:
  store i32 1, ptr@g
  br label %exit

exit:
  ret void
}

; And again with ule.
define void @f14(i64 %a) {
; CHECK-LABEL: f14:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    tmhh %r2, 49152
; CHECK-NEXT:    bnor %r14
; CHECK-NEXT:  .LBB13_1: # %store
; CHECK-NEXT:    lgrl %r1, g@GOT
; CHECK-NEXT:    mvhi 0(%r1), 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ule i64 %a, 13835058055282163711
  br i1 %cmp, label %exit, label %store

store:
  store i32 1, ptr@g
  br label %exit

exit:
  ret void
}

; And again with ugt.
define void @f15(i64 %a) {
; CHECK-LABEL: f15:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    tmhh %r2, 49152
; CHECK-NEXT:    bor %r14
; CHECK-NEXT:  .LBB14_1: # %store
; CHECK-NEXT:    lgrl %r1, g@GOT
; CHECK-NEXT:    mvhi 0(%r1), 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ugt i64 %a, 13835058055282163711
  br i1 %cmp, label %exit, label %store

store:
  store i32 1, ptr@g
  br label %exit

exit:
  ret void
}

; And again with uge.
define void @f16(i64 %a) {
; CHECK-LABEL: f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    tmhh %r2, 49152
; CHECK-NEXT:    bor %r14
; CHECK-NEXT:  .LBB15_1: # %store
; CHECK-NEXT:    lgrl %r1, g@GOT
; CHECK-NEXT:    mvhi 0(%r1), 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp uge i64 %a, 13835058055282163712
  br i1 %cmp, label %exit, label %store

store:
  store i32 1, ptr@g
  br label %exit

exit:
  ret void
}

; Decrease the constant from f13 to make TMHH invalid.
define void @f17(i64 %a) {
; CHECK-LABEL: f17:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    srlg %r0, %r2, 48
; CHECK-NEXT:    cgfi %r0, 49151
; CHECK-NEXT:    blr %r14
; CHECK-NEXT:  .LBB16_1: # %store
; CHECK-NEXT:    lgrl %r1, g@GOT
; CHECK-NEXT:    mvhi 0(%r1), 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ult i64 %a, 13834776580305453056
  br i1 %cmp, label %exit, label %store

store:
  store i32 1, ptr@g
  br label %exit

exit:
  ret void
}

; Check that we don't use TMHH just to test the top bit.
define void @f18(i64 %a) {
; CHECK-LABEL: f18:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cgibhe %r2, 0, 0(%r14)
; CHECK-NEXT:  .LBB17_1: # %store
; CHECK-NEXT:    lgrl %r1, g@GOT
; CHECK-NEXT:    mvhi 0(%r1), 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ult i64 %a, 9223372036854775808
  br i1 %cmp, label %exit, label %store

store:
  store i32 1, ptr@g
  br label %exit

exit:
  ret void
}

; Check that we don't fold a shift if the comparison value
; would need to be shifted out of range
define void @f19(i64 %a) {
; CHECK-LABEL: f19:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    srlg %r0, %r2, 63
; CHECK-NEXT:    cgibl %r0, 3, 0(%r14)
; CHECK-NEXT:  .LBB18_1: # %store
; CHECK-NEXT:    lgrl %r1, g@GOT
; CHECK-NEXT:    mvhi 0(%r1), 1
; CHECK-NEXT:    br %r14
entry:
  %shr = lshr i64 %a, 63
  %cmp = icmp ult i64 %shr, 3
  br i1 %cmp, label %exit, label %store

store:
  store i32 1, ptr@g
  br label %exit

exit:
  ret void
}

