; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
;RUN: llc < %s -mtriple=amdgcn -mcpu=verde -verify-machineinstrs | FileCheck %s --check-prefixes=PREGFX10
;RUN: llc < %s -mtriple=amdgcn -mcpu=tonga -verify-machineinstrs | FileCheck %s --check-prefixes=PREGFX10
;RUN: llc < %s -mtriple=amdgcn -mcpu=gfx1010 -verify-machineinstrs | FileCheck %s --check-prefixes=GFX10
;RUN: llc < %s -mtriple=amdgcn -mcpu=gfx1100 -amdgpu-enable-delay-alu=0 -verify-machineinstrs | FileCheck %s --check-prefixes=GFX11
;RUN: llc < %s -mtriple=amdgcn -mcpu=gfx1200 -amdgpu-enable-delay-alu=0 -verify-machineinstrs | FileCheck %s --check-prefixes=GFX12,GFX12-SDAG
;RUN: llc < %s -global-isel -mtriple=amdgcn -mcpu=gfx1200 -amdgpu-enable-delay-alu=0 -verify-machineinstrs | FileCheck %s --check-prefixes=GFX12,GFX12-GISEL

define amdgpu_ps {<4 x float>, <4 x float>, <4 x float>} @buffer_load(<4 x i32> inreg) {
; PREGFX10-LABEL: buffer_load:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    buffer_load_dwordx4 v[0:3], off, s[0:3], 0
; PREGFX10-NEXT:    buffer_load_dwordx4 v[4:7], off, s[0:3], 0 glc
; PREGFX10-NEXT:    buffer_load_dwordx4 v[8:11], off, s[0:3], 0 slc
; PREGFX10-NEXT:    s_waitcnt vmcnt(0)
; PREGFX10-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: buffer_load:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    s_clause 0x2
; GFX10-NEXT:    buffer_load_dwordx4 v[0:3], off, s[0:3], 0
; GFX10-NEXT:    buffer_load_dwordx4 v[4:7], off, s[0:3], 0 glc
; GFX10-NEXT:    buffer_load_dwordx4 v[8:11], off, s[0:3], 0 slc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    s_clause 0x2
; GFX11-NEXT:    buffer_load_b128 v[0:3], off, s[0:3], 0
; GFX11-NEXT:    buffer_load_b128 v[4:7], off, s[0:3], 0 glc
; GFX11-NEXT:    buffer_load_b128 v[8:11], off, s[0:3], 0 slc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
;
; GFX12-LABEL: buffer_load:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    s_clause 0x2
; GFX12-NEXT:    buffer_load_b128 v[0:3], off, s[0:3], null
; GFX12-NEXT:    buffer_load_b128 v[4:7], off, s[0:3], null th:TH_LOAD_NT
; GFX12-NEXT:    buffer_load_b128 v[8:11], off, s[0:3], null th:TH_LOAD_HT
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    ; return to shader part epilog
main_body:
  %data = call <4 x float> @llvm.amdgcn.raw.buffer.load.v4f32(<4 x i32> %0, i32 0, i32 0, i32 0)
  %data_glc = call <4 x float> @llvm.amdgcn.raw.buffer.load.v4f32(<4 x i32> %0, i32 0, i32 0, i32 1)
  %data_slc = call <4 x float> @llvm.amdgcn.raw.buffer.load.v4f32(<4 x i32> %0, i32 0, i32 0, i32 2)
  %r0 = insertvalue {<4 x float>, <4 x float>, <4 x float>} poison, <4 x float> %data, 0
  %r1 = insertvalue {<4 x float>, <4 x float>, <4 x float>} %r0, <4 x float> %data_glc, 1
  %r2 = insertvalue {<4 x float>, <4 x float>, <4 x float>} %r1, <4 x float> %data_slc, 2
  ret {<4 x float>, <4 x float>, <4 x float>} %r2
}

define amdgpu_ps {<4 x float>, <4 x float>, <4 x float>} @buffer_load_dlc(<4 x i32> inreg) {
; PREGFX10-LABEL: buffer_load_dlc:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    buffer_load_dwordx4 v[0:3], off, s[0:3], 0
; PREGFX10-NEXT:    buffer_load_dwordx4 v[4:7], off, s[0:3], 0 glc
; PREGFX10-NEXT:    buffer_load_dwordx4 v[8:11], off, s[0:3], 0 slc
; PREGFX10-NEXT:    s_waitcnt vmcnt(0)
; PREGFX10-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: buffer_load_dlc:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    s_clause 0x2
; GFX10-NEXT:    buffer_load_dwordx4 v[0:3], off, s[0:3], 0 dlc
; GFX10-NEXT:    buffer_load_dwordx4 v[4:7], off, s[0:3], 0 glc dlc
; GFX10-NEXT:    buffer_load_dwordx4 v[8:11], off, s[0:3], 0 slc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_dlc:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    s_clause 0x2
; GFX11-NEXT:    buffer_load_b128 v[0:3], off, s[0:3], 0 dlc
; GFX11-NEXT:    buffer_load_b128 v[4:7], off, s[0:3], 0 glc dlc
; GFX11-NEXT:    buffer_load_b128 v[8:11], off, s[0:3], 0 slc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
;
; GFX12-LABEL: buffer_load_dlc:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    s_clause 0x2
; GFX12-NEXT:    buffer_load_b128 v[0:3], off, s[0:3], null th:TH_LOAD_NT_RT
; GFX12-NEXT:    buffer_load_b128 v[4:7], off, s[0:3], null th:TH_LOAD_RT_NT
; GFX12-NEXT:    buffer_load_b128 v[8:11], off, s[0:3], null th:TH_LOAD_NT_HT
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    ; return to shader part epilog
main_body:
  %data = call <4 x float> @llvm.amdgcn.raw.buffer.load.v4f32(<4 x i32> %0, i32 0, i32 0, i32 4)
  %data_glc = call <4 x float> @llvm.amdgcn.raw.buffer.load.v4f32(<4 x i32> %0, i32 0, i32 0, i32 5)
  %data_slc = call <4 x float> @llvm.amdgcn.raw.buffer.load.v4f32(<4 x i32> %0, i32 0, i32 0, i32 6)
  %r0 = insertvalue {<4 x float>, <4 x float>, <4 x float>} poison, <4 x float> %data, 0
  %r1 = insertvalue {<4 x float>, <4 x float>, <4 x float>} %r0, <4 x float> %data_glc, 1
  %r2 = insertvalue {<4 x float>, <4 x float>, <4 x float>} %r1, <4 x float> %data_slc, 2
  ret {<4 x float>, <4 x float>, <4 x float>} %r2
}

define amdgpu_ps <4 x float> @buffer_load_immoffs(<4 x i32> inreg) {
; PREGFX10-LABEL: buffer_load_immoffs:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    buffer_load_dwordx4 v[0:3], off, s[0:3], 0 offset:40
; PREGFX10-NEXT:    s_waitcnt vmcnt(0)
; PREGFX10-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: buffer_load_immoffs:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    buffer_load_dwordx4 v[0:3], off, s[0:3], 0 offset:40
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_immoffs:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    buffer_load_b128 v[0:3], off, s[0:3], 0 offset:40
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
;
; GFX12-LABEL: buffer_load_immoffs:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    buffer_load_b128 v[0:3], off, s[0:3], null offset:40
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    ; return to shader part epilog
main_body:
  %data = call <4 x float> @llvm.amdgcn.raw.buffer.load.v4f32(<4 x i32> %0, i32 40, i32 0, i32 0)
  ret <4 x float> %data
}

define amdgpu_ps <4 x float> @buffer_load_immoffs_large(<4 x i32> inreg) {
; PREGFX10-LABEL: buffer_load_immoffs_large:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    s_movk_i32 s4, 0x1ffc
; PREGFX10-NEXT:    buffer_load_dwordx4 v[0:3], off, s[0:3], s4 offset:4
; PREGFX10-NEXT:    s_waitcnt vmcnt(0)
; PREGFX10-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: buffer_load_immoffs_large:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    s_movk_i32 s4, 0x1ffc
; GFX10-NEXT:    buffer_load_dwordx4 v[0:3], off, s[0:3], s4 offset:4
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_immoffs_large:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    s_movk_i32 s4, 0x1ffc
; GFX11-NEXT:    buffer_load_b128 v[0:3], off, s[0:3], s4 offset:4
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
;
; GFX12-LABEL: buffer_load_immoffs_large:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    s_movk_i32 s4, 0x1ffc
; GFX12-NEXT:    buffer_load_b128 v[0:3], off, s[0:3], s4 offset:4
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    ; return to shader part epilog
main_body:
  %data = call <4 x float> @llvm.amdgcn.raw.buffer.load.v4f32(<4 x i32> %0, i32 4, i32 8188, i32 0)
  ret <4 x float> %data
}

define amdgpu_ps <4 x float> @buffer_load_ofs(<4 x i32> inreg, i32) {
; PREGFX10-LABEL: buffer_load_ofs:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    buffer_load_dwordx4 v[0:3], v0, s[0:3], 0 offen
; PREGFX10-NEXT:    s_waitcnt vmcnt(0)
; PREGFX10-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: buffer_load_ofs:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    buffer_load_dwordx4 v[0:3], v0, s[0:3], 0 offen
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_ofs:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    buffer_load_b128 v[0:3], v0, s[0:3], 0 offen
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
;
; GFX12-LABEL: buffer_load_ofs:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    buffer_load_b128 v[0:3], v0, s[0:3], null offen
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    ; return to shader part epilog
main_body:
  %data = call <4 x float> @llvm.amdgcn.raw.buffer.load.v4f32(<4 x i32> %0, i32 %1, i32 0, i32 0)
  ret <4 x float> %data
}

define amdgpu_ps <4 x float> @buffer_load_ofs_imm(<4 x i32> inreg, i32) {
; PREGFX10-LABEL: buffer_load_ofs_imm:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    buffer_load_dwordx4 v[0:3], v0, s[0:3], 0 offen offset:60
; PREGFX10-NEXT:    s_waitcnt vmcnt(0)
; PREGFX10-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: buffer_load_ofs_imm:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    buffer_load_dwordx4 v[0:3], v0, s[0:3], 0 offen offset:60
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_ofs_imm:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    buffer_load_b128 v[0:3], v0, s[0:3], 0 offen offset:60
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
;
; GFX12-LABEL: buffer_load_ofs_imm:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    buffer_load_b128 v[0:3], v0, s[0:3], null offen offset:60
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    ; return to shader part epilog
main_body:
  %ofs = add i32 %1, 60
  %data = call <4 x float> @llvm.amdgcn.raw.buffer.load.v4f32(<4 x i32> %0, i32 %ofs, i32 0, i32 0)
  ret <4 x float> %data
}

define amdgpu_ps <4 x float> @buffer_load_voffset_large_12bit(<4 x i32> inreg) {
; PREGFX10-LABEL: buffer_load_voffset_large_12bit:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    buffer_load_dwordx4 v[0:3], off, s[0:3], 0 offset:4092
; PREGFX10-NEXT:    s_waitcnt vmcnt(0)
; PREGFX10-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: buffer_load_voffset_large_12bit:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    buffer_load_dwordx4 v[0:3], off, s[0:3], 0 offset:4092
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_voffset_large_12bit:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    buffer_load_b128 v[0:3], off, s[0:3], 0 offset:4092
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
;
; GFX12-LABEL: buffer_load_voffset_large_12bit:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    buffer_load_b128 v[0:3], off, s[0:3], null offset:4092
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    ; return to shader part epilog
main_body:
  %data = call <4 x float> @llvm.amdgcn.raw.buffer.load.v4f32(<4 x i32> %0, i32 4092, i32 0, i32 0)
  ret <4 x float> %data
}

define amdgpu_ps <4 x float> @buffer_load_voffset_large_13bit(<4 x i32> inreg) {
; PREGFX10-LABEL: buffer_load_voffset_large_13bit:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    v_mov_b32_e32 v0, 0x1000
; PREGFX10-NEXT:    buffer_load_dwordx4 v[0:3], v0, s[0:3], 0 offen offset:4092
; PREGFX10-NEXT:    s_waitcnt vmcnt(0)
; PREGFX10-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: buffer_load_voffset_large_13bit:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    v_mov_b32_e32 v0, 0x1000
; GFX10-NEXT:    buffer_load_dwordx4 v[0:3], v0, s[0:3], 0 offen offset:4092
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_voffset_large_13bit:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v0, 0x1000
; GFX11-NEXT:    buffer_load_b128 v[0:3], v0, s[0:3], 0 offen offset:4092
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
;
; GFX12-LABEL: buffer_load_voffset_large_13bit:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    buffer_load_b128 v[0:3], off, s[0:3], null offset:8188
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    ; return to shader part epilog
main_body:
  %data = call <4 x float> @llvm.amdgcn.raw.buffer.load.v4f32(<4 x i32> %0, i32 8188, i32 0, i32 0)
  ret <4 x float> %data
}

define amdgpu_ps <4 x float> @buffer_load_voffset_large_16bit(<4 x i32> inreg) {
; PREGFX10-LABEL: buffer_load_voffset_large_16bit:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    v_mov_b32_e32 v0, 0xf000
; PREGFX10-NEXT:    buffer_load_dwordx4 v[0:3], v0, s[0:3], 0 offen offset:4092
; PREGFX10-NEXT:    s_waitcnt vmcnt(0)
; PREGFX10-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: buffer_load_voffset_large_16bit:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    v_mov_b32_e32 v0, 0xf000
; GFX10-NEXT:    buffer_load_dwordx4 v[0:3], v0, s[0:3], 0 offen offset:4092
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_voffset_large_16bit:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v0, 0xf000
; GFX11-NEXT:    buffer_load_b128 v[0:3], v0, s[0:3], 0 offen offset:4092
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
;
; GFX12-LABEL: buffer_load_voffset_large_16bit:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    buffer_load_b128 v[0:3], off, s[0:3], null offset:65532
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    ; return to shader part epilog
main_body:
  %data = call <4 x float> @llvm.amdgcn.raw.buffer.load.v4f32(<4 x i32> %0, i32 65532, i32 0, i32 0)
  ret <4 x float> %data
}

define amdgpu_ps <4 x float> @buffer_load_voffset_large_23bit(<4 x i32> inreg) {
; PREGFX10-LABEL: buffer_load_voffset_large_23bit:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    v_mov_b32_e32 v0, 0x7ff000
; PREGFX10-NEXT:    buffer_load_dwordx4 v[0:3], v0, s[0:3], 0 offen offset:4092
; PREGFX10-NEXT:    s_waitcnt vmcnt(0)
; PREGFX10-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: buffer_load_voffset_large_23bit:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    v_mov_b32_e32 v0, 0x7ff000
; GFX10-NEXT:    buffer_load_dwordx4 v[0:3], v0, s[0:3], 0 offen offset:4092
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_voffset_large_23bit:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v0, 0x7ff000
; GFX11-NEXT:    buffer_load_b128 v[0:3], v0, s[0:3], 0 offen offset:4092
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
;
; GFX12-LABEL: buffer_load_voffset_large_23bit:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    buffer_load_b128 v[0:3], off, s[0:3], null offset:8388604
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    ; return to shader part epilog
main_body:
  %data = call <4 x float> @llvm.amdgcn.raw.buffer.load.v4f32(<4 x i32> %0, i32 8388604, i32 0, i32 0)
  ret <4 x float> %data
}

define amdgpu_ps <4 x float> @buffer_load_voffset_large_24bit(<4 x i32> inreg) {
; PREGFX10-LABEL: buffer_load_voffset_large_24bit:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    v_mov_b32_e32 v0, 0xfff000
; PREGFX10-NEXT:    buffer_load_dwordx4 v[0:3], v0, s[0:3], 0 offen offset:4092
; PREGFX10-NEXT:    s_waitcnt vmcnt(0)
; PREGFX10-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: buffer_load_voffset_large_24bit:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    v_mov_b32_e32 v0, 0xfff000
; GFX10-NEXT:    buffer_load_dwordx4 v[0:3], v0, s[0:3], 0 offen offset:4092
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_voffset_large_24bit:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v0, 0xfff000
; GFX11-NEXT:    buffer_load_b128 v[0:3], v0, s[0:3], 0 offen offset:4092
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
;
; GFX12-LABEL: buffer_load_voffset_large_24bit:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    v_mov_b32_e32 v0, 0x800000
; GFX12-NEXT:    buffer_load_b128 v[0:3], v0, s[0:3], null offen offset:8388604
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    ; return to shader part epilog
main_body:
  %data = call <4 x float> @llvm.amdgcn.raw.buffer.load.v4f32(<4 x i32> %0, i32 16777212, i32 0, i32 0)
  ret <4 x float> %data
}


define amdgpu_ps float @buffer_load_x1(<4 x i32> inreg %rsrc, i32 %ofs) {
; PREGFX10-LABEL: buffer_load_x1:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    buffer_load_dword v0, v0, s[0:3], 0 offen
; PREGFX10-NEXT:    s_waitcnt vmcnt(0)
; PREGFX10-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: buffer_load_x1:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    buffer_load_dword v0, v0, s[0:3], 0 offen
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_x1:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    buffer_load_b32 v0, v0, s[0:3], 0 offen
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
;
; GFX12-LABEL: buffer_load_x1:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    buffer_load_b32 v0, v0, s[0:3], null offen
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    ; return to shader part epilog
main_body:
  %data = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 %ofs, i32 0, i32 0)
  ret float %data
}

define amdgpu_ps <2 x float> @buffer_load_x2(<4 x i32> inreg %rsrc, i32 %ofs) {
; PREGFX10-LABEL: buffer_load_x2:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    buffer_load_dwordx2 v[0:1], v0, s[0:3], 0 offen
; PREGFX10-NEXT:    s_waitcnt vmcnt(0)
; PREGFX10-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: buffer_load_x2:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    buffer_load_dwordx2 v[0:1], v0, s[0:3], 0 offen
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_x2:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    buffer_load_b64 v[0:1], v0, s[0:3], 0 offen
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
;
; GFX12-LABEL: buffer_load_x2:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    buffer_load_b64 v[0:1], v0, s[0:3], null offen
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    ; return to shader part epilog
main_body:
  %data = call <2 x float> @llvm.amdgcn.raw.buffer.load.v2f32(<4 x i32> %rsrc, i32 %ofs, i32 0, i32 0)
  ret <2 x float> %data
}

define amdgpu_ps <4 x float> @buffer_load_negative_offset(<4 x i32> inreg, i32 %ofs) {
; GFX10-LABEL: buffer_load_negative_offset:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    v_add_nc_u32_e32 v0, -16, v0
; GFX10-NEXT:    buffer_load_dwordx4 v[0:3], v0, s[0:3], 0 offen
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_negative_offset:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_add_nc_u32_e32 v0, -16, v0
; GFX11-NEXT:    buffer_load_b128 v[0:3], v0, s[0:3], 0 offen
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
;
; GFX12-LABEL: buffer_load_negative_offset:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    v_add_nc_u32_e32 v0, -16, v0
; GFX12-NEXT:    buffer_load_b128 v[0:3], v0, s[0:3], null offen
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    ; return to shader part epilog
main_body:
  %ofs.1 = add i32 %ofs, -16
  %data = call <4 x float> @llvm.amdgcn.raw.buffer.load.v4f32(<4 x i32> %0, i32 %ofs.1, i32 0, i32 0)
  ret <4 x float> %data
}

define amdgpu_ps float @buffer_load_mmo(<4 x i32> inreg %rsrc, ptr addrspace(3) %lds) {
; GFX10-LABEL: buffer_load_mmo:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    buffer_load_dword v1, off, s[0:3], 0
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    ds_write2_b32 v0, v2, v2 offset1:4
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, v1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_mmo:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    buffer_load_b32 v1, off, s[0:3], 0
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    ds_store_2addr_b32 v0, v2, v2 offset1:4
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v0, v1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
;
; GFX12-LABEL: buffer_load_mmo:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    buffer_load_b32 v1, off, s[0:3], null
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    ds_store_2addr_b32 v0, v2, v2 offset1:4
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v0, v1
; GFX12-NEXT:    s_wait_dscnt 0x0
; GFX12-NEXT:    ; return to shader part epilog
entry:
  store float 0.0, ptr addrspace(3) %lds
  %val = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 0, i32 0, i32 0)
  %tmp2 = getelementptr float, ptr addrspace(3) %lds, i32 4
  store float 0.0, ptr addrspace(3) %tmp2
  ret float %val
}

define amdgpu_ps void @buffer_load_x1_offen_merged_and(<4 x i32> inreg %rsrc, i32 %a) {
; PREGFX10-LABEL: buffer_load_x1_offen_merged_and:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    buffer_load_dwordx4 v[1:4], v0, s[0:3], 0 offen offset:4
; PREGFX10-NEXT:    buffer_load_dwordx2 v[5:6], v0, s[0:3], 0 offen offset:28
; PREGFX10-NEXT:    s_waitcnt vmcnt(1)
; PREGFX10-NEXT:    exp mrt0 v1, v2, v3, v4 done vm
; PREGFX10-NEXT:    s_waitcnt vmcnt(0)
; PREGFX10-NEXT:    exp mrt0 v5, v6, v0, v0 done vm
; PREGFX10-NEXT:    s_endpgm
;
; GFX10-LABEL: buffer_load_x1_offen_merged_and:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    buffer_load_dwordx4 v[1:4], v0, s[0:3], 0 offen offset:4
; GFX10-NEXT:    buffer_load_dwordx2 v[5:6], v0, s[0:3], 0 offen offset:28
; GFX10-NEXT:    s_waitcnt vmcnt(1)
; GFX10-NEXT:    exp mrt0 v1, v2, v3, v4 done vm
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    exp mrt0 v5, v6, v0, v0 done vm
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: buffer_load_x1_offen_merged_and:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    buffer_load_b128 v[1:4], v0, s[0:3], 0 offen offset:4
; GFX11-NEXT:    buffer_load_b64 v[5:6], v0, s[0:3], 0 offen offset:28
; GFX11-NEXT:    s_waitcnt vmcnt(1)
; GFX11-NEXT:    exp mrt0 v1, v2, v3, v4 done
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    exp mrt0 v5, v6, v0, v0 done
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: buffer_load_x1_offen_merged_and:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    buffer_load_b128 v[1:4], v0, s[0:3], null offen offset:4
; GFX12-NEXT:    buffer_load_b64 v[5:6], v0, s[0:3], null offen offset:28
; GFX12-NEXT:    s_wait_loadcnt 0x1
; GFX12-NEXT:    export mrt0 v1, v2, v3, v4 done
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    export mrt0 v5, v6, v0, v0 done
; GFX12-NEXT:    s_endpgm
main_body:
  %a1 = add i32 %a, 4
  %a2 = add i32 %a, 8
  %a3 = add i32 %a, 12
  %a4 = add i32 %a, 16
  %a5 = add i32 %a, 28
  %a6 = add i32 %a, 32
  %r1 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 %a1, i32 0, i32 0)
  %r2 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 %a2, i32 0, i32 0)
  %r3 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 %a3, i32 0, i32 0)
  %r4 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 %a4, i32 0, i32 0)
  %r5 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 %a5, i32 0, i32 0)
  %r6 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 %a6, i32 0, i32 0)
  call void @llvm.amdgcn.exp.f32(i32 0, i32 15, float %r1, float %r2, float %r3, float %r4, i1 true, i1 true)
  call void @llvm.amdgcn.exp.f32(i32 0, i32 15, float %r5, float %r6, float poison, float poison, i1 true, i1 true)
  ret void
}

define amdgpu_ps void @buffer_load_x1_offen_merged_or(<4 x i32> inreg %rsrc, i32 %inp) {
; PREGFX10-LABEL: buffer_load_x1_offen_merged_or:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    v_lshlrev_b32_e32 v4, 6, v0
; PREGFX10-NEXT:    buffer_load_dwordx4 v[0:3], v4, s[0:3], 0 offen offset:4
; PREGFX10-NEXT:    buffer_load_dwordx2 v[4:5], v4, s[0:3], 0 offen offset:28
; PREGFX10-NEXT:    s_waitcnt vmcnt(1)
; PREGFX10-NEXT:    exp mrt0 v0, v1, v2, v3 done vm
; PREGFX10-NEXT:    s_waitcnt vmcnt(0)
; PREGFX10-NEXT:    exp mrt0 v4, v5, v0, v0 done vm
; PREGFX10-NEXT:    s_endpgm
;
; GFX10-LABEL: buffer_load_x1_offen_merged_or:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    v_lshlrev_b32_e32 v6, 6, v0
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    buffer_load_dwordx4 v[0:3], v6, s[0:3], 0 offen offset:4
; GFX10-NEXT:    buffer_load_dwordx2 v[4:5], v6, s[0:3], 0 offen offset:28
; GFX10-NEXT:    s_waitcnt vmcnt(1)
; GFX10-NEXT:    exp mrt0 v0, v1, v2, v3 done vm
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    exp mrt0 v4, v5, v0, v0 done vm
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: buffer_load_x1_offen_merged_or:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 6, v0
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    buffer_load_b128 v[0:3], v4, s[0:3], 0 offen offset:4
; GFX11-NEXT:    buffer_load_b64 v[4:5], v4, s[0:3], 0 offen offset:28
; GFX11-NEXT:    s_waitcnt vmcnt(1)
; GFX11-NEXT:    exp mrt0 v0, v1, v2, v3 done
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    exp mrt0 v4, v5, v0, v0 done
; GFX11-NEXT:    s_endpgm
;
; GFX12-SDAG-LABEL: buffer_load_x1_offen_merged_or:
; GFX12-SDAG:       ; %bb.0: ; %main_body
; GFX12-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 6, v0
; GFX12-SDAG-NEXT:    s_clause 0x1
; GFX12-SDAG-NEXT:    buffer_load_b128 v[0:3], v4, s[0:3], null offen offset:4
; GFX12-SDAG-NEXT:    buffer_load_b64 v[4:5], v4, s[0:3], null offen offset:28
; GFX12-SDAG-NEXT:    s_wait_loadcnt 0x1
; GFX12-SDAG-NEXT:    export mrt0 v0, v1, v2, v3 done
; GFX12-SDAG-NEXT:    s_wait_loadcnt 0x0
; GFX12-SDAG-NEXT:    export mrt0 v4, v5, v0, v0 done
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: buffer_load_x1_offen_merged_or:
; GFX12-GISEL:       ; %bb.0: ; %main_body
; GFX12-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 6, v0
; GFX12-GISEL-NEXT:    v_or_b32_e32 v1, 4, v0
; GFX12-GISEL-NEXT:    v_or_b32_e32 v2, 8, v0
; GFX12-GISEL-NEXT:    v_or_b32_e32 v3, 12, v0
; GFX12-GISEL-NEXT:    v_or_b32_e32 v4, 16, v0
; GFX12-GISEL-NEXT:    v_or_b32_e32 v5, 28, v0
; GFX12-GISEL-NEXT:    v_or_b32_e32 v0, 32, v0
; GFX12-GISEL-NEXT:    s_clause 0x5
; GFX12-GISEL-NEXT:    buffer_load_b32 v1, v1, s[0:3], null offen
; GFX12-GISEL-NEXT:    buffer_load_b32 v2, v2, s[0:3], null offen
; GFX12-GISEL-NEXT:    buffer_load_b32 v3, v3, s[0:3], null offen
; GFX12-GISEL-NEXT:    buffer_load_b32 v4, v4, s[0:3], null offen
; GFX12-GISEL-NEXT:    buffer_load_b32 v5, v5, s[0:3], null offen
; GFX12-GISEL-NEXT:    buffer_load_b32 v0, v0, s[0:3], null offen
; GFX12-GISEL-NEXT:    s_wait_loadcnt 0x2
; GFX12-GISEL-NEXT:    export mrt0 v1, v2, v3, v4 done
; GFX12-GISEL-NEXT:    s_wait_loadcnt 0x0
; GFX12-GISEL-NEXT:    export mrt0 v5, v0, v0, v0 done
; GFX12-GISEL-NEXT:    s_endpgm
main_body:
  %a = shl i32 %inp, 6
  %a1 = or i32 %a, 4
  %a2 = or i32 %a, 8
  %a3 = or i32 %a, 12
  %a4 = or i32 %a, 16
  %a5 = or i32 %a, 28
  %a6 = or i32 %a, 32
  %r1 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 %a1, i32 0, i32 0)
  %r2 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 %a2, i32 0, i32 0)
  %r3 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 %a3, i32 0, i32 0)
  %r4 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 %a4, i32 0, i32 0)
  %r5 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 %a5, i32 0, i32 0)
  %r6 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 %a6, i32 0, i32 0)
  call void @llvm.amdgcn.exp.f32(i32 0, i32 15, float %r1, float %r2, float %r3, float %r4, i1 true, i1 true)
  call void @llvm.amdgcn.exp.f32(i32 0, i32 15, float %r5, float %r6, float poison, float poison, i1 true, i1 true)
  ret void
}

define amdgpu_ps void @buffer_load_x1_offen_merged_glc_slc(<4 x i32> inreg %rsrc, i32 %a) {
; PREGFX10-LABEL: buffer_load_x1_offen_merged_glc_slc:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    buffer_load_dwordx2 v[1:2], v0, s[0:3], 0 offen offset:4
; PREGFX10-NEXT:    buffer_load_dwordx2 v[3:4], v0, s[0:3], 0 offen offset:12 glc
; PREGFX10-NEXT:    buffer_load_dwordx2 v[5:6], v0, s[0:3], 0 offen offset:28 glc slc
; PREGFX10-NEXT:    s_waitcnt vmcnt(1)
; PREGFX10-NEXT:    exp mrt0 v1, v2, v3, v4 done vm
; PREGFX10-NEXT:    s_waitcnt vmcnt(0)
; PREGFX10-NEXT:    exp mrt0 v5, v6, v0, v0 done vm
; PREGFX10-NEXT:    s_endpgm
;
; GFX10-LABEL: buffer_load_x1_offen_merged_glc_slc:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    s_clause 0x2
; GFX10-NEXT:    buffer_load_dwordx2 v[1:2], v0, s[0:3], 0 offen offset:4
; GFX10-NEXT:    buffer_load_dwordx2 v[3:4], v0, s[0:3], 0 offen offset:12 glc
; GFX10-NEXT:    buffer_load_dwordx2 v[5:6], v0, s[0:3], 0 offen offset:28 glc slc
; GFX10-NEXT:    s_waitcnt vmcnt(1)
; GFX10-NEXT:    exp mrt0 v1, v2, v3, v4 done vm
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    exp mrt0 v5, v6, v0, v0 done vm
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: buffer_load_x1_offen_merged_glc_slc:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    s_clause 0x2
; GFX11-NEXT:    buffer_load_b64 v[1:2], v0, s[0:3], 0 offen offset:4
; GFX11-NEXT:    buffer_load_b64 v[3:4], v0, s[0:3], 0 offen offset:12 glc
; GFX11-NEXT:    buffer_load_b64 v[5:6], v0, s[0:3], 0 offen offset:28 glc slc
; GFX11-NEXT:    s_waitcnt vmcnt(1)
; GFX11-NEXT:    exp mrt0 v1, v2, v3, v4 done
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    exp mrt0 v5, v6, v0, v0 done
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: buffer_load_x1_offen_merged_glc_slc:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    s_clause 0x2
; GFX12-NEXT:    buffer_load_b64 v[1:2], v0, s[0:3], null offen offset:4
; GFX12-NEXT:    buffer_load_b64 v[3:4], v0, s[0:3], null offen offset:12 th:TH_LOAD_NT
; GFX12-NEXT:    buffer_load_b64 v[5:6], v0, s[0:3], null offen offset:28 th:TH_LOAD_LU
; GFX12-NEXT:    s_wait_loadcnt 0x1
; GFX12-NEXT:    export mrt0 v1, v2, v3, v4 done
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    export mrt0 v5, v6, v0, v0 done
; GFX12-NEXT:    s_endpgm
main_body:
  %a1 = add i32 %a, 4
  %a2 = add i32 %a, 8
  %a3 = add i32 %a, 12
  %a4 = add i32 %a, 16
  %a5 = add i32 %a, 28
  %a6 = add i32 %a, 32
  %r1 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 %a1, i32 0, i32 0)
  %r2 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 %a2, i32 0, i32 0)
  %r3 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 %a3, i32 0, i32 1)
  %r4 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 %a4, i32 0, i32 1)
  %r5 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 %a5, i32 0, i32 3)
  %r6 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 %a6, i32 0, i32 3)
  call void @llvm.amdgcn.exp.f32(i32 0, i32 15, float %r1, float %r2, float %r3, float %r4, i1 true, i1 true)
  call void @llvm.amdgcn.exp.f32(i32 0, i32 15, float %r5, float %r6, float poison, float poison, i1 true, i1 true)
  ret void
}

define amdgpu_ps void @buffer_load_x2_offen_merged_and(<4 x i32> inreg %rsrc, i32 %a) {
; PREGFX10-LABEL: buffer_load_x2_offen_merged_and:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    buffer_load_dwordx4 v[0:3], v0, s[0:3], 0 offen offset:4
; PREGFX10-NEXT:    s_waitcnt vmcnt(0)
; PREGFX10-NEXT:    exp mrt0 v0, v1, v2, v3 done vm
; PREGFX10-NEXT:    s_endpgm
;
; GFX10-LABEL: buffer_load_x2_offen_merged_and:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    buffer_load_dwordx4 v[0:3], v0, s[0:3], 0 offen offset:4
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    exp mrt0 v0, v1, v2, v3 done vm
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: buffer_load_x2_offen_merged_and:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    buffer_load_b128 v[0:3], v0, s[0:3], 0 offen offset:4
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    exp mrt0 v0, v1, v2, v3 done
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: buffer_load_x2_offen_merged_and:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    buffer_load_b128 v[0:3], v0, s[0:3], null offen offset:4
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    export mrt0 v0, v1, v2, v3 done
; GFX12-NEXT:    s_endpgm
main_body:
  %a1 = add i32 %a, 4
  %a2 = add i32 %a, 12
  %vr1 = call <2 x float> @llvm.amdgcn.raw.buffer.load.v2f32(<4 x i32> %rsrc, i32 %a1, i32 0, i32 0)
  %vr2 = call <2 x float> @llvm.amdgcn.raw.buffer.load.v2f32(<4 x i32> %rsrc, i32 %a2, i32 0, i32 0)
  %r1 = extractelement <2 x float> %vr1, i32 0
  %r2 = extractelement <2 x float> %vr1, i32 1
  %r3 = extractelement <2 x float> %vr2, i32 0
  %r4 = extractelement <2 x float> %vr2, i32 1
  call void @llvm.amdgcn.exp.f32(i32 0, i32 15, float %r1, float %r2, float %r3, float %r4, i1 true, i1 true)
  ret void
}

define amdgpu_ps void @buffer_load_x2_offen_merged_or(<4 x i32> inreg %rsrc, i32 %inp) {
; PREGFX10-LABEL: buffer_load_x2_offen_merged_or:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; PREGFX10-NEXT:    buffer_load_dwordx4 v[0:3], v0, s[0:3], 0 offen offset:4
; PREGFX10-NEXT:    s_waitcnt vmcnt(0)
; PREGFX10-NEXT:    exp mrt0 v0, v1, v2, v3 done vm
; PREGFX10-NEXT:    s_endpgm
;
; GFX10-LABEL: buffer_load_x2_offen_merged_or:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX10-NEXT:    buffer_load_dwordx4 v[0:3], v0, s[0:3], 0 offen offset:4
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    exp mrt0 v0, v1, v2, v3 done vm
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: buffer_load_x2_offen_merged_or:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX11-NEXT:    buffer_load_b128 v[0:3], v0, s[0:3], 0 offen offset:4
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    exp mrt0 v0, v1, v2, v3 done
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: buffer_load_x2_offen_merged_or:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX12-NEXT:    buffer_load_b128 v[0:3], v0, s[0:3], null offen offset:4
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    export mrt0 v0, v1, v2, v3 done
; GFX12-NEXT:    s_endpgm
main_body:
  %a = shl i32 %inp, 4
  %a1 = add i32 %a, 4
  %a2 = add i32 %a, 12
  %vr1 = call <2 x float> @llvm.amdgcn.raw.buffer.load.v2f32(<4 x i32> %rsrc, i32 %a1, i32 0, i32 0)
  %vr2 = call <2 x float> @llvm.amdgcn.raw.buffer.load.v2f32(<4 x i32> %rsrc, i32 %a2, i32 0, i32 0)
  %r1 = extractelement <2 x float> %vr1, i32 0
  %r2 = extractelement <2 x float> %vr1, i32 1
  %r3 = extractelement <2 x float> %vr2, i32 0
  %r4 = extractelement <2 x float> %vr2, i32 1
  call void @llvm.amdgcn.exp.f32(i32 0, i32 15, float %r1, float %r2, float %r3, float %r4, i1 true, i1 true)
  ret void
}

define amdgpu_ps void @buffer_load_x1_offset_merged(<4 x i32> inreg %rsrc) {
; PREGFX10-LABEL: buffer_load_x1_offset_merged:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    buffer_load_dwordx4 v[0:3], off, s[0:3], 0 offset:4
; PREGFX10-NEXT:    buffer_load_dwordx2 v[4:5], off, s[0:3], 0 offset:28
; PREGFX10-NEXT:    s_waitcnt vmcnt(1)
; PREGFX10-NEXT:    exp mrt0 v0, v1, v2, v3 done vm
; PREGFX10-NEXT:    s_waitcnt vmcnt(0)
; PREGFX10-NEXT:    exp mrt0 v4, v5, v0, v0 done vm
; PREGFX10-NEXT:    s_endpgm
;
; GFX10-LABEL: buffer_load_x1_offset_merged:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    buffer_load_dwordx4 v[0:3], off, s[0:3], 0 offset:4
; GFX10-NEXT:    buffer_load_dwordx2 v[4:5], off, s[0:3], 0 offset:28
; GFX10-NEXT:    s_waitcnt vmcnt(1)
; GFX10-NEXT:    exp mrt0 v0, v1, v2, v3 done vm
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    exp mrt0 v4, v5, v0, v0 done vm
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: buffer_load_x1_offset_merged:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    buffer_load_b128 v[0:3], off, s[0:3], 0 offset:4
; GFX11-NEXT:    buffer_load_b64 v[4:5], off, s[0:3], 0 offset:28
; GFX11-NEXT:    s_waitcnt vmcnt(1)
; GFX11-NEXT:    exp mrt0 v0, v1, v2, v3 done
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    exp mrt0 v4, v5, v0, v0 done
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: buffer_load_x1_offset_merged:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    buffer_load_b128 v[0:3], off, s[0:3], null offset:4
; GFX12-NEXT:    buffer_load_b64 v[4:5], off, s[0:3], null offset:28
; GFX12-NEXT:    s_wait_loadcnt 0x1
; GFX12-NEXT:    export mrt0 v0, v1, v2, v3 done
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    export mrt0 v4, v5, v0, v0 done
; GFX12-NEXT:    s_endpgm
main_body:
  %r1 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 4, i32 0, i32 0)
  %r2 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 8, i32 0, i32 0)
  %r3 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 12, i32 0, i32 0)
  %r4 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 16, i32 0, i32 0)
  %r5 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 28, i32 0, i32 0)
  %r6 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 32, i32 0, i32 0)
  call void @llvm.amdgcn.exp.f32(i32 0, i32 15, float %r1, float %r2, float %r3, float %r4, i1 true, i1 true)
  call void @llvm.amdgcn.exp.f32(i32 0, i32 15, float %r5, float %r6, float poison, float poison, i1 true, i1 true)
  ret void
}

define amdgpu_ps void @buffer_load_x2_offset_merged(<4 x i32> inreg %rsrc) {
; PREGFX10-LABEL: buffer_load_x2_offset_merged:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    buffer_load_dwordx4 v[0:3], off, s[0:3], 0 offset:4
; PREGFX10-NEXT:    s_waitcnt vmcnt(0)
; PREGFX10-NEXT:    exp mrt0 v0, v1, v2, v3 done vm
; PREGFX10-NEXT:    s_endpgm
;
; GFX10-LABEL: buffer_load_x2_offset_merged:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    buffer_load_dwordx4 v[0:3], off, s[0:3], 0 offset:4
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    exp mrt0 v0, v1, v2, v3 done vm
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: buffer_load_x2_offset_merged:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    buffer_load_b128 v[0:3], off, s[0:3], 0 offset:4
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    exp mrt0 v0, v1, v2, v3 done
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: buffer_load_x2_offset_merged:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    buffer_load_b128 v[0:3], off, s[0:3], null offset:4
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    export mrt0 v0, v1, v2, v3 done
; GFX12-NEXT:    s_endpgm
main_body:
  %vr1 = call <2 x float> @llvm.amdgcn.raw.buffer.load.v2f32(<4 x i32> %rsrc, i32 4, i32 0, i32 0)
  %vr2 = call <2 x float> @llvm.amdgcn.raw.buffer.load.v2f32(<4 x i32> %rsrc, i32 12, i32 0, i32 0)
  %r1 = extractelement <2 x float> %vr1, i32 0
  %r2 = extractelement <2 x float> %vr1, i32 1
  %r3 = extractelement <2 x float> %vr2, i32 0
  %r4 = extractelement <2 x float> %vr2, i32 1
  call void @llvm.amdgcn.exp.f32(i32 0, i32 15, float %r1, float %r2, float %r3, float %r4, i1 true, i1 true)
  ret void
}

define amdgpu_ps {<4 x float>, <2 x float>, float} @buffer_load_int(<4 x i32> inreg) {
; PREGFX10-LABEL: buffer_load_int:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    buffer_load_dwordx4 v[0:3], off, s[0:3], 0
; PREGFX10-NEXT:    buffer_load_dwordx2 v[4:5], off, s[0:3], 0 glc
; PREGFX10-NEXT:    buffer_load_dword v6, off, s[0:3], 0 slc
; PREGFX10-NEXT:    s_waitcnt vmcnt(0)
; PREGFX10-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: buffer_load_int:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    s_clause 0x2
; GFX10-NEXT:    buffer_load_dwordx4 v[0:3], off, s[0:3], 0
; GFX10-NEXT:    buffer_load_dwordx2 v[4:5], off, s[0:3], 0 glc
; GFX10-NEXT:    buffer_load_dword v6, off, s[0:3], 0 slc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_int:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    s_clause 0x2
; GFX11-NEXT:    buffer_load_b128 v[0:3], off, s[0:3], 0
; GFX11-NEXT:    buffer_load_b64 v[4:5], off, s[0:3], 0 glc
; GFX11-NEXT:    buffer_load_b32 v6, off, s[0:3], 0 slc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
;
; GFX12-LABEL: buffer_load_int:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    s_clause 0x2
; GFX12-NEXT:    buffer_load_b128 v[0:3], off, s[0:3], null
; GFX12-NEXT:    buffer_load_b64 v[4:5], off, s[0:3], null th:TH_LOAD_NT
; GFX12-NEXT:    buffer_load_b32 v6, off, s[0:3], null th:TH_LOAD_HT
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    ; return to shader part epilog
main_body:
  %data = call <4 x i32> @llvm.amdgcn.raw.buffer.load.v4i32(<4 x i32> %0, i32 0, i32 0, i32 0)
  %data_glc = call <2 x i32> @llvm.amdgcn.raw.buffer.load.v2i32(<4 x i32> %0, i32 0, i32 0, i32 1)
  %data_slc = call i32 @llvm.amdgcn.raw.buffer.load.i32(<4 x i32> %0, i32 0, i32 0, i32 2)
  %fdata = bitcast <4 x i32> %data to <4 x float>
  %fdata_glc = bitcast <2 x i32> %data_glc to <2 x float>
  %fdata_slc = bitcast i32 %data_slc to float
  %r0 = insertvalue {<4 x float>, <2 x float>, float} poison, <4 x float> %fdata, 0
  %r1 = insertvalue {<4 x float>, <2 x float>, float} %r0, <2 x float> %fdata_glc, 1
  %r2 = insertvalue {<4 x float>, <2 x float>, float} %r1, float %fdata_slc, 2
  ret {<4 x float>, <2 x float>, float} %r2
}

define amdgpu_ps float @raw_buffer_load_ubyte(<4 x i32> inreg %rsrc) {
; PREGFX10-LABEL: raw_buffer_load_ubyte:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    buffer_load_ubyte v0, off, s[0:3], 0
; PREGFX10-NEXT:    s_waitcnt vmcnt(0)
; PREGFX10-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; PREGFX10-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: raw_buffer_load_ubyte:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    buffer_load_ubyte v0, off, s[0:3], 0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: raw_buffer_load_ubyte:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    buffer_load_u8 v0, off, s[0:3], 0
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX11-NEXT:    ; return to shader part epilog
;
; GFX12-LABEL: raw_buffer_load_ubyte:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    buffer_load_u8 v0, off, s[0:3], null
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_cvt_f32_ubyte0_e32 v0, v0
; GFX12-NEXT:    ; return to shader part epilog
main_body:
  %tmp = call i8 @llvm.amdgcn.raw.buffer.load.i8(<4 x i32> %rsrc, i32 0, i32 0, i32 0)
  %tmp2 = zext i8 %tmp to i32
  %val = uitofp i32 %tmp2 to float
  ret float %val
}

define amdgpu_ps float @raw_buffer_load_i16(<4 x i32> inreg %rsrc) {
; PREGFX10-LABEL: raw_buffer_load_i16:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    buffer_load_ushort v0, off, s[0:3], 0
; PREGFX10-NEXT:    s_waitcnt vmcnt(0)
; PREGFX10-NEXT:    v_cvt_f32_u32_e32 v0, v0
; PREGFX10-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: raw_buffer_load_i16:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    buffer_load_ushort v0, off, s[0:3], 0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cvt_f32_u32_e32 v0, v0
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: raw_buffer_load_i16:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    buffer_load_u16 v0, off, s[0:3], 0
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_cvt_f32_u32_e32 v0, v0
; GFX11-NEXT:    ; return to shader part epilog
;
; GFX12-LABEL: raw_buffer_load_i16:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    buffer_load_u16 v0, off, s[0:3], null
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_cvt_f32_u32_e32 v0, v0
; GFX12-NEXT:    ; return to shader part epilog
main_body:
  %tmp = call i16 @llvm.amdgcn.raw.buffer.load.i16(<4 x i32> %rsrc, i32 0, i32 0, i32 0)
  %tmp2 = zext i16 %tmp to i32
  %val = uitofp i32 %tmp2 to float
  ret float %val
}

define amdgpu_ps float @raw_buffer_load_sbyte(<4 x i32> inreg %rsrc) {
; PREGFX10-LABEL: raw_buffer_load_sbyte:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    buffer_load_sbyte v0, off, s[0:3], 0
; PREGFX10-NEXT:    s_waitcnt vmcnt(0)
; PREGFX10-NEXT:    v_cvt_f32_i32_e32 v0, v0
; PREGFX10-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: raw_buffer_load_sbyte:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    buffer_load_sbyte v0, off, s[0:3], 0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cvt_f32_i32_e32 v0, v0
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: raw_buffer_load_sbyte:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    buffer_load_i8 v0, off, s[0:3], 0
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_cvt_f32_i32_e32 v0, v0
; GFX11-NEXT:    ; return to shader part epilog
;
; GFX12-LABEL: raw_buffer_load_sbyte:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    buffer_load_i8 v0, off, s[0:3], null
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_cvt_f32_i32_e32 v0, v0
; GFX12-NEXT:    ; return to shader part epilog
main_body:
  %tmp = call i8 @llvm.amdgcn.raw.buffer.load.i8(<4 x i32> %rsrc, i32 0, i32 0, i32 0)
  %tmp2 = sext i8 %tmp to i32
  %val = sitofp i32 %tmp2 to float
  ret float %val
}

define amdgpu_ps float @raw_buffer_load_sshort(<4 x i32> inreg %rsrc) {
; PREGFX10-LABEL: raw_buffer_load_sshort:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    buffer_load_sshort v0, off, s[0:3], 0
; PREGFX10-NEXT:    s_waitcnt vmcnt(0)
; PREGFX10-NEXT:    v_cvt_f32_i32_e32 v0, v0
; PREGFX10-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: raw_buffer_load_sshort:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    buffer_load_sshort v0, off, s[0:3], 0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cvt_f32_i32_e32 v0, v0
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: raw_buffer_load_sshort:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    buffer_load_i16 v0, off, s[0:3], 0
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_cvt_f32_i32_e32 v0, v0
; GFX11-NEXT:    ; return to shader part epilog
;
; GFX12-LABEL: raw_buffer_load_sshort:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    buffer_load_i16 v0, off, s[0:3], null
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_cvt_f32_i32_e32 v0, v0
; GFX12-NEXT:    ; return to shader part epilog
main_body:
  %tmp = call i16 @llvm.amdgcn.raw.buffer.load.i16(<4 x i32> %rsrc, i32 0, i32 0, i32 0)
  %tmp2 = sext i16 %tmp to i32
  %val = sitofp i32 %tmp2 to float
  ret float %val
}

define amdgpu_ps void @raw_buffer_load_f16(<4 x i32> inreg %rsrc, ptr addrspace(3) %ptr) {
; PREGFX10-LABEL: raw_buffer_load_f16:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    buffer_load_ushort v1, off, s[0:3], 0
; PREGFX10-NEXT:    s_mov_b32 m0, -1
; PREGFX10-NEXT:    s_waitcnt vmcnt(0)
; PREGFX10-NEXT:    ds_write_b16 v0, v1
; PREGFX10-NEXT:    s_endpgm
;
; GFX10-LABEL: raw_buffer_load_f16:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    buffer_load_ushort v1, off, s[0:3], 0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    ds_write_b16 v0, v1
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: raw_buffer_load_f16:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    buffer_load_u16 v1, off, s[0:3], 0
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ds_store_b16 v0, v1
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: raw_buffer_load_f16:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    buffer_load_u16 v1, off, s[0:3], null
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    ds_store_b16 v0, v1
; GFX12-NEXT:    s_endpgm
main_body:
  %val = call half @llvm.amdgcn.raw.buffer.load.f16(<4 x i32> %rsrc, i32 0, i32 0, i32 0)
  store half %val, ptr addrspace(3) %ptr
  ret void
}

define amdgpu_ps void @raw_buffer_load_v2f16(<4 x i32> inreg %rsrc, ptr addrspace(3) %ptr) {
; PREGFX10-LABEL: raw_buffer_load_v2f16:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    buffer_load_dword v1, off, s[0:3], 0
; PREGFX10-NEXT:    s_mov_b32 m0, -1
; PREGFX10-NEXT:    s_waitcnt vmcnt(0)
; PREGFX10-NEXT:    ds_write_b32 v0, v1
; PREGFX10-NEXT:    s_endpgm
;
; GFX10-LABEL: raw_buffer_load_v2f16:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    buffer_load_dword v1, off, s[0:3], 0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    ds_write_b32 v0, v1
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: raw_buffer_load_v2f16:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    buffer_load_b32 v1, off, s[0:3], 0
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ds_store_b32 v0, v1
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: raw_buffer_load_v2f16:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    buffer_load_b32 v1, off, s[0:3], null
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    ds_store_b32 v0, v1
; GFX12-NEXT:    s_endpgm
main_body:
  %val = call <2 x half> @llvm.amdgcn.raw.buffer.load.v2f16(<4 x i32> %rsrc, i32 0, i32 0, i32 0)
  store <2 x half> %val, ptr addrspace(3) %ptr
  ret void
}

define amdgpu_ps void @raw_buffer_load_v4f16(<4 x i32> inreg %rsrc, ptr addrspace(3) %ptr) {
; PREGFX10-LABEL: raw_buffer_load_v4f16:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    buffer_load_dwordx2 v[1:2], off, s[0:3], 0
; PREGFX10-NEXT:    s_mov_b32 m0, -1
; PREGFX10-NEXT:    s_waitcnt vmcnt(0)
; PREGFX10-NEXT:    ds_write_b64 v0, v[1:2]
; PREGFX10-NEXT:    s_endpgm
;
; GFX10-LABEL: raw_buffer_load_v4f16:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    buffer_load_dwordx2 v[1:2], off, s[0:3], 0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    ds_write_b64 v0, v[1:2]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: raw_buffer_load_v4f16:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    buffer_load_b64 v[1:2], off, s[0:3], 0
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ds_store_b64 v0, v[1:2]
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: raw_buffer_load_v4f16:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    buffer_load_b64 v[1:2], off, s[0:3], null
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    ds_store_b64 v0, v[1:2]
; GFX12-NEXT:    s_endpgm
main_body:
  %val = call <4 x half> @llvm.amdgcn.raw.buffer.load.v4f16(<4 x i32> %rsrc, i32 0, i32 0, i32 0)
  store <4 x half> %val, ptr addrspace(3) %ptr
  ret void
}

define amdgpu_ps void @raw_buffer_load_v2i16(<4 x i32> inreg %rsrc, ptr addrspace(3) %ptr) {
; PREGFX10-LABEL: raw_buffer_load_v2i16:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    buffer_load_dword v1, off, s[0:3], 0
; PREGFX10-NEXT:    s_mov_b32 m0, -1
; PREGFX10-NEXT:    s_waitcnt vmcnt(0)
; PREGFX10-NEXT:    ds_write_b32 v0, v1
; PREGFX10-NEXT:    s_endpgm
;
; GFX10-LABEL: raw_buffer_load_v2i16:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    buffer_load_dword v1, off, s[0:3], 0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    ds_write_b32 v0, v1
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: raw_buffer_load_v2i16:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    buffer_load_b32 v1, off, s[0:3], 0
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ds_store_b32 v0, v1
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: raw_buffer_load_v2i16:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    buffer_load_b32 v1, off, s[0:3], null
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    ds_store_b32 v0, v1
; GFX12-NEXT:    s_endpgm
main_body:
  %val = call <2 x i16> @llvm.amdgcn.raw.buffer.load.v2i16(<4 x i32> %rsrc, i32 0, i32 0, i32 0)
  store <2 x i16> %val, ptr addrspace(3) %ptr
  ret void
}

define amdgpu_ps void @raw_buffer_load_v4i16(<4 x i32> inreg %rsrc, ptr addrspace(3) %ptr) {
; PREGFX10-LABEL: raw_buffer_load_v4i16:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    buffer_load_dwordx2 v[1:2], off, s[0:3], 0
; PREGFX10-NEXT:    s_mov_b32 m0, -1
; PREGFX10-NEXT:    s_waitcnt vmcnt(0)
; PREGFX10-NEXT:    ds_write_b64 v0, v[1:2]
; PREGFX10-NEXT:    s_endpgm
;
; GFX10-LABEL: raw_buffer_load_v4i16:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    buffer_load_dwordx2 v[1:2], off, s[0:3], 0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    ds_write_b64 v0, v[1:2]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: raw_buffer_load_v4i16:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    buffer_load_b64 v[1:2], off, s[0:3], 0
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ds_store_b64 v0, v[1:2]
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: raw_buffer_load_v4i16:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    buffer_load_b64 v[1:2], off, s[0:3], null
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    ds_store_b64 v0, v[1:2]
; GFX12-NEXT:    s_endpgm
main_body:
  %val = call <4 x i16> @llvm.amdgcn.raw.buffer.load.v4i16(<4 x i32> %rsrc, i32 0, i32 0, i32 0)
  store <4 x i16> %val, ptr addrspace(3) %ptr
  ret void
}

define amdgpu_ps void @raw_buffer_load_x1_offset_merged(<4 x i32> inreg %rsrc) {
; PREGFX10-LABEL: raw_buffer_load_x1_offset_merged:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    buffer_load_dwordx4 v[0:3], off, s[0:3], 0 offset:4
; PREGFX10-NEXT:    buffer_load_dwordx2 v[4:5], off, s[0:3], 0 offset:28
; PREGFX10-NEXT:    s_waitcnt vmcnt(1)
; PREGFX10-NEXT:    exp mrt0 v0, v1, v2, v3 done vm
; PREGFX10-NEXT:    s_waitcnt vmcnt(0)
; PREGFX10-NEXT:    exp mrt0 v4, v5, v0, v0 done vm
; PREGFX10-NEXT:    s_endpgm
;
; GFX10-LABEL: raw_buffer_load_x1_offset_merged:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    buffer_load_dwordx4 v[0:3], off, s[0:3], 0 offset:4
; GFX10-NEXT:    buffer_load_dwordx2 v[4:5], off, s[0:3], 0 offset:28
; GFX10-NEXT:    s_waitcnt vmcnt(1)
; GFX10-NEXT:    exp mrt0 v0, v1, v2, v3 done vm
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    exp mrt0 v4, v5, v0, v0 done vm
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: raw_buffer_load_x1_offset_merged:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    buffer_load_b128 v[0:3], off, s[0:3], 0 offset:4
; GFX11-NEXT:    buffer_load_b64 v[4:5], off, s[0:3], 0 offset:28
; GFX11-NEXT:    s_waitcnt vmcnt(1)
; GFX11-NEXT:    exp mrt0 v0, v1, v2, v3 done
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    exp mrt0 v4, v5, v0, v0 done
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: raw_buffer_load_x1_offset_merged:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    buffer_load_b128 v[0:3], off, s[0:3], null offset:4
; GFX12-NEXT:    buffer_load_b64 v[4:5], off, s[0:3], null offset:28
; GFX12-NEXT:    s_wait_loadcnt 0x1
; GFX12-NEXT:    export mrt0 v0, v1, v2, v3 done
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    export mrt0 v4, v5, v0, v0 done
; GFX12-NEXT:    s_endpgm
main_body:
  %r1 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 4, i32 0, i32 0)
  %r2 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 8, i32 0, i32 0)
  %r3 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 12, i32 0, i32 0)
  %r4 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 16, i32 0, i32 0)
  %r5 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 28, i32 0, i32 0)
  %r6 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 32, i32 0, i32 0)
  call void @llvm.amdgcn.exp.f32(i32 0, i32 15, float %r1, float %r2, float %r3, float %r4, i1 true, i1 true)
  call void @llvm.amdgcn.exp.f32(i32 0, i32 15, float %r5, float %r6, float poison, float poison, i1 true, i1 true)
  ret void
}

define amdgpu_ps void @raw_buffer_load_x1_offset_swizzled_not_merged_pregfx12(<4 x i32> inreg %rsrc) {
; PREGFX10-LABEL: raw_buffer_load_x1_offset_swizzled_not_merged_pregfx12:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    buffer_load_dword v0, off, s[0:3], 0 offset:4
; PREGFX10-NEXT:    buffer_load_dword v1, off, s[0:3], 0 offset:8
; PREGFX10-NEXT:    buffer_load_dword v2, off, s[0:3], 0 offset:12
; PREGFX10-NEXT:    buffer_load_dword v3, off, s[0:3], 0 offset:16
; PREGFX10-NEXT:    buffer_load_dword v4, off, s[0:3], 0 offset:28
; PREGFX10-NEXT:    buffer_load_dword v5, off, s[0:3], 0 offset:32
; PREGFX10-NEXT:    s_waitcnt vmcnt(2)
; PREGFX10-NEXT:    exp mrt0 v0, v1, v2, v3 done vm
; PREGFX10-NEXT:    s_waitcnt vmcnt(0)
; PREGFX10-NEXT:    exp mrt0 v4, v5, v0, v0 done vm
; PREGFX10-NEXT:    s_endpgm
;
; GFX10-LABEL: raw_buffer_load_x1_offset_swizzled_not_merged_pregfx12:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    s_clause 0x5
; GFX10-NEXT:    buffer_load_dword v0, off, s[0:3], 0 offset:4
; GFX10-NEXT:    buffer_load_dword v1, off, s[0:3], 0 offset:8
; GFX10-NEXT:    buffer_load_dword v2, off, s[0:3], 0 offset:12
; GFX10-NEXT:    buffer_load_dword v3, off, s[0:3], 0 offset:16
; GFX10-NEXT:    buffer_load_dword v4, off, s[0:3], 0 offset:28
; GFX10-NEXT:    buffer_load_dword v5, off, s[0:3], 0 offset:32
; GFX10-NEXT:    s_waitcnt vmcnt(2)
; GFX10-NEXT:    exp mrt0 v0, v1, v2, v3 done vm
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    exp mrt0 v4, v5, v0, v0 done vm
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: raw_buffer_load_x1_offset_swizzled_not_merged_pregfx12:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    s_clause 0x5
; GFX11-NEXT:    buffer_load_b32 v0, off, s[0:3], 0 offset:4
; GFX11-NEXT:    buffer_load_b32 v1, off, s[0:3], 0 offset:8
; GFX11-NEXT:    buffer_load_b32 v2, off, s[0:3], 0 offset:12
; GFX11-NEXT:    buffer_load_b32 v3, off, s[0:3], 0 offset:16
; GFX11-NEXT:    buffer_load_b32 v4, off, s[0:3], 0 offset:28
; GFX11-NEXT:    buffer_load_b32 v5, off, s[0:3], 0 offset:32
; GFX11-NEXT:    s_waitcnt vmcnt(2)
; GFX11-NEXT:    exp mrt0 v0, v1, v2, v3 done
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    exp mrt0 v4, v5, v0, v0 done
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: raw_buffer_load_x1_offset_swizzled_not_merged_pregfx12:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    buffer_load_b128 v[0:3], off, s[0:3], null offset:4 scope:SCOPE_SE
; GFX12-NEXT:    buffer_load_b64 v[4:5], off, s[0:3], null offset:28 scope:SCOPE_SE
; GFX12-NEXT:    s_wait_loadcnt 0x1
; GFX12-NEXT:    export mrt0 v0, v1, v2, v3 done
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    export mrt0 v4, v5, v0, v0 done
; GFX12-NEXT:    s_endpgm
main_body:
  %r1 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 4, i32 0, i32 8)
  %r2 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 8, i32 0, i32 8)
  %r3 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 12, i32 0, i32 8)
  %r4 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 16, i32 0, i32 8)
  %r5 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 28, i32 0, i32 8)
  %r6 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 32, i32 0, i32 8)
  call void @llvm.amdgcn.exp.f32(i32 0, i32 15, float %r1, float %r2, float %r3, float %r4, i1 true, i1 true)
  call void @llvm.amdgcn.exp.f32(i32 0, i32 15, float %r5, float %r6, float poison, float poison, i1 true, i1 true)
  ret void
}

define amdgpu_ps void @raw_buffer_load_x1_offset_swizzled_not_merged(<4 x i32> inreg %rsrc) {
; PREGFX10-LABEL: raw_buffer_load_x1_offset_swizzled_not_merged:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    buffer_load_dwordx4 v[0:3], off, s[0:3], 0 offset:4
; PREGFX10-NEXT:    buffer_load_dwordx2 v[4:5], off, s[0:3], 0 offset:28
; PREGFX10-NEXT:    s_waitcnt vmcnt(1)
; PREGFX10-NEXT:    exp mrt0 v0, v1, v2, v3 done vm
; PREGFX10-NEXT:    s_waitcnt vmcnt(0)
; PREGFX10-NEXT:    exp mrt0 v4, v5, v0, v0 done vm
; PREGFX10-NEXT:    s_endpgm
;
; GFX10-LABEL: raw_buffer_load_x1_offset_swizzled_not_merged:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    buffer_load_dwordx4 v[0:3], off, s[0:3], 0 offset:4
; GFX10-NEXT:    buffer_load_dwordx2 v[4:5], off, s[0:3], 0 offset:28
; GFX10-NEXT:    s_waitcnt vmcnt(1)
; GFX10-NEXT:    exp mrt0 v0, v1, v2, v3 done vm
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    exp mrt0 v4, v5, v0, v0 done vm
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: raw_buffer_load_x1_offset_swizzled_not_merged:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    buffer_load_b128 v[0:3], off, s[0:3], 0 offset:4
; GFX11-NEXT:    buffer_load_b64 v[4:5], off, s[0:3], 0 offset:28
; GFX11-NEXT:    s_waitcnt vmcnt(1)
; GFX11-NEXT:    exp mrt0 v0, v1, v2, v3 done
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    exp mrt0 v4, v5, v0, v0 done
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: raw_buffer_load_x1_offset_swizzled_not_merged:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    s_clause 0x5
; GFX12-NEXT:    buffer_load_b32 v0, off, s[0:3], null offset:4
; GFX12-NEXT:    buffer_load_b32 v1, off, s[0:3], null offset:8
; GFX12-NEXT:    buffer_load_b32 v2, off, s[0:3], null offset:12
; GFX12-NEXT:    buffer_load_b32 v3, off, s[0:3], null offset:16
; GFX12-NEXT:    buffer_load_b32 v4, off, s[0:3], null offset:28
; GFX12-NEXT:    buffer_load_b32 v5, off, s[0:3], null offset:32
; GFX12-NEXT:    s_wait_loadcnt 0x2
; GFX12-NEXT:    export mrt0 v0, v1, v2, v3 done
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    export mrt0 v4, v5, v0, v0 done
; GFX12-NEXT:    s_endpgm
main_body:
  %r1 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 4, i32 0, i32 64)
  %r2 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 8, i32 0, i32 64)
  %r3 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 12, i32 0, i32 64)
  %r4 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 16, i32 0, i32 64)
  %r5 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 28, i32 0, i32 64)
  %r6 = call float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32> %rsrc, i32 32, i32 0, i32 64)
  call void @llvm.amdgcn.exp.f32(i32 0, i32 15, float %r1, float %r2, float %r3, float %r4, i1 true, i1 true)
  call void @llvm.amdgcn.exp.f32(i32 0, i32 15, float %r5, float %r6, float poison, float poison, i1 true, i1 true)
  ret void
}

declare float @llvm.amdgcn.raw.buffer.load.f32(<4 x i32>, i32, i32, i32) #0
declare <2 x float> @llvm.amdgcn.raw.buffer.load.v2f32(<4 x i32>, i32, i32, i32) #0
declare <4 x float> @llvm.amdgcn.raw.buffer.load.v4f32(<4 x i32>, i32, i32, i32) #0
declare i32 @llvm.amdgcn.raw.buffer.load.i32(<4 x i32>, i32, i32, i32) #0
declare <2 x i32> @llvm.amdgcn.raw.buffer.load.v2i32(<4 x i32>, i32, i32, i32) #0
declare <4 x i32> @llvm.amdgcn.raw.buffer.load.v4i32(<4 x i32>, i32, i32, i32) #0
declare void @llvm.amdgcn.exp.f32(i32, i32, float, float, float, float, i1, i1) #0
declare i8 @llvm.amdgcn.raw.buffer.load.i8(<4 x i32>, i32, i32, i32) #0
declare i16 @llvm.amdgcn.raw.buffer.load.i16(<4 x i32>, i32, i32, i32) #0
declare <2 x i16> @llvm.amdgcn.raw.buffer.load.v2i16(<4 x i32>, i32, i32, i32) #0
declare <4 x i16> @llvm.amdgcn.raw.buffer.load.v4i16(<4 x i32>, i32, i32, i32) #0
declare half @llvm.amdgcn.raw.buffer.load.f16(<4 x i32>, i32, i32, i32) #0
declare <2 x half> @llvm.amdgcn.raw.buffer.load.v2f16(<4 x i32>, i32, i32, i32) #0
declare <4 x half> @llvm.amdgcn.raw.buffer.load.v4f16(<4 x i32>, i32, i32, i32) #0
attributes #0 = { nounwind readonly }
