// Copyright (C) 2000-2007, Luca Padovani <padovani@sti.uniurb.it>.
// 
// This file is part of GtkMathView, a flexible, high-quality rendering
// engine for MathML documents.
// 
// GtkMathView is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published
// by the Free Software Foundation; either version 3 of the License, or
// (at your option) any later version.
// 
// GtkMathView is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

#include "TFM.hh"

static TFM::Font font = {
"CMTT",

  0xee,
  "TeX typewriter text",
  0x00800000,
  0xdf43ca73,
  7,
  128
};

static TFM::Dimension dimension[] = {
  { 0x01, "slant", 0x00000000 },
  { 0x02, "space", 0x00088008 },
  { 0x03, "space_stretch", 0x00000000 },
  { 0x04, "space_shrink", 0x00000000 },
  { 0x05, "x_height", 0x0006e38e },
  { 0x06, "quad", 0x00110010 },
  { 0x07, "extra_space", 0x00088008 }
};


static TFM::Ligature C_21_Ligature[] = {
  { 0x60, 0x00, 0x0e }
};

static TFM::Ligature C_3f_Ligature[] = {
  { 0x60, 0x00, 0x0f }
};


static TFM::Character character[] = {
  { 0x00, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x01, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x02, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x03, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x04, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x05, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x06, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x07, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x08, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x09, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x0a, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x0b, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x0c, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x0d, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x0e, 0x00088008, 0x000638e4, 0x00038e38, 0x00000000, 0, 0, 0, 0 },
  { 0x0f, 0x00088008, 0x000638e4, 0x00038e38, 0x00000000, 0, 0, 0, 0 },
  { 0x10, 0x00088008, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x11, 0x00088008, 0x0006e38e, 0x00038e38, 0x00000000, 0, 0, 0, 0 },
  { 0x12, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x13, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x14, 0x00088008, 0x00090e38, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x15, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x16, 0x00088008, 0x00092220, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x17, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x18, 0x00088008, 0x00000000, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x19, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x1a, 0x00088008, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x1b, 0x00088008, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x1c, 0x00088008, 0x0008aaaa, 0x0001c71c, 0x00000000, 0, 0, 0, 0 },
  { 0x1d, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x1e, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x1f, 0x00088008, 0x000aaaaa, 0x0000e38e, 0x00000000, 0, 0, 0, 0 },
  { 0x20, 0x00088008, 0x00038000, 0x0001c71c, 0x00000000, 0, 0, 0, 0 },
  { 0x21, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 1, C_21_Ligature },
  { 0x22, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x23, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x24, 0x00088008, 0x000b1c72, 0x00015556, 0x00000000, 0, 0, 0, 0 },
  { 0x25, 0x00088008, 0x000b1c72, 0x00015556, 0x00000000, 0, 0, 0, 0 },
  { 0x26, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x27, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x28, 0x00088008, 0x000b1c72, 0x00015554, 0x00000000, 0, 0, 0, 0 },
  { 0x29, 0x00088008, 0x000b1c72, 0x00015554, 0x00000000, 0, 0, 0, 0 },
  { 0x2a, 0x00088008, 0x00085556, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x2b, 0x00088008, 0x00088824, 0xfffec108, 0x00000000, 0, 0, 0, 0 },
  { 0x2c, 0x00088008, 0x0002271e, 0x000238e4, 0x00000000, 0, 0, 0, 0 },
  { 0x2d, 0x00088008, 0x00088824, 0xfffec108, 0x00000000, 0, 0, 0, 0 },
  { 0x2e, 0x00088008, 0x0002271e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x2f, 0x00088008, 0x000b1c72, 0x00015554, 0x00000000, 0, 0, 0, 0 },
  { 0x30, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x31, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x32, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x33, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x34, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x35, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x36, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x37, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x38, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x39, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3a, 0x00088008, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3b, 0x00088008, 0x0006e38e, 0x000238e4, 0x00000000, 0, 0, 0, 0 },
  { 0x3c, 0x00088008, 0x0008f1c8, 0xffff2aac, 0x00000000, 0, 0, 0, 0 },
  { 0x3d, 0x00088008, 0x0006b49e, 0xfffced82, 0x00000000, 0, 0, 0, 0 },
  { 0x3e, 0x00088008, 0x0008f1c8, 0xffff2aac, 0x00000000, 0, 0, 0, 0 },
  { 0x3f, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 1, C_3f_Ligature },
  { 0x40, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x41, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x42, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x43, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x44, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x45, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x46, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x47, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x48, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x49, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x4a, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x4b, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x4c, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x4d, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x4e, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x4f, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x50, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x51, 0x00088008, 0x0009c71c, 0x000238e4, 0x00000000, 0, 0, 0, 0 },
  { 0x52, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x53, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x54, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x55, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x56, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x57, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x58, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x59, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5a, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5b, 0x00088008, 0x000b1c72, 0x00015554, 0x00000000, 0, 0, 0, 0 },
  { 0x5c, 0x00088008, 0x000b1c72, 0x00015554, 0x00000000, 0, 0, 0, 0 },
  { 0x5d, 0x00088008, 0x000b1c72, 0x00015554, 0x00000000, 0, 0, 0, 0 },
  { 0x5e, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5f, 0x00088008, 0x00000000, 0x000193e4, 0x00000000, 0, 0, 0, 0 },
  { 0x60, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x61, 0x00088008, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x62, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x63, 0x00088008, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x64, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x65, 0x00088008, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x66, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x67, 0x00088008, 0x0006e38e, 0x00038e38, 0x00000000, 0, 0, 0, 0 },
  { 0x68, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x69, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x6a, 0x00088008, 0x0009c71c, 0x00038e38, 0x00000000, 0, 0, 0, 0 },
  { 0x6b, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x6c, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x6d, 0x00088008, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x6e, 0x00088008, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x6f, 0x00088008, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x70, 0x00088008, 0x0006e38e, 0x00038e38, 0x00000000, 0, 0, 0, 0 },
  { 0x71, 0x00088008, 0x0006e38e, 0x00038e38, 0x00000000, 0, 0, 0, 0 },
  { 0x72, 0x00088008, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x73, 0x00088008, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x74, 0x00088008, 0x0008db70, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x75, 0x00088008, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x76, 0x00088008, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x77, 0x00088008, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x78, 0x00088008, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x79, 0x00088008, 0x0006e38e, 0x00038e38, 0x00000000, 0, 0, 0, 0 },
  { 0x7a, 0x00088008, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x7b, 0x00088008, 0x000b1c72, 0x00015554, 0x00000000, 0, 0, 0, 0 },
  { 0x7c, 0x00088008, 0x000b1c72, 0x00015554, 0x00000000, 0, 0, 0, 0 },
  { 0x7d, 0x00088008, 0x000b1c72, 0x00015554, 0x00000000, 0, 0, 0, 0 },
  { 0x7e, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x7f, 0x00088008, 0x0009c71c, 0x00000000, 0x00000000, 0, 0, 0, 0 }
};

void
cmtt8_tables(TFM::Font*& _font, TFM::Dimension*& _dimension, TFM::Character*& _character)
{
  _font = &font;
  _dimension = dimension;
  _character = character;
}
