/******************************************************************************
 *
 * Copyright (C) 1997-2022 by Dimitri van Heesch.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation under the terms of the GNU General Public License is hereby
 * granted. No representations are made about the suitability of this software
 * for any purpose. It is provided "as is" without express or implied warranty.
 * See the GNU General Public License for more details.
 *
 * Documents produced by Doxygen are derivative works derived from the
 * input used in their production; they are not affected by this license.
 *
 */

#ifndef IMAGE_H
#define IMAGE_H

#include <memory>
#include "types.h"
#include "qcstring.h"

/** Class representing a bitmap image generated by doxygen. */
class Image
{
  public:
    Image(uint w,uint h);
   ~Image();

    void setPixel(uint x,uint y,uchar val);
    uchar getPixel(uint x,uint y) const;
    void writeChar(uint x,uint y,char c,uchar fg);
    void writeString(uint x,uint y,const QCString &s,uchar fg);
    void drawHorzLine(uint y,uint xs,uint xe,uchar colIndex,uint mask);
    void drawHorzArrow(uint y,uint xs,uint xe,uchar colIndex,uint mask);
    void drawVertLine(uint x,uint ys,uint ye,uchar colIndex,uint mask);
    void drawVertArrow(uint x,uint ys,uint ye,uchar colIndex,uint mask);
    void drawRect(uint x,uint y,uint width,uint height,uchar colIndex,uint mask);
    void fillRect(uint x,uint y,uint width,uint height,uchar colIndex,uint mask);
    bool save(const QCString &fileName);
    friend uint stringLength(const QCString &s);
    uint width() const;
    uint height() const;
    static uint stringLength(const QCString &s);

  private:
    struct Private;
    std::unique_ptr<Private> p;
};

/** Class representing a bitmap image colored based on hue/sat/gamma settings. */
class ColoredImage
{
  public:
    ColoredImage(uint width,uint height,
           const uchar *greyLevels,const uchar *alphaLevels,
           int saturation,int hue,int gamma);
   ~ColoredImage();
    bool save(const QCString &fileName);
    static void hsl2rgb(double h,double s,double l,
                        double *pRed,double *pGreen,double *pBlue);
  private:
    struct Private;
    std::unique_ptr<Private> p;
};

#endif
