/**/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs


parse arg language texmf source options



if directory(texmf) = '' then exit 1


if language = '049' then do

  msg.1 = 'msg:Concrete: Lsche Verzeichnisse'
  msg.2 = 'msg:Concrete: Entpacke Zeichenstze'
  msg.3 = 'msg:Concrete: Erzeuge'
  msg.4 = 'Lauf'
  msg.5 = 'von'

end
else do

  msg.1 = 'msg:Concrete: deleting directories'
  msg.2 = 'msg:Concrete: installing files'
  msg.3 = 'msg:Concrete: Creating'
  msg.4 = 'run'
  msg.5 = 'of'

end



install = texmf||'\os2tex\install'
unzip   = install||'\unzip '
kdir    = install||'\kdir '
bin     = texmf||'\os2tex\bin'
exec    = bin||'\tex.exe'


if Pos("InstallFiles", options) > 0 then do


   say msg.1


   install||'\kdir '||texmf||'\fonts\source\public\concrete'
   install||'\kdir '||texmf||'\fonts\source\public\concmath'
   install||'\kdir '||texmf||'\fonts\source\public\ecc'

   install||'\kdir '||texmf||'\fonts\tfm\public\concrete'
   install||'\kdir '||texmf||'\fonts\tfm\public\concmath'
   install||'\kdir '||texmf||'\fonts\tfm\public\ecc'


   say msg.2


   install||'\unzip '||source||'\concrete.zip'


   if directory(texmf||'\tex\latex') = '' then exit 1



   kdir||'beton'
   kdir||'ccfonts'

   unzip||source||'\beton.zip'
   unzip||source||'\ccfonts.zip'


   kdir||texmf||'\doc\latex\beton'
   kdir||texmf||'\doc\latex\ccfonts'

   'md '||texmf||'\doc\latex\beton'
   'md '||texmf||'\doc\latex\ccfonts'


   say 'msg:Concrete: beton.ins'


   exec||' -ff latex.fmt -pf '||bin||' -po '||texmf||'\tex\latex\beton -pi '||texmf||'\tex\latex\beton;'||texmf||'\tex\latex\base beton.ins'


   say 'msg:Concrete: ccfonts.ins'

   exec||' -a '||source||'\concrete.ans -ff latex.fmt -pf '||bin||' -po '||texmf||'\tex\latex\ccfonts -pi '||texmf||'\tex\latex\ccfonts;'||texmf||'\tex\latex\base ccfonts.ins'



   do i=1 to 2
      say msg.3' beton.dvi 'msg.4' 'i' 'msg.5' 2'
      exec||' -r -ff latex.fmt -pf '||bin||' -po '||texmf||'\doc\latex\beton -pt '||texmf||'\fonts\tfm -pi '||texmf||'\doc\latex\beton;'||texmf||'\tex\latex beton.dtx'
   end


   do i=1 to 2
      say msg.3' ccfonts.dvi 'msg.4' 'i' 'msg.5' 2'
      exec||' -r -ff latex.fmt -pf '||bin||' -po '||texmf||'\doc\latex\ccfonts -pt '||texmf||'\fonts\tfm -pi '||texmf||'\doc\latex\ccfonts;'||texmf||'\tex\latex ccfonts.dtx'
   end


   'copy '||texmf||'\tex\latex\ccfonts\liesmich '||texmf||'\doc\latex\ccfonts'
   'copy '||texmf||'\tex\latex\ccfonts\readme '||texmf||'\doc\latex\ccfonts'

   'del '||texmf||'\tex\latex\ccfonts\liesmich'
   'del '||texmf||'\tex\latex\ccfonts\readme'


   'del '||texmf||'\tex\latex\beton\*.dtx'
   'del '||texmf||'\tex\latex\beton\*.ins'

   'del '||texmf||'\tex\latex\ccfonts\*.dtx'
   'del '||texmf||'\tex\latex\ccfonts\*.ins'

end



if SysOS2Ver()='2.30' then
  top = 48
else
  top = 45


if Pos("CreateObjects", options) > 0 then do

   classname = 'WPFolder'
   if language = '049' then
      objtitle  = 'Zeichenstze'
   else
      objtitle  = 'Fonts'
   location  = '<OS2TEX_DOC_FOLDER>'
   setup     = 'OBJECTID=<OS2TEX_FONTS_FOLDER>;ICONVIEW=MINI,NONFLOWED;ALWAYSSORT=YES;ICONVIEWPOS=50,50,25,'||top
   duplicate = 'update'


   rc = SysCreateObject(classname,objtitle,location,setup,duplicate)

   if rc = 0 then do
      exit 1
   end




   classname = 'WPProgram'
   objtitle  = 'Concrete'
   location  = '<OS2TEX_FONTS_FOLDER>'
   setup     = 'EXENAME='texmf'\os2tex\bin\dvi.exe;PROGTYPE=PM;STARTUPDIR='texmf'\os2tex\bin;OBJECTID=<OS2TEX_concrete_beton.dvi>;PARAMETERS='texmf'\doc\latex\beton\beton.dvi'
   duplicate = 'replace'

   rc = SysCreateObject(classname,objtitle,location,setup,duplicate)

   if rc = 0 then do
      exit 1
   end



   classname = 'WPProgram'
   objtitle  = 'Concrete ECC'
   location  = '<OS2TEX_FONTS_FOLDER>'
   setup     = 'EXENAME='texmf'\os2tex\bin\dvi.exe;PROGTYPE=PM;STARTUPDIR='texmf'\os2tex\bin;OBJECTID=<OS2TEX_ccfonts.dvi>;PARAMETERS='texmf'\doc\latex\ccfonts\ccfonts.dvi'
   duplicate = 'replace'

   rc = SysCreateObject(classname,objtitle,location,setup,duplicate)

   if rc = 0 then do
      exit 1
   end


end




