/******************************************************

  File TFCONFIG.CMD - TFE configuration tool

  This procedure is part of the EPM TeX Front End v2.5a
  (C) 1997-1999 Walter Schmidt.

*******************************************************/

VERSION = 'TFCONFIG 2.9c'
APP = 'EPMTFE'
DEFAULT_CFGFILE = 'tfe.cfg'

call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
call SysLoadFuncs

parse arg cfgfile option .

if cfgfile = '' then cfgfile = DEFAULT_CFGFILE
else do
   c = substr(cfgfile,1,1)
   if c = '-' | c = '/' then do
      option = cfgfile
      cfgfile = DEFAULT_CFGFILE
   end /* do */
end /* do */

nowrite = (translate(option) = '-N') | (translate(option) = '/N')
delete = (translate(option) = '-D') | (translate(option) = '/D')
view = (translate(option) = '-V') | (translate(option) = '/V')
write = (translate(option) = '-U') | (translate(option) = '/U') | (option = '')

if option <> '' & \ (nowrite | delete | view | write) then signal givehelp

if \ (view | nowrite) then say VERSION', 'date()' 'time()

inifile = SysIni('USER', 'EPM', 'EPMIniPath')
if (inifile = 'ERROR:') & \ nowrite  then do
   say 'Apparently the EPM is not installed.'
   return 2
end /* do */

inifile = strip(inifile, 'T', '0'x)

if filespec('D', inifile) = '' then do
   bootdr = value('COMSPEC', , 'OS2ENVIRONMENT')
   bootdr = filespec('D', bootdr)
   inifile= bootdr||inifile
end /* do */

if view then signal appview

if delete then signal appdelete

lineno = 0
errflag = 0

if \ nowrite then say 'Updating' inifile '...'

do while lines(cfgfile) > 0
   l = linein(cfgfile)
   lineno = lineno + 1
   parse var l rawcode '#' comment
   code = translate(rawcode, " ", "09"x)
   if code <> '' then do
      parse var code  key '=' value
      if key <> '' then do
         key = strip(key)
         if nowrite then 
            say lineno': 'key' ='value
         else do
            value = strip(value)
            if value <> '' then do
              ret = SysIni(inifile, APP, translate(key), value||'0'x)
              if ret <> '' then do
                 say 'error: writing line 'lineno' failed'
                 errflag = 1
              end /* do */
            end /* do */
            else call SysIni inifile, APP, translate(key), 'DELETE:'
         end /* do */
      end /* do */
   end /* do */
end /* do */

if lineno = 0 then do
    say 'File 'cfgfile' empty or not found.'
    return 1
end /* do */

if \ nowrite then do
   ret = SysIni(inifile, APP, 'VERSION', VERSION||'0'x)
   if ret <> '' then do
      say 'error: cannot write version info to 'inifile
      errflag = 1
   end /* do */
end /* do */
   
if errflag then do
   say '... failed.'
   return 2
end /* do */
else do
   if \ nowrite then say '... done.'
   return 0
end /* do */

/* finis */

appdelete:
say 'Deleting the application '||APP||' from 'inifile' ...'
ret = SysIni(inifile, APP, 'DELETE:')
if ret <> '' then do
   say '... failed.'
   return 2
end /* do */
else do
   say '... done.'
   return 0
end /* do */

appview:
ret = SysIni(inifile, APP, 'ALL:', keys)
if ret \= 'ERROR:' then do
   do i=1 to keys.0
      value = SysIni(inifile, APP, keys.i)
      say keys.i '=' strip(value, 'T', '0'x)
   end /* do */
   return 0
end /* do */
else return 2

givehelp:
say
say VERSION
say
say 'Usage: TFCONFIG [FILE] [OPTIONS]'
say
say 'Update, view or clear TeX Front End settings.'
say
say '  /U  update (default)'
say '  /N  list contents of configuration file only'
say '  /V  view current settings'
say '  /D  delete all settings'
say
say 'Settings are read from .\tfe.cfg, unless FILE is specified.'
say 'A given filename is ignored, if /V or /D is requested.'
say
return 1
/* eof */

