/*****************************************************************************\
*                                                                             *
*  WinGnuc.h  -  Macros for GNU C Compiler to include win32 sdk               *
*                                                                             *
*                                                                             *
*  Copyright (c) 1995-1996 Rainer Schnitker.  All rights reserved.            *
*                                                                             *
\*****************************************************************************/

#ifndef _WINGNUC_H
#define _WINGNUC_H

#ifdef __GNUC__

/* --- remove this comment if you have old SDK headers ---
#define OLD_SDK_HEADERS
*/  /* remove this comment if you have old SDK headers */

#ifndef WIN32_LEAN_AND_MEAN         /* too many errors in afx*.h */
#define WIN32_LEAN_AND_MEAN
#endif

#ifdef OLD_SDK_HEADERS
#define _CFRONT_PASS_               /* old headers: don't get errors */
/* #define __midl */                /* very old headers */
#else
#define MIDL_PASS                   /* new headers: disable _asm statements */
#endif

#define _STDCALL_SUPPORTED

#define __stdcall __attribute__((stdcall))
#define __cdecl                     /* do not define */
#define _cdecl                      /* do not define */
#define __unaligned
#define __export

#ifndef WIN32
#define WIN32 100
#endif
#ifndef _WIN32
#define _WIN32
#endif

#ifdef i386
#define _X86_
#define I386_HOST	1
#ifndef _M_IX86
#define _M_IX86		300
#endif
#endif

#ifndef _WCHAR_T
#define _WCHAR_T                    /* EMX wchar_t */
#define _WCHAR_T_DEFINED            /* SDK wchar_t */
typedef unsigned short wchar_t;
#else  /* _WCHAR_T */
#ifndef _WCHAR_T_DEFINED
#define _WCHAR_T_DEFINED
#endif
#endif /* _WCHAR_T */

/* define missing structured exception handlers */
struct _EXCEPTION_RECORD;
struct _CONTEXT;
struct _RTL_CRITICAL_SECTION;
struct tagCREATESTRUCTA;
struct tagCREATESTRUCTW;

#endif /* __GNUC__ */

#endif /* _WINGNUC_H */
