/***************************************************************************\
*                                                                           *
*   COMMDLG.H                                                               *
*                                                                           *
*   Some headers are used from the cygnus project                           *
*   Modified by:                                                            *
*    kiefer@isys.de                                                         *
*    rainer@mathematik.uni-bielefeld.de                                     *
*									    *
\***************************************************************************/

#if !defined (_COMMDLG_H)
#define _COMMDLG_H

#ifdef __cplusplus
extern "C" {
#endif

#if !defined(RC_INVOKED)
#pragma pack(1)     /* emx knows #pragma pack */

typedef UINT WINAPI (*LPOFNHOOKPROC) (HWND, UINT, WPARAM, LPARAM);

#define OPENFILENAME TSTRUCT(OPENFILENAME)
#define LPOPENFILENAME TSTRUCT(LPOPENFILENAME)
typedef struct {
    DWORD           lStructSize;
    HWND            hwndOwner;
    HINSTANCE       hInstance;
    LPCTSTR         lpstrFilter;
    LPTSTR          lpstrCustomFilter;
    DWORD           nMaxCustFilter;
    DWORD           nFilterIndex;
    LPTSTR          lpstrFile;
    DWORD           nMaxFile;
    LPTSTR          lpstrFileTitle;
    DWORD           nMaxFileTitle;
    LPCTSTR         lpstrInitialDir;
    LPCTSTR         lpstrTitle;
    DWORD           Flags;
    WORD            nFileOffset;
    WORD            nFileExtension;
    LPCTSTR         lpstrDefExt;
    LPARAM          lCustData;
    LPOFNHOOKPROC   lpfnHook;
    LPCTSTR         lpTemplateName;
} OPENFILENAME, * LPOPENFILENAME;

#define GetOpenFileName TFUNCT(GetOpenFileName)
BOOL APIENTRY GetOpenFileName(LPOPENFILENAME);

#define GetSaveFileName TFUNCT(GetSaveFileName)
BOOL APIENTRY GetSaveFileName(LPOPENFILENAME);

#define GetFileTitle TFUNCT(GetFileTitle)
short APIENTRY GetFileTitle(LPCTSTR, LPTSTR, WORD);

#define OFN_READONLY                0x00000001
#define OFN_OVERWRITEPROMPT         0x00000002
#define OFN_HIDEREADONLY            0x00000004
#define OFN_NOCHANGEDIR             0x00000008
#define OFN_SHOWHELP                0x00000010
#define OFN_ENABLEHOOK              0x00000020
#define OFN_ENABLETEMPLATE          0x00000040
#define OFN_ENABLETEMPLATEHANDLE    0x00000080
#define OFN_NOVALIDATE              0x00000100
#define OFN_ALLOWMULTISELECT        0x00000200
#define OFN_EXTENSIONDIFFERENT      0x00000400
#define OFN_PATHMUSTEXIST           0x00000800
#define OFN_FILEMUSTEXIST           0x00001000
#define OFN_CREATEPROMPT            0x00002000
#define OFN_SHAREAWARE              0x00004000
#define OFN_NOREADONLYRETURN        0x00008000
#define OFN_NOTESTFILECREATE        0x00010000
#define OFN_NONETWORKBUTTON         0x00020000
#define OFN_NOLONGNAMES             0x00040000
#define OFN_EXPLORER		0x00080000
#define OFN_NODEREFERENCELINKS	0x00100000
#define OFN_LONGNAMES		0x00200000
#define OFN_SHAREFALLTHROUGH        2
#define OFN_SHARENOWARN             1
#define OFN_SHAREWARN               0

typedef UINT APIENTRY (*LPCCHOOKPROC) (HWND, UINT, WPARAM, LPARAM);

#define CHOOSECOLOR TSTRUCT(CHOOSECOLOR)
#define LPCHOOSECOLOR TSTRUCT(LPCHOOSECOLOR)
typedef struct tagCHOOSECOLORW {
    DWORD           lStructSize;
    HWND            hwndOwner;
    HWND            hInstance;
    COLORREF        rgbResult;
    COLORREF        *lpCustColors;
    DWORD           Flags;
    LPARAM          lCustData;
    LPCCHOOKPROC    lpfnHook;
    LPCTSTR         lpTemplateName;
} CHOOSECOLOR, * LPCHOOSECOLOR;

#define ChooseColor TFUNCT(ChooseColor)
BOOL APIENTRY ChooseColor(LPCHOOSECOLOR);

#define CC_RGBINIT              0x00000001
#define CC_FULLOPEN             0x00000002
#define CC_PREVENTFULLOPEN      0x00000004
#define CC_SHOWHELP             0x00000008
#define CC_ENABLEHOOK           0x00000010
#define CC_ENABLETEMPLATE       0x00000020
#define CC_ENABLETEMPLATEHANDLE 0x00000040

typedef UINT APIENTRY (*LPFRHOOKPROC) (HWND, UINT, WPARAM, LPARAM);

#define FINDREPLACE TSTRUCT(FINDREPLACE)
#define LPFINDREPLACE TSTRUCT(LPFINDREPLACE)
typedef struct {
    DWORD       lStructSize;
    HWND        hwndOwner;
    HINSTANCE   hInstance;
    DWORD       Flags;
    LPTSTR      lpstrFindWhat;
    LPTSTR      lpstrReplaceWith;
    WORD        wFindWhatLen;
    WORD        wReplaceWithLen;
    LPARAM      lCustData;
    LPFRHOOKPROC lpfnHook;
    LPCTSTR     lpTemplateName;
} FINDREPLACE, * LPFINDREPLACE;

#define FR_DOWN                         0x00000001
#define FR_WHOLEWORD                    0x00000002
#define FR_MATCHCASE                    0x00000004
#define FR_FINDNEXT                     0x00000008
#define FR_REPLACE                      0x00000010
#define FR_REPLACEALL                   0x00000020
#define FR_DIALOGTERM                   0x00000040
#define FR_SHOWHELP                     0x00000080
#define FR_ENABLEHOOK                   0x00000100
#define FR_ENABLETEMPLATE               0x00000200
#define FR_NOUPDOWN                     0x00000400
#define FR_NOMATCHCASE                  0x00000800
#define FR_NOWHOLEWORD                  0x00001000
#define FR_ENABLETEMPLATEHANDLE         0x00002000
#define FR_HIDEUPDOWN                   0x00004000
#define FR_HIDEMATCHCASE                0x00008000
#define FR_HIDEWHOLEWORD                0x00010000

#define FindText TFUNCT(FindText)
HWND APIENTRY FindText(LPFINDREPLACE);

#define ReplaceText TFUNCT(ReplaceText)
HWND APIENTRY ReplaceText(LPFINDREPLACE);

typedef UINT (APIENTRY *LPCFHOOKPROC) (HWND, UINT, WPARAM, LPARAM);

#define CHOOSEFONT TSTRUCT(CHOOSEFONT)
#define LPCHOOSEFONT TSTRUCT(LPCHOOSEFONT)
typedef struct {
    DWORD               lStructSize;
    HWND                hwndOwner;
    HDC                 hDC;
    LPLOGFONT           lpLogFont;
    INT                 iPointSize;
    DWORD               Flags;
    COLORREF            rgbColors;
    LPARAM              lCustData;
    LPCFHOOKPROC        lpfnHook;
    LPCTSTR             lpTemplateName;
    HINSTANCE           hInstance;
    LPTSTR              lpszStyle;
    WORD                nFontType;
    WORD                __dummy__;
    INT                 nSizeMin;
    INT                 nSizeMax;
} CHOOSEFONT, *LPCHOOSEFONT;

#define ChooseFont TFUNCT(ChooseFont)
BOOL APIENTRY ChooseFont(LPCHOOSEFONT);

#define CF_SCREENFONTS             0x00000001
#define CF_PRINTERFONTS            0x00000002
#define CF_BOTH                    (CF_SCREENFONTS | CF_PRINTERFONTS)
#define CF_SHOWHELP                0x00000004L
#define CF_ENABLEHOOK              0x00000008L
#define CF_ENABLETEMPLATE          0x00000010L
#define CF_ENABLETEMPLATEHANDLE    0x00000020L
#define CF_INITTOLOGFONTSTRUCT     0x00000040L
#define CF_USESTYLE                0x00000080L
#define CF_EFFECTS                 0x00000100L
#define CF_APPLY                   0x00000200L
#define CF_ANSIONLY                0x00000400L
#define CF_NOVECTORFONTS           0x00000800L
#define CF_NOOEMFONTS              CF_NOVECTORFONTS
#define CF_NOSIMULATIONS           0x00001000L
#define CF_LIMITSIZE               0x00002000L
#define CF_FIXEDPITCHONLY          0x00004000L
#define CF_WYSIWYG                 0x00008000L // must also have CF_SCREENFONTS & CF_PRINTERFONTS
#define CF_FORCEFONTEXIST          0x00010000L
#define CF_SCALABLEONLY            0x00020000L
#define CF_TTONLY                  0x00040000L
#define CF_NOFACESEL               0x00080000L
#define CF_NOSTYLESEL              0x00100000L
#define CF_NOSIZESEL               0x00200000L
#define SIMULATED_FONTTYPE    0x8000
#define PRINTER_FONTTYPE      0x4000
#define SCREEN_FONTTYPE       0x2000
#define BOLD_FONTTYPE         0x0100
#define ITALIC_FONTTYPE       0x0200
#define REGULAR_FONTTYPE      0x0400
#define WM_CHOOSEFONT_GETLOGFONT      (WM_USER + 1)

#define LBSELCHSTRING  TEXT("commdlg_LBSelChangedNotify")
#define SHAREVISTRING  TEXT("commdlg_ShareViolation")
#define FILEOKSTRING   TEXT("commdlg_FileNameOK")
#define COLOROKSTRING  TEXT("commdlg_ColorOK")
#define SETRGBSTRING   TEXT("commdlg_SetRGBColor")
#define HELPMSGSTRING  TEXT("commdlg_help")
#define FINDMSGSTRING  TEXT("commdlg_FindReplace")

#define CD_LBSELNOITEMS -1
#define CD_LBSELCHANGE   0
#define CD_LBSELSUB      1
#define CD_LBSELADD      2

typedef UINT (APIENTRY *LPPRINTHOOKPROC) (HWND, UINT, WPARAM, LPARAM);
typedef UINT (APIENTRY *LPSETUPHOOKPROC) (HWND, UINT, WPARAM, LPARAM);

#define PRINTDLG TSTRUCT(PRINTDLG)
#define LPPRINTDLG TSTRUCT(LPPRINTDLG)
typedef struct {
    DWORD               lStructSize;
    HWND                hwndOwner;
    HGLOBAL             hDevMode;
    HGLOBAL             hDevNames;
    HDC                 hDC;
    DWORD               Flags;
    WORD                nFromPage;
    WORD                nToPage;
    WORD                nMinPage;
    WORD                nMaxPage;
    WORD                nCopies;
    HINSTANCE           hInstance;
    LPARAM              lCustData;
    LPPRINTHOOKPROC     lpfnPrintHook;
    LPSETUPHOOKPROC     lpfnSetupHook;
    LPCTSTR             lpPrintTemplateName;
    LPCTSTR             lpSetupTemplateName;
    HGLOBAL             hPrintTemplate;
    HGLOBAL             hSetupTemplate;
} PRINTDLGA, *LPPRINTDLG;

#define PrintDlg TFUNCT(PrintDlg)
BOOL APIENTRY PrintDlg(LPPRINTDLG);

#define PD_ALLPAGES                  0x00000000
#define PD_SELECTION                 0x00000001
#define PD_PAGENUMS                  0x00000002
#define PD_NOSELECTION               0x00000004
#define PD_NOPAGENUMS                0x00000008
#define PD_COLLATE                   0x00000010
#define PD_PRINTTOFILE               0x00000020
#define PD_PRINTSETUP                0x00000040
#define PD_NOWARNING                 0x00000080
#define PD_RETURNDC                  0x00000100
#define PD_RETURNIC                  0x00000200
#define PD_RETURNDEFAULT             0x00000400
#define PD_SHOWHELP                  0x00000800
#define PD_ENABLEPRINTHOOK           0x00001000
#define PD_ENABLESETUPHOOK           0x00002000
#define PD_ENABLEPRINTTEMPLATE       0x00004000
#define PD_ENABLESETUPTEMPLATE       0x00008000
#define PD_ENABLEPRINTTEMPLATEHANDLE 0x00010000
#define PD_ENABLESETUPTEMPLATEHANDLE 0x00020000
#define PD_USEDEVMODECOPIES          0x00040000
#define PD_DISABLEPRINTTOFILE        0x00080000
#define PD_HIDEPRINTTOFILE           0x00100000
#define PD_NONETWORKBUTTON           0x00200000

typedef struct tagDEVNAMES {
    WORD wDriverOffset;
    WORD wDeviceOffset;
    WORD wOutputOffset;
    WORD wDefault;
} DEVNAMES;

typedef DEVNAMES * LPDEVNAMES;

#define DN_DEFAULTPRN      0x0001

DWORD APIENTRY CommDlgExtendedError(VOID);

#pragma pack()

#endif /* !RC_INVOKED */

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif /* !defined (_COMMDLG_H) */
